/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.classification.Label;
import org.tribuo.classification.LabelFactory;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.SimpleDataSourceProvenance;

public final class LabelledDataGenerator {
    private static final LabelFactory labelFactory = new LabelFactory();

    private LabelledDataGenerator() {
    }

    public static Pair<Dataset<Label>, Dataset<Label>> denseTrainTest() {
        return LabelledDataGenerator.denseTrainTest(-1.0);
    }

    public static Pair<Dataset<Label>, Dataset<Label>> denseTrainTest(double negate) {
        SimpleDataSourceProvenance provenance = new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset train = new MutableDataset((DataProvenance)provenance, (OutputFactory)labelFactory);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), (String[])names.clone(), values));
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), (String[])names.clone(), values));
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), (String[])names.clone(), values));
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), (String[])names.clone(), values));
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), (String[])names.clone(), values));
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), (String[])names.clone(), values));
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), (String[])names.clone(), values));
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), (String[])names.clone(), values));
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), (String[])names.clone(), values));
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), (String[])names.clone(), values));
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), (String[])names.clone(), values));
        SimpleDataSourceProvenance testProvenance = new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset test = new MutableDataset((DataProvenance)testProvenance, (OutputFactory)labelFactory);
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Label("Foo"), (String[])names.clone(), values));
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Label("Bar"), (String[])names.clone(), values));
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Label("Baz"), (String[])names.clone(), values));
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Label("Quux"), (String[])names.clone(), values));
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Label>, Dataset<Label>> sparseTrainTest() {
        return LabelledDataGenerator.sparseTrainTest(-1.0);
    }

    public static Pair<Dataset<Label>, Dataset<Label>> sparseTrainTest(double negate) {
        SimpleDataSourceProvenance provenance = new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset train = new MutableDataset((DataProvenance)provenance, (OutputFactory)labelFactory);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "D", "F", "H"};
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"A", "J", "D", "M"};
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"C", "E", "F", "H"};
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"E", "G", "F", "I"};
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"J", "K", "C", "E"};
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"E", "A", "K", "J"};
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), names, values));
        names = new String[]{"B", "C", "E", "H"};
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), names, values));
        names = new String[]{"A", "M", "I", "J"};
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Label("Baz"), names, values));
        names = new String[]{"Z", "A", "B", "C"};
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), names, values));
        names = new String[]{"K", "V", "E", "D"};
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), names, values));
        names = new String[]{"B", "G", "E", "A"};
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Label("Quux"), names, values));
        SimpleDataSourceProvenance testProvenance = new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset test = new MutableDataset((DataProvenance)testProvenance, (OutputFactory)labelFactory);
        names = new String[]{"AA", "B", "C", "D"};
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "BB", "F", "E"};
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"B", "E", "G", "H"};
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Label("Baz"), names, values));
        names = new String[]{"B", "CC", "DD", "EE"};
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Label("Quux"), names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Label>, Dataset<Label>> binarySparseTrainTest() {
        return LabelledDataGenerator.binarySparseTrainTest(-1.0);
    }

    public static Pair<Dataset<Label>, Dataset<Label>> binarySparseTrainTest(double negate) {
        SimpleDataSourceProvenance provenance = new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset train = new MutableDataset((DataProvenance)provenance, (OutputFactory)labelFactory);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "D", "F", "H"};
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"A", "J", "D", "M"};
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"C", "E", "F", "H"};
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"E", "G", "F", "I"};
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"J", "K", "C", "E"};
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"E", "A", "K", "J"};
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "C", "E", "H"};
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"A", "M", "I", "J"};
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"Z", "A", "B", "C"};
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"K", "V", "E", "D"};
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"B", "G", "E", "A"};
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        SimpleDataSourceProvenance testProvenance = new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)labelFactory);
        MutableDataset test = new MutableDataset((DataProvenance)testProvenance, (OutputFactory)labelFactory);
        names = new String[]{"AA", "B", "C", "D"};
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "BB", "F", "E"};
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        names = new String[]{"B", "E", "G", "H"};
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)new Label("Foo"), names, values));
        names = new String[]{"B", "CC", "DD", "EE"};
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)new Label("Bar"), names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Example<Label> invalidSparseExample() {
        return new ArrayExample((Output)new Label("Foo"), new String[]{"1", "5", "8"}, new double[]{1.0, 5.0, 8.0});
    }

    public static Example<Label> emptyExample() {
        return new ArrayExample((Output)new Label("Foo"), new String[0], new double[0]);
    }
}

