/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.DefaultMemoryRequestServer;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Util;
import com.yahoo.memory.XxHash64;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

abstract class BaseState {
    static final AtomicLong currentDirectMemoryAllocations_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryAllocated_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryMapAllocations_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryMapAllocated_ = new AtomicLong();
    static final MemoryRequestServer defaultMemReqSvr = new DefaultMemoryRequestServer();
    static final int READONLY = 1;
    static final int REGION = 2;
    static final int DUPLICATE = 4;
    static final int HEAP = 0;
    static final int DIRECT = 8;
    static final int MAP = 16;
    static final int BYTEBUF = 24;
    static final int NATIVE = 0;
    static final int NONNATIVE = 32;
    static final int MEMORY = 0;
    static final int BUFFER = 64;
    private final long capacityBytes_;
    private final long cumBaseOffset_;

    BaseState(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        this.capacityBytes_ = capacityBytes;
        this.cumBaseOffset_ = regionOffset + (unsafeObj == null ? nativeBaseOffset : (long)UnsafeUtil.unsafe.arrayBaseOffset(unsafeObj.getClass()));
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof BaseState ? CompareAndCopy.equals(this, (BaseState)that) : false;
    }

    public final boolean equalTo(long thisOffsetBytes, Object that, long thatOffsetBytes, long lengthBytes) {
        return that instanceof BaseState ? CompareAndCopy.equals(this, thisOffsetBytes, (BaseState)that, thatOffsetBytes, lengthBytes) : false;
    }

    public ByteBuffer getByteBuffer() {
        return null;
    }

    public final ByteOrder getByteOrder() {
        return this.isNonNativeType() ? Util.nonNativeOrder : Util.nativeOrder;
    }

    public final long getCapacity() {
        this.assertValid();
        return this.capacityBytes_;
    }

    public final long getCumulativeOffset() {
        this.assertValid();
        return this.cumBaseOffset_;
    }

    public final long getCumulativeOffset(long offsetBytes) {
        this.assertValid();
        return this.cumBaseOffset_ + offsetBytes;
    }

    abstract MemoryRequestServer getMemoryRequestServer();

    long getNativeBaseOffset() {
        return 0L;
    }

    public final long getRegionOffset() {
        Object unsafeObj = this.getUnsafeObject();
        return unsafeObj == null ? this.cumBaseOffset_ - this.getNativeBaseOffset() : this.cumBaseOffset_ - (long)UnsafeUtil.unsafe.arrayBaseOffset(unsafeObj.getClass());
    }

    public final long getRegionOffset(long offsetBytes) {
        return this.getRegionOffset() + offsetBytes;
    }

    abstract int getTypeId();

    Object getUnsafeObject() {
        return null;
    }

    public final boolean hasArray() {
        this.assertValid();
        return this.getUnsafeObject() != null;
    }

    public final int hashCode() {
        return (int)this.xxHash64(0L, this.getCapacity(), 0L);
    }

    public final long xxHash64(long offsetBytes, long lengthBytes, long seed) {
        this.checkValid();
        return XxHash64.hash(this.getUnsafeObject(), this.getCumulativeOffset() + offsetBytes, lengthBytes, seed);
    }

    public final boolean hasByteBuffer() {
        this.assertValid();
        return this.getByteBuffer() != null;
    }

    public final boolean isDirect() {
        return this.getUnsafeObject() == null;
    }

    public final boolean isNativeOrder() {
        this.assertValid();
        return Util.isNativeOrder(this.getByteOrder());
    }

    public final boolean isReadOnly() {
        this.assertValid();
        return this.isReadOnlyType();
    }

    public final boolean isSameResource(Object that) {
        this.checkValid();
        if (that == null) {
            return false;
        }
        BaseState that1 = (BaseState)that;
        that1.checkValid();
        if (this == that1) {
            return true;
        }
        return this.getCumulativeOffset() == that1.getCumulativeOffset() && this.getCapacity() == that1.getCapacity() && this.getUnsafeObject() == that1.getUnsafeObject() && this.getByteBuffer() == that1.getByteBuffer();
    }

    public boolean isValid() {
        return true;
    }

    final void assertValid() {
        assert (this.isValid()) : "Memory not valid.";
    }

    final void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("Memory not valid.");
        }
    }

    final void assertValidAndBoundsForRead(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.getCapacity());
    }

    final void assertValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.getCapacity());
        assert (!this.isReadOnly()) : "Memory is read-only.";
    }

    public final void checkValidAndBounds(long offsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, this.getCapacity());
    }

    final void checkValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, this.getCapacity());
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Memory is read-only.");
        }
    }

    final boolean isReadOnlyType() {
        return (this.getTypeId() & 1) > 0;
    }

    final boolean isBufferType() {
        return (this.getTypeId() & 0x40) > 0;
    }

    final boolean isDuplicateType() {
        return (this.getTypeId() & 4) > 0;
    }

    final boolean isRegionType() {
        return (this.getTypeId() & 2) > 0;
    }

    final boolean isNonNativeType() {
        return (this.getTypeId() & 0x20) > 0;
    }

    final boolean isHeapType() {
        return (this.getTypeId() >>> 3 & 3) == 0;
    }

    final boolean isDirectType() {
        return (this.getTypeId() >>> 3 & 3) == 1;
    }

    final boolean isMapType() {
        return (this.getTypeId() >>> 3 & 3) == 2;
    }

    final boolean isBBType() {
        return (this.getTypeId() >>> 3 & 3) == 3;
    }

    public static final long getCurrentDirectMemoryAllocations() {
        return currentDirectMemoryAllocations_.get();
    }

    public static final long getCurrentDirectMemoryAllocated() {
        return currentDirectMemoryAllocated_.get();
    }

    public static final long getCurrentDirectMemoryMapAllocations() {
        return currentDirectMemoryMapAllocations_.get();
    }

    public static final long getCurrentDirectMemoryMapAllocated() {
        return currentDirectMemoryMapAllocated_.get();
    }

    static void reachabilityFence(Object obj) {
    }

    public final String toHexString(String header, long offsetBytes, int lengthBytes) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(UnsafeUtil.LS);
        sb.append("Header Comment      : ").append(header).append(UnsafeUtil.LS);
        sb.append("Call Parameters     : ").append(call);
        return BaseState.toHex(this, sb.toString(), offsetBytes, lengthBytes);
    }

    static final String toHex(BaseState state, String preamble, long offsetBytes, int lengthBytes) {
        long uObjHeader;
        String uObjStr;
        long capacity = state.getCapacity();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, capacity);
        StringBuilder sb = new StringBuilder();
        Object uObj = state.getUnsafeObject();
        if (uObj == null) {
            uObjStr = "null";
            uObjHeader = 0L;
        } else {
            uObjStr = uObj.getClass().getSimpleName() + ", " + ((long)uObj.hashCode() & 0xFFFFFFFFL);
            uObjHeader = UnsafeUtil.unsafe.arrayBaseOffset(uObj.getClass());
        }
        ByteBuffer bb = state.getByteBuffer();
        String bbStr = bb == null ? "null" : bb.getClass().getSimpleName() + ", " + ((long)bb.hashCode() & 0xFFFFFFFFL);
        MemoryRequestServer memReqSvr = state.getMemoryRequestServer();
        String memReqStr = memReqSvr != null ? memReqSvr.getClass().getSimpleName() + ", " + ((long)memReqSvr.hashCode() & 0xFFFFFFFFL) : "null";
        long cumBaseOffset = state.getCumulativeOffset();
        sb.append(preamble).append(UnsafeUtil.LS);
        sb.append("UnsafeObj, hashCode : ").append(uObjStr).append(UnsafeUtil.LS);
        sb.append("UnsafeObjHeader     : ").append(uObjHeader).append(UnsafeUtil.LS);
        sb.append("ByteBuf, hashCode   : ").append(bbStr).append(UnsafeUtil.LS);
        sb.append("RegionOffset        : ").append(state.getRegionOffset()).append(UnsafeUtil.LS);
        sb.append("Capacity            : ").append(capacity).append(UnsafeUtil.LS);
        sb.append("CumBaseOffset       : ").append(cumBaseOffset).append(UnsafeUtil.LS);
        sb.append("MemReq, hashCode    : ").append(memReqStr).append(UnsafeUtil.LS);
        sb.append("Valid               : ").append(state.isValid()).append(UnsafeUtil.LS);
        sb.append("Read Only           : ").append(state.isReadOnly()).append(UnsafeUtil.LS);
        sb.append("Byte Order          : ").append(state.getByteOrder().toString()).append(UnsafeUtil.LS);
        sb.append("JDK Major Version   : ").append(UnsafeUtil.JDK).append(UnsafeUtil.LS);
        sb.append("Data, littleEndian  :  0  1  2  3  4  5  6  7");
        for (long i = 0L; i < (long)lengthBytes; ++i) {
            int b = UnsafeUtil.unsafe.getByte(uObj, cumBaseOffset + offsetBytes + i) & 0xFF;
            if (i % 8L == 0L) {
                sb.append(String.format("%n%20s: ", offsetBytes + i));
            }
            sb.append(String.format("%02x ", b));
        }
        sb.append(UnsafeUtil.LS);
        return sb.toString();
    }
}

