/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.changes;

import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndicesService;
import org.opensearch.replication.ReplicationPlugin;
import org.opensearch.replication.action.changes.GetChangesRequest;
import org.opensearch.replication.action.changes.GetChangesResponse;
import org.opensearch.replication.seqno.RemoteClusterStats;
import org.opensearch.replication.seqno.RemoteClusterTranslogService;
import org.opensearch.replication.seqno.RemoteShardMetric;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportActionProxy;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001'BG\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0016\u0010\u0017\u001a\u00120&R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/opensearch/replication/action/changes/TransportGetChangesAction;", "Lorg/opensearch/action/support/single/shard/TransportSingleShardAction;", "Lorg/opensearch/replication/action/changes/GetChangesRequest;", "Lorg/opensearch/replication/action/changes/GetChangesResponse;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "translogService", "Lorg/opensearch/replication/seqno/RemoteClusterTranslogService;", "remoteStatsService", "Lorg/opensearch/replication/seqno/RemoteClusterStats;", "(Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/indices/IndicesService;Lorg/opensearch/replication/seqno/RemoteClusterTranslogService;Lorg/opensearch/replication/seqno/RemoteClusterStats;)V", "asyncShardOperation", "", "request", "shardId", "Lorg/opensearch/index/shard/ShardId;", "listener", "Lorg/opensearch/action/ActionListener;", "getResponseReader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "isTranslogPruningByRetentionLeaseEnabled", "", "resolveIndex", "shardOperation", "shards", "Lorg/opensearch/cluster/routing/ShardsIterator;", "state", "Lorg/opensearch/cluster/ClusterState;", "Lorg/opensearch/action/support/single/shard/TransportSingleShardAction$InternalRequest;", "Companion", "opensearch-cross-cluster-replication"})
public final class TransportGetChangesAction
extends TransportSingleShardAction<GetChangesRequest, GetChangesResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final RemoteClusterTranslogService translogService;
    @NotNull
    private final RemoteClusterStats remoteStatsService;
    @NotNull
    private static final TimeValue WAIT_FOR_NEW_OPS_TIMEOUT;
    private static final Logger log;

    @Inject
    public TransportGetChangesAction(@NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull IndicesService indicesService, @NotNull RemoteClusterTranslogService translogService, @NotNull RemoteClusterStats remoteStatsService) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)((Object)translogService), (String)"translogService");
        Intrinsics.checkNotNullParameter((Object)((Object)remoteStatsService), (String)"remoteStatsService");
        super("indices:data/read/plugins/replication/changes", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetChangesRequest::new, "replication_leader");
        this.indicesService = indicesService;
        this.translogService = translogService;
        this.remoteStatsService = remoteStatsService;
        TransportActionProxy.registerProxyAction((TransportService)transportService, (String)"indices:data/read/plugins/replication/changes", GetChangesResponse::new);
    }

    @NotNull
    protected GetChangesResponse shardOperation(@NotNull GetChangesRequest request, @NotNull ShardId shardId) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        throw new UnsupportedOperationException("use asyncShardOperation");
    }

    protected void asyncShardOperation(@NotNull GetChangesRequest request, @NotNull ShardId shardId, @NotNull ActionListener<GetChangesResponse> listener2) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        ThreadPool threadPool = this.threadPool;
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"threadPool");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.coroutineContext(threadPool, "replication_leader"), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, shardId, request, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            final /* synthetic */ ActionListener<GetChangesResponse> $listener;
            final /* synthetic */ TransportGetChangesAction this$0;
            final /* synthetic */ ShardId $shardId;
            final /* synthetic */ GetChangesRequest $request;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                this.$shardId = $shardId;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var29_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$listener;
                        var3_4 = this.this$0;
                        var4_5 = this.$shardId;
                        var5_6 = this.$request;
                        $i$f$completeWith = false;
                        var28_8 = $this$completeWith$iv;
                        $i$a$-completeWith-TransportGetChangesAction$asyncShardOperation$1$1 = false;
                        relativeStartNanos = System.nanoTime();
                        var10_11 = TransportGetChangesAction.access$getRemoteStatsService$p(var3_4).getStats();
                        var11_12 = TransportGetChangesAction.access$getRemoteStatsService$p(var3_4).getStats().getOrDefault(var4_5, new RemoteShardMetric());
                        var10_11.put(var4_5, var11_12);
                        v0 = TransportGetChangesAction.access$getRemoteStatsService$p(var3_4).getStats().get(var4_5);
                        Intrinsics.checkNotNull((Object)v0);
                        indexMetric = v0;
                        indexMetric.getLastFetchTime().set(relativeStartNanos);
                        indexShard = TransportGetChangesAction.access$getIndicesService$p(var3_4).indexServiceSafe(var4_5.getIndex()).getShard(var4_5.getId());
                        if (indexShard.getLastSyncedGlobalCheckpoint() >= var5_6.getFromSeqNo()) ** GOTO lbl60
                        Intrinsics.checkNotNullExpressionValue((Object)indexShard, (String)"indexShard");
                        this.L$0 = $this$completeWith$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = indexMetric;
                        this.L$5 = indexShard;
                        this.L$6 = var28_8;
                        this.label = 1;
                        v1 = CoroutinesKt.waitForGlobalCheckpoint(indexShard, var5_6.getFromSeqNo(), TransportGetChangesAction.Companion.getWAIT_FOR_NEW_OPS_TIMEOUT(), (Continuation<? super Long>)this);
                        ** if (v1 != var29_2) goto lbl37
lbl36:
                        // 1 sources

                        return var29_2;
lbl37:
                        // 1 sources

                        ** GOTO lbl52
                    }
                    case 1: {
                        $i$f$completeWith = false;
                        $i$a$-completeWith-TransportGetChangesAction$asyncShardOperation$1$1 = false;
                        var28_8 = (ActionListener)this.L$6;
                        indexShard = (IndexShard)this.L$5;
                        indexMetric = (RemoteShardMetric)this.L$4;
                        var5_6 = (GetChangesRequest)this.L$3;
                        var4_5 = (ShardId)this.L$2;
                        var3_4 = (TransportGetChangesAction)this.L$1;
                        $this$completeWith$iv = (ActionListener)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl52:
                            // 2 sources

                            gcp = ((Number)v1).longValue();
                            if (indexShard.getLastSyncedGlobalCheckpoint() < var5_6.getFromSeqNo()) {
                                v2 = var14_14 = gcp > indexShard.getLastSyncedGlobalCheckpoint();
                                if (_Assertions.ENABLED && !var14_14) {
                                    $i$a$-assert-TransportGetChangesAction$asyncShardOperation$1$1$1 = false;
                                    $i$a$-assert-TransportGetChangesAction$asyncShardOperation$1$1$1 = "Checkpoint didn't advance at all";
                                    throw new AssertionError((Object)$i$a$-assert-TransportGetChangesAction$asyncShardOperation$1$1$1);
                                }
                                throw new OpenSearchTimeoutException("global checkpoint not synced. Retry after a few miliseconds...", new Object[0]);
                            }
lbl60:
                            // 3 sources

                            relativeStartNanos = System.nanoTime();
                            var16_19 = indexShard.getLastSyncedGlobalCheckpoint();
                            var18_20 = var5_6.getToSeqNo();
                            toSeqNo = Math.min(var16_19, var18_20);
                            ops = null;
                            ops = CollectionsKt.emptyList();
                            fetchFromTranslog = TransportGetChangesAction.access$isTranslogPruningByRetentionLeaseEnabled(var3_4, var4_5);
                            if (fetchFromTranslog) {
                                try {
                                    v3 = TransportGetChangesAction.access$getTranslogService$p(var3_4);
                                    Intrinsics.checkNotNullExpressionValue((Object)indexShard, (String)"indexShard");
                                    ops = v3.getHistoryOfOperations(indexShard, var5_6.getFromSeqNo(), toSeqNo);
                                }
                                catch (Exception e) {
                                    TransportGetChangesAction.access$getLog$cp().debug("Fetching changes from translog for " + var5_6.getShardId() + " - from:" + var5_6.getFromSeqNo() + ", to:" + toSeqNo + " failed with exception - " + ExtensionsKt.stackTraceToString(e));
                                    fetchFromTranslog = false;
                                }
                            }
                            if (!fetchFromTranslog) {
                                TransportGetChangesAction.access$getLog$cp().debug("Fetching changes from lucene for " + var5_6.getShardId() + " - from:" + var5_6.getFromSeqNo() + ", to:" + toSeqNo);
                                relativeStartNanos = System.nanoTime();
                                var20_22 = (Closeable)indexShard.newChangesSnapshot("odr", var5_6.getFromSeqNo(), toSeqNo, true, true);
                                var21_23 = null;
                                try {
                                    snapshot = (Translog.Snapshot)var20_22;
                                    $i$a$-use-TransportGetChangesAction$asyncShardOperation$1$1$2 = false;
                                    ops = new ArrayList<Translog.Operation>(snapshot.totalOperations());
                                    op = snapshot.next();
                                    while (op != null) {
                                        ops.add(op);
                                        op = snapshot.next();
                                    }
                                    var22_24 = Unit.INSTANCE;
                                }
                                catch (Throwable var22_25) {
                                    var21_23 = var22_25;
                                    throw var22_25;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var20_22, (Throwable)var21_23);
                                }
                            }
                            tookInNanos = System.nanoTime() - relativeStartNanos;
                            tookInMillis = TimeUnit.NANOSECONDS.toMillis(tookInNanos);
                            if (fetchFromTranslog) {
                                indexMetric.getLatencyTlog().addAndGet(tookInMillis);
                                indexMetric.getOpsTlog().addAndGet(ops.size());
                            } else {
                                indexMetric.getLatencyLucene().addAndGet(tookInMillis);
                                indexMetric.getOpsLucene().addAndGet(ops.size());
                            }
                            indexMetric.getTlogSize().set(indexShard.translogStats().getTranslogSizeInBytes());
                            indexMetric.getOps().addAndGet(ops.size());
                            ops.stream().forEach((Consumer<Translog.Operation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda-3$lambda-2(org.opensearch.replication.seqno.RemoteShardMetric org.opensearch.index.translog.Translog$Operation ), (Lorg/opensearch/index/translog/Translog$Operation;)V)((RemoteShardMetric)indexMetric));
                            var28_8.onResponse((Object)new GetChangesResponse(ops, var5_6.getFromSeqNo(), indexShard.getMaxSeqNoOfUpdatesOrDeletes(), indexShard.getLastSyncedGlobalCheckpoint()));
                        }
                        catch (Exception e$iv) {
                            $this$completeWith$iv.onFailure(e$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-3$lambda-2(RemoteShardMetric $indexMetric, Translog.Operation op) {
                $indexMetric.getBytesRead().addAndGet(op.estimateSize());
            }
        }), (int)2, null);
    }

    private final boolean isTranslogPruningByRetentionLeaseEnabled(ShardId shardId) {
        Boolean enabled;
        Boolean bl;
        IndexMetadata indexMetadata = (IndexMetadata)this.clusterService.state().getMetadata().getIndices().get((Object)shardId.getIndexName());
        if (indexMetadata == null) {
            bl = null;
        } else {
            Settings settings = indexMetadata.getSettings();
            bl = enabled = settings == null ? null : settings.getAsBoolean(ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING().getKey(), Boolean.valueOf(false));
        }
        if (enabled != null) {
            return enabled;
        }
        return false;
    }

    protected boolean resolveIndex(@NotNull GetChangesRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return true;
    }

    @NotNull
    protected Writeable.Reader<GetChangesResponse> getResponseReader() {
        return TransportGetChangesAction::getResponseReader$lambda-0;
    }

    @NotNull
    protected ShardsIterator shards(@NotNull ClusterState state, @NotNull TransportSingleShardAction.InternalRequest request) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ShardIterator shardIterator = state.routingTable().shardRoutingTable(((GetChangesRequest)request.request()).getShardId()).activeInitializingShardsRandomIt();
        Intrinsics.checkNotNullExpressionValue((Object)shardIterator, (String)"state.routingTable().sha\u2026tializingShardsRandomIt()");
        return (ShardsIterator)shardIterator;
    }

    private static final GetChangesResponse getResponseReader$lambda-0(StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        return new GetChangesResponse(inp);
    }

    public static final /* synthetic */ RemoteClusterStats access$getRemoteStatsService$p(TransportGetChangesAction $this) {
        return $this.remoteStatsService;
    }

    public static final /* synthetic */ IndicesService access$getIndicesService$p(TransportGetChangesAction $this) {
        return $this.indicesService;
    }

    public static final /* synthetic */ boolean access$isTranslogPruningByRetentionLeaseEnabled(TransportGetChangesAction $this, ShardId shardId) {
        return $this.isTranslogPruningByRetentionLeaseEnabled(shardId);
    }

    public static final /* synthetic */ RemoteClusterTranslogService access$getTranslogService$p(TransportGetChangesAction $this) {
        return $this.translogService;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        TimeValue timeValue = TimeValue.timeValueMinutes((long)1L);
        Intrinsics.checkNotNull((Object)timeValue);
        WAIT_FOR_NEW_OPS_TIMEOUT = timeValue;
        log = LogManager.getLogger(TransportGetChangesAction.class);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/replication/action/changes/TransportGetChangesAction$Companion;", "", "()V", "WAIT_FOR_NEW_OPS_TIMEOUT", "Lorg/opensearch/common/unit/TimeValue;", "getWAIT_FOR_NEW_OPS_TIMEOUT", "()Lorg/opensearch/common/unit/TimeValue;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeValue getWAIT_FOR_NEW_OPS_TIMEOUT() {
            return WAIT_FOR_NEW_OPS_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

