/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.NoOpValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.Migration;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v6.ConfigV6;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class ValidateApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/validate")));

    @Inject
    public ValidateApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.VALIDATE;
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        boolean acceptInvalid = request.paramAsBoolean("accept_invalid", false);
        SecurityDynamicConfiguration<ConfigV6> loadedConfig = this.load(CType.CONFIG, true, acceptInvalid);
        if (loadedConfig.getVersion() != 1) {
            this.badRequestResponse(channel, "Can not migrate configuration because it was already migrated.");
            return;
        }
        try {
            SecurityDynamicConfiguration<ConfigV6> configV6 = loadedConfig;
            SecurityDynamicConfiguration<?> actionGroupsV6 = this.load(CType.ACTIONGROUPS, true, acceptInvalid);
            SecurityDynamicConfiguration<InternalUserV6> internalUsersV6 = this.load(CType.INTERNALUSERS, true, acceptInvalid);
            SecurityDynamicConfiguration<RoleV6> rolesV6 = this.load(CType.ROLES, true, acceptInvalid);
            SecurityDynamicConfiguration<RoleMappingsV6> rolesmappingV6 = this.load(CType.ROLESMAPPING, true, acceptInvalid);
            SecurityDynamicConfiguration<AuditConfig> auditConfigV6 = this.load(CType.AUDIT, true);
            SecurityDynamicConfiguration<ActionGroupsV7> actionGroupsV7 = Migration.migrateActionGroups(actionGroupsV6);
            SecurityDynamicConfiguration<ConfigV7> configV7 = Migration.migrateConfig(configV6);
            SecurityDynamicConfiguration<InternalUserV7> internalUsersV7 = Migration.migrateInternalUsers(internalUsersV6);
            Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> rolesTenantsV7 = Migration.migrateRoles(rolesV6, rolesmappingV6);
            SecurityDynamicConfiguration<RoleMappingsV7> rolesmappingV7 = Migration.migrateRoleMappings(rolesmappingV6);
            SecurityDynamicConfiguration<AuditConfig> auditConfigV7 = Migration.migrateAudit(auditConfigV6);
            this.successResponse(channel, "OK.");
        }
        catch (Exception e) {
            this.internalErrorResponse(channel, "Configuration is not valid.");
        }
    }

    @Override
    protected void handleDelete(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.GET);
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.PUT);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new NoOpValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType getConfigName() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.paramAsBoolean("accept_invalid", false);
    }
}

