/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.LoggerMessageFormat;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.RolesInjector;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.CompatConfig;
import org.opensearch.security.configuration.DlsFlsRequestValve;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public class SecurityFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final org.opensearch.common.util.concurrent.ThreadContext threadContext;
    private final ClusterService cs;
    private final CompatConfig compatConfig;
    private final IndexResolverReplacer indexResolverReplacer;
    private final XFFResolver xffResolver;
    private final WildcardMatcher immutableIndicesMatcher;
    private final RolesInjector rolesInjector;
    private final UserInjector userInjector;

    public SecurityFilter(Settings settings, PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, CompatConfig compatConfig, IndexResolverReplacer indexResolverReplacer, XFFResolver xffResolver) {
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.cs = cs;
        this.compatConfig = compatConfig;
        this.indexResolverReplacer = indexResolverReplacer;
        this.xffResolver = xffResolver;
        this.immutableIndicesMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.compliance.immutable_indices", Collections.emptyList()));
        this.rolesInjector = new RolesInjector(auditLog);
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.log.info("{} indices are made immutable.", (Object)this.immutableIndicesMatcher);
    }

    @VisibleForTesting
    WildcardMatcher getImmutableIndicesMatcher() {
        return this.immutableIndicesMatcher;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
            ThreadContext.clearAll();
            this.apply0(task, action, request, listener, chain);
        }
    }

    private static Set<String> alias2Name(Set<Alias> aliases) {
        return (Set)aliases.stream().map(a -> a.name()).collect(ImmutableSet.toImmutableSet());
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(final Task task, final String action, final Request request, final ActionListener<Response> listener, final ActionFilterChain<Request, Response> chain) {
        try {
            PrivilegesEvaluator eval;
            boolean internalRequest;
            ComplianceConfig complianceConfig;
            if (this.threadContext.getTransient("_opendistro_security_origin") == null) {
                this.threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if ((complianceConfig = this.auditLog.getComplianceConfig()) != null && complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            Set<String> injectedRoles = this.rolesInjector.injectUserAndRoles((TransportRequest)request, action, task, this.threadContext);
            boolean enforcePrivilegesEvaluation = false;
            User user = (User)this.threadContext.getTransient("_opendistro_security_user");
            if (user == null && (user = this.userInjector.getInjectedUser()) != null) {
                this.threadContext.putTransient("_opendistro_security_user", (Object)user);
                enforcePrivilegesEvaluation = true;
            }
            boolean userIsAdmin = SecurityFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(this.threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_opendistro_security_conf_request"));
            boolean passThroughRequest = action.startsWith("indices:admin/seq_no") || action.equals("cluster:admin/opendistro_security/whoami");
            boolean bl = internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && action.startsWith("internal:") && !action.startsWith("internal:transport/proxy");
            if (user != null) {
                ThreadContext.put((String)"user", (String)user.getName());
            }
            if (OpenSearchSecurityPlugin.isActionTraceEnabled()) {
                Object count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                OpenSearchSecurityPlugin.traceAction("Node " + this.cs.localNode().getName() + " -> " + action + " (" + (String)count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_opendistro_security_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress());
                this.threadContext.putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + action + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_opendistro_security_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress() + " " + this.threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                    this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (this.immutableIndicesMatcher != WildcardMatcher.NONE) {
                boolean isImmutable = false;
                if (request instanceof BulkShardRequest) {
                    BulkItemRequest bsr;
                    BulkItemRequest[] bulkItemRequestArray = ((BulkShardRequest)request).items();
                    int n = bulkItemRequestArray.length;
                    for (int i = 0; i < n && !(isImmutable = this.checkImmutableIndices((bsr = bulkItemRequestArray[i]).request(), listener)); ++i) {
                    }
                } else {
                    isImmutable = this.checkImmutableIndices(request, listener);
                }
                if (isImmutable) {
                    return;
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(this.threadContext.getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && injectedRoles == null && !enforcePrivilegesEvaluation) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (user == null) {
                boolean skipSecurityIfDualMode;
                if (action.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                boolean bl2 = skipSecurityIfDualMode = this.threadContext.getTransient("_opendistro_security_passive_security") == Boolean.TRUE;
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null) && !this.compatConfig.transportInterClusterAuthEnabled()) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null || skipSecurityIfDualMode) && this.compatConfig.transportInterClusterPassiveAuthEnabled()) {
                    this.log.info("Transport auth in passive mode and no user found. Injecting default user");
                    user = User.DEFAULT_TRANSPORT_USER;
                    this.threadContext.putTransient("_opendistro_security_user", (Object)user);
                } else {
                    this.log.error("No user found for " + action + " from " + request.remoteAddress() + " " + this.threadContext.getTransient("_opendistro_security_origin") + " via " + this.threadContext.getTransient("_opendistro_security_channel_type") + " " + this.threadContext.getHeaders());
                    listener.onFailure((Exception)new OpenSearchSecurityException("No user found for " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    return;
                }
            }
            if (!(eval = this.evalp).isInitialized()) {
                this.log.error("OpenSearch Security not initialized for {}", (Object)action);
                listener.onFailure((Exception)new OpenSearchSecurityException("OpenSearch Security not initialized for " + action, RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            PrivilegesEvaluatorResponse pres = eval.evaluate(user, action, request, task, injectedRoles);
            if (this.log.isDebugEnabled()) {
                this.log.debug(pres.toString());
            }
            if (pres.isAllowed()) {
                this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                if (!this.dlsFlsValve.invoke(action, request, listener, pres.getEvaluatedDlsFlsConfig(), pres.getResolved())) {
                    return;
                }
                CreateIndexRequestBuilder createIndexRequestBuilder = pres.getCreateIndexRequestBuilder();
                if (createIndexRequestBuilder == null) {
                    chain.proceed(task, action, request, listener);
                } else {
                    final CreateIndexRequest createIndexRequest = (CreateIndexRequest)createIndexRequestBuilder.request();
                    this.log.info("Request {} requires new tenant index {} with aliases {}", (Object)request.getClass().getSimpleName(), (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()));
                    createIndexRequestBuilder.execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse createIndexResponse) {
                            if (createIndexResponse.isAcknowledged()) {
                                SecurityFilter.this.log.debug("Request to create index {} with aliases {} acknowledged, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName());
                                chain.proceed(task, action, request, listener);
                            } else {
                                String message = LoggerMessageFormat.format((String)"Request to create index {} with aliases {} was not acknowledged, failing {}", (String)createIndexRequest.index(), (Object[])new Object[]{SecurityFilter.alias2Name(createIndexRequest.aliases()), request.getClass().getSimpleName()});
                                SecurityFilter.this.log.error(message);
                                listener.onFailure((Exception)new OpenSearchException(message, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                            if (cause instanceof ResourceAlreadyExistsException) {
                                SecurityFilter.this.log.warn("Request to create index {} with aliases {} failed as the resource already exists, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                chain.proceed(task, action, request, listener);
                            } else {
                                SecurityFilter.this.log.error("Request to create index {} with aliases {} failed, failing {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), (Object)e);
                                listener.onFailure(e);
                            }
                        }
                    });
                }
            } else {
                this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
                String err = !pres.getMissingSecurityRoles().isEmpty() ? String.format("No mapping for %s on roles %s", user, pres.getMissingSecurityRoles()) : (injectedRoles != null ? String.format("no permissions for %s and associated roles %s", pres.getMissingPrivileges(), pres.getResolvedSecurityRoles()) : String.format("no permissions for %s and %s", pres.getMissingPrivileges(), user));
                this.log.debug(err);
                listener.onFailure((Exception)new OpenSearchSecurityException(err, RestStatus.FORBIDDEN, new Object[0]));
            }
        }
        catch (OpenSearchException e) {
            if (task != null) {
                this.log.debug("Failed to apply filter. Task id: {} ({}). Action: {}", (Object)task.getId(), (Object)task.getDescription(), (Object)action, (Object)e);
            } else {
                this.log.debug("Failed to apply filter. Action: {}", (Object)action, (Object)e);
            }
            listener.onFailure((Exception)((Object)e));
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception " + e, e);
            listener.onFailure((Exception)new OpenSearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && this.threadContext.getHeader("_opendistro_security_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            this.threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
        }
    }

    private boolean checkImmutableIndices(Object request, ActionListener listener) {
        boolean isModifyIndexRequest;
        boolean bl = isModifyIndexRequest = request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest;
        if (isModifyIndexRequest && this.isRequestIndexImmutable(request)) {
            listener.onFailure((Exception)new OpenSearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0]));
            return true;
        }
        if (request instanceof IndexRequest && this.isRequestIndexImmutable(request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
        }
        return false;
    }

    private boolean isRequestIndexImmutable(Object request) {
        IndexResolverReplacer.Resolved resolved = this.indexResolverReplacer.resolveRequest(request);
        if (resolved.isLocalAll()) {
            return true;
        }
        Set<String> allIndices = resolved.getAllIndices();
        return this.immutableIndicesMatcher.matchAny(allIndices);
    }
}

