/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.transport;

import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.ssl.transport.SecuritySSLRequestHandler;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.transport.InterClusterRequestEvaluator;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

public class SecurityRequestHandler<T extends TransportRequest>
extends SecuritySSLRequestHandler<T> {
    private final AuditLog auditLog;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;

    SecurityRequestHandler(String action, TransportRequestHandler<T> actualHandler, ThreadPool threadPool, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs, SSLConfig SSLConfig2, SslExceptionHandler sslExceptionHandler) {
        super(action, actualHandler, threadPool, principalExtractor, SSLConfig2, sslExceptionHandler);
        this.auditLog = auditLog;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceivedDecorate(T request, TransportRequestHandler<T> handler, TransportChannel transportChannel, Task task) throws Exception {
        String resolvedActionClass = request.getClass().getSimpleName();
        if (request instanceof BulkShardRequest && ((BulkShardRequest)request).items().length == 1) {
            resolvedActionClass = ((BulkShardRequest)request).items()[0].request().getClass().getSimpleName();
        }
        if (request instanceof TransportReplicationAction.ConcreteShardRequest) {
            resolvedActionClass = ((TransportReplicationAction.ConcreteShardRequest)request).getRequest().getClass().getSimpleName();
        }
        String initialActionClassValue = this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header");
        ThreadContext.StoredContext sgContext = this.getThreadContext().newStoredContext(false);
        String originHeader = this.getThreadContext().getHeader("_opendistro_security_origin_header");
        if (!Strings.isNullOrEmpty((String)originHeader)) {
            this.getThreadContext().putTransient("_opendistro_security_origin", (Object)originHeader);
        }
        try {
            boolean skipSecurityIfDualMode;
            ShardSearchRequest sr;
            if (transportChannel.getChannelType() == null) {
                throw new RuntimeException("Can not determine channel type (null)");
            }
            String channelType = transportChannel.getChannelType();
            if (!channelType.equals("direct") && !channelType.equals("transport")) {
                TransportChannel innerChannel = this.getInnerChannel(transportChannel);
                channelType = innerChannel.getChannelType();
            }
            this.getThreadContext().putTransient("_opendistro_security_channel_type", (Object)channelType);
            this.getThreadContext().putTransient("_opendistro_security_action_name", (Object)task.getAction());
            if (request instanceof ShardSearchRequest && (sr = (ShardSearchRequest)request).source() != null && sr.source().suggest() != null) {
                this.getThreadContext().putTransient("_opendistro_security_issuggest", (Object)Boolean.TRUE);
            }
            if (channelType.equals("direct")) {
                String rolesValidation;
                String userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header");
                String injectedRolesHeader = this.getThreadContext().getHeader("opendistro_security_injected_roles_header");
                String injectedUserHeader = this.getThreadContext().getHeader("injected_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    if (!Strings.isNullOrEmpty((String)injectedRolesHeader)) {
                        this.getThreadContext().putTransient("opendistro_security_injected_roles", (Object)injectedRolesHeader);
                    } else if (!Strings.isNullOrEmpty((String)injectedUserHeader)) {
                        this.getThreadContext().putTransient("injected_user", (Object)injectedUserHeader);
                    }
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                String originalRemoteAddress = this.getThreadContext().getHeader("_opendistro_security_remote_address_header");
                if (!Strings.isNullOrEmpty((String)originalRemoteAddress)) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                }
                if (!Strings.isNullOrEmpty((String)(rolesValidation = this.getThreadContext().getHeader("opendistro_security_injected_roles_validation_header")))) {
                    this.getThreadContext().putTransient("opendistro_security_injected_roles_validation", (Object)rolesValidation);
                }
                if (OpenSearchSecurityPlugin.isActionTraceEnabled()) {
                    this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " DIR -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders());
                }
                this.putInitialActionClassHeader(initialActionClassValue, resolvedActionClass);
                super.messageReceivedDecorate(request, handler, transportChannel, task);
                return;
            }
            boolean bl = skipSecurityIfDualMode = this.getThreadContext().getTransient("_opendistro_security_passive_security") == Boolean.TRUE;
            if (skipSecurityIfDualMode) {
                if (this.getThreadContext().getTransient("_opendistro_security_remote_address") == null) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)request.remoteAddress());
                }
                if (this.getThreadContext().getTransient("_opendistro_security_origin") == null) {
                    this.getThreadContext().putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.TRANSPORT.toString());
                }
                if (this.getThreadContext().getTransient("_opendistro_security_ssl_transport_trustedcluster_request") == null) {
                    this.getThreadContext().putTransient("_opendistro_security_ssl_transport_trustedcluster_request", (Object)Boolean.TRUE);
                }
                super.messageReceivedDecorate(request, handler, transportChannel, task);
                return;
            }
            if (!(HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext()) || task.getAction().equals("internal:transport/handshake") || !task.getAction().startsWith("internal:") && !task.getAction().contains("["))) {
                this.auditLog.logMissingPrivileges(task.getAction(), (TransportRequest)request, task);
                this.log.error("Internal or shard requests (" + task.getAction() + ") not allowed from a non-server node for transport type " + transportChannel.getChannelType());
                transportChannel.sendResponse((Exception)new OpenSearchSecurityException("Internal or shard requests not allowed from a non-server node for transport type " + transportChannel.getChannelType(), new Object[0]));
                return;
            }
            String principal = null;
            principal = (String)this.getThreadContext().getTransient("_opendistro_security_ssl_transport_principal");
            if (principal == null) {
                OpenSearchSecurityException ex = new OpenSearchSecurityException("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". OpenSearch Security needs the OpenSearch Security SSL plugin to be installed", new Object[0]);
                this.auditLog.logSSLException((TransportRequest)request, (Throwable)ex, task.getAction(), task);
                this.log.error("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". OpenSearch Security needs the OpenSearch Security SSL plugin to be installed");
                transportChannel.sendResponse((Exception)ex);
                return;
            }
            if (this.getThreadContext().getTransient("_opendistro_security_origin") == null) {
                this.getThreadContext().putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.TRANSPORT.toString());
            }
            if (HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext())) {
                String userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header");
                String injectedRolesHeader = this.getThreadContext().getHeader("opendistro_security_injected_roles_header");
                String injectedUserHeader = this.getThreadContext().getHeader("injected_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    if (!Strings.isNullOrEmpty((String)injectedRolesHeader)) {
                        this.getThreadContext().putTransient("opendistro_security_injected_roles", (Object)injectedRolesHeader);
                    } else if (!Strings.isNullOrEmpty((String)injectedUserHeader)) {
                        this.getThreadContext().putTransient("injected_user", (Object)injectedUserHeader);
                    }
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                String originalRemoteAddress = this.getThreadContext().getHeader("_opendistro_security_remote_address_header");
                if (!Strings.isNullOrEmpty((String)originalRemoteAddress)) {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                } else {
                    this.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)request.remoteAddress());
                }
                String rolesValidation = this.getThreadContext().getHeader("opendistro_security_injected_roles_validation_header");
                if (!Strings.isNullOrEmpty((String)rolesValidation)) {
                    this.getThreadContext().putTransient("opendistro_security_injected_roles_validation", (Object)rolesValidation);
                }
            } else {
                OpenSearchException exception = ExceptionUtils.createTransportClientNoLongerSupportedException();
                this.log.error(exception.toString());
                transportChannel.sendResponse((Exception)((Object)exception));
                return;
            }
            if (OpenSearchSecurityPlugin.isActionTraceEnabled()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " NETTI -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            this.putInitialActionClassHeader(initialActionClassValue, resolvedActionClass);
            super.messageReceivedDecorate(request, handler, transportChannel, task);
        }
        finally {
            if (OpenSearchSecurityPlugin.isActionTraceEnabled()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FIN -> " + transportChannel.getChannelType() + " " + this.getThreadContext().getHeaders());
            }
            if (sgContext != null) {
                sgContext.close();
            }
        }
    }

    private void putInitialActionClassHeader(String initialActionClassValue, String resolvedActionClass) {
        if (initialActionClassValue == null) {
            if (this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header") == null) {
                this.getThreadContext().putHeader("_opendistro_security_initial_action_class_header", resolvedActionClass);
            }
        } else if (this.getThreadContext().getHeader("_opendistro_security_initial_action_class_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_initial_action_class_header", initialActionClassValue);
        }
    }

    @Override
    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) throws Exception {
        boolean isInterClusterRequest = this.requestEvalProvider.isInterClusterRequest(request, localCerts, peerCerts, principal);
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isInterClusterRequest) {
            if (this.cs.getClusterName().value().equals(this.getThreadContext().getHeader("_opendistro_security_remotecn"))) {
                if (isTraceEnabled && !action.startsWith("internal:")) {
                    this.log.trace("Is inter cluster request ({}/{}/{})", (Object)action, request.getClass(), (Object)request.remoteAddress());
                }
                this.getThreadContext().putTransient("_opendistro_security_ssl_transport_intercluster_request", (Object)Boolean.TRUE);
            } else {
                this.getThreadContext().putTransient("_opendistro_security_ssl_transport_trustedcluster_request", (Object)Boolean.TRUE);
            }
        } else if (isTraceEnabled) {
            this.log.trace("Is not an inter cluster request");
        }
        super.addAdditionalContextValues(action, request, localCerts, peerCerts, principal);
    }
}

