/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.rest.RestStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0017\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J%\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001fH\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lorg/opensearch/indexmanagement/IndexManagementIndices;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/IndicesAdminClient;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/IndicesAdminClient;Lorg/opensearch/cluster/service/ClusterService;)V", "historyNumberOfReplicas", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "historyNumberOfShards", "logger", "Lorg/apache/logging/log4j/Logger;", "attemptInitStateManagementIndex", "", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptUpdateConfigIndexMapping", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndUpdateHistoryIndex", "checkAndUpdateIMConfigIndex", "(Lorg/apache/logging/log4j/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "createHistoryIndex", "index", "", "alias", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexManagementIndexExists", "indexStateManagementIndexHistoryExists", "Companion", "opensearch-index-management"})
public class IndexManagementIndices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesAdminClient client;
    @NotNull
    private final ClusterService clusterService;
    private final Logger logger;
    private volatile Integer historyNumberOfShards;
    private volatile Integer historyNumberOfReplicas;
    @NotNull
    public static final String HISTORY_INDEX_BASE = ".opendistro-ism-managed-index-history";
    @NotNull
    public static final String HISTORY_WRITE_INDEX_ALIAS = ".opendistro-ism-managed-index-history-write";
    @NotNull
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>";
    @NotNull
    public static final String HISTORY_ALL = ".opendistro-ism-managed-index-history*";
    @NotNull
    private static final String indexManagementMappings;
    @NotNull
    private static final String indexStateManagementHistoryMappings;
    @NotNull
    private static final String rollupTargetMappings;
    @NotNull
    private static final String transformTargetMappings;

    public IndexManagementIndices(@NotNull Settings settings, @NotNull IndicesAdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
        this.logger = LogManager.getLogger(this.getClass());
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS().get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS(), arg_0 -> IndexManagementIndices._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS(), arg_0 -> IndexManagementIndices._init_$lambda-1(this, arg_0));
    }

    public void checkAndUpdateIMConfigIndex(@NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.indexManagementIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-ism-config").mapping(indexManagementMappings).settings(Settings.builder().put("index.hidden", true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(actionListener){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                {
                    this.$actionListener = $actionListener;
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$actionListener.onFailure(e);
                }

                public void onResponse(@NotNull CreateIndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }
            });
        } else {
            ClusterState clusterState = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, this.client, actionListener);
        }
    }

    @Nullable
    public Object checkAndUpdateIMConfigIndex(@NotNull Logger logger, @NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.checkAndUpdateIMConfigIndex$suspendImpl(this, logger, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkAndUpdateIMConfigIndex$suspendImpl(IndexManagementIndices var0, Logger var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof checkAndUpdateIMConfigIndex.2)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super checkAndUpdateIMConfigIndex.2>)var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.checkAndUpdateIMConfigIndex$suspendImpl(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = logger;
                $continuation.label = 1;
                var4_6 = $continuation;
                var5_7 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var4_6));
                cont = (Continuation)var5_7;
                $i$a$-suspendCoroutine-IndexManagementIndices$checkAndUpdateIMConfigIndex$response$1 = false;
                var0.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>((Continuation<? super AcknowledgedResponse>)cont){
                    final /* synthetic */ Continuation<AcknowledgedResponse> $cont;
                    {
                        this.$cont = $cont;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        this.$cont.resumeWith(Result.constructor-impl((Object)response2));
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                    }
                }));
                v0 = var5_7.getOrThrow();
                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v1 = v0;
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                logger = (Logger)$continuation.L$1;
                (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                response = (AcknowledgedResponse)v1;
                if (response.isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                logger.error("Unable to create or update .opendistro-ism-config with newest mapping.");
                throw new OpenSearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean indexManagementIndexExists() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-ism-config");
    }

    @Nullable
    public Object attemptInitStateManagementIndex(@NotNull Client client, @NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this, client, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object attemptInitStateManagementIndex$suspendImpl(IndexManagementIndices var0, Client var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof attemptInitStateManagementIndex.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super attemptInitStateManagementIndex.1>)var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.indexManagementIndexExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)new Function2<Client, ActionListener<AcknowledgedResponse>, Unit>(this){
                    final /* synthetic */ IndexManagementIndices this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.this$0.checkAndUpdateIMConfigIndex(it);
                    }
                }, $continuation);
                ** if (v0 != var7_5) goto lbl21
lbl20:
                // 1 sources

                return var7_5;
lbl21:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    this.logger.error("Creating .opendistro-ism-config with mappings NOT acknowledged");
                    return Boxing.boxBoolean((boolean)false);
                }
                catch (ResourceAlreadyExistsException var4_8) {
                    var3_7 = true;
                }
                catch (Exception e) {
                    this.logger.error("Error trying to create .opendistro-ism-config", (Throwable)e);
                    var3_7 = false;
                }
                return Boxing.boxBoolean((boolean)(var3_7 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object attemptUpdateConfigIndexMapping(@NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.attemptUpdateConfigIndexMapping$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object attemptUpdateConfigIndexMapping$suspendImpl(IndexManagementIndices var0, Continuation var1_1) {
        if (!(var1_1 instanceof attemptUpdateConfigIndexMapping.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super attemptUpdateConfigIndexMapping.1>)var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.attemptUpdateConfigIndexMapping$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(this){
                    final /* synthetic */ IndexManagementIndices this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        ClusterState clusterState = IndexManagementIndices.access$getClusterService$p(this.this$0).state();
                        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                        IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, IndexManagementIndices.access$getClient$p(this.this$0), it);
                    }
                }, $continuation);
                ** if (v0 != var6_4) goto lbl19
lbl18:
                // 1 sources

                return var6_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    this.logger.error("Trying to update config index mapping not acknowledged.");
                    return Boxing.boxBoolean((boolean)false);
                }
                catch (Exception e) {
                    this.logger.error("Failed when trying to update config index mapping.", (Throwable)e);
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean indexStateManagementIndexHistoryExists() {
        return this.clusterService.state().getMetadata().hasAlias(HISTORY_WRITE_INDEX_ALIAS);
    }

    @Nullable
    public Object checkAndUpdateHistoryIndex(@NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkAndUpdateHistoryIndex$suspendImpl(IndexManagementIndices var0, Continuation var1_1) {
        if (!(var1_1 instanceof checkAndUpdateHistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super checkAndUpdateHistoryIndex.1>)var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.indexStateManagementIndexHistoryExists()) break;
                $continuation.label = 1;
                v0 = this.createHistoryIndex("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>", ".opendistro-ism-managed-index-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                return v0;
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(this){
            final /* synthetic */ IndexManagementIndices this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ClusterState clusterState = IndexManagementIndices.access$getClusterService$p(this.this$0).state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                IndexUtils.Companion.checkAndUpdateHistoryIndexMapping(clusterState, IndexManagementIndices.access$getClient$p(this.this$0), it);
            }
        }, $continuation);
        if (v1 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl32
        {
            case 2: {
                this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                if ((response = (AcknowledgedResponse)v1).isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                this.logger.error("Updating .opendistro-ism-managed-index-history-write with new mappings NOT acknowledged");
                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private Object createHistoryIndex(String var1_1, String var2_2, Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof createHistoryIndex.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.access$createHistoryIndex(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(this, index){
                    final /* synthetic */ IndexManagementIndices this$0;
                    final /* synthetic */ String $index;
                    {
                        this.this$0 = $receiver;
                        this.$index = $index;
                        super(2);
                    }

                    public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String[] stringArray = new String[]{this.$index};
                        IndexManagementIndices.access$getClient$p(this.this$0).exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
                    }
                }, $continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                v1 = new CreateIndexRequest(index).mapping(IndexManagementIndices.indexStateManagementHistoryMappings);
                v2 = Settings.builder().put("index.hidden", true);
                var6_8 = this.historyNumberOfShards;
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"historyNumberOfShards");
                v3 = v2.put("index.number_of_shards", ((Number)var6_8).intValue());
                var6_8 = this.historyNumberOfReplicas;
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"historyNumberOfReplicas");
                request = v1.settings(v3.put("index.number_of_replicas", ((Number)var6_8).intValue()).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(this, request){
                    final /* synthetic */ IndexManagementIndices this$0;
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(@NotNull IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        IndexManagementIndices.access$getClient$p(this.this$0).create(this.$request, it);
                    }
                }, $continuation);
                ** if (v4 != var10_6) goto lbl48
lbl47:
                // 1 sources

                return var10_6;
lbl48:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                index = (String)$continuation.L$1;
                this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl56:
                    // 2 sources

                    if ((createIndexResponse = (CreateIndexResponse)v4).isAcknowledged()) {
                        v5 = true;
                    } else {
                        this.logger.error("Creating " + index + " with mappings NOT acknowledged");
                        v5 = false;
                    }
                    var6_9 = v5;
                }
                catch (ResourceAlreadyExistsException var7_11) {
                    var6_9 = true;
                }
                catch (Exception e) {
                    this.logger.error("Error trying to create " + index, (Throwable)e);
                    var6_9 = false;
                }
                return Boxing.boxBoolean((boolean)(var6_9 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createHistoryIndex$default(IndexManagementIndices indexManagementIndices, String string, String string2, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createHistoryIndex");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return indexManagementIndices.createHistoryIndex(string, string2, (Continuation<? super Boolean>)continuation);
    }

    private static final void _init_$lambda-0(IndexManagementIndices this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyNumberOfShards = it;
    }

    private static final void _init_$lambda-1(IndexManagementIndices this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyNumberOfReplicas = it;
    }

    public static final /* synthetic */ ClusterService access$getClusterService$p(IndexManagementIndices $this) {
        return $this.clusterService;
    }

    public static final /* synthetic */ IndicesAdminClient access$getClient$p(IndexManagementIndices $this) {
        return $this.client;
    }

    public static final /* synthetic */ Object access$createHistoryIndex(IndexManagementIndices $this, String index2, String alias, Continuation $completion) {
        return $this.createHistoryIndex(index2, alias, (Continuation<? super Boolean>)$completion);
    }

    static {
        URL uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-config.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"IndexManagementIndices::\u2026ndistro-ism-config.json\")");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        indexManagementMappings = new String(byArray, charset);
        uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-history.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"IndexManagementIndices::\u2026distro-ism-history.json\")");
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL);
        indexStateManagementHistoryMappings = new String(byArray, charset);
        uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-rollup-target.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"IndexManagementIndices::\u2026stro-rollup-target.json\")");
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL);
        rollupTargetMappings = new String(byArray, charset);
        uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-transform-target.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"IndexManagementIndices::\u2026o-transform-target.json\")");
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL);
        transformTargetMappings = new String(byArray, charset);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/IndexManagementIndices$Companion;", "", "()V", "HISTORY_ALL", "", "HISTORY_INDEX_BASE", "HISTORY_INDEX_PATTERN", "HISTORY_WRITE_INDEX_ALIAS", "indexManagementMappings", "getIndexManagementMappings", "()Ljava/lang/String;", "indexStateManagementHistoryMappings", "getIndexStateManagementHistoryMappings", "rollupTargetMappings", "getRollupTargetMappings", "transformTargetMappings", "getTransformTargetMappings", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getIndexManagementMappings() {
            return indexManagementMappings;
        }

        @NotNull
        public final String getIndexStateManagementHistoryMappings() {
            return indexStateManagementHistoryMappings;
        }

        @NotNull
        public final String getRollupTargetMappings() {
            return rollupTargetMappings;
        }

        @NotNull
        public final String getTransformTargetMappings() {
            return transformTargetMappings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

