/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.notification;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.indexmanagement.indexstatemanagement.action.NotificationAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.notification.AttemptNotificationStep;
import org.opensearch.indexmanagement.indexstatemanagement.util.NotificationUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0011\u0010\u0015\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/notification/AttemptNotificationStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/NotificationAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/NotificationAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "compileTemplate", "scriptService", "Lorg/opensearch/script/ScriptService;", "template", "Lorg/opensearch/script/Script;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "currentMetadata", "handleException", "", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isIdempotent", "", "Companion", "opensearch-index-management"})
public final class AttemptNotificationStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "attempt_notification";
    @NotNull
    public static final String CHANNEL_TITLE = "Index Management-ISM-Notification Action";

    public AttemptNotificationStep(@NotNull NotificationAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptNotificationStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                scriptService = context.getScriptService();
                compiledMessage = this.compileTemplate(scriptService, this.action.getMessageTemplate(), context.getMetadata());
                v1 = this.action.getDestination();
                if (v1 == null) ** GOTO lbl43
                v2 = v1.buildLegacyBaseMessage(null, compiledMessage);
                if (v2 == null) ** GOTO lbl43
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = indexName;
                $continuation.L$3 = compiledMessage;
                $continuation.label = 1;
                v3 = NotificationUtils.publishLegacyNotification(v2, context.getClient(), (Continuation<? super Unit>)$continuation);
                ** if (v3 != var8_4) goto lbl33
lbl32:
                // 1 sources

                return var8_4;
lbl33:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                compiledMessage = (String)$continuation.L$3;
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptNotificationStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl43:
                // 4 sources

                v4 = this.action.getChannel();
                if (v4 == null) ** GOTO lbl61
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v5 = NotificationUtils.sendNotification(v4, context.getClient(), "Index Management-ISM-Notification Action", context.getMetadata(), compiledMessage, context.getUser(), (Continuation<? super Unit>)$continuation);
                ** if (v5 != var8_4) goto lbl53
lbl52:
                // 1 sources

                return var8_4;
lbl53:
                // 1 sources

                ** GOTO lbl61
            }
            case 2: {
                indexName = (String)$continuation.L$1;
                this = (AttemptNotificationStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl61:
                    // 3 sources

                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptNotificationStep.Companion.getSuccessMessage(indexName)));
                }
                catch (Exception e) {
                    this.handleException(indexName, e);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleException(String indexName, Exception e) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            Map map = mutableInfo;
            String string = "cause";
            map.put(string, errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (int)120575, null);
    }

    private final String compileTemplate(ScriptService scriptService, Script template, ManagedIndexMetaData managedIndexMetaData) {
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        Map map = template.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"template.params");
        String string = factory.newInstance(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", OpenSearchExtensionsKt.convertToMap((ToXContent)managedIndexMetaData))))).execute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptService.compile(te\u2026))\n            .execute()");
        return string;
    }

    public boolean isIdempotent() {
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/notification/AttemptNotificationStep$Companion;", "", "()V", "CHANNEL_TITLE", "", "name", "getFailedMessage", "index", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to send notification [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully sent notification [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

