/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.opensearchapi;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ThreadContextElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.commons.authuser.User;
import org.opensearch.indexmanagement.util.SecurityUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/indexmanagement/opensearchapi/IndexManagementSecurityContext;", "Lkotlinx/coroutines/ThreadContextElement;", "", "id", "", "settings", "Lorg/opensearch/common/settings/Settings;", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext;", "user", "Lorg/opensearch/commons/authuser/User;", "(Ljava/lang/String;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/util/concurrent/ThreadContext;Lorg/opensearch/commons/authuser/User;)V", "injector", "Lorg/opensearch/commons/InjectSecurity;", "getInjector", "()Lorg/opensearch/commons/InjectSecurity;", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "logger", "Lorg/apache/logging/log4j/Logger;", "restoreThreadContext", "context", "Lkotlin/coroutines/CoroutineContext;", "oldState", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/Unit;)V", "updateThreadContext", "Key", "opensearch-index-management"})
public final class IndexManagementSecurityContext
implements ThreadContextElement<Unit> {
    @NotNull
    public static final Key Key = new Key(null);
    @NotNull
    private final String id;
    @NotNull
    private final ThreadContext threadContext;
    @Nullable
    private final User user;
    @NotNull
    private final Logger logger;
    @NotNull
    private final InjectSecurity injector;

    public IndexManagementSecurityContext(@NotNull String id2, @NotNull Settings settings, @NotNull ThreadContext threadContext, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
        this.id = id2;
        this.threadContext = threadContext;
        this.user = user;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.logger = logger;
        this.injector = new InjectSecurity(this.id, settings, this.threadContext);
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return Key;
    }

    @NotNull
    public final InjectSecurity getInjector() {
        return this.injector;
    }

    public void updateThreadContext(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.debug("Setting security context in thread " + Thread.currentThread().getName() + " for job " + this.id);
        this.injector.injectRoles(this.user == null ? SecurityUtils.Companion.getDEFAULT_INJECT_ROLES() : this.user.getRoles());
        this.injector.injectProperty("index_management_plugin_internal_user", (Object)true);
    }

    public void restoreThreadContext(@NotNull CoroutineContext context, @NotNull Unit oldState) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        this.logger.debug("Cleaning up security context in thread " + Thread.currentThread().getName() + " for job " + this.id);
        this.injector.close();
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)ThreadContextElement.DefaultImpls.fold((ThreadContextElement)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)ThreadContextElement.DefaultImpls.get((ThreadContextElement)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return ThreadContextElement.DefaultImpls.minusKey((ThreadContextElement)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return ThreadContextElement.DefaultImpls.plus((ThreadContextElement)this, (CoroutineContext)context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/indexmanagement/opensearchapi/IndexManagementSecurityContext$Key;", "Lkotlin/coroutines/CoroutineContext$Key;", "Lorg/opensearch/indexmanagement/opensearchapi/IndexManagementSecurityContext;", "()V", "opensearch-index-management"})
    public static final class Key
    implements CoroutineContext.Key<IndexManagementSecurityContext> {
        private Key() {
        }

        public /* synthetic */ Key(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

