/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.transport.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesResponse;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.TransportGetSMPoliciesAction;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ+\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ5\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0012\u0004\u0012\u00020$0!2\u0006\u0010%\u001a\u00020&2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\"\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0012\u0004\u0012\u00020$0!2\u0006\u0010+\u001a\u00020,H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0013*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/TransportGetSMPoliciesAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/BaseTransportAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPoliciesRequest;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPoliciesResponse;", "client", "Lorg/opensearch/client/Client;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/client/Client;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "executeRequest", "request", "user", "Lorg/opensearch/commons/authuser/User;", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPoliciesRequest;Lorg/opensearch/commons/authuser/User;Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllPolicies", "Lkotlin/Pair;", "", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "", "searchParams", "Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;", "(Lorg/opensearch/indexmanagement/common/model/rest/SearchParams;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllPoliciesRequest", "Lorg/opensearch/action/search/SearchRequest;", "parseGetAllPoliciesResponse", "searchResponse", "Lorg/opensearch/action/search/SearchResponse;", "opensearch-index-management"})
public final class TransportGetSMPoliciesAction
extends BaseTransportAction<GetSMPoliciesRequest, GetSMPoliciesResponse> {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    private final Logger log;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetSMPoliciesAction(@NotNull Client client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/snapshot_management/policy/search", transportService, client, actionFilters, GetSMPoliciesRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetSMPoliciesAction._init_$lambda-0(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object executeRequest(@NotNull GetSMPoliciesRequest var1_1, @Nullable User var2_2, @NotNull ThreadContext.StoredContext var3_3, @NotNull Continuation<? super GetSMPoliciesResponse> var4_4) {
        if (!(var4_4 instanceof executeRequest.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ TransportGetSMPoliciesAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeRequest((GetSMPoliciesRequest)null, (User)null, (ThreadContext.StoredContext)null, (Continuation<? super GetSMPoliciesResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                searchParams = request.getSearchParams();
                $continuation.label = 1;
                v0 = this.getAllPolicies(searchParams, (User)user, (Continuation<? super Pair<? extends List<SMPolicy>, Long>>)$continuation);
                if (v0 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                var6_9 = (Pair)v0;
                policies = (List)var6_9.component1();
                totalPoliciesCount = ((Number)var6_9.component2()).longValue();
                return new GetSMPoliciesResponse(policies, totalPoliciesCount);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getAllPolicies(SearchParams var1_1, User var2_2, Continuation<? super Pair<? extends List<SMPolicy>, Long>> var3_3) {
        if (!(var3_3 instanceof getAllPolicies.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransportGetSMPoliciesAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransportGetSMPoliciesAction.access$getAllPolicies(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                searchRequest = this.getAllPoliciesRequest((SearchParams)searchParams, (User)user);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.getClient(), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.search(this.$searchRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var10_6) goto lbl20
lbl19:
                // 1 sources

                return var10_6;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                this = (TransportGetSMPoliciesAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    var6_8 = (SearchResponse)v0;
                }
                catch (IndexNotFoundException var7_9) {
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                searchResponse = var6_8;
                return this.parseGetAllPoliciesResponse(searchResponse);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SearchRequest getAllPoliciesRequest(SearchParams searchParams, User user) {
        FieldSortBuilder sortBuilder = searchParams.getSortBuilder();
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("sm_policy")).must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchParams.getQueryString()).defaultOperator(Operator.AND).field("sm_policy.name"));
        Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"queryBuilder");
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
        SecurityUtils.Companion.addUserFilter(user, queryBuilder, bl, "sm_policy.user");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(searchParams.getSize()).from(searchParams.getFrom()).sort((SortBuilder)sortBuilder).query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        String[] stringArray = new String[]{".opendistro-ism-config"};
        SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSourceBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"SearchRequest(IndexManag\u2026urce(searchSourceBuilder)");
        return searchRequest;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<SMPolicy>, Long> parseGetAllPoliciesResponse(SearchResponse searchResponse2) {
        Pair pair;
        try {
            void $this$mapTo$iv$iv;
            long l;
            TotalHits totalHits = searchResponse2.getHits().getTotalHits();
            long totalPolicies = totalHits == null ? 0L : (l = totalHits.value);
            SearchHit[] searchHitArray = searchResponse2.getHits().getHits();
            Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"searchResponse.hits.hits");
            Object[] $this$map$iv = searchHitArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SearchHit searchHit = (SearchHit)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getSourceRef();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.sourceRef");
                XContentParser xContentParser = OpenSearchExtensionsKt.contentParser(object);
                object = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.id");
                collection.add((SMPolicy)OpenSearchExtensionsKt.parseWithType(xContentParser, (String)object, it.getSeqNo(), it.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, SMPolicy>((Object)SMPolicy.Companion){

                    @NotNull
                    public final SMPolicy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((SMPolicy.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                }));
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)totalPolicies);
        }
        catch (Exception e) {
            this.log.error("Failed to parse snapshot management policy in search response", (Throwable)e);
            throw new OpenSearchStatusException("Failed to parse snapshot management policy", RestStatus.NOT_FOUND, new Object[0]);
        }
        return pair;
    }

    private static final void _init_$lambda-0(TransportGetSMPoliciesAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ Object access$getAllPolicies(TransportGetSMPoliciesAction $this, SearchParams searchParams, User user, Continuation $completion) {
        return $this.getAllPolicies(searchParams, user, (Continuation<? super Pair<? extends List<SMPolicy>, Long>>)$completion);
    }
}

