/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HotShardRcaConfig {
    public static final String CONFIG_NAME = "hot-shard-rca";
    private Double cpuUtilizationThreshold;
    private Double ioTotThroughputThreshold;
    private Double ioTotSysCallRateThreshold;
    public static final double DEFAULT_CPU_UTILIZATION_THRESHOLD = 0.01;
    public static final double DEFAULT_IO_TOTAL_THROUGHPUT_THRESHOLD_IN_BYTE_PER_SEC = 250000.0;
    public static final double DEFAULT_IO_TOTAL_SYSCALL_RATE_THRESHOLD_PER_SEC = 0.01;

    public HotShardRcaConfig(RcaConf rcaConf) {
        this.cpuUtilizationThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "cpu-utilization", 0.01, s -> s > 0.0, Double.class);
        this.ioTotThroughputThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "io-total-throughput-in-bytes", 250000.0, s -> s > 0.0, Double.class);
        this.ioTotSysCallRateThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "io-total-syscallrate-per-second", 0.01, s -> s > 0.0, Double.class);
    }

    public double getCpuUtilizationThreshold() {
        return this.cpuUtilizationThreshold;
    }

    public double getIoTotThroughputThreshold() {
        return this.ioTotThroughputThreshold;
    }

    public double getIoTotSysCallRateThreshold() {
        return this.ioTotSysCallRateThreshold;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String CPU_UTILIZATION_THRESHOLD = "cpu-utilization";
        public static final String IO_TOT_THROUGHPUT_THRESHOLD_IN_BYTES = "io-total-throughput-in-bytes";
        public static final String IO_TOT_SYSCALL_RATE_THRESHOLD_PER_SECOND = "io-total-syscallrate-per-second";
    }
}

