/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.model.MLModelGetResponse;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetModelTransportAction
extends HandledTransportAction<ActionRequest, MLModelGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetModelTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/ml/models/get", transportService, actionFilters, MLModelGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGetResponse> actionListener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelGetRequest.getModelId();
        GetRequest getRequest = new GetRequest(".plugins-ml-model").id(modelId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(r -> {
                log.info("Completed Get Model Request, id:{}", (Object)modelId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModel mlModel = MLModel.parse((XContentParser)parser);
                        actionListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml model" + r.getId(), (Throwable)e);
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model"));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    actionListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model"));
                } else {
                    log.error("Failed to get ML model " + modelId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get ML model " + modelId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

