/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetResponse;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetTaskTransportAction
extends HandledTransportAction<ActionRequest, MLTaskGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetTaskTransportAction.class);
    Client client;
    NamedXContentRegistry xContentRegistry;

    @Inject
    public GetTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/ml/tasks/get", transportService, actionFilters, MLTaskGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLTaskGetResponse> actionListener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlTaskGetRequest.getTaskId();
        GetRequest getRequest = new GetRequest(".plugins-ml-task").id(taskId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.wrap(r -> {
                log.info("Completed Get Task Request, id:{}", (Object)taskId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLTask mlTask = MLTask.parse((XContentParser)parser);
                        actionListener.onResponse((Object)MLTaskGetResponse.builder().mlTask(mlTask).build());
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml task" + r.getId(), (Throwable)e);
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find task"));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    actionListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find task"));
                } else {
                    log.error("Failed to get ML task " + taskId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get ML task " + taskId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

