/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionStats;

public class MLAlgoStats
implements ToXContentFragment,
Writeable {
    private Map<ActionName, MLActionStats> algoStats;

    public MLAlgoStats(StreamInput in) throws IOException {
        this.algoStats = in.readMap(stream -> (ActionName)stream.readEnum(ActionName.class), MLActionStats::new);
    }

    public MLAlgoStats(Map<ActionName, MLActionStats> algoStats) {
        this.algoStats = algoStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.algoStats, (stream, v) -> stream.writeEnum((Enum)v), (stream, stats) -> stats.writeTo(stream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.algoStats != null && this.algoStats.size() > 0) {
            for (Map.Entry<ActionName, MLActionStats> entry : this.algoStats.entrySet()) {
                builder.startObject(entry.getKey().name().toLowerCase(Locale.ROOT));
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public MLActionStats getActionStats(ActionName action) {
        return this.algoStats == null ? null : this.algoStats.get((Object)action);
    }
}

