/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.task;

import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.Model;
import org.opensearch.ml.common.breaker.MLCircuitBreakerService;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataset.DataFrameInputDataset;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.MLPredictionOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.indices.MLInputDatasetHandler;
import org.opensearch.ml.permission.AccessController;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionLevelStat;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.task.MLTaskRunner;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportResponseHandler;

public class MLPredictTaskRunner
extends MLTaskRunner<MLPredictionTaskRequest, MLTaskResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLPredictTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;
    private final NamedXContentRegistry xContentRegistry;

    public MLPredictTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, NamedXContentRegistry xContentRegistry) {
        super(mlTaskManager, mlStats, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/opensearch/ml/predict";
    }

    @Override
    protected TransportResponseHandler<MLTaskResponse> getResponseHandler(ActionListener<MLTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLTaskResponse::new);
    }

    @Override
    protected void executeTask(MLPredictionTaskRequest request, ActionListener<MLTaskResponse> listener) {
        MLInputDataType inputDataType = request.getMlInput().getInputDataset().getInputDataType();
        Instant now = Instant.now();
        MLTask mlTask = MLTask.builder().taskId(UUID.randomUUID().toString()).modelId(request.getModelId()).taskType(MLTaskType.PREDICTION).inputType(inputDataType).functionName(request.getMlInput().getFunctionName()).state(MLTaskState.CREATED).workerNode(this.clusterService.localNode().getId()).createTime(now).lastUpdateTime(now).async(false).build();
        MLInput mlInput = request.getMlInput();
        if (mlInput.getInputDataset().getInputDataType().equals((Object)MLInputDataType.SEARCH_QUERY)) {
            ActionListener dataFrameActionListener = ActionListener.wrap(dataFrame -> this.predict(mlTask, (DataFrame)dataFrame, request, listener), e -> {
                log.error("Failed to generate DataFrame from search query", (Throwable)e);
                this.handleAsyncMLTaskFailure(mlTask, (Exception)e);
                listener.onFailure(e);
            });
            this.mlInputDatasetHandler.parseSearchQueryInput(mlInput.getInputDataset(), (ActionListener<DataFrame>)new ThreadedActionListener(log, this.threadPool, "OPENSEARCH_ML_TASK_THREAD_POOL", dataFrameActionListener, false));
        } else {
            DataFrame inputDataFrame = this.mlInputDatasetHandler.parseDataFrameInput(mlInput.getInputDataset());
            this.threadPool.executor("OPENSEARCH_ML_TASK_THREAD_POOL").execute(() -> this.predict(mlTask, inputDataFrame, request, listener));
        }
    }

    private void predict(MLTask mlTask, DataFrame inputDataFrame, MLPredictionTaskRequest request, ActionListener<MLTaskResponse> listener) {
        ActionListener<MLTaskResponse> internalListener = this.wrappedCleanupListener(listener, mlTask.getTaskId());
        this.mlStats.getStat(MLNodeLevelStat.ML_NODE_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat(MLNodeLevelStat.ML_NODE_TOTAL_REQUEST_COUNT).increment();
        this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.PREDICT, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        this.mlTaskManager.add(mlTask);
        if (request.getModelId() != null) {
            try (ThreadContext.StoredContext context = this.threadPool.getThreadContext().stashContext();){
                MLInput mlInput = request.getMlInput();
                ActionListener getResponseListener = ActionListener.wrap(r -> {
                    if (r == null || !r.isExists()) {
                        internalListener.onFailure((Exception)new ResourceNotFoundException("No model found, please check the modelId.", new Object[0]));
                        return;
                    }
                    try (XContentParser xContentParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, r.getSourceAsString());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xContentParser.nextToken(), (XContentParser)xContentParser);
                        MLModel mlModel = MLModel.parse((XContentParser)xContentParser);
                        User resourceUser = mlModel.getUser();
                        User requestUser = AccessController.getUserContext(this.client);
                        if (!AccessController.checkUserPermissions(requestUser, resourceUser, request.getModelId())) {
                            OpenSearchException e = new OpenSearchException("User: " + requestUser.getName() + " does not have permissions to run predict by model: " + request.getModelId(), new Object[0]);
                            this.handlePredictFailure(mlTask, internalListener, (Exception)e, false);
                            return;
                        }
                        Model model = new Model();
                        model.setName(mlModel.getName());
                        model.setVersion(mlModel.getVersion().intValue());
                        byte[] decoded = Base64.getDecoder().decode(mlModel.getContent());
                        model.setContent(decoded);
                        this.mlTaskManager.updateTaskState(mlTask.getTaskId(), MLTaskState.RUNNING, mlTask.isAsync());
                        MLOutput output = MLEngine.predict((Input)mlInput.toBuilder().inputDataset((MLInputDataset)new DataFrameInputDataset(inputDataFrame)).build(), (Model)model);
                        if (output instanceof MLPredictionOutput) {
                            ((MLPredictionOutput)output).setStatus(MLTaskState.COMPLETED.name());
                        }
                        this.handleAsyncMLTaskComplete(mlTask);
                        MLTaskResponse response = MLTaskResponse.builder().output(output).build();
                        internalListener.onResponse((Object)response);
                    }
                    catch (Exception e) {
                        log.error("Failed to predict model " + request.getModelId(), (Throwable)e);
                        internalListener.onFailure(e);
                    }
                }, e -> {
                    log.error("Failed to predict " + mlInput.getAlgorithm() + ", modelId: " + mlTask.getModelId(), (Throwable)e);
                    this.handlePredictFailure(mlTask, internalListener, (Exception)e, true);
                });
                GetRequest getRequest = new GetRequest(".plugins-ml-model", mlTask.getModelId());
                this.client.get(getRequest, ActionListener.runBefore((ActionListener)getResponseListener, () -> context.restore()));
            }
            catch (Exception e2) {
                log.error("Failed to get model " + mlTask.getModelId(), (Throwable)e2);
                this.handlePredictFailure(mlTask, internalListener, e2, true);
            }
        } else {
            IllegalArgumentException e3 = new IllegalArgumentException("ModelId is invalid");
            log.error("ModelId is invalid", (Throwable)e3);
            this.handlePredictFailure(mlTask, internalListener, e3, false);
        }
    }

    private void handlePredictFailure(MLTask mlTask, ActionListener<MLTaskResponse> listener, Exception e, boolean trackFailure) {
        if (trackFailure) {
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.PREDICT, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat(MLNodeLevelStat.ML_NODE_TOTAL_FAILURE_COUNT).increment();
        }
        this.handleAsyncMLTaskFailure(mlTask, e);
        listener.onFailure(e);
    }
}

