/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.heap.AdmissionControlByHeap;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.model.HeapMetric;
import org.opensearch.performanceanalyzer.util.range.Range;
import org.opensearch.performanceanalyzer.util.range.RangeConfiguration;

public class AdmissionControlByMediumHeap
implements AdmissionControlByHeap {
    private static final Logger LOG = LogManager.getLogger(AdmissionControlByMediumHeap.class);
    private double previousHeapPercent = 0.0;
    private InstanceDetails instanceDetails;
    private RangeConfiguration requestSizeHeapRange;

    @Override
    public void init(InstanceDetails instanceDetails, RangeConfiguration rangeConfiguration) {
        this.instanceDetails = instanceDetails;
        this.requestSizeHeapRange = rangeConfiguration;
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> generateFlowUnits(HeapMetric heapMetric) {
        long currentTimeMillis = System.currentTimeMillis();
        double currentHeapPercent = heapMetric.getHeapPercent();
        HotNodeSummary nodeSummary = new HotNodeSummary(this.instanceDetails.getInstanceId(), this.instanceDetails.getInstanceIp());
        if (this.requestSizeHeapRange.hasRangeChanged(this.previousHeapPercent, currentHeapPercent)) {
            double currentThreshold = this.getThreshold(this.requestSizeHeapRange, currentHeapPercent);
            if (currentThreshold == 0.0) {
                return new ResourceFlowUnit<HotNodeSummary>(currentTimeMillis, new ResourceContext(Resources.State.HEALTHY), nodeSummary, !this.instanceDetails.getIsMaster());
            }
            LOG.debug("[AdmissionControl] PreviousHeapPercent={} CurrentHeapPercent={} CurrentDesiredThreshold={}", (Object)this.previousHeapPercent, (Object)currentHeapPercent, (Object)currentThreshold);
            double previousThreshold = this.getThreshold(this.requestSizeHeapRange, this.previousHeapPercent);
            this.previousHeapPercent = currentHeapPercent;
            HotResourceSummary resourceSummary = new HotResourceSummary(ResourceUtil.HEAP_MAX_SIZE, currentThreshold, previousThreshold, 0);
            nodeSummary.appendNestedSummary(resourceSummary);
            PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.ADMISSION_CONTROL_RCA_TRIGGERED, this.instanceDetails.getInstanceId().toString(), 1);
            return new ResourceFlowUnit<HotNodeSummary>(currentTimeMillis, new ResourceContext(Resources.State.UNHEALTHY), nodeSummary, !this.instanceDetails.getIsMaster());
        }
        return new ResourceFlowUnit<HotNodeSummary>(currentTimeMillis, new ResourceContext(Resources.State.HEALTHY), nodeSummary, !this.instanceDetails.getIsMaster());
    }

    private double getThreshold(RangeConfiguration heapRange, double heapPercent) {
        Range range = heapRange.getRange(heapPercent);
        return Objects.isNull(range) ? 0.0 : range.getThreshold();
    }
}

