/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader.HttpRequestMetricsSnapshot;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;

public class HttpRequestEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(HttpRequestEventProcessor.class);
    private HttpRequestMetricsSnapshot httpSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private HttpRequestEventProcessor(HttpRequestMetricsSnapshot httpSnap) {
        this.httpSnap = httpSnap;
    }

    static HttpRequestEventProcessor buildHttpRequestMetricEventsProcessor(long currWindowStartTime, long currWindowEndTime, Connection conn, NavigableMap<Long, HttpRequestMetricsSnapshot> httpRqMetricsMap) throws Exception {
        if (httpRqMetricsMap.get(currWindowStartTime) == null) {
            HttpRequestMetricsSnapshot httpRqSnap = new HttpRequestMetricsSnapshot(conn, currWindowStartTime);
            Map.Entry<Long, HttpRequestMetricsSnapshot> entry = httpRqMetricsMap.lastEntry();
            if (entry != null) {
                httpRqSnap.rolloverInflightRequests(entry.getValue());
            }
            httpRqMetricsMap.put(currWindowStartTime, httpRqSnap);
            return new HttpRequestEventProcessor(httpRqSnap);
        }
        return new HttpRequestEventProcessor((HttpRequestMetricsSnapshot)httpRqMetricsMap.get(currWindowStartTime));
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.httpSnap.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
    }

    @Override
    public void processEvent(Event event) {
        String[] keyItems = event.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        if (keyItems[1].equals("http")) {
            if (keyItems[4].equals("start")) {
                this.emitStartHttpMetric(event, keyItems);
            } else if (keyItems[4].equals("finish")) {
                this.emitFinishHttpMetric(event, keyItems);
            }
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("http");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.httpSnap.startBatchPut();
        }
    }

    private void emitStartHttpMetric(Event entry, String[] keyItems) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String startTimeVal = keyValueMap.get(AllMetrics.HttpMetric.START_TIME.toString());
        String itemCountVal = keyValueMap.get(AllMetrics.HttpMetric.HTTP_REQUEST_DOCS.toString());
        try {
            long st = Long.parseLong(startTimeVal);
            String indices = keyValueMap.get(AllMetrics.HttpDimension.INDICES.toString());
            long itemCount = Long.parseLong(itemCountVal);
            String rid = keyItems[3];
            String operation = keyItems[2];
            this.handle.bind(new Object[]{rid, operation, indices, null, null, itemCount, st, null});
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse string. StartTime:{}, itemCount:{}, ExcepionCode: {},\n startMetrics:{}", (Object)startTimeVal, (Object)itemCountVal, (Object)StatExceptionCode.READER_PARSER_ERROR.toString(), (Object)entry.key);
            StatsCollector.instance().logException(StatExceptionCode.READER_PARSER_ERROR);
            throw e;
        }
    }

    private void emitFinishHttpMetric(Event entry, String[] keyItems) {
        Map<String, String> keyValueMap = ReaderMetricsProcessor.extractEntryData(entry.value);
        String finishTimeVal = keyValueMap.get(AllMetrics.HttpMetric.FINISH_TIME.toString());
        String status = keyValueMap.get(AllMetrics.HttpDimension.HTTP_RESP_CODE.toString());
        String exception = keyValueMap.get(AllMetrics.HttpDimension.EXCEPTION.toString());
        try {
            long ft = Long.parseLong(finishTimeVal);
            String rid = keyItems[3];
            String operation = keyItems[2];
            this.handle.bind(new Object[]{rid, operation, null, status, exception, null, null, ft});
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse string. FinishTime:{} ExcepionCode: {} \n finishMetrics:{}", (Object)finishTimeVal, (Object)StatExceptionCode.READER_PARSER_ERROR.toString(), (Object)entry.key);
            StatsCollector.instance().logException(StatExceptionCode.READER_PARSER_ERROR);
            throw e;
        }
    }
}

