/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.resthandler;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.reportsscheduler.action.GetReportInstanceAction;
import org.opensearch.reportsscheduler.action.UpdateReportInstanceStatusAction;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.GetReportInstanceRequest;
import org.opensearch.reportsscheduler.model.GetReportInstanceResponse;
import org.opensearch.reportsscheduler.model.UpdateReportInstanceStatusRequest;
import org.opensearch.reportsscheduler.model.UpdateReportInstanceStatusResponse;
import org.opensearch.reportsscheduler.resthandler.PluginBaseHandler;
import org.opensearch.reportsscheduler.resthandler.RestResponseToXContentListener;
import org.opensearch.reportsscheduler.util.HelpersKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/reportsscheduler/resthandler/ReportInstanceRestHandler;", "Lorg/opensearch/reportsscheduler/resthandler/PluginBaseHandler;", "()V", "executeRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "getName", "", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "responseParams", "", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-reports-scheduler"})
public final class ReportInstanceRestHandler
extends PluginBaseHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String REPORT_INSTANCE_LIST_ACTION = "report_instance_actions";
    @NotNull
    private static final String REPORT_INSTANCE_URL = "/_plugins/_reports/instance";
    @NotNull
    private static final String LEGACY_REPORT_INSTANCE_URL = "/_opendistro/_reports/instance";

    @NotNull
    public String getName() {
        return REPORT_INSTANCE_LIST_ACTION;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_reports/instance/{reportInstanceId}", RestRequest.Method.POST, "/_opendistro/_reports/instance/{reportInstanceId}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_reports/instance/{reportInstanceId}", RestRequest.Method.GET, "/_opendistro/_reports/instance/{reportInstanceId}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected Set<String> responseParams() {
        return SetsKt.setOf((Object)"reportInstanceId");
    }

    @Override
    @NotNull
    protected BaseRestHandler.RestChannelConsumer executeRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        BaseRestHandler.RestChannelConsumer restChannelConsumer;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String string = request.param("reportInstanceId");
        if (string == null) {
            throw new IllegalArgumentException("Must specify id");
        }
        String reportInstanceId = string;
        RestRequest.Method method = request.method();
        switch (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                restChannelConsumer = arg_0 -> ReportInstanceRestHandler.executeRequest$lambda-0(client, request, reportInstanceId, arg_0);
                break;
            }
            case 2: {
                restChannelConsumer = arg_0 -> ReportInstanceRestHandler.executeRequest$lambda-1(client, reportInstanceId, arg_0);
                break;
            }
            default: {
                restChannelConsumer = arg_0 -> ReportInstanceRestHandler.executeRequest$lambda-2(request, arg_0);
            }
        }
        return restChannelConsumer;
    }

    private static final void executeRequest$lambda-0(NodeClient $client, RestRequest $request, String $reportInstanceId, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$reportInstanceId, (String)"$reportInstanceId");
        Metrics.REPORT_INSTANCE_UPDATE_TOTAL.getCounter().increment();
        Metrics.REPORT_INSTANCE_UPDATE_INTERVAL_COUNT.getCounter().increment();
        ActionType<UpdateReportInstanceStatusResponse> actionType = UpdateReportInstanceStatusAction.Companion.getACTION_TYPE$opensearch_reports_scheduler();
        ActionRequest actionRequest = UpdateReportInstanceStatusRequest.Companion.parse(HelpersKt.contentParserNextToken($request), $reportInstanceId);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executeRequest$lambda-1(NodeClient $client, String $reportInstanceId, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$reportInstanceId, (String)"$reportInstanceId");
        Metrics.REPORT_INSTANCE_INFO_TOTAL.getCounter().increment();
        Metrics.REPORT_INSTANCE_INFO_INTERVAL_COUNT.getCounter().increment();
        ActionType<GetReportInstanceResponse> actionType = GetReportInstanceAction.Companion.getACTION_TYPE$opensearch_reports_scheduler();
        ActionRequest actionRequest = new GetReportInstanceRequest($reportInstanceId);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    private static final void executeRequest$lambda-2(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/reportsscheduler/resthandler/ReportInstanceRestHandler$Companion;", "", "()V", "LEGACY_REPORT_INSTANCE_URL", "", "REPORT_INSTANCE_LIST_ACTION", "REPORT_INSTANCE_URL", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            nArray[RestRequest.Method.POST.ordinal()] = 1;
            nArray[RestRequest.Method.GET.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

