/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.settings;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.SecureString;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/settings/LegacyOpenDistroDestinationSettings;", "", "()V", "Companion", "opensearch-alerting"})
public final class LegacyOpenDistroDestinationSettings {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String DESTINATION_SETTING_PREFIX = "opendistro.alerting.destination.";
    @NotNull
    public static final String EMAIL_DESTINATION_SETTING_PREFIX = "opendistro.alerting.destination.email.";
    @NotNull
    private static final List<String> ALLOW_LIST_ALL;
    @NotNull
    private static final List<String> HOST_DENY_LIST_NONE;
    @NotNull
    private static final Setting<List<String>> ALLOW_LIST;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;
    @NotNull
    private static final Setting<List<String>> HOST_DENY_LIST;

    private static final Setting EMAIL_USERNAME$lambda-1(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_PASSWORD$lambda-2(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = ArraysKt.toList((Object[])DestinationType.values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DestinationType destinationType = (DestinationType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        ALLOW_LIST_ALL = (List)var3_4;
        HOST_DENY_LIST_NONE = CollectionsKt.emptyList();
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated};
        Setting setting = Setting.listSetting((String)"opendistro.alerting.destination.allow_list", ALLOW_LIST_ALL, Function.identity(), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"listSetting(\n           \u2026erty.Deprecated\n        )");
        ALLOW_LIST = setting;
        setting = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", LegacyOpenDistroDestinationSettings::EMAIL_USERNAME$lambda-1, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"affixKeySetting(\n       \u2026ng(key, null) }\n        )");
        EMAIL_USERNAME = setting;
        setting = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", LegacyOpenDistroDestinationSettings::EMAIL_PASSWORD$lambda-2, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"affixKeySetting(\n       \u2026ng(key, null) }\n        )");
        EMAIL_PASSWORD = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final, Setting.Property.Deprecated};
        setting = Setting.listSetting((String)"opendistro.destination.host.deny_list", HOST_DENY_LIST_NONE, Function.identity(), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"listSetting(\n           \u2026erty.Deprecated\n        )");
        HOST_DENY_LIST = setting;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000fH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020!0#2\u0006\u0010\u001b\u001a\u00020\u001cR\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006%"}, d2={"Lorg/opensearch/alerting/settings/LegacyOpenDistroDestinationSettings$Companion;", "", "()V", "ALLOW_LIST", "Lorg/opensearch/common/settings/Setting;", "", "", "getALLOW_LIST", "()Lorg/opensearch/common/settings/Setting;", "ALLOW_LIST_ALL", "getALLOW_LIST_ALL", "()Ljava/util/List;", "DESTINATION_SETTING_PREFIX", "EMAIL_DESTINATION_SETTING_PREFIX", "EMAIL_PASSWORD", "Lorg/opensearch/common/settings/Setting$AffixSetting;", "Lorg/opensearch/common/settings/SecureString;", "getEMAIL_PASSWORD", "()Lorg/opensearch/common/settings/Setting$AffixSetting;", "EMAIL_USERNAME", "getEMAIL_USERNAME", "HOST_DENY_LIST", "getHOST_DENY_LIST", "HOST_DENY_LIST_NONE", "getHOST_DENY_LIST_NONE", "getLegacyEmailSettingValue", "T", "settings", "Lorg/opensearch/common/settings/Settings;", "emailAccountName", "emailSetting", "(Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Lorg/opensearch/common/settings/Setting$AffixSetting;)Ljava/lang/Object;", "getLegacySecureDestinationSettings", "Lorg/opensearch/alerting/settings/LegacyOpenDistroDestinationSettings$Companion$SecureDestinationSettings;", "loadLegacyDestinationSettings", "", "SecureDestinationSettings", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getALLOW_LIST_ALL() {
            return ALLOW_LIST_ALL;
        }

        @NotNull
        public final List<String> getHOST_DENY_LIST_NONE() {
            return HOST_DENY_LIST_NONE;
        }

        @NotNull
        public final Setting<List<String>> getALLOW_LIST() {
            return ALLOW_LIST;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_USERNAME() {
            return EMAIL_USERNAME;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_PASSWORD() {
            return EMAIL_PASSWORD;
        }

        @NotNull
        public final Setting<List<String>> getHOST_DENY_LIST() {
            return HOST_DENY_LIST;
        }

        @NotNull
        public final Map<String, SecureDestinationSettings> loadLegacyDestinationSettings(@NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Set emailAccountNames = settings.getGroups(LegacyOpenDistroDestinationSettings.EMAIL_DESTINATION_SETTING_PREFIX).keySet();
            Map emailAccounts = new LinkedHashMap();
            for (String emailAccountName : emailAccountNames) {
                SecureDestinationSettings it;
                if (this.getLegacySecureDestinationSettings(settings, emailAccountName) == null) continue;
                boolean bl = false;
                emailAccounts.put(emailAccountName, it);
            }
            return emailAccounts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SecureDestinationSettings getLegacySecureDestinationSettings(Settings settings, String emailAccountName) {
            SecureDestinationSettings secureDestinationSettings;
            SecureString secureString = this.getLegacyEmailSettingValue(settings, emailAccountName, this.getEMAIL_USERNAME());
            if (secureString == null) {
                secureDestinationSettings = null;
            } else {
                Closeable closeable = (Closeable)secureString;
                Throwable throwable = null;
                try {
                    SecureDestinationSettings secureDestinationSettings2;
                    SecureString emailUsername = (SecureString)closeable;
                    boolean bl = false;
                    SecureString secureString2 = Companion.getLegacyEmailSettingValue(settings, emailAccountName, Companion.getEMAIL_PASSWORD());
                    if (secureString2 == null) {
                        secureDestinationSettings2 = null;
                    } else {
                        Closeable closeable2 = (Closeable)secureString2;
                        Throwable throwable2 = null;
                        try {
                            SecureString emailPassword = (SecureString)closeable2;
                            boolean bl2 = false;
                            SecureString secureString3 = emailUsername.clone();
                            Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"emailUsername.clone()");
                            SecureString secureString4 = secureString3;
                            secureString3 = emailPassword.clone();
                            Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"emailPassword.clone()");
                            SecureDestinationSettings secureDestinationSettings3 = new SecureDestinationSettings(secureString4, secureString3);
                            secureDestinationSettings2 = secureDestinationSettings3;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    SecureDestinationSettings secureDestinationSettings4 = secureDestinationSettings2;
                    secureDestinationSettings = secureDestinationSettings4;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return secureDestinationSettings;
        }

        private final <T> T getLegacyEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
            Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
            return (T)concreteSetting.get(settings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/alerting/settings/LegacyOpenDistroDestinationSettings$Companion$SecureDestinationSettings;", "", "emailUsername", "Lorg/opensearch/common/settings/SecureString;", "emailPassword", "(Lorg/opensearch/common/settings/SecureString;Lorg/opensearch/common/settings/SecureString;)V", "getEmailPassword", "()Lorg/opensearch/common/settings/SecureString;", "getEmailUsername", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "opensearch-alerting"})
        public static final class SecureDestinationSettings {
            @NotNull
            private final SecureString emailUsername;
            @NotNull
            private final SecureString emailPassword;

            public SecureDestinationSettings(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkNotNullParameter((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkNotNullParameter((Object)emailPassword, (String)"emailPassword");
                this.emailUsername = emailUsername;
                this.emailPassword = emailPassword;
            }

            @NotNull
            public final SecureString getEmailUsername() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString getEmailPassword() {
                return this.emailPassword;
            }

            @NotNull
            public final SecureString component1() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString component2() {
                return this.emailPassword;
            }

            @NotNull
            public final SecureDestinationSettings copy(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkNotNullParameter((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkNotNullParameter((Object)emailPassword, (String)"emailPassword");
                return new SecureDestinationSettings(emailUsername, emailPassword);
            }

            public static /* synthetic */ SecureDestinationSettings copy$default(SecureDestinationSettings secureDestinationSettings, SecureString secureString, SecureString secureString2, int n, Object object) {
                if ((n & 1) != 0) {
                    secureString = secureDestinationSettings.emailUsername;
                }
                if ((n & 2) != 0) {
                    secureString2 = secureDestinationSettings.emailPassword;
                }
                return secureDestinationSettings.copy(secureString, secureString2);
            }

            @NotNull
            public String toString() {
                return "SecureDestinationSettings(emailUsername=" + this.emailUsername + ", emailPassword=" + this.emailPassword + ")";
            }

            public int hashCode() {
                int result = this.emailUsername.hashCode();
                result = result * 31 + this.emailPassword.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SecureDestinationSettings)) {
                    return false;
                }
                SecureDestinationSettings secureDestinationSettings = (SecureDestinationSettings)other;
                if (!Intrinsics.areEqual((Object)this.emailUsername, (Object)secureDestinationSettings.emailUsername)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.emailPassword, (Object)secureDestinationSettings.emailPassword);
            }
        }
    }
}

