/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import java.util.List;
import lombok.Generated;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class HighlightExpression
extends FunctionExpression {
    private final Expression highlightField;

    public HighlightExpression(Expression highlightField) {
        super(BuiltinFunctionName.HIGHLIGHT.getName(), List.of(highlightField));
        this.highlightField = highlightField;
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        String refName = "_highlight." + StringUtils.unquoteText((String)this.getHighlightField().toString());
        return valueEnv.resolve(DSL.ref(refName, ExprCoreType.STRING));
    }

    @Override
    public ExprType type() {
        return ExprCoreType.ARRAY;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitHighlight(this, context);
    }

    @Generated
    public Expression getHighlightField() {
        return this.highlightField;
    }
}

