/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public class BuiltinFunctionRepository {
    private final Map<FunctionName, FunctionResolver> functionResolverMap;

    public void register(FunctionResolver resolver) {
        this.functionResolverMap.put(resolver.getFunctionName(), resolver);
    }

    public FunctionImplementation compile(FunctionName functionName, List<Expression> expressions) {
        FunctionBuilder resolvedFunctionBuilder = this.resolve(new FunctionSignature(functionName, expressions.stream().map(expression -> expression.type()).collect(Collectors.toList())));
        return resolvedFunctionBuilder.apply(expressions);
    }

    public FunctionBuilder resolve(FunctionSignature functionSignature) {
        FunctionName functionName = functionSignature.getFunctionName();
        if (this.functionResolverMap.containsKey(functionName)) {
            Pair<FunctionSignature, FunctionBuilder> resolvedSignature = this.functionResolverMap.get(functionName).resolve(functionSignature);
            List<ExprType> sourceTypes = functionSignature.getParamTypeList();
            List<ExprType> targetTypes = ((FunctionSignature)resolvedSignature.getKey()).getParamTypeList();
            FunctionBuilder funcBuilder = (FunctionBuilder)resolvedSignature.getValue();
            if (Cast.isCastFunction(functionName) || sourceTypes.equals(targetTypes)) {
                return funcBuilder;
            }
            return this.castArguments(sourceTypes, targetTypes, funcBuilder);
        }
        throw new ExpressionEvaluationException(String.format("unsupported function name: %s", functionName.getFunctionName()));
    }

    private FunctionBuilder castArguments(List<ExprType> sourceTypes, List<ExprType> targetTypes, FunctionBuilder funcBuilder) {
        return arguments -> {
            ArrayList<Expression> argsCasted = new ArrayList<Expression>();
            for (int i = 0; i < arguments.size(); ++i) {
                ExprType targetType;
                Expression arg = (Expression)arguments.get(i);
                ExprType sourceType = (ExprType)sourceTypes.get(i);
                if (this.isCastRequired(sourceType, targetType = (ExprType)targetTypes.get(i))) {
                    argsCasted.add(this.cast(arg, targetType));
                    continue;
                }
                argsCasted.add(arg);
            }
            return funcBuilder.apply(argsCasted);
        };
    }

    private boolean isCastRequired(ExprType sourceType, ExprType targetType) {
        if (ExprCoreType.numberTypes().contains(sourceType) && ExprCoreType.numberTypes().contains(targetType)) {
            return false;
        }
        return sourceType.shouldCast(targetType);
    }

    private Expression cast(Expression arg, ExprType targetType) {
        FunctionName castFunctionName = Cast.getCastFunctionName(targetType);
        if (castFunctionName == null) {
            throw new ExpressionEvaluationException(StringUtils.format((String)"Type conversion to type %s is not supported", (Object[])new Object[]{targetType}));
        }
        return (Expression)((Object)this.compile(castFunctionName, (List<Expression>)ImmutableList.of((Object)arg)));
    }

    @Generated
    public BuiltinFunctionRepository(Map<FunctionName, FunctionResolver> functionResolverMap) {
        this.functionResolverMap = functionResolverMap;
    }
}

