/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner;

import com.google.common.base.Strings;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.LogicalPlanOptimizer;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.StorageEngine;
import org.opensearch.sql.storage.Table;

public class Planner {
    private final StorageEngine storageEngine;
    private final LogicalPlanOptimizer logicalOptimizer;

    public PhysicalPlan plan(LogicalPlan plan) {
        String tableName = this.findTableName(plan);
        if (Strings.isNullOrEmpty((String)tableName)) {
            return (PhysicalPlan)plan.accept(new DefaultImplementor(), null);
        }
        Table table = this.storageEngine.getTable(tableName);
        return table.implement(table.optimize(this.optimize(plan)));
    }

    private String findTableName(LogicalPlan plan) {
        return plan.accept(new LogicalPlanNodeVisitor<String, Object>(){

            @Override
            public String visitNode(LogicalPlan node, Object context) {
                List<LogicalPlan> children = node.getChild();
                if (children.isEmpty()) {
                    return "";
                }
                return children.get(0).accept(this, context);
            }

            @Override
            public String visitRelation(LogicalRelation node, Object context) {
                return node.getRelationName();
            }
        }, null);
    }

    private LogicalPlan optimize(LogicalPlan plan) {
        return this.logicalOptimizer.optimize(plan);
    }

    @Generated
    public Planner(StorageEngine storageEngine, LogicalPlanOptimizer logicalOptimizer) {
        this.storageEngine = storageEngine;
        this.logicalOptimizer = logicalOptimizer;
    }
}

