/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.collector;

import java.util.function.Supplier;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.planner.physical.collector.BucketCollector;
import org.opensearch.sql.planner.physical.collector.Collector;
import org.opensearch.sql.planner.physical.collector.Rounding;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public class SpanCollector
extends BucketCollector {
    private final SpanExpression spanExpr;
    private final Rounding<?> rounding;

    public SpanCollector(NamedExpression bucketExpr, Supplier<Collector> supplier) {
        super(bucketExpr, supplier);
        this.spanExpr = (SpanExpression)bucketExpr.getDelegated();
        this.rounding = Rounding.createRounding(this.spanExpr);
    }

    @Override
    protected ExprValue bucketKey(BindingTuple tuple) {
        return this.rounding.round(this.spanExpr.getField().valueOf(tuple));
    }

    @Override
    protected ExprValue[] allocateBuckets() {
        return this.rounding.createBuckets();
    }

    @Override
    protected int locateBucket(ExprValue value) {
        return this.rounding.locate(value);
    }
}

