/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.opensearch.ingest.common.AbstractStringProcessor;

public final class URLDecodeProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "urldecode";

    URLDecodeProcessor(String processorTag, String description, String field, boolean ignoreMissing, String targetField) {
        super(processorTag, description, ignoreMissing, targetField, field);
    }

    public static String apply(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not URL-decode value.", e);
        }
    }

    @Override
    protected String process(String value) {
        return URLDecodeProcessor.apply(value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(URLDecodeProcessor.TYPE);
        }

        protected URLDecodeProcessor newProcessor(String tag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new URLDecodeProcessor(tag, description, field, ignoreMissing, targetField);
        }
    }
}

