/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.options;

import com.oracle.labs.mlrg.olcut.config.Option;
import java.util.logging.Logger;
import org.tribuo.util.tokens.Tokenizer;
import org.tribuo.util.tokens.impl.NonTokenizer;
import org.tribuo.util.tokens.impl.ShapeTokenizer;
import org.tribuo.util.tokens.options.BreakIteratorTokenizerOptions;
import org.tribuo.util.tokens.options.SplitCharactersTokenizerOptions;
import org.tribuo.util.tokens.options.SplitPatternTokenizerOptions;
import org.tribuo.util.tokens.options.TokenizerOptions;
import org.tribuo.util.tokens.universal.UniversalTokenizer;

public class CoreTokenizerOptions
implements TokenizerOptions {
    private static final Logger logger = Logger.getLogger(CoreTokenizerOptions.class.getName());
    public BreakIteratorTokenizerOptions breakIteratorOptions;
    public SplitCharactersTokenizerOptions splitCharactersTokenizerOptions;
    public SplitPatternTokenizerOptions splitPatternTokenizerOptions;
    @Option(longName="core-tokenizer-type", usage="Type of tokenizer")
    public CoreTokenizerType coreTokenizerType = CoreTokenizerType.SPLIT_CHARACTERS;

    @Override
    public Tokenizer getTokenizer() {
        Tokenizer tokenizer;
        logger.info("Using " + (Object)((Object)this.coreTokenizerType));
        switch (this.coreTokenizerType) {
            case BREAK_ITERATOR: {
                tokenizer = this.breakIteratorOptions.getTokenizer();
                break;
            }
            case SPLIT_CHARACTERS: {
                tokenizer = this.splitCharactersTokenizerOptions.getTokenizer();
                break;
            }
            case NON: {
                tokenizer = new NonTokenizer();
                break;
            }
            case SHAPE: {
                tokenizer = new ShapeTokenizer();
                break;
            }
            case SPLIT_PATTERN: {
                tokenizer = this.splitPatternTokenizerOptions.getTokenizer();
                break;
            }
            case UNIVERSAL: {
                tokenizer = new UniversalTokenizer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tokenizer " + (Object)((Object)this.coreTokenizerType));
            }
        }
        return tokenizer;
    }

    public static enum CoreTokenizerType {
        BREAK_ITERATOR,
        SPLIT_CHARACTERS,
        NON,
        SHAPE,
        SPLIT_PATTERN,
        UNIVERSAL;

    }
}

