/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public class CaseChangeEntryHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 821;
    private CaseChange dnCaseChange = CaseChange.NONE;
    private CaseChange attributeNameCaseChange = CaseChange.NONE;
    private CaseChange attributeValueCaseChange = CaseChange.NONE;
    private String[] attributeNames;

    public CaseChange getDnCaseChange() {
        return this.dnCaseChange;
    }

    public void setDnCaseChange(CaseChange cc) {
        this.dnCaseChange = cc;
    }

    public CaseChange getAttributeNameCaseChange() {
        return this.attributeNameCaseChange;
    }

    public void setAttributeNameCaseChange(CaseChange cc) {
        this.attributeNameCaseChange = cc;
    }

    public CaseChange getAttributeValueCaseChange() {
        return this.attributeValueCaseChange;
    }

    public void setAttributeValueCaseChange(CaseChange cc) {
        this.attributeValueCaseChange = cc;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(String ... names) {
        this.attributeNames = names;
    }

    @Override
    protected String handleDn(Connection conn, SearchRequest request, SearchEntry entry) {
        return CaseChange.perform(this.dnCaseChange, entry.getDn());
    }

    @Override
    protected void handleAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        if (this.attributeNames == null) {
            super.handleAttributes(conn, request, entry);
        } else {
            for (String s : this.attributeNames) {
                LdapAttribute la = entry.getAttribute(s);
                if (la == null) continue;
                this.handleAttribute(conn, request, la);
            }
        }
    }

    @Override
    protected String handleAttributeName(Connection conn, SearchRequest request, String name) {
        return CaseChange.perform(this.attributeNameCaseChange, name);
    }

    @Override
    protected String handleAttributeValue(Connection conn, SearchRequest request, String value) {
        return CaseChange.perform(this.attributeValueCaseChange, value);
    }

    @Override
    protected byte[] handleAttributeValue(Connection conn, SearchRequest request, byte[] value) {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CaseChangeEntryHandler) {
            CaseChangeEntryHandler v = (CaseChangeEntryHandler)o;
            return LdapUtils.areEqual((Object)this.dnCaseChange, (Object)v.dnCaseChange) && LdapUtils.areEqual((Object)this.attributeNameCaseChange, (Object)v.attributeNameCaseChange) && LdapUtils.areEqual((Object)this.attributeValueCaseChange, (Object)v.attributeValueCaseChange) && LdapUtils.areEqual(this.attributeNames, v.attributeNames);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(821, new Object[]{this.dnCaseChange, this.attributeNameCaseChange, this.attributeValueCaseChange, this.attributeNames});
    }

    public String toString() {
        return String.format("[%s@%d::dnCaseChange=%s, attributeNameCaseChange=%s, attributeValueCaseChange=%s, attributeNames=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.dnCaseChange, this.attributeNameCaseChange, this.attributeValueCaseChange, Arrays.toString(this.attributeNames)});
    }

    public static enum CaseChange {
        NONE,
        LOWER,
        UPPER;


        public static String perform(CaseChange cc, String string) {
            String s = null;
            if (LOWER == cc) {
                s = string.toLowerCase();
            } else if (UPPER == cc) {
                s = string.toUpperCase();
            } else if (NONE == cc) {
                s = string;
            }
            return s;
        }
    }
}

