/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchType;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.ScriptSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.KVValue;
import org.opensearch.sql.legacy.domain.MethodField;
import org.opensearch.sql.legacy.domain.Order;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.SqlOpenSearchRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.sql.legacy.rewriter.nestedfield.NestedFieldProjection;
import org.opensearch.sql.legacy.utils.SQLFunctions;

public class DefaultQueryAction
extends QueryAction {
    private final Select select;
    private SearchRequestBuilder request;
    private final List<String> fieldNames = new LinkedList<String>();

    public DefaultQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    public void initialize(SearchRequestBuilder request) {
        this.request = request;
    }

    @Override
    public SqlOpenSearchRequestBuilder explain() throws SqlParseException {
        Objects.requireNonNull(this.sqlRequest, "SqlRequest is required for OpenSearch request build");
        this.buildRequest();
        this.checkAndSetScroll();
        return new SqlOpenSearchRequestBuilder((ActionRequestBuilder)this.request);
    }

    private void buildRequest() throws SqlParseException {
        this.request = new SearchRequestBuilder((OpenSearchClient)this.client, SearchAction.INSTANCE);
        this.setIndicesAndTypes();
        this.setFields(this.select.getFields());
        this.setWhere(this.select.getWhere());
        this.setSorts(this.select.getOrderBys());
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        this.updateRequestWithCollapse(this.select, this.request);
        this.updateRequestWithPostFilter(this.select, this.request);
        this.updateRequestWithInnerHits(this.select, this.request);
    }

    @VisibleForTesting
    public void checkAndSetScroll() {
        LocalClusterState clusterState = LocalClusterState.state();
        Integer fetchSize = this.sqlRequest.fetchSize();
        TimeValue timeValue = (TimeValue)clusterState.getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        Integer rowCount = this.select.getRowCount();
        if (this.checkIfScrollNeeded(fetchSize, rowCount)) {
            Metrics.getInstance().getNumericalMetric(MetricName.DEFAULT_CURSOR_REQUEST_COUNT_TOTAL).increment();
            Metrics.getInstance().getNumericalMetric(MetricName.DEFAULT_CURSOR_REQUEST_TOTAL).increment();
            this.request.setSize(fetchSize.intValue()).setScroll(timeValue);
        } else {
            this.request.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
            this.setLimit(this.select.getOffset(), rowCount != null ? rowCount : 200);
        }
    }

    private boolean checkIfScrollNeeded(Integer fetchSize, Integer rowCount) {
        return this.format != null && this.format.equals((Object)Format.JDBC) && fetchSize > 0 && (rowCount == null || rowCount > fetchSize);
    }

    @Override
    public Optional<List<String>> getFieldNames() {
        return Optional.of(this.fieldNames);
    }

    public Select getSelect() {
        return this.select;
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
    }

    public void setFields(List<Field> fields) throws SqlParseException {
        if (!this.select.getFields().isEmpty() && !this.select.isSelectAll()) {
            ArrayList<String> includeFields = new ArrayList<String>();
            ArrayList<String> excludeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field instanceof MethodField) {
                    MethodField method = (MethodField)field;
                    if (method.getName().toLowerCase().equals("script")) {
                        this.handleScriptField(method);
                        if (!(method.getExpression() instanceof SQLCastExpr)) continue;
                        includeFields.add(method.getParams().get(0).toString());
                        continue;
                    }
                    if (method.getName().equalsIgnoreCase("include")) {
                        for (KVValue kvValue : method.getParams()) {
                            includeFields.add(kvValue.value.toString());
                        }
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase("exclude")) continue;
                    for (KVValue kvValue : method.getParams()) {
                        excludeFields.add(kvValue.value.toString());
                    }
                    continue;
                }
                if (field == null || !this.isNotNested(field)) continue;
                includeFields.add(field.getName());
            }
            this.fieldNames.addAll(includeFields);
            this.request.setFetchSource(includeFields.toArray(new String[0]), excludeFields.toArray(new String[0]));
        }
    }

    private void handleScriptField(MethodField method) throws SqlParseException {
        List<KVValue> params = method.getParams();
        int numOfParams = params.size();
        if (2 != numOfParams && 3 != numOfParams) {
            throw new SqlParseException("scripted_field only allows 'script(name,script)' or 'script(name,lang,script)'");
        }
        String fieldName = params.get((int)0).value.toString();
        this.fieldNames.add(fieldName);
        String secondParam = params.get((int)1).value.toString();
        Script script = 2 == numOfParams ? new Script(secondParam) : new Script(ScriptType.INLINE, secondParam, params.get((int)2).value.toString(), Collections.emptyMap());
        this.request.addScriptField(fieldName, script);
    }

    private void setWhere(Where where) throws SqlParseException {
        BoolQueryBuilder boolQuery = null;
        if (where != null) {
            boolQuery = QueryMaker.explain(where, this.select.isQuery);
        }
        if (this.sqlRequest != null) {
            boolQuery = this.sqlRequest.checkAndAddFilter(boolQuery);
        }
        this.request.setQuery((QueryBuilder)boolQuery);
    }

    private void setSorts(List<Order> orderBys) {
        HashMap<String, FieldSortBuilder> sortBuilderMap = new HashMap<String, FieldSortBuilder>();
        for (Order order : orderBys) {
            String orderByName = order.getName();
            SortOrder sortOrder = SortOrder.valueOf((String)order.getType());
            if (order.getNestedPath() != null) {
                this.request.addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)orderByName).order(sortOrder)).setNestedSort(new NestedSortBuilder(order.getNestedPath())));
                continue;
            }
            if (order.isScript()) {
                this.request.addSort(SortBuilders.scriptSort((Script)new Script(orderByName), (ScriptSortBuilder.ScriptSortType)this.getScriptSortType(order)).order(sortOrder));
                continue;
            }
            if (orderByName.equals("_score")) {
                this.request.addSort(orderByName, sortOrder);
                continue;
            }
            FieldSortBuilder fieldSortBuilder = sortBuilderMap.computeIfAbsent(orderByName, key -> {
                FieldSortBuilder fs = SortBuilders.fieldSort((String)key);
                this.request.addSort((SortBuilder)fs);
                return fs;
            });
            this.setSortParams(fieldSortBuilder, order);
        }
    }

    private void setSortParams(FieldSortBuilder fieldSortBuilder, Order order) {
        fieldSortBuilder.order(SortOrder.valueOf((String)order.getType()));
        SQLExpr expr = order.getSortField().getExpression();
        if (expr instanceof SQLBinaryOpExpr) {
            fieldSortBuilder.missing((Object)this.getNullOrderString((SQLBinaryOpExpr)expr));
        }
    }

    private String getNullOrderString(SQLBinaryOpExpr expr) {
        SQLBinaryOperator operator = expr.getOperator();
        return operator == SQLBinaryOperator.IsNot ? "_first" : "_last";
    }

    private ScriptSortBuilder.ScriptSortType getScriptSortType(Order order) {
        ScriptSortBuilder.ScriptSortType scriptSortType;
        Schema.Type scriptFunctionReturnType = SQLFunctions.getOrderByFieldType(order.getSortField());
        switch (scriptFunctionReturnType) {
            case TEXT: {
                scriptSortType = ScriptSortBuilder.ScriptSortType.STRING;
                break;
            }
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: {
                scriptSortType = ScriptSortBuilder.ScriptSortType.NUMBER;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + scriptFunctionReturnType);
            }
        }
        return scriptSortType;
    }

    private void setLimit(int from, int size) {
        this.request.setFrom(from);
        if (size > -1) {
            this.request.setSize(size);
        }
    }

    public SearchRequestBuilder getRequestBuilder() {
        return this.request;
    }

    private boolean isNotNested(Field field) {
        return !field.isNested() || field.isReverseNested();
    }

    private void updateRequestWithInnerHits(Select select, SearchRequestBuilder request) {
        new NestedFieldProjection(request).project(select.getFields(), select.getNestedJoinType());
    }
}

