/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.libsvm;

import java.io.Serializable;

public enum KernelType implements Serializable
{
    LINEAR(0),
    POLY(1),
    RBF(2),
    SIGMOID(3);

    final int nativeType;

    private KernelType(int nativeType) {
        this.nativeType = nativeType;
    }

    public int getNativeType() {
        return this.nativeType;
    }

    public static KernelType getKernelType(int nativeType) {
        switch (nativeType) {
            case 0: {
                return LINEAR;
            }
            case 1: {
                return POLY;
            }
            case 2: {
                return RBF;
            }
            case 3: {
                return SIGMOID;
            }
        }
        throw new IllegalArgumentException("Unknown native type " + nativeType);
    }
}

