/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.observability.model.ObservabilityObjectType;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\"\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0010J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/observability/index/ObservabilityQueryHelper;", "", "types", "Ljava/util/EnumSet;", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "(Ljava/util/EnumSet;)V", "prefixes", "addMatchQueryBuilder", "", "query", "Lorg/opensearch/index/query/BoolQueryBuilder;", "queryKey", "", "queryValue", "addQueryFilters", "filterParams", "", "addSortField", "sourceBuilder", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "sortField", "sortOrder", "Lorg/opensearch/search/sort/SortOrder;", "addTermQueryBuilder", "addTermsQueryBuilder", "addTypeFilters", "getQueryAllBuilder", "Lorg/opensearch/index/query/QueryBuilder;", "getRangeQueryBuilder", "Companion", "opensearch-observability"})
public final class ObservabilityQueryHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnumSet<ObservabilityObjectType> types;
    @NotNull
    private final EnumSet<ObservabilityObjectType> prefixes;
    @NotNull
    private static final Set<String> METADATA_RANGE_FIELDS;
    @NotNull
    private static final Set<String> KEYWORD_FIELDS;
    @NotNull
    private static final Set<String> TEXT_FIELDS;
    @NotNull
    private static final Set<String> METADATA_FIELDS;
    @NotNull
    private static final Set<String> OBSERVABILITY_OBJECT_FIELDS;
    @NotNull
    private static final Set<String> ALL_FIELDS;
    @NotNull
    private static final Set<String> FILTER_PARAMS;

    public ObservabilityQueryHelper(@NotNull EnumSet<ObservabilityObjectType> types) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        this.types = types;
        this.prefixes = this.types.size() == 0 ? ObservabilityObjectType.Companion.getAll() : this.types;
    }

    public final void addSortField(@NotNull SearchSourceBuilder sourceBuilder, @Nullable String sortField, @Nullable SortOrder sortOrder) {
        SortOrder order;
        Intrinsics.checkNotNullParameter((Object)sourceBuilder, (String)"sourceBuilder");
        SortOrder sortOrder2 = sortOrder;
        if (sortOrder2 == null) {
            sortOrder2 = order = SortOrder.ASC;
        }
        if (sortField == null) {
            sourceBuilder.sort("lastUpdatedTimeMs", order);
        } else {
            ObservabilityObjectType it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            List list;
            List fields = new ArrayList();
            if (METADATA_RANGE_FIELDS.contains(sortField)) {
                fields.add(sortField);
            } else if (KEYWORD_FIELDS.contains(sortField)) {
                Iterable iterable = this.types;
                list = fields;
                $i$f$map = false;
                Iterator iterator = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ObservabilityObjectType observabilityObjectType = (ObservabilityObjectType)((Object)item$iv$iv);
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getTag() + "." + sortField);
                }
                list.addAll((List)destination$iv$iv);
            } else if (TEXT_FIELDS.contains(sortField)) {
                $this$map$iv = this.types;
                list = fields;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ObservabilityObjectType)((Object)item$iv$iv);
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getTag() + "." + sortField + ".keyword");
                }
                list.addAll((List)destination$iv$iv);
            } else {
                throw new OpenSearchStatusException("Field " + sortField + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
            Iterable $this$forEach$iv = fields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                sourceBuilder.sort(it2, order);
            }
        }
    }

    public final void addTypeFilters(@NotNull BoolQueryBuilder query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (this.types.size() > 0) {
            Iterable $this$forEach$iv = this.types;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObservabilityObjectType it = (ObservabilityObjectType)((Object)element$iv);
                boolean bl = false;
                query.should().add(QueryBuilders.existsQuery((String)it.getTag()));
            }
            query.minimumShouldMatch(1);
        }
    }

    public final void addQueryFilters(@NotNull BoolQueryBuilder query, @NotNull Map<String, String> filterParams) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(filterParams, (String)"filterParams");
        Map<String, String> $this$forEach$iv = filterParams;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"query", (Object)it.getKey())) {
                query.filter(this.getQueryAllBuilder(it.getValue()));
                continue;
            }
            if (METADATA_RANGE_FIELDS.contains(it.getKey())) {
                query.filter(this.getRangeQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (KEYWORD_FIELDS.contains(it.getKey())) {
                this.addTermsQueryBuilder(query, it.getKey(), it.getValue());
                continue;
            }
            if (TEXT_FIELDS.contains(it.getKey())) {
                this.addMatchQueryBuilder(query, it.getKey(), it.getValue());
                continue;
            }
            throw new OpenSearchStatusException("Query on " + it.getKey() + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
    }

    private final QueryBuilder getQueryAllBuilder(String queryValue) {
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        Iterable $this$forEach$iv = OBSERVABILITY_OBJECT_FIELDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.prefixes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ObservabilityObjectType type = (ObservabilityObjectType)((Object)element$iv2);
                boolean bl2 = false;
                allQuery.field(type + "." + it);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)allQuery, (String)"allQuery");
        return (QueryBuilder)allQuery;
    }

    private final QueryBuilder getRangeQueryBuilder(String queryKey, String queryValue) {
        QueryBuilder queryBuilder;
        String[] stringArray = new String[]{".."};
        List range = StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        switch (range.size()) {
            case 1: {
                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)queryKey, (String)queryValue);
                Intrinsics.checkNotNullExpressionValue((Object)termQueryBuilder, (String)"termQuery(queryKey, queryValue)");
                queryBuilder = (QueryBuilder)termQueryBuilder;
                break;
            }
            case 2: {
                RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)queryKey);
                rangeQuery.from(range.get(0));
                rangeQuery.to(range.get(1));
                RangeQueryBuilder rangeQueryBuilder = rangeQuery;
                Intrinsics.checkNotNullExpressionValue((Object)rangeQueryBuilder, (String)"{\n                val ra\u2026 rangeQuery\n            }");
                queryBuilder = (QueryBuilder)rangeQueryBuilder;
                break;
            }
            default: {
                throw new OpenSearchStatusException("Invalid Range format " + queryValue + ", allowed format 'exact' or 'from..to'", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
        }
        return queryBuilder;
    }

    private final void addTermQueryBuilder(BoolQueryBuilder query, String queryKey, String queryValue) {
        Iterable $this$forEach$iv = this.prefixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservabilityObjectType it = (ObservabilityObjectType)((Object)element$iv);
            boolean bl = false;
            query.filter((QueryBuilder)QueryBuilders.termQuery((String)(it.getTag() + "." + queryKey), (String)queryValue));
        }
    }

    private final void addTermsQueryBuilder(BoolQueryBuilder query, String queryKey, String queryValue) {
        Iterable $this$forEach$iv = this.prefixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservabilityObjectType it = (ObservabilityObjectType)((Object)element$iv);
            boolean bl = false;
            String[] stringArray = new String[]{","};
            query.filter((QueryBuilder)QueryBuilders.termsQuery((String)(it.getTag() + "." + queryKey), (Collection)StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }
    }

    private final void addMatchQueryBuilder(BoolQueryBuilder query, String queryKey, String queryValue) {
        Iterable $this$forEach$iv = this.prefixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservabilityObjectType it = (ObservabilityObjectType)((Object)element$iv);
            boolean bl = false;
            query.should().add(QueryBuilders.matchQuery((String)(it.getTag() + "." + queryKey), (Object)queryValue).operator(Operator.AND));
        }
        query.minimumShouldMatch(1);
    }

    static {
        Object[] objectArray = new String[]{"lastUpdatedTimeMs", "createdTimeMs"};
        METADATA_RANGE_FIELDS = SetsKt.setOf((Object[])objectArray);
        KEYWORD_FIELDS = SetsKt.emptySet();
        TEXT_FIELDS = SetsKt.setOf((Object)"name");
        METADATA_FIELDS = METADATA_RANGE_FIELDS;
        OBSERVABILITY_OBJECT_FIELDS = CollectionsKt.union((Iterable)KEYWORD_FIELDS, (Iterable)TEXT_FIELDS);
        ALL_FIELDS = CollectionsKt.union((Iterable)METADATA_FIELDS, (Iterable)OBSERVABILITY_OBJECT_FIELDS);
        FILTER_PARAMS = CollectionsKt.union((Iterable)ALL_FIELDS, (Iterable)SetsKt.setOf((Object)"query"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/observability/index/ObservabilityQueryHelper$Companion;", "", "()V", "ALL_FIELDS", "", "", "FILTER_PARAMS", "getFILTER_PARAMS", "()Ljava/util/Set;", "KEYWORD_FIELDS", "METADATA_FIELDS", "METADATA_RANGE_FIELDS", "OBSERVABILITY_OBJECT_FIELDS", "TEXT_FIELDS", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getFILTER_PARAMS() {
            return FILTER_PARAMS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

