/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation.metrics;

import java.util.List;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.metrics.MetricContext;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;

public interface EvaluationMetric<T extends Output<T>, C extends MetricContext<T>> {
    public double compute(C var1);

    public MetricTarget<T> getTarget();

    public String getName();

    default public MetricID<T> getID() {
        return new MetricID<T>(this.getTarget(), this.getName());
    }

    public C createContext(Model<T> var1, List<Prediction<T>> var2);

    default public C createContext(Model<T> model, Dataset<T> dataset) {
        return this.createContext(model, model.predict(dataset));
    }

    public static enum Average {
        MACRO,
        MICRO;

    }
}

