/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(22, -23, 4) >> ivec3(22, 23, 4)) => ivec3(0, -1, 0)
 * (ivec3(22, -23, 4) >> ivec3(19, 1, 13)) => ivec3(0, -12, 0)
 * (ivec3(22, 23, 4) >> ivec3(22, 23, 4)) => ivec3(0, 0, 0)
 * (ivec3(22, 23, 4) >> ivec3(19, 1, 13)) => ivec3(0, 11, 0)
 * (ivec3(-19, 1, -13) >> ivec3(22, 23, 4)) => ivec3(-1, 0, -1)
 * (ivec3(-19, 1, -13) >> ivec3(19, 1, 13)) => ivec3(-1, 0, -1)
 * (ivec3(19, 1, 13) >> ivec3(22, 23, 4)) => ivec3(0, 0, 0)
 * (ivec3(19, 1, 13) >> ivec3(19, 1, 13)) => ivec3(0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec3(22, -23, 4) >> ivec3(22, 23, 4)), ivec3(0, -1, 0))) ? 1 : -1] array0;
  float[all(equal((ivec3(22, -23, 4) >> ivec3(19, 1, 13)), ivec3(0, -12, 0))) ? 1 : -1] array1;
  float[all(equal((ivec3(22, 23, 4) >> ivec3(22, 23, 4)), ivec3(0, 0, 0))) ? 1 : -1] array2;
  float[all(equal((ivec3(22, 23, 4) >> ivec3(19, 1, 13)), ivec3(0, 11, 0))) ? 1 : -1] array3;
  float[all(equal((ivec3(-19, 1, -13) >> ivec3(22, 23, 4)), ivec3(-1, 0, -1))) ? 1 : -1] array4;
  float[all(equal((ivec3(-19, 1, -13) >> ivec3(19, 1, 13)), ivec3(-1, 0, -1))) ? 1 : -1] array5;
  float[all(equal((ivec3(19, 1, 13) >> ivec3(22, 23, 4)), ivec3(0, 0, 0))) ? 1 : -1] array6;
  float[all(equal((ivec3(19, 1, 13) >> ivec3(19, 1, 13)), ivec3(0, 0, 0))) ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
