# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class UsersService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """UsersService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def delete_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_users_id_prepare(user_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_users_id_async(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_users_id_prepare(user_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_users_id_prepare(self, user_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_flags(self, **kwargs):  # noqa: E501,D401,D403
        """Return the feature flags for the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flags(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_flags_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_flags_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_flags_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Return the feature flags for the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flags_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_flags_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/flags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_flags_async(self, **kwargs):  # noqa: E501,D401,D403
        """Return the feature flags for the currently authenticated user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_flags_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/flags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_flags_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span']  # noqa: E501
        self._check_operation_params('get_flags', all_params, local_var_params)

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_me(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_me_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_me_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_me_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_me_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_me_async(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_me_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_me_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span']  # noqa: E501
        self._check_operation_params('get_me', all_params, local_var_params)

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_users(self, **kwargs):  # noqa: E501,D401,D403
        """List all users.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str after: Resource ID to seek from. Results are not inclusive of this ID. Use `after` instead of `offset`.
        :param str name:
        :param str id:
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all users.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str after: Resource ID to seek from. Results are not inclusive of this ID. Use `after` instead of `offset`.
        :param str name:
        :param str id:
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Users',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_users_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all users.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str after: Resource ID to seek from. Results are not inclusive of this ID. Use `after` instead of `offset`.
        :param str name:
        :param str id:
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Users',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_users_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'after', 'name', 'id']  # noqa: E501
        self._check_operation_params('get_users', all_params, local_var_params)

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_users`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_users`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_users`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_id_prepare(user_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_users_id_async(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_id_prepare(user_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_users_id_prepare(self, user_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_users_id(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to update. (required)
        :param User user: User update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
            return data

    def patch_users_id_with_http_info(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id_with_http_info(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to update. (required)
        :param User user: User update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_users_id_prepare(user_id, user, **kwargs)

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_users_id_async(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to update. (required)
        :param User user: User update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_users_id_prepare(user_id, user, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_users_id_prepare(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'user', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_users_id`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `patch_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_users(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: User to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def post_users_with_http_info(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: User to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_prepare(user, **kwargs)

        return self.api_client.call_api(
            '/api/v2/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_users_async(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param User user: User to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_prepare(user, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_users_prepare(self, user, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_users', all_params, local_var_params)
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `post_users`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_users_id_password(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
            return data

    def post_users_id_password_with_http_info(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password_with_http_info(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_id_password_prepare(user_id, password_reset_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_users_id_password_async(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_id_password_prepare(user_id, password_reset_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_users_id_password_prepare(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'password_reset_body', 'zap_trace_span', 'authorization']  # noqa: E501
        self._check_operation_params('post_users_id_password', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_users_id_password`")  # noqa: E501
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `post_users_id_password`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_me_password(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
            return data

    def put_me_password_with_http_info(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password_with_http_info(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_me_password_prepare(password_reset_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/me/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_me_password_async(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_me_password_prepare(password_reset_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/me/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_me_password_prepare(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['password_reset_body', 'zap_trace_span', 'authorization']  # noqa: E501
        self._check_operation_params('put_me_password', all_params, local_var_params)
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `put_me_password`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
