/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;

public class Like {
    private static final char anyChar = '_';
    private static final char anyString = '%';
    private static final String SUPER_STRING = "\uffff";

    private Like() {
    }

    public static Boolean like(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, int n3, RuleBasedCollator ruleBasedCollator) throws StandardException {
        return Like.like(cArray, 0, n, cArray2, 0, n2, cArray3, n3, ruleBasedCollator);
    }

    private static Boolean like(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, char[] cArray3, int n5, RuleBasedCollator ruleBasedCollator) throws StandardException {
        int n6;
        char c = ' ';
        boolean bl = true;
        if (cArray == null) {
            return null;
        }
        if (cArray2 == null) {
            return null;
        }
        if (cArray3 == null) {
            bl = false;
        } else {
            c = cArray3[0];
        }
        while (true) {
            Boolean bl2;
            if ((bl2 = Like.checkLengths(n, n2, n3, cArray2, n4)) != null) {
                return bl2;
            }
            while (!(cArray2[n3] == '_' || cArray2[n3] == '%' || bl && cArray2[n3] == c)) {
                if (Like.checkEquality(cArray, n, cArray2, n3, ruleBasedCollator)) {
                    if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                    return bl2;
                }
                return Boolean.FALSE;
            }
            if (bl && cArray2[n3] == c) {
                if (++n3 == n4) {
                    throw StandardException.newException("22025");
                }
                if (cArray2[n3] != c && cArray2[n3] != '_' && cArray2[n3] != '%') {
                    throw StandardException.newException("22025");
                }
                if (Like.checkEquality(cArray, n, cArray2, n3, ruleBasedCollator)) {
                    if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                    return bl2;
                }
                return Boolean.FALSE;
            }
            if (cArray2[n3] == '_') {
                if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                return bl2;
            }
            if (cArray2[n3] == '%') break;
        }
        if (n3 + 1 == n4) {
            return Boolean.TRUE;
        }
        boolean bl3 = true;
        for (n6 = n3 + 1; n6 < n4; ++n6) {
            if (cArray2[n6] == '%') continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return Boolean.TRUE;
        }
        n6 = n2 - n;
        int n7 = 0;
        int n8 = Like.getMinLen(cArray2, n3 + 1, n4, bl, c);
        for (int i = n6; i >= n8; --i) {
            Boolean bl4 = Like.like(cArray, n + n7, n + n7 + i, cArray2, n3 + 1, n4, cArray3, n5, ruleBasedCollator);
            if (bl4.booleanValue()) {
                return bl4;
            }
            ++n7;
        }
        return Boolean.FALSE;
    }

    private static boolean checkEquality(char[] cArray, int n, char[] cArray2, int n2, RuleBasedCollator ruleBasedCollator) {
        if (cArray[n] == cArray2[n2]) {
            return true;
        }
        if (ruleBasedCollator == null) {
            return false;
        }
        String string = new String(cArray, n, 1);
        String string2 = new String(cArray2, n2, 1);
        return ruleBasedCollator.compare(string, string2) == 0;
    }

    static int getMinLen(char[] cArray, int n, int n2, boolean bl, char c) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (bl && cArray[n4] == c) {
                n4 += 2;
                ++n3;
                continue;
            }
            if (cArray[n4] == '%') {
                ++n4;
                continue;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    static Boolean checkLengths(int n, int n2, int n3, char[] cArray, int n4) {
        if (n == n2) {
            if (n3 == n4) {
                return Boolean.TRUE;
            }
            for (int i = n3; i < n4; ++i) {
                if (cArray[i] == '%') continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (n3 == n4) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean like(char[] cArray, int n, char[] cArray2, int n2, RuleBasedCollator ruleBasedCollator) throws StandardException {
        if (cArray == null || cArray2 == null) {
            return null;
        }
        return Like.like(cArray, n, cArray2, n2, null, 0, ruleBasedCollator);
    }

    public static boolean isOptimizable(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        return c != '_' && c != '%';
    }

    public static String greaterEqualStringFromParameter(String string, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.greaterEqualString(string, null, n);
    }

    public static String greaterEqualStringFromParameterWithEsc(String string, String string2, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.greaterEqualString(string, string2, n);
    }

    public static String greaterEqualString(String string, String string2, int n) throws StandardException {
        char c;
        int n2 = string.indexOf(95);
        int n3 = string.indexOf(37);
        if (string2 != null && string2.length() != 0 && string.indexOf(c = string2.charAt(0)) != -1) {
            return Like.padWithNulls(Like.greaterEqualString(string, c), n);
        }
        if (n2 == -1) {
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
        } else {
            string = n3 == -1 ? string.substring(0, n2) : string.substring(0, n2 > n3 ? n3 : n2);
        }
        return Like.padWithNulls(string, n);
    }

    private static String greaterEqualString(String string, char c) throws StandardException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        for (int i = 0; i < n && n2 < n; ++i) {
            char c2 = cArray[i];
            if (c2 == c) {
                if (++i >= n) {
                    throw StandardException.newException("22025");
                }
                cArray2[n2++] = cArray[i];
                continue;
            }
            if (c2 == '_' || c2 == '%') {
                return new String(cArray2, 0, n2);
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    public static String stripEscapesNoPatternChars(String string, char c) throws StandardException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        for (int i = 0; i < n && n2 < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (++i >= n) {
                    throw StandardException.newException("22025");
                }
                cArray2[n2++] = cArray[i];
                continue;
            }
            if (c2 == '_' || c2 == '%') {
                return null;
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    public static String lessThanStringFromParameter(String string, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.lessThanString(string, null, n);
    }

    public static String lessThanStringFromParameterWithEsc(String string, String string2, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.lessThanString(string, string2, n);
    }

    public static String lessThanString(String string, String string2, int n) throws StandardException {
        char c;
        char c2 = string2 != null && string2.length() != 0 ? (char)string2.charAt(0) : (char)'\uffffffff';
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2) {
                if (++i >= string.length()) {
                    throw StandardException.newException("22025");
                }
                c3 = string.charAt(i);
            } else if (c3 == '_' || c3 == '%') break;
            stringBuffer.append(c3);
        }
        if (stringBuffer.length() == 0) {
            return SUPER_STRING;
        }
        int n2 = stringBuffer.length() - 1;
        char c4 = c = stringBuffer.charAt(n2);
        if ((c4 = (char)(c4 + '\u0001')) < c) {
            return SUPER_STRING;
        }
        stringBuffer.setCharAt(n2, c4);
        if (stringBuffer.length() < n) {
            stringBuffer.setLength(n);
        }
        return stringBuffer.toString();
    }

    public static boolean isLikeComparisonNeeded(String string) {
        int n = string.indexOf(95);
        int n2 = string.indexOf(37);
        if (n == -1 && n2 == -1) {
            return false;
        }
        if (n != -1) {
            return true;
        }
        return n2 != string.length() - 1;
    }

    private static String padWithNulls(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n).append(string);
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }
}

