/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.CopyContextFieldAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeepCopyBufferedRecordsAction
extends CopyContextFieldAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public DeepCopyBufferedRecordsAction() {
    }

    public DeepCopyBufferedRecordsAction(String srcConnectionAlias, String dstConnectionAlias) {
        super(srcConnectionAlias, dstConnectionAlias);
    }

    @Override
    protected void copyField(TlsContext src, TlsContext dst) {
        this.deepCopyRecords(src, dst);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    private void deepCopyRecords(TlsContext src, TlsContext dst) {
        LinkedList<AbstractRecord> recordBuffer = new LinkedList<AbstractRecord>();
        try {
            for (AbstractRecord record : src.getRecordBuffer()) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ObjectOutputStream outStream = new ObjectOutputStream(stream);
                outStream.writeObject(record);
                outStream.close();
                ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                AbstractRecord recordCopy = (AbstractRecord)inStream.readObject();
                recordBuffer.add(recordCopy);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            LOGGER.error("Error while creating deep copy of recordBuffer");
            throw new WorkflowExecutionException(ex.toString());
        }
        dst.setRecordBuffer(recordBuffer);
    }
}

