/* -*- Mode: C; c-basic-offset: 8; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=8 shiftwidth=4 expandtab: */

/*
    config-internal.h.in -- Template configuration file (not exported options).

    Copyright (c) 1990, Giuseppe Attardi.
    Copyright (c) 2001, Juan Jose Garcia Ripoll.

    See top-level file 'LICENSE' for license details.
*/

/* -------------------------------------------------------------------- *
 *      BUILD OPTIONS WHICH NEED NOT BE EXPORTED                        *
 * -------------------------------------------------------------------- */

/*
 * FEATURES LINKED IN:
 */

/* Define this if you want a runtime version only without compiler      */
#undef RUNTIME
/* Profile tool                                                         */
#undef PROFILE
/* Program Development Environment                                      */
#undef PDE

/* Allow loading dynamically linked code                                */
#undef ENABLE_DLOPEN

/* Undefine this if you do not want ECL to check for circular lists     */
#define ECL_SAFE

/* Activate Boehm-Weiser incremental garbage collector                  */
#undef GBC_BOEHM_GENGC

/* Activate Boehm-Weiser precise garbage collector                      */
#undef GBC_BOEHM_PRECISE

/* Weak hash tables need the garbage collector and weak pointers        */
#ifdef GBC_BOEHM
#define ECL_WEAK_HASH
#endif

/*
 * SYSTEM FEATURES:
 */

/* Most significant byte first                                          */
#undef WORDS_BIGENDIAN
/* Has <sys/resource.h>                                                 */
#undef HAVE_SYS_RESOURCE_H
#undef HAVE_ULIMIT_H
/* High precision timer                                                 */
#undef HAVE_NANOSLEEP
/* Float version if isnan()                                             */
#undef HAVE_ISNANF
/* float.h for epsilons, maximum real numbers, etc			*/
#undef HAVE_FLOAT_H
/* select()								*/
#ifndef NACL
#undef HAVE_SELECT
#endif
#undef HAVE_SYS_SELECT_H
#undef HAVE_SYS_IOCTL_H
/* putenv() or setenv()							*/
#undef HAVE_SETENV
#undef HAVE_PUTENV
/* times() and sys/times.h						*/
#ifndef NACL
#undef HAVE_TIMES
#endif
/* gettimeofday() and sys/time.h					*/
#undef HAVE_GETTIMEOFDAY
/* getrusage() and sys/resource.h					*/
#ifndef NACL
#undef HAVE_GETRUSAGE
#endif
/* user home directory, user name, etc...				*/
#undef HAVE_PW_H
/* symbolic links and checking their existence				*/
#ifndef NACL
#undef HAVE_LSTAT
#endif
/* safe creation of temporary files					*/
#undef HAVE_MKSTEMP
/* timer for userland threads						*/
#undef HAVE_ALARM
/* filesytem                                                            */
#undef HAVE_DIRENT_H
/* dynamic linking of libraries                                         */
#undef HAVE_DLFCN_H
#undef HAVE_LINK_H
#undef HAVE_MACH_O_DYLD_H
/* POSIX signals							*/
#ifndef NACL
#undef HAVE_SIGPROCMASK
#endif
/* isatty() checks whether a file is connected to a			*/
#undef HAVE_ISATTY
/* do we want to have signed zeros                                      */
#undef ECL_SIGNED_ZERO
/* has support for large files                                          */
#undef HAVE_FSEEKO
/* the tzset() function gets the current time zone                      */
#undef HAVE_TZSET
/* several floating point functions (ISO C99)                           */
#undef HAVE_EXPF
#undef HAVE_LOGF
#undef HAVE_SQRTF
#undef HAVE_COSF
#undef HAVE_SINF
#undef HAVE_TANF
#undef HAVE_SINHF
#undef HAVE_COSHF
#undef HAVE_TANHF
#undef HAVE_FLOORF
#undef HAVE_CEILF
#undef HAVE_FABSF
#undef HAVE_FREXPF
#undef HAVE_LDEXPF
#undef HAVE_LOG1P
#undef HAVE_LOG1PF
#undef HAVE_LOG1PL
#undef HAVE_COPYSIGNF
#undef HAVE_COPYSIGN
#undef HAVE_COPYSIGNL
/* whether we have sched_yield() that gives priority to other threads   */
#undef HAVE_SCHED_YIELD
/* whether we have a working sem_init()                                 */
#undef HAVE_SEM_INIT
/* whether we have read/write locks                                     */
#undef HAVE_POSIX_RWLOCK
/* uname() for system identification                                    */
#undef HAVE_UNAME
#undef HAVE_UNISTD_H
#undef HAVE_SYS_WAIT_H
#undef HAVE_SYS_MMAN_H
/* size of long long                                                    */
#undef ECL_LONG_LONG_BITS
/* existence of char **environ                                          */
#undef HAVE_ENVIRON
/* existence of pointer -> function name functions                      */
#undef HAVE_BACKTRACE
#undef HAVE_BACKTRACE_SYMBOLS
#undef HAVE_SCHED_H
#undef HAVE_SYSTEM

/* what characters are used to mark beginning of new line               */
#undef ECL_NEWLINE_IS_CRLF
#undef ECL_NEWLINE_IS_LFCR

/*
 * PARAMETERS:
 */

/*
 * Memory limits for the old garbage collector.
 */
#define LISP_PAGESIZE   2048    /* Page size in bytes                   */
#define MAXPAGE 65536           /* Maximum Memory Size                  */

/* We allocate a number of strings in a pool which is used to speed up reading */
#define ECL_MAX_STRING_POOL_SIZE        10
#define ECL_BUFFER_STRING_SIZE          4192

/*
 * Macros that depend on these system features.
 */
#if defined(sparc) || defined(i386) || defined(mips)
#  define       stack_align(n)  (((n) + 0x7) & ~0x7)
#else
#  define       stack_align(n)  (((n) + 03) & ~03)
#endif

#undef FILE_CNT
#if 2 == 1
#  define FILE_CNT(fp)  ((fp)->_IO_read_end - (fp)->_IO_read_ptr)
#endif
#if 2 == 2
#  define FILE_CNT(fp)  ((fp)->_r)
#endif
#if 2 == 3
#  define FILE_CNT(fp)  ((fp)->_cnt)
#endif

#if defined(cygwin) || defined(ECL_MS_WINDOWS_HOST)
#  define IS_DIR_SEPARATOR(x) ((x=='/')||(x=='\\'))
#  define DIR_SEPARATOR         '/'
#  define PATH_SEPARATOR        ';'
#else
#  define IS_DIR_SEPARATOR(x) (x=='/')
#  define DIR_SEPARATOR '/'
#  define PATH_SEPARATOR        ':'
#endif

#define ECL_ARCHITECTURE "MIPS64"

#ifdef ECL_AVOID_FPE_H
# define ecl_detect_fpe()
#else
# include "arch/fpe_none.c"
#endif

#ifdef ECL_INCLUDE_MATH_H
# include <math.h>
# ifdef _MSC_VER
#  undef complex
#  define signbit(x) (copysign(1.0,(x)))
# endif
# ifndef isfinite
#  error "Function isfinite() is missing"
# endif
# ifndef signbit
#  ifndef ECL_SIGNED_ZERO
#   define signbit(x) ((x) < 0)
#  else
#   ifdef HAVE_COPYSIGN
#    define signbit(x) (copysign(1.0,(x)) < 0)
#   else 
     /* Fall back to no signed zero */
#    undef \
     ECL_SIGNED_ZERO
#    define signbit(x) ((x) < 0)
#   endif
#  endif
# endif
/*
 * GCC fails to compile the following code
 * if (f == 0.0) { if (signbit(f)) ... }
 */
# if defined(__sun__) && defined(__GNUC__)
#  undef \
   signbit /* Avoid autoconf removing this */
#  define signbit(x) (copysign(1.0,(x)) < 0)
# endif
#endif

#if defined(HAVE_LIBFFI) && defined(ECL_INCLUDE_FFI_H)
#include "ffi.h"
#endif

/* Can we determine and set the stack size at runtime? */
#undef ECL_CAN_SET_STACK_SIZE

#if defined(ECL_CAN_SET_STACK_SIZE)
#define ECL_DEFAULT_C_STACK_SIZE 0 /* Use the stack size provided by the OS */
#else
#define ECL_DEFAULT_C_STACK_SIZE 1048576
#endif

/* Do the fixed and optional arguments of a variadic function use a
 * different calling convention?
 * Hardcoded since there's no easy way to determine this from a
 * configure check and currently ARM64 apple is the only platform
 * known to do this. */
#if defined(__APPLE__) && (defined(__arm64__) || defined(__aarch64__))
#define ECL_C_COMPATIBLE_VARIADIC_DISPATCH
#endif
