/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.security;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.guacamole.auth.jdbc.security.PasswordEncryptionService;

public class SHA256PasswordEncryptionService
implements PasswordEncryptionService {
    @Override
    public byte[] createPasswordHash(String password, byte[] salt) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(password);
            if (salt != null) {
                builder.append(BaseEncoding.base16().encode(salt));
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(builder.toString().getBytes("UTF-8"));
            return md.digest();
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Unexpected lack of SHA-256 support.", e);
        }
    }
}

