/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactorContextWebFilter
implements WebFilter {
    private final ServerSecurityContextRepository repository;

    public ReactorContextWebFilter(ServerSecurityContextRepository repository) {
        Assert.notNull((Object)repository, "repository cannot be null");
        this.repository = repository;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return chain.filter(exchange2).subscriberContext(context -> context.hasKey(SecurityContext.class) ? context : this.withSecurityContext((Context)context, exchange2));
    }

    private Context withSecurityContext(Context mainContext, ServerWebExchange exchange2) {
        return mainContext.putAll((Context)this.repository.load(exchange2).as(ReactiveSecurityContextHolder::withSecurityContext));
    }
}

