/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class CsrfServerLogoutHandler
implements ServerLogoutHandler {
    private final ServerCsrfTokenRepository csrfTokenRepository;

    public CsrfServerLogoutHandler(ServerCsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    @Override
    public Mono<Void> logout(WebFilterExchange exchange2, Authentication authentication) {
        return this.csrfTokenRepository.saveToken(exchange2.getExchange(), null);
    }
}

