/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.AbstractMyBatisModule;
import org.mybatis.guice.Preconditions;
import org.mybatis.guice.binder.AliasBinder;
import org.mybatis.guice.binder.TypeHandlerBinder;
import org.mybatis.guice.configuration.ConfigurationProvider;
import org.mybatis.guice.configuration.settings.AggressiveLazyLoadingConfigurationSetting;
import org.mybatis.guice.configuration.settings.AliasConfigurationSetting;
import org.mybatis.guice.configuration.settings.AutoMappingBehaviorConfigurationSetting;
import org.mybatis.guice.configuration.settings.CacheEnabledConfigurationSetting;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;
import org.mybatis.guice.configuration.settings.DefaultExecutorTypeConfigurationSetting;
import org.mybatis.guice.configuration.settings.DefaultScriptingLanguageTypeConfigurationSetting;
import org.mybatis.guice.configuration.settings.DefaultStatementTimeoutConfigurationSetting;
import org.mybatis.guice.configuration.settings.InterceptorConfigurationSettingProvider;
import org.mybatis.guice.configuration.settings.JavaTypeAndHandlerConfigurationSettingProvider;
import org.mybatis.guice.configuration.settings.LazyLoadingEnabledConfigurationSetting;
import org.mybatis.guice.configuration.settings.LocalCacheScopeConfigurationSetting;
import org.mybatis.guice.configuration.settings.MapUnderscoreToCamelCaseConfigurationSetting;
import org.mybatis.guice.configuration.settings.MapperConfigurationSetting;
import org.mybatis.guice.configuration.settings.MultipleResultSetsEnabledConfigurationSetting;
import org.mybatis.guice.configuration.settings.ObjectFactoryConfigurationSetting;
import org.mybatis.guice.configuration.settings.ObjectWrapperFactoryConfigurationSetting;
import org.mybatis.guice.configuration.settings.TypeHandlerConfigurationSettingProvider;
import org.mybatis.guice.configuration.settings.UseColumnLabelConfigurationSetting;
import org.mybatis.guice.configuration.settings.UseGeneratedKeysConfigurationSetting;
import org.mybatis.guice.environment.EnvironmentProvider;
import org.mybatis.guice.provision.ConfigurationProviderProvisionListener;
import org.mybatis.guice.provision.KeyMatcher;
import org.mybatis.guice.session.SqlSessionFactoryProvider;
import org.mybatis.guice.type.TypeHandlerProvider;

public abstract class MyBatisModule
extends AbstractMyBatisModule {
    private Class<? extends ObjectFactory> objectFactoryType = DefaultObjectFactory.class;
    private Class<? extends ObjectWrapperFactory> objectWrapperFactoryType = DefaultObjectWrapperFactory.class;
    private Class<? extends LanguageDriver> defaultScriptingLanguageType = XMLLanguageDriver.class;
    private Class<? extends javax.inject.Provider<? extends SqlSessionFactory>> sqlSessionFactoryProviderType = SqlSessionFactoryProvider.class;
    private Class<? extends javax.inject.Provider<? extends Configuration>> configurationProviderType = ConfigurationProvider.class;

    @Override
    final void internalConfigure() {
        this.initialize();
        this.bind(Environment.class).toProvider(EnvironmentProvider.class).in(Scopes.SINGLETON);
        this.bind(Configuration.class).toProvider(this.configurationProviderType).in(Scopes.SINGLETON);
        this.bind(SqlSessionFactory.class).toProvider(this.sqlSessionFactoryProviderType);
        this.bind(ObjectFactory.class).to(this.objectFactoryType).in(Scopes.SINGLETON);
        this.bind(ObjectWrapperFactory.class).to(this.objectWrapperFactoryType).in(Scopes.SINGLETON);
        this.bindConfigurationSettingProvider(new ObjectFactoryConfigurationSetting(this.objectFactoryType));
        this.bindConfigurationSettingProvider(new ObjectWrapperFactoryConfigurationSetting(this.objectWrapperFactoryType));
        this.bindConfigurationSetting(new DefaultScriptingLanguageTypeConfigurationSetting(this.defaultScriptingLanguageType));
    }

    protected final void environmentId(String environmentId) {
        Preconditions.checkArgument(environmentId != null, "Parameter 'environmentId' must be not null");
        this.bindConstant().annotatedWith(Names.named("mybatis.environment.id")).to(environmentId);
    }

    protected final void lazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.bindConfigurationSetting(new LazyLoadingEnabledConfigurationSetting(lazyLoadingEnabled));
    }

    protected final void aggressiveLazyLoading(boolean aggressiveLazyLoading) {
        this.bindConfigurationSetting(new AggressiveLazyLoadingConfigurationSetting(aggressiveLazyLoading));
    }

    protected final void multipleResultSetsEnabled(boolean multipleResultSetsEnabled) {
        this.bindConfigurationSetting(new MultipleResultSetsEnabledConfigurationSetting(multipleResultSetsEnabled));
    }

    protected final void useGeneratedKeys(boolean useGeneratedKeys) {
        this.bindConfigurationSetting(new UseGeneratedKeysConfigurationSetting(useGeneratedKeys));
    }

    protected final void useColumnLabel(boolean useColumnLabel) {
        this.bindConfigurationSetting(new UseColumnLabelConfigurationSetting(useColumnLabel));
    }

    protected final void useCacheEnabled(boolean useCacheEnabled) {
        this.bindConfigurationSetting(new CacheEnabledConfigurationSetting(useCacheEnabled));
    }

    protected final void useConfigurationProvider(Class<? extends javax.inject.Provider<? extends Configuration>> configurationProviderType) {
        this.configurationProviderType = configurationProviderType;
    }

    protected final void useSqlSessionFactoryProvider(Class<? extends javax.inject.Provider<? extends SqlSessionFactory>> sqlSessionFactoryProvider) {
        this.sqlSessionFactoryProviderType = sqlSessionFactoryProvider;
    }

    protected final void failFast(boolean failFast) {
        this.bindBoolean("mybatis.configuration.failFast", failFast);
    }

    protected final void mapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.bindConfigurationSetting(new MapUnderscoreToCamelCaseConfigurationSetting(mapUnderscoreToCamelCase));
    }

    protected final void defaultStatementTimeout(Integer defaultStatementTimeout) {
        this.bindConfigurationSetting(new DefaultStatementTimeoutConfigurationSetting(defaultStatementTimeout));
    }

    protected final void bindConfigurationSetting(ConfigurationSetting configurationSetting) {
        this.bindListener(KeyMatcher.create(Key.get(ConfigurationProvider.class)), ConfigurationProviderProvisionListener.create(configurationSetting));
    }

    protected final <P extends javax.inject.Provider<? extends ConfigurationSetting>> void bindConfigurationSettingProvider(P configurationSettingProvider) {
        this.bindListener(KeyMatcher.create(Key.get(ConfigurationProvider.class)), ConfigurationProviderProvisionListener.create(configurationSettingProvider, this.binder()));
    }

    private final void bindBoolean(String name, boolean value) {
        this.bindConstant().annotatedWith(Names.named(name)).to(value);
    }

    protected final void executorType(ExecutorType executorType) {
        Preconditions.checkArgument(executorType != null, "Parameter 'executorType' must be not null");
        this.bindConfigurationSetting(new DefaultExecutorTypeConfigurationSetting(executorType));
    }

    protected final void localCacheScope(LocalCacheScope localeCacheScope) {
        Preconditions.checkArgument(localeCacheScope != null, "Parameter 'localCacheScope' must be not null");
        this.bindConfigurationSetting(new LocalCacheScopeConfigurationSetting(localeCacheScope));
    }

    protected final void autoMappingBehavior(AutoMappingBehavior autoMappingBehavior) {
        Preconditions.checkArgument(autoMappingBehavior != null, "Parameter 'autoMappingBehavior' must be not null");
        this.bindConfigurationSetting(new AutoMappingBehaviorConfigurationSetting(autoMappingBehavior));
    }

    protected final void bindDataSourceProviderType(Class<? extends javax.inject.Provider<DataSource>> dataSourceProviderType) {
        Preconditions.checkArgument(dataSourceProviderType != null, "Parameter 'dataSourceProviderType' must be not null");
        this.bind(DataSource.class).toProvider(dataSourceProviderType).in(Scopes.SINGLETON);
    }

    protected final void bindDataSourceProvider(javax.inject.Provider<DataSource> dataSourceProvider) {
        Preconditions.checkArgument(dataSourceProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bindDataSourceProvider(Providers.guicify(dataSourceProvider));
    }

    protected final void bindDataSourceProvider(Provider<DataSource> dataSourceProvider) {
        Preconditions.checkArgument(dataSourceProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bind(DataSource.class).toProvider(dataSourceProvider).in(Scopes.SINGLETON);
    }

    protected final void bindDatabaseIdProvider(Class<? extends DatabaseIdProvider> databaseIdProvider) {
        Preconditions.checkArgument(databaseIdProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bind(DatabaseIdProvider.class).to(databaseIdProvider).in(Scopes.SINGLETON);
    }

    protected final void bindDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        Preconditions.checkArgument(databaseIdProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bind(DatabaseIdProvider.class).toInstance(databaseIdProvider);
    }

    protected final void bindTransactionFactoryType(Class<? extends TransactionFactory> transactionFactoryType) {
        Preconditions.checkArgument(transactionFactoryType != null, "Parameter 'transactionFactoryType' must be not null");
        this.bind(TransactionFactory.class).to(transactionFactoryType).in(Scopes.SINGLETON);
    }

    protected final void bindTransactionFactory(javax.inject.Provider<TransactionFactory> transactionFactoryProvider) {
        Preconditions.checkArgument(transactionFactoryProvider != null, "Parameter 'transactionFactoryProvider' must be not null");
        this.bindTransactionFactory(Providers.guicify(transactionFactoryProvider));
    }

    protected final void bindTransactionFactory(Provider<TransactionFactory> transactionFactoryProvider) {
        Preconditions.checkArgument(transactionFactoryProvider != null, "Parameter 'transactionFactoryProvider' must be not null");
        this.bind(TransactionFactory.class).toProvider(transactionFactoryProvider).in(Scopes.SINGLETON);
    }

    protected final void bindObjectFactoryType(Class<? extends ObjectFactory> objectFactoryType) {
        Preconditions.checkArgument(objectFactoryType != null, "Parameter 'objectFactoryType' must be not null");
        this.objectFactoryType = objectFactoryType;
    }

    protected final void bindObjectWrapperFactoryType(Class<? extends ObjectWrapperFactory> objectWrapperFactoryType) {
        Preconditions.checkArgument(this.objectFactoryType != null, "Parameter 'objectWrapperFactoryType' must be not null");
        this.objectWrapperFactoryType = objectWrapperFactoryType;
    }

    protected final void bindDefaultScriptingLanguageType(Class<? extends LanguageDriver> defaultScriptingLanguageType) {
        Preconditions.checkArgument(defaultScriptingLanguageType != null, "Parameter 'defaultScriptingLanguageType' must be not null");
        this.defaultScriptingLanguageType = defaultScriptingLanguageType;
    }

    protected final AliasBinder addAlias(final String alias) {
        Preconditions.checkArgument(alias != null && alias.length() > 0, "Empty or null 'alias' is not valid");
        return new AliasBinder(){

            @Override
            public void to(Class<?> clazz) {
                Preconditions.checkArgument(clazz != null, "Null type not valid for alias '%s'", alias);
                MyBatisModule.this.bindConfigurationSetting(new AliasConfigurationSetting(alias, clazz));
            }
        };
    }

    protected final void addSimpleAlias(Class<?> type) {
        Preconditions.checkArgument(type != null, "Parameter 'type' must be not null");
        String alias = type.getSimpleName();
        Alias annotation = type.getAnnotation(Alias.class);
        if (annotation != null) {
            alias = annotation.value();
        }
        this.addAlias(alias).to(type);
    }

    protected final void addSimpleAliases(Collection<Class<?>> types) {
        Preconditions.checkArgument(types != null, "Parameter 'types' must be not null");
        for (Class<?> type : types) {
            this.addSimpleAlias(type);
        }
    }

    protected final void addSimpleAliases(String packageName, ResolverUtil.Test test) {
        this.addSimpleAliases(MyBatisModule.getClasses(test, packageName));
    }

    protected final void addSimpleAliases(String packageName) {
        this.addSimpleAliases(MyBatisModule.getClasses(packageName));
    }

    protected final <T> TypeHandlerBinder<T> handleType(final Class<T> type) {
        Preconditions.checkArgument(type != null, "Parameter 'type' must be not null");
        return new TypeHandlerBinder<T>(){

            @Override
            public void with(Class<? extends TypeHandler<? extends T>> handler) {
                Preconditions.checkArgument(handler != null, "TypeHandler must not be null for '%s'", type.getName());
                this.bindTypeHandler(TypeLiteral.get(handler));
                MyBatisModule.this.bindConfigurationSettingProvider(JavaTypeAndHandlerConfigurationSettingProvider.create(type, Key.get(handler)));
            }

            @Override
            public void with(TypeLiteral<? extends TypeHandler<? extends T>> handler) {
                Preconditions.checkArgument(handler != null, "TypeHandler must not be null for '%s'", type.getName());
                this.bindTypeHandler(handler);
                MyBatisModule.this.bindConfigurationSettingProvider(JavaTypeAndHandlerConfigurationSettingProvider.create(type, Key.get(handler)));
            }

            @Override
            public void withProvidedTypeHandler(Class<? extends TypeHandler<? extends T>> handler) {
                Preconditions.checkArgument(handler != null, "TypeHandler must not be null for '%s'", type.getName());
                this.bindProvidedTypeHandler(TypeLiteral.get(handler), type);
                MyBatisModule.this.bindConfigurationSettingProvider(JavaTypeAndHandlerConfigurationSettingProvider.create(type, Key.get(handler)));
            }

            @Override
            public void withProvidedTypeHandler(TypeLiteral<? extends TypeHandler<? extends T>> handler) {
                Preconditions.checkArgument(handler != null, "TypeHandler must not be null for '%s'", type.getName());
                this.bindProvidedTypeHandler(handler, type);
                MyBatisModule.this.bindConfigurationSettingProvider(JavaTypeAndHandlerConfigurationSettingProvider.create(type, Key.get(handler)));
            }

            final <TH extends TypeHandler<? extends T>> void bindTypeHandler(TypeLiteral<TH> typeHandlerType) {
                MyBatisModule.this.bind(typeHandlerType).in(Scopes.SINGLETON);
            }

            final <TH extends TypeHandler<? extends T>> void bindProvidedTypeHandler(TypeLiteral<TH> typeHandlerType, Class<T> type2) {
                MyBatisModule.this.bind(typeHandlerType).toProvider(Providers.guicify(new TypeHandlerProvider(typeHandlerType, type2))).in(Scopes.SINGLETON);
            }
        };
    }

    protected final void addTypeHandlerClass(Class<? extends TypeHandler<?>> handlerClass) {
        Preconditions.checkArgument(handlerClass != null, "Parameter 'handlerClass' must not be null");
        this.bind(TypeLiteral.get(handlerClass)).in(Scopes.SINGLETON);
        this.bindConfigurationSettingProvider(new TypeHandlerConfigurationSettingProvider(Key.get(handlerClass)));
    }

    protected final void addTypeHandlersClasses(Collection<Class<? extends TypeHandler<?>>> handlersClasses) {
        Preconditions.checkArgument(handlersClasses != null, "Parameter 'handlersClasses' must not be null");
        for (Class<TypeHandler<?>> clazz : handlersClasses) {
            this.addTypeHandlerClass(clazz);
        }
    }

    protected final void addTypeHandlerClasses(String packageName) {
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        this.addTypeHandlersClasses(new ResolverUtil().find(new ResolverUtil.IsA(TypeHandler.class), packageName).getClasses());
    }

    protected final void addInterceptorClass(Class<? extends Interceptor> interceptorClass) {
        Preconditions.checkArgument(interceptorClass != null, "Parameter 'interceptorClass' must not be null");
        this.bindConfigurationSettingProvider(new InterceptorConfigurationSettingProvider(interceptorClass));
    }

    protected final void addInterceptorsClasses(Collection<Class<? extends Interceptor>> interceptorsClasses) {
        Preconditions.checkArgument(interceptorsClasses != null, "Parameter 'interceptorsClasses' must not be null");
        for (Class<? extends Interceptor> interceptorClass : interceptorsClasses) {
            this.addInterceptorClass(interceptorClass);
        }
    }

    protected final void addInterceptorsClasses(String packageName) {
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        this.addInterceptorsClasses(new ResolverUtil().find(new ResolverUtil.IsA(Interceptor.class), packageName).getClasses());
    }

    protected final void addMapperClass(Class<?> mapperClass) {
        Preconditions.checkArgument(mapperClass != null, "Parameter 'mapperClass' must not be null");
        this.bindListener(KeyMatcher.create(Key.get(ConfigurationProvider.class)), ConfigurationProviderProvisionListener.create(new MapperConfigurationSetting(mapperClass)));
        this.bindMapper(mapperClass);
    }

    protected final void addMapperClasses(Collection<Class<?>> mapperClasses) {
        Preconditions.checkArgument(mapperClasses != null, "Parameter 'mapperClasses' must not be null");
        for (Class<?> mapperClass : mapperClasses) {
            this.addMapperClass(mapperClass);
        }
    }

    protected final void addMapperClasses(String packageName) {
        this.addMapperClasses(MyBatisModule.getClasses(packageName));
    }

    protected final void addMapperClasses(String packageName, ResolverUtil.Test test) {
        this.addMapperClasses(MyBatisModule.getClasses(test, packageName));
    }

    private static Set<Class<?>> getClasses(String packageName) {
        return MyBatisModule.getClasses(new ResolverUtil.IsA(Object.class), packageName);
    }

    private static Set<Class<?>> getClasses(ResolverUtil.Test test, String packageName) {
        Preconditions.checkArgument(test != null, "Parameter 'test' must not be null");
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        return new ResolverUtil().find(test, packageName).getClasses();
    }
}

