"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../../scales/constants");
var spec_1 = require("../state/utils/spec");
var specs_1 = require("./specs");
function fillSeries(series, xValues, seriesSpecs, groupScaleType, specsByGroupIds) {
    var sortedXValues = __spread(xValues.values());
    var filledSeries = new Map();
    series.forEach(function (dataSeries, key) {
        var spec = spec_1.getSpecsById(seriesSpecs, key);
        if (!spec) {
            return;
        }
        var group = specsByGroupIds.get(spec.groupId);
        if (!group) {
            return;
        }
        var isStacked = Boolean(group.stacked.find(function (_a) {
            var id = _a.id;
            return id === key;
        }));
        var noFillRequired = isXFillNotRequired(spec, groupScaleType, isStacked);
        var filledDataSeries = dataSeries.map(function (_a) {
            var data = _a.data, rest = __rest(_a, ["data"]);
            if (data.length === xValues.size || noFillRequired) {
                return __assign(__assign({}, rest), { data: data });
            }
            var filledData = [];
            var missingValues = new Set(xValues);
            for (var i = 0; i < data.length; i++) {
                var x = data[i].x;
                filledData.push(data[i]);
                missingValues.delete(x);
            }
            var missingValuesArray = __spread(missingValues.values());
            for (var i = 0; i < missingValuesArray.length; i++) {
                var missingValue = missingValuesArray[i];
                var index = sortedXValues.indexOf(missingValue);
                filledData.splice(index, 0, {
                    x: missingValue,
                    y1: null,
                    y0: null,
                    initialY1: null,
                    initialY0: null,
                    mark: null,
                    datum: undefined,
                    filled: {
                        x: missingValue,
                    },
                });
            }
            return __assign(__assign({}, rest), { data: filledData });
        });
        filledSeries.set(key, filledDataSeries);
    });
    return filledSeries;
}
exports.fillSeries = fillSeries;
function isXFillNotRequired(spec, groupScaleType, isStacked) {
    var onlyNoFitAreaLine = (specs_1.isAreaSeriesSpec(spec) || specs_1.isLineSeriesSpec(spec)) && !spec.fit;
    var onlyContinuous = groupScaleType === constants_1.ScaleType.Linear || groupScaleType === constants_1.ScaleType.Time;
    return onlyNoFitAreaLine && onlyContinuous && !isStacked;
}
//# sourceMappingURL=fill_series.js.map