import * as React from "react";
import { JSONObject, MediaBundle } from "@nteract/commutable";
/** Error handling types */
interface ReactErrorInfo {
    componentStack: string;
}
interface Caught {
    error: Error;
    info: ReactErrorInfo;
}
export interface RichMediaProps {
    /**
     * Object of media type → data
     *
     * E.g.
     *
     * ```js
     * {
     *   "text/plain": "raw text",
     * }
     * ```
     *
     * See [Jupyter message spec](http://jupyter-client.readthedocs.io/en/stable/messaging.html#display-data)
     * for more detail.
     *
     */
    data: Readonly<MediaBundle>;
    /**
     * custom settings, typically keyed by media type
     */
    metadata: Readonly<JSONObject>;
    /**
     * React elements that accept media bundle data, will get passed data[mimetype]
     */
    children: React.ReactElement<any> | React.ReactNodeArray | null | undefined;
    renderError(param: {
        error: Error;
        info: ReactErrorInfo;
        data: MediaBundle;
        metadata: object;
        children: React.ReactNode;
    }): React.ReactElement<any>;
}
interface State {
    caughtError?: Caught | null;
}
export declare class RichMedia extends React.PureComponent<RichMediaProps, State> {
    static defaultProps: Partial<RichMediaProps>;
    state: Partial<State>;
    componentDidCatch(error: Error, info: ReactErrorInfo): void;
    choose: (children: React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)> | React.ReactNodeArray | null | undefined) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)> | null;
    render(): React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)> | null;
}
export default RichMedia;
