"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;

var _opensearch_observability_plugin = require("./adaptors/opensearch_observability_plugin");

var _ppl_plugin = require("./adaptors/ppl_plugin");

var _index = require("./routes/index");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObservabilityPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const openSearchObservabilityClient = core.opensearch.legacy.createClient('opensearch_observability', {
      plugins: [_ppl_plugin.PPLPlugin, _opensearch_observability_plugin.OpenSearchObservabilityPlugin]
    }); // @ts-ignore

    core.http.registerRouteHandlerContext('observability_plugin', (context, request) => {
      return {
        logger: this.logger,
        observabilityClient: openSearchObservabilityClient
      };
    }); // Register server side APIs

    (0, _index.setupRoutes)({
      router,
      client: openSearchObservabilityClient
    });
    return {};
  }

  start(core) {
    this.logger.debug('Observability: Started');
    return {};
  }

  stop() {}

}

exports.ObservabilityPlugin = ObservabilityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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