<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Impostazioni accounto',
    'sidebar_personalization' => 'Personalizzazione',
    'sidebar_settings_storage' => 'Archiviazione',
    'sidebar_settings_export' => 'Esporta dati',
    'sidebar_settings_users' => 'Utenti',
    'sidebar_settings_subscriptions' => 'Sottoscrizioni',
    'sidebar_settings_import' => 'Importa dati',
    'sidebar_settings_tags' => 'Gestione dei tag',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Risorse DAV',
    'sidebar_settings_security' => 'Sicurezza',
    'sidebar_settings_auditlogs' => 'Verifica logs',

    'title_general' => 'Informazioni generali',
    'title_i18n' => 'Impostazioni internazionali',
    'title_layout' => 'Impaginazione',

    'me_title' => 'Me come contatto',
    'me_help' => 'Questo è il contatto che rappresenta <em>te</em> a Monica',
    'me_select' => 'Seleziona un contatto',
    'me_no_contact' => 'Ancora nessun contatto selezionato.',
    'me_select_click' => 'Clicca qui per selezionare un contatto.',
    'me_remove_contact' => 'Rimuovi l\'associazione',
    'me_choose' => 'Scegli te stesso',
    'me_choose_placeholder' => 'Scegli te stesso',

    'export_title' => 'Esporta i dati del tuo account',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Nome',
    'lastname' => 'Cognome',
    'name_order' => 'Ordine del nome',
    'name_order_firstname_lastname' => '<First name> <Last name> – John Doe',
    'name_order_lastname_firstname' => '<Last name> <First name> – Doe John',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – John Doe (Rambo)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – John (Rambo) Doe',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Doe John (Rambo)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Doe (Rambo) John',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (John Doe)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Mario Rossi)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Valuta',
    'name' => 'Il tuo nome: :name',
    'email' => 'Email',
    'email_placeholder' => 'Insersci un\'email',
    'email_help' => 'Questa è l\'email usata per accedere e dove Monica invierà i tuoi promemoria.',
    'timezone' => 'Fuso orario',
    'temperature_scale' => 'Unità temperatura',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Impaginazione',
    'layout_small' => 'Massimo 1200 pixel di larghezza',
    'layout_big' => 'Larghezza intera del browser',
    'save' => 'Aggiorna impostazioni',
    'delete_title' => 'Rimuovi il tuo account',
    'delete_desc' => 'Desideri eliminare il tuo profilo? L\'eliminazione è permanente e tutti i tuoi dati saranno eliminati permanentemente. Se hai un abbonamento, sarà annullato immediatamente.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Desideri ripristinare il tuo profilo? Questo rimuoverà tutti i tuoi contatti e tutti i dati a essi associati. Il tuo profilo non sarà eliminato.',
    'reset_title' => 'Reimposta il tuo account',
    'reset_cta' => 'Reimposta il tuo account',
    'reset_notice' => 'Sei sicuro di voler ripristinare il tuo profilo? Ciò è permanente e non annullabile.',
    'reset_success' => 'Il tuo profilo è stato correttamente ripristinato.',
    'delete_notice' => 'Sei sicuro di voler eliminare il tuo profilo? Ciò è permanente e non annullabile. Tutti i tuoi dati saranno eliminati e non saranno recuperabili.',
    'delete_cta' => 'Rimuovi account',
    'settings_success' => 'Impostazioni aggiornate',
    'locale' => 'Lingua',
    'locale_help' => 'Vuoi aiutare a tradurre Monica o ad aggiungere una nuova lingua? Segui <a href=":url" target="_blank" lang="en">questo link per ulteriori informazioni</a>.',
    'locale_ar' => 'Arabo',
    'locale_cs' => 'Ceco',
    'locale_de' => 'Tedesco',
    'locale_el' => 'Greco',
    'locale_en' => 'Inglese',
    'locale_en-GB' => 'Inglese (Regno Unito)',
    'locale_es' => 'Spagnolo',
    'locale_fr' => 'Francese',
    'locale_he' => 'Ebraico',
    'locale_hr' => 'Croato',
    'locale_id' => 'Indonesiano',
    'locale_it' => 'Italiano',
    'locale_ja' => 'Giapponese',
    'locale_nl' => 'Olandese',
    'locale_pt' => 'Portoghese',
    'locale_pt-BR' => 'Portoghese Brasiliano',
    'locale_ru' => 'Russo',
    'locale_sv' => 'Svedese',
    'locale_vi' => 'Vietnamita',
    'locale_zh' => 'Cinese semplificato',
    'locale_zh-TW' => 'Cinese Tradizionale',
    'locale_tr' => 'Turco',

    'security_title' => 'Sicurezza',
    'security_help' => 'Modifica le impostazioni di sicurezza relative al tuo account',
    'password_change' => 'Modifica la tua password',
    'password_current' => 'Password attuale',
    'password_current_placeholder' => 'Inserisci la tua password corrente',
    'password_new1' => 'Nuova password',
    'password_new1_placeholder' => 'Inserisci la tua nuova password',
    'password_new2' => 'Conferma la tua nuova password',
    'password_new2_placeholder' => 'Digita di nuovo la tua nuova password',
    'password_btn' => 'Modifica password',
    '2fa_title' => 'Autenticazione a due fattori',
    '2fa_otp_title' => 'App di autenticazione a due fattori',
    '2fa_enable_title' => 'Abilita autenticazione a due fattori',
    '2fa_enable_description' => 'Abilita l\'Autenticazione a Due Fattori per aumentare la sicurezza del tuo profilo.',
    '2fa_enable_otp' => 'Apri la tua app mobile dell\'Autenticazione a Due Fattori e scansiona il seguente codice QR:',
    '2fa_enable_otp_help' => 'Se la tua app mobile di Autenticazione a Due Fattori non supporta i codici QR, inserisci il seguente codice:',
    '2fa_enable_otp_validate' => 'Sei pregato di validare il nuovo dispositivo appena configurato:',
    '2fa_enable_success' => 'Autenticazione a due fattori attivata.',
    '2fa_enable_error' => 'Errore durante l\'attivazione dell\'autenticazione a due fattori.',
    '2fa_enable_error_already_set' => 'Autenticazione a due fattori già attiva',
    '2fa_disable_title' => 'Disabilita autenticazione a due fattori',
    '2fa_disable_description' => 'Disabilita l\'Autenticazione a Due Fattori per il tuo profilo. Attenzione, il tuo profilo sarà molto meno sicuro!',
    '2fa_disable_success' => 'Autenticazione a due fattori disattivata',
    '2fa_disable_error' => 'Errore durante la disattivazione dell\'autenticazione a due fattori',

    'webauthn_title' => 'Chiave di sicurezza — Protocollo WebAuthn',
    'webauthn_enable_description' => 'Aggiungi una nuova chiave di sicurezza',
    'webauthn_key_name_help' => 'Dai un nome alla tua chiave.',
    'webauthn_key_name' => 'Nome della chiave:',
    'webauthn_success' => 'Chiave rilevata e confermata.',
    'webauthn_last_use' => 'Ultimo uso: {timestamp}',
    'webauthn_delete_confirmation' => 'Sei sicuro di voler cancellare questa chiave?',
    'webauthn_delete_success' => 'Chiave eliminata',
    'webauthn_insertKey' => 'Inserisci la tua chiave di sicurezza.',
    'webauthn_buttonAdvise' => 'Se la tua chiave ha un bottone, premilo.',
    'webauthn_noButtonAdvise' => 'Se non ce l\'ha, rimuovila e reinseriscila.',
    'webauthn_not_supported' => 'Il tuo browser non supporta WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn supporta solo connessioni sicure. Si prega di caricare questa pagina con lo schema https.',
    'webauthn_error_already_used' => 'Questa chiave è già registrata. Non è necessario registrarla nuovamente.',
    'webauthn_error_not_allowed' => 'L\'operazione è scaduta o non è stata consentita.',

    'recovery_title' => 'Codici di recupero',
    'recovery_show' => 'Ottieni codici di recupero',
    'recovery_copy_help' => 'Copia i codici nella clipboard',
    'recovery_help_intro' => 'Ecco i tuoi codici di recupero:',
    'recovery_help_information' => 'Puoi usare ciascun codice una volta soltanto.',
    'recovery_clipboard' => 'Codici copiati negli appunti.',
    'recovery_generate' => 'Genera nuovi codici…',
    'recovery_generate_help' => 'Generare nuovi codici invaliderà quelli precedentemente generati.',
    'recovery_already_used_help' => 'Questo codice è già stato usato.',

    'users_list_title' => 'Utenti con accesso al tuo account',
    'users_list_add_user' => 'Invita un nouvo utente',
    'users_list_you' => 'Sei tu',
    'users_list_invitations_title' => 'Inviti in attesa di risposta',
    'users_list_invitations_explanation' => 'Qui sotto trovi gli inviti a Monica come collaboratori.',
    'users_list_invitations_invited_by' => 'invitato da :name',
    'users_list_invitations_sent_date' => 'il :date',
    'users_blank_title' => 'Sei l\'unica persona che ha accesso a questo account.',
    'users_blank_add_title' => 'Vuoi invitare qualcun altro ?',
    'users_blank_description' => 'Questa persona avrà il tuo stesso accesso, e potrà aggiungere, modificare o rimuovere qualsiasi contatto.',
    'users_blank_cta' => 'Invita qualcuno',
    'users_add_title' => 'Invita un nuovo utente al tuo profilo via email',
    'users_add_description' => 'Questa persona avrà il tuo stesso accesso, inclusi l\'invito o l\'eliminazione di altri utenti, tu incluso. Assicurati di avere fiducia in questa persona prima di dargli accesso.',
    'users_add_email_field' => 'Inserisci l\'email della persona che vuoi invitare',
    'users_add_confirmation' => 'Confermo che voglio invitare quest\'utente al mio profilo. Sono consapevole che questa persona avrà accesso a TUTTI i miei dati e vedrà esattamente ciò che vedo.',
    'users_add_cta' => 'Invita utente tramite email',
    'users_accept_title' => 'Accetta l\'invito e crea un account',
    'users_error_please_confirm' => 'Ti preghiamo di confermare di voler invitare questo utente prima di procedere',
    'users_error_email_already_taken' => 'Questa email è già assegnata. Ti preghiamo di sceglierne un\'altra',
    'users_error_already_invited' => 'Hai già invitato questo utente. Ti preghiamo di scegliere un\'altro indirizzo email.',
    'users_error_email_not_similar' => 'Questa non è l\'email della persona che ti ha invitato.',
    'users_invitation_deleted_confirmation_message' => 'Invito rimosso',
    'users_invitations_delete_confirmation' => 'Rimuovere invito?',
    'users_list_delete_confirmation' => 'Rimuovere questo utente dal tuo account?',
    'users_invitation_need_subscription' => 'Aggiungere altri utenti richiede una sottoscrizione.',

    'subscriptions_account_current_plan' => 'Il tuo piano attuale',
    'subscriptions_account_current_legacy' => 'Piano corrente, non più selezionabile:',
    'subscriptions_account_current_paid_plan' => 'Stai usando il piano :name. Grazie infinite per essere abbonato.',

    'subscriptions_account_next_billing_title' => 'Prossima fattura',
    'subscriptions_account_next_billing' => 'Il tuo abbonamento verrà automaticamente rinnovato il <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Ti addebiteremo <strong>:price</strong> per un altro <strong>mese</strong>.',
    'subscriptions_account_bill_annual' => 'Ti addebiteremo <strong>:price</strong> per un altro <strong>anno</strong>.',
    'subscriptions_account_change' => 'Cambia piano',

    'subscriptions_account_cancel_title' => 'Annulla abbonamento',
    'subscriptions_account_cancel_action' => 'Annulla abbonamento',
    'subscriptions_account_cancel' => 'Puoi annullare il tuo abbonamento in qualsiasi momento.',
    'subscriptions_account_free_plan' => 'Stai usando il piano gratuito.',
    'subscriptions_account_free_plan_upgrade' => 'Puoi promuovere il tuo piano al livello :name, che costa $:price al mese. I vantaggi sono:',
    'subscriptions_account_free_plan_benefits_users' => 'Numero di utenti illimitato',
    'subscriptions_account_free_plan_benefits_reminders' => 'Promemoria via email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importa i tuoi contatti con vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Supporta il progetto a lungo termine, così che possiamo introdurre grandi nuove funzionalità.',
    'subscriptions_account_upgrade' => 'Promuovi il tuo account',
    'subscriptions_account_upgrade_title' => 'Aggiorna Monica oggi e ottieni relazioni più significative.',
    'subscriptions_account_upgrade_choice' => 'Scegli un piano e unisciti alle :customers persone abbonate a Monica.',
    'subscriptions_account_update_title' => 'Aggiorna l\'abbonamento di Monica',
    'subscriptions_account_update_description' => 'Puoi cambiare la frequenza del tuo abbonamento qui.',
    'subscriptions_account_update_information' => 'Sarai addebitato immediatamente per il nuovo importo. Il tuo abbonamento si estenderà al nuovo periodo, in base alla tua scelta.',
    'subscriptions_account_invoices' => 'Ricevute',
    'subscriptions_account_invoices_download' => 'Scarica',
    'subscriptions_account_invoices_subscription' => 'Abbonamento da :startDate a :endDate',
    'subscriptions_account_payment' => 'Quale opzione di pagamento preferisci?',
    'subscriptions_account_confirm_payment' => 'Il tuo pagamento è attualmente incompleto, per favore <a href=":url">conferma il tuo pagamento</a>.',
    'subscriptions_downgrade_title' => 'Retrocedi il tuo piano a quello gratuito',
    'subscriptions_downgrade_limitations' => 'Il piano gratuito è limitato. Per poter retrocedere il tuo account al piano gratuito, devi soddisfare questi requisiti:',
    'subscriptions_downgrade_rule_users' => 'Devi avere un solo utente nel tuo account',
    'subscriptions_downgrade_rule_users_constraint' => 'Al momento hai <a href=":url">1 utente</a> nel tuo account.|Al momento hai <a href=":url">:count utenti</a> nel tuo account.',
    'subscriptions_downgrade_rule_invitations' => 'Non devi avere alcun invito in attesa',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Correntemente hai <a href=":url">1 invito in attesa</a>.|Correntemente hai <a href=":url">:count inviti in attesa</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Non puoi avere più di :number contatti attivi',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Al momento hai <a href=":url">1 contatto</a>.|Al momento hai <a href=":url">:count contatti</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'Possiamo anche <a href=":url">archiviare tutti i tuoi contatti per te</a>: ciò cancellerebbe questa regola e ti consentirebbe di procedere con il processo di downgrade del tuo profilo.',
    'subscriptions_downgrade_cta' => 'Retrocedi',
    'subscriptions_downgrade_success' => 'Sei tornato al piano gratuito!',
    'subscriptions_downgrade_thanks' => 'Grazie mille per aver provato il piano a pagamento. Continuiamo sempre ad aggiungere nuove funzionalità su Monica, quindi potresti voler tornare in futuro per vedere se potresti esser interessato ad abbonarti di nuovo.',
    'subscriptions_back' => 'Torna alle impostazioni',
    'subscriptions_upgrade_title' => 'Promuovi il tuo account',
    'subscriptions_upgrade_choose' => 'Hai scelto il piano :plan.',
    'subscriptions_upgrade_infos' => 'Non potremmo essere più felici. Inserisci le informazioni sul pagamento qui sotto.',
    'subscriptions_upgrade_name' => 'Nome sulla carta',
    'subscriptions_upgrade_zip' => 'CAP',
    'subscriptions_upgrade_credit' => 'Carta di credito o debito',
    'subscriptions_upgrade_submit' => 'Paga {amount}',
    'subscriptions_upgrade_charge' => 'Addebiteremo ora :price alla tua carta. Il prossimo addebito sarà il :date. Se dovessi cambiare idea, potrai annullarlo in ogni momento, senza spiegazioni.',
    'subscriptions_upgrade_charge_handled' => 'Il pagamento è gestito da <a href=":url">Stripe</a>. Nessuna informazione sulla tua carta arriva ai nostri server.',
    'subscriptions_upgrade_success' => 'Grazie! Adesso sei abbonato.',
    'subscriptions_upgrade_thanks' => 'Benvenuto nella community di persone che tenta di migliorare il mondo.',

    'subscriptions_payment_confirm_title' => 'Conferma il tuo pagamento per :amount',
    'subscriptions_payment_confirm_information' => 'È necessaria una conferma ulteriore per elaborare il pagamento. Conferma il pagamento compilando i dettagli di pagamento qui sotto.',
    'subscriptions_payment_succeeded_title' => 'Pagamento riuscito',
    'subscriptions_payment_succeeded' => 'Questo pagamento è già stato confermato con successo.',
    'subscriptions_payment_cancelled_title' => 'Pagamento annullato',
    'subscriptions_payment_cancelled' => 'Questo pagamento è stato annullato.',
    'subscriptions_payment_error_name' => 'Per favore inserisci il tuo nome.',
    'subscriptions_payment_success' => 'Pagamento effettuato con successo.',

    'subscriptions_pdf_title' => 'Sottoscrizione mensile a :name',
    'subscriptions_plan_frequency_year' => ':amount / anno',
    'subscriptions_plan_frequency_month' => ':amount / mese',
    'subscriptions_plan_choose' => 'Scegli questo piano',
    'subscriptions_plan_year_title' => 'Paga annualmente',
    'subscriptions_plan_year_bonus' => 'Nessun pensiero per un anno',
    'subscriptions_plan_month_title' => 'Paga mensilmente',
    'subscriptions_plan_month_bonus' => 'Cancella in qualsiasi momento',
    'subscriptions_plan_include1' => 'Incluso nell\'abbonamento:',
    'subscriptions_plan_include2' => 'Numero di contatti illimitato • Numero di utenti illimitato • Promemoria via email • Importazione da vCard • Personalizzazione della pagina dei contatti',
    'subscriptions_plan_include3' => 'Il 100% dei profitti va nello sviluppo di questo progetto grande e open source.',
    'subscriptions_help_title' => 'Altri dettagli che potrebbero interessarti',
    'subscriptions_help_opensource_title' => 'Cosa significa open source?',
    'subscriptions_help_opensource_desc' => 'Monica è un progetto open source. Ciò significa che è costruito da una community che vuole costruire un buono strumento per il bene maggiore. Essere open source significa che il codice è disponibile pubblicamente su GitHub e che tutti possono ispezionarlo, modificarlo o migliorarlo. Tutto il denaro che raccogliamo è dedicato a costruire funzionalità migliori, pagare per server più potenti e pagare altri costi. Grazie per il tuo aiuto. Non potremmo farlo senza di te.',
    'subscriptions_help_limits_title' => 'C\'è un limite al numero di contatti che posso avere sul piano gratuito?',
    'subscriptions_help_limits_plan' => 'Sì. Il piano gratuito ti permette di gestire :number contatti.',
    'subscriptions_help_discounts_title' => 'Avete sconti per organizzazioni no-profit e studenti?',
    'subscriptions_help_discounts_desc' => 'Sì! Monica è gratuita per studenti, no-profit e organizzazioni di beneficienza. Basta contattare <a href=":support">il supporto clienti</a> con una prova del tuo status, e aggiorneremo il tuo account.',
    'subscriptions_help_change_title' => 'Che succede se cambio idea?',
    'subscriptions_help_change_desc' => 'Puoi annullare quando vuoi, senza spiegazioni, e puoi farlo da solo, non serve contattare il supporto. Tuttavia, non sarai rimborsato per il periodo corrente.',

    'stripe_error_card' => 'La tua carta è stata declinata. Il messaggio ricevuto è: :message',
    'stripe_error_api_connection' => 'Comunicazione con Stripe fallita. Riprova tra poco.',
    'stripe_error_rate_limit' => 'Troppe richieste a Stripe in questo momento. Riprova tra poco.',
    'stripe_error_invalid_request' => 'Parametri non validi. Riprova più tardi.',
    'stripe_error_authentication' => 'Autenticazione con Stripe non valida',

    'import_title' => 'Importa contatti nel tuo account',
    'import_cta' => 'Carica contatti',
    'import_stat' => 'Hai importato :number file fino ad ora.',
    'import_result_stat' => 'vCard caricata con 1 contatto (:total_imported importati, :total_skipped saltati)|vCard caricata con :total_contacts contatti (:total_imported importati, :total_skipped saltati)',
    'import_view_report' => 'Vedi resoconto',
    'import_in_progress' => 'Importazione in corso. Ricarica la pagina in un minuto.',
    'import_upload_title' => 'Importa i contatti da un file vCard',
    'import_upload_rules_desc' => 'Ci sono alcune regole:',
    'import_upload_rule_format' => 'Supportiamo file <code>.vcard</code> e <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Supportiamo il formato vCard 3.0, il formato predefinito per Contacts.app di macOS e Google Contacts.',
    'import_upload_rule_instructions' => 'Esporta le istruzioni per <a href=":url1" target="_blank" rel="noopener noreferrer">Contacts.app di macOS</a> e <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Se i tuoi contatti hanno indirizzi email o numeri telefonici multipli, solo i primi saranno salvati.',
    'import_upload_rule_limit' => 'I file sono limitati a 10 MB.',
    'import_upload_rule_time' => 'Potrebbe volerci fino a un minuto per caricare ed elaborare i contatti. Sei pregato di esser paziente.',
    'import_upload_rule_cant_revert' => 'Sei pregato di assicurarti che i dati siano accurati prima di caricarli, poiché non puoi annullarne il caricamento.',
    'import_upload_form_file' => 'Il tuo file <code>.vcf</code> o <code>.vCard</code>:',
    'import_upload_behaviour' => 'Comportamento:',
    'import_upload_behaviour_add' => 'Aggiungi nuovi contatti e salta esistenti',
    'import_upload_behaviour_replace' => 'Sovrascrivi i contatti già esistenti',
    'import_upload_behaviour_help' => 'La sostituzione rimpiazzerà tutti i dati trovati nella vCard, ma manterrà i campi di contatto esistenti.',
    'import_report_title' => 'Resoconto dell\'importazione',
    'import_report_date' => 'Data dell\'importazione',
    'import_report_type' => 'Tipo di importazione',
    'import_report_number_contacts' => 'Numero di contatti nel file',
    'import_report_number_contacts_imported' => 'Numero di contatti importati',
    'import_report_number_contacts_skipped' => 'Numero di contatti omessi',
    'import_report_status_imported' => 'Importati',
    'import_report_status_skipped' => 'Omessi',
    'import_vcard_parse_error' => 'Errore nel parsing della vCard',
    'import_vcard_contact_exist' => 'Contatto già esistente',
    'import_vcard_contact_no_firstname' => 'Nome mancante (obbligatorio)',
    'import_vcard_file_not_found' => 'File non trovato',
    'import_vcard_unknown_entry' => 'Nome di contatto sconosciuto',
    'import_vcard_file_no_entries' => 'Il file non contiene contatti',
    'import_blank_title' => 'Non hai importato nessun contatto per ora.',
    'import_blank_question' => 'Importare contatti?',
    'import_blank_description' => 'Possiamo importare file vCard ottenibili da Google Contacts o dal tuo gestore di contatti.',
    'import_blank_cta' => 'Importa vCard',
    'import_need_subscription' => 'Importare dati richiede una sottoscrizione.',

    'tags_list_title' => 'Etichette',
    'tags_list_description' => 'Puoi organizzare i tuoi contatti attraverso le etichette. Le etichette funzionano come delle cartelle, ma puoi aggiungere più di un\'etichetta a ogni contatto. Per aggiungere una nuova etichetta, aggiungila al contatto stesso.',
    'tags_list_contact_number' => '1 contatto|:count contatti',
    'tags_list_delete_success' => 'Etichetta rimossa',
    'tags_list_delete_confirmation' => 'Rimuovere etichetta? Nessun contatto verrà rimosso, solo l\'etichetta.',
    'tags_blank_title' => 'Le etichette sono un buon modo di organizzare i tuoi contatti.',
    'tags_blank_description' => 'I tag funzionano come cartelle, ma puoi aggiungerne più di uno a un contatto. Vai a un contatto e tagga un amico, proprio sotto al nome. Una volta taggato un contatto, torna qui per gestire tutti i tag nel tuo profilo.',

    'api_title' => 'Accesso all\'API',
    'api_description' => 'L\'API puó essere usata per manipolare le informazioni in Monica da un\'applicazione esterna, ad esempio da un\'applicazione per smartphone.',
    'api_help' => 'Per utilizzare le API, é obbligatorio l\'uso di un token. È possibile creare un token di accesso personale (autenticazione Bearer), o autorizzare un client OAuth per farlo creare al posto vostro. Vedi <a href=":url">documentazione riguardo le API</a> per maggiori informazioni.',
    'api_endpoint' => 'L\'endpoint API per questa istanza Monica è:',

    'api_personal_access_tokens' => 'Personal access token',
    'api_pao_description' => 'Assicurati di dare questo token a fonti fidate, giá che danno accesso a tutti i tuoi dati.',
    'api_token_title' => 'Token di Acceso personale',
    'api_token_create_new' => 'Crea nuovo token',
    'api_token_not_created' => 'Non hai creato nessun token di accesso.',
    'api_token_name' => 'Nome token',
    'api_token_expire' => 'Scade il {date}',
    'api_token_delete' => 'Rimuovi',
    'api_token_create' => 'Crea Token',
    'api_token_scopes' => 'Visibilità',
    'api_token_help' => 'Ecco il tuo nuovo token. Questa è l\'unica volta in cui viene mostrato, per cui segnatelo! Da ora in poi puoi utilizzarlo per fare richieste alle API.',

    'api_oauth_clients' => 'I tuoi client Oauth',
    'api_oauth_clients_desc' => 'Questa sezione ti permette di registrare i tuoi client OAuth.',
    'api_oauth_clients_desc2' => 'Usa questo Id Client per richiedere un nuovo token e convertire i codici di autorizzazione a token di accesso. Vedi la <a href="{url}">documentazione di Laravel Passport</a> per ulteriori informazioni.',
    'api_oauth_title' => 'Client OAuth',
    'api_oauth_create_new' => 'Crea nuovo client',
    'api_oauth_edit' => 'Modifica client',
    'api_oauth_not_created' => 'Non hai ancora creato nessun client OAuth.',
    'api_oauth_clientid' => 'ID Cliente',
    'api_oauth_name' => 'Nome',
    'api_oauth_name_help' => 'Qualcosa di riconoscibile per i tuoi utenti.',
    'api_oauth_secret' => 'Segreto',
    'api_oauth_create' => 'Crea client',
    'api_oauth_redirecturl' => 'URL di reindirizzamento',
    'api_oauth_redirecturl_help' => 'Indirizzo della callback di autorizzazione della tua applicazione.',

    'api_authorized_clients' => 'Lista di client autorizzati',
    'api_authorized_clients_desc' => 'Questa sezione elenca tutti i client che hai autorizzato ad accedere all\'applicazione. Puoi revocare questa autorizzazione in qualsiasi momento.',
    'api_authorized_clients_title' => 'Applicazioni autorizzate',
    'api_authorized_clients_none' => 'Ancora non c\'è alcun client autorizzato.',
    'api_authorized_clients_name' => 'Nome',
    'api_authorized_clients_scopes' => 'Visibilità',

    'personalization_tab_title' => 'Personalizza il tuo account',

    'personalization_title' => 'Qui puoi trovare diverse impostazioni per configurare il tuo profilo. Queste funzionalità sono intese per "utenti esperti" che vogliono il massimo controllo su Monica.',
    'personalization_contact_field_type_title' => 'Forme di contatto',
    'personalization_contact_field_type_add' => 'Aggiungi una nuova forma di contatto',
    'personalization_contact_field_type_description' => 'Puoi configurare tutti i diversi tipi di campi di contatto che puoi associare a tutti i tuoi contatti. Ad esempio, se comparisse un nuovo social network in futuro, potrai aggiungere questo nuovo mezzo di comunicazione ai tuoi contatti, proprio qui.',
    'personalization_contact_field_type_table_name' => 'Nome',
    'personalization_contact_field_type_table_protocol' => 'Protocollo',
    'personalization_contact_field_type_table_actions' => 'Azioni',
    'personalization_contact_field_type_modal_title' => 'Aggiungi una nova forma di contatto',
    'personalization_contact_field_type_modal_edit_title' => 'Aggiorna una forma di contatto esistente',
    'personalization_contact_field_type_modal_delete_title' => 'Rimuovi una forma di contatto esistente',
    'personalization_contact_field_type_modal_delete_description' => 'Sei sicuro di voler eliminare questo tipo di campo di contatto? Eliminandolo, cancellerai TUTTI i dati di questo tipo per tutti i tuoi contatti.',
    'personalization_contact_field_type_modal_name' => 'Nome',
    'personalization_contact_field_type_modal_protocol' => 'Protocollo (facoltativo)',
    'personalization_contact_field_type_modal_protocol_help' => 'Si puó cliccare su ogni forma di contatto. Se é impostato un protocollo, useremo quello.',
    'personalization_contact_field_type_modal_icon' => 'Icona (facoltativa)',
    'personalization_contact_field_type_modal_icon_help' => 'Puoi associare un\'icona a questa forma di contatto. Dev\'essere un\'icona di Font Awesome.',
    'personalization_contact_field_type_delete_success' => 'Il tipo di campo di contatto è stato correttamente eliminato.',
    'personalization_contact_field_type_add_success' => 'Forma di contatto aggiunta.',
    'personalization_contact_field_type_edit_success' => 'Forma di contatto aggiornata.',

    'personalization_genders_title' => 'Tipi di sesso',
    'personalization_genders_add' => 'Aggiungi un nuovo sesso',
    'personalization_genders_desc' => 'Puoi definire tutti i sessi che vuoi. Nel tuo account deve essere presente almeno un tipo di sesso.',
    'personalization_genders_modal_add' => 'Aggiungi sesso',
    'personalization_genders_modal_edit' => 'Aggiorna sesso',
    'personalization_genders_modal_name' => 'Nome',
    'personalization_genders_modal_name_help' => 'Il nome utilizzato per visualizzare il genere in una pagina di contatto.',
    'personalization_genders_modal_sex' => 'Sesso',
    'personalization_genders_modal_sex_help' => 'Usato per definire le relazioni, e durante il processo di importazione/esportazione della VCard.',
    'personalization_genders_modal_default' => 'Seleziona il sesso predefinito per un nuovo contatto',
    'personalization_genders_modal_delete' => 'Elimina sesso',
    'personalization_genders_modal_delete_desc' => 'Sei sicuro di voler eliminare il genere "{name}"?',
    'personalization_genders_modal_delete_question' => 'Correntemente hai {count} contatto con questo genere. Se elimini questo genere, questo contatto quale dovrebbe avere?|Correntemente hai {count} contatti con questo genere. Se elimini questo genere, questi contatti quale dovrebbe avere?',
    'personalization_genders_modal_delete_question_default' => 'Questo genere è predefinito. Se elimini questo genere, quale sarà il nuovo predefinito?',
    'personalization_genders_modal_error' => 'Sei pregato di scegliere un genere dall\'elenco.',
    'personalization_genders_list_contact_number' => '{count} contatto|{count} contatti',
    'personalization_genders_table_name' => 'Nome',
    'personalization_genders_table_sex' => 'Sesso',
    'personalization_genders_table_default' => 'Predefinito',
    'personalization_genders_default' => 'Genere predefinito',
    'personalization_genders_make_default' => 'Cambia genere predefinito',
    'personalization_genders_select_default' => 'Seleziona genere predefinito',
    'personalization_genders_m' => 'Maschio',
    'personalization_genders_f' => 'Femmina',
    'personalization_genders_o' => 'Altro',
    'personalization_genders_u' => 'Sconosciuto',
    'personalization_genders_n' => 'Nessuno o non applicabile',

    'personalization_reminder_rule_save' => 'Cambiamenti salvati',
    'personalization_reminder_rule_title' => 'Regole per i promemoria',
    'personalization_reminder_rule_line' => '{count} giorno prima|{count} giorni prima',
    'personalization_reminder_rule_desc' => 'Per ogni promemoria che imposti, Monica ti invierà un\'email un certo numero di giorni prima dell\'evento. Puoi regolare qui queste impostazioni di notifica. Queste notifiche si applicano solo a promemoria mensili e annuali.',

    'personalization_module_save' => 'Cambiamenti salvati',
    'personalization_module_title' => 'Funzionalità',
    'personalization_module_desc' => 'Potresti non necessitare di tutte le funzionalità di Monica. Sotto puoi attivare/disattivare funzionalità specifiche usate su una rubrica. Questa modifica influenzerà TUTTI i tuoi contatti. Disattivare una funzionalità non ne elimina tutti i dati, nasconde semplicemente la funzionalità.',

    'personalisation_paid_upgrade' => 'Questa è una funzionalità premium che richiede un abbonamento a pagamento per essere attivo. Aggiorna il tuo account visitando <a href=":url">Impostazioni > Abbonamento</a>.',
    'personalisation_paid_upgrade_vue' => 'Questa è una funzionalità premium che richiede un abbonamento a pagamento per essere attiva. Aggiorna il tuo account visitando <a href="{url}">Impostazioni > Abbonamento</a>.',

    'reminder_time_to_send' => 'Orario del giorno di invio dei promemoria',
    'reminder_time_to_send_help' => 'Il tuo prossimo promemoria è pianificato per l\'invio alle <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Categorie per le attività',
    'personalization_activity_type_category_add' => 'Aggiungi una nuova categoria di attività',
    'personalization_activity_type_category_table_name' => 'Nome',
    'personalization_activity_type_category_description' => 'Un\'attività con uno dei tuoi contatti può avere un tipo e un tipo di categoria. Il tuo profilo è fornito con una serie di tipi di categoria predefiniti di default, ma puoi personalizzarli qui.',
    'personalization_activity_type_category_table_actions' => 'Azioni',
    'personalization_activity_type_category_modal_add' => 'Aggiungi nuova categoria',
    'personalization_activity_type_category_modal_edit' => 'Modifica una categoria',
    'personalization_activity_type_category_modal_question' => 'Come dovremmo denominare questa nuova categoria?',
    'personalization_activity_type_add_button' => 'Aggiungi categoria',
    'personalization_activity_type_modal_add' => 'Aggiungi una nuova categoria',
    'personalization_activity_type_modal_question' => 'Come dovremmo denominare questo nuovo tipo d\'attività?',
    'personalization_activity_type_modal_edit' => 'Aggiorna una categoria esistente',
    'personalization_activity_type_category_modal_delete' => 'Elimina una categoria',
    'personalization_activity_type_category_modal_delete_desc' => 'Sei sicuro di voler eliminare questa categoria? Eliminarla cancellerà tutti i tipi d\'attività associati. Le attività appartenenti a questa categoria non saranno influenzate da quest\'eliminazione.',
    'personalization_activity_type_modal_delete' => 'Elimina un tipo di attività',
    'personalization_activity_type_modal_delete_desc' => 'Sei sicuro di eliminare questo tipo di attività? Le attività che appartengono a questa categoria non saranno eliminate.',
    'personalization_activity_type_modal_delete_error' => 'Impossibile trovare questo tipo.',
    'personalization_activity_type_category_modal_delete_error' => 'Impossibile trovare questa categoria.',

    'personalization_life_event_category_title' => 'Categorie dell\'evento della vita',
    'personalization_live_event_category_table_name' => 'Nome',
    'personalization_life_event_category_description' => 'Un evento importante può avere un tipo e una categoria. Il tuo profilo è fornito di una serie di categorie predefinite e tipi di default, ma puoi personalizzare qui i tipi di evento importante.',
    'personalization_live_event_category_table_actions' => 'Azioni',
    'personalization_life_event_type_add_button' => 'Aggiungi un nuovo tipo di evento della vita',
    'personalization_life_event_type_modal_add' => 'Aggiungi un nuovo tipo di evento della vita',
    'personalization_life_event_type_modal_question' => 'Come dovremmo denominare questo nuovo tipo di evento importante?',
    'personalization_life_event_type_modal_edit' => 'Modifica un tipo di evento della vita',
    'personalization_life_event_type_modal_delete' => 'Elimina un tipo di evento della vita',
    'personalization_life_event_type_modal_delete_desc' => 'Sei sicuro di voler eliminare questo tipo di evento della vita? Gli eventi della vita che appartengono a questo tipo saranno eliminati eseguendo quest\'azione.',
    'personalization_life_event_type_modal_delete_error' => 'Impossibile trovare questo tipo di evento della vita.',

    'personalization_life_event_category_work_education' => 'Lavoro e educazione',
    'personalization_life_event_category_family_relationships' => 'Famiglia e relazioni',
    'personalization_life_event_category_home_living' => 'Casa e vita',
    'personalization_life_event_category_travel_experiences' => 'Viaggi e esperienze',
    'personalization_life_event_category_health_wellness' => 'Salute e benessere',

    'personalization_life_event_type_new_job' => 'Nuovo lavoro',
    'personalization_life_event_type_retirement' => 'Pensionamento',
    'personalization_life_event_type_new_school' => 'Nuova scuola',
    'personalization_life_event_type_study_abroad' => 'Studio all\'estero',
    'personalization_life_event_type_volunteer_work' => 'Volontariato',
    'personalization_life_event_type_published_book_or_paper' => 'Pubblicazione di un libro o articolo',
    'personalization_life_event_type_military_service' => 'Servizio militare',
    'personalization_life_event_type_first_met' => 'Primo incontro',
    'personalization_life_event_type_new_relationship' => 'Nuova relazione',
    'personalization_life_event_type_engagement' => 'Fidanzamento',
    'personalization_life_event_type_marriage' => 'Matrimonio',
    'personalization_life_event_type_anniversary' => 'Anniversario',
    'personalization_life_event_type_expecting_a_baby' => 'Attesa di un bambino',
    'personalization_life_event_type_new_child' => 'Nuovo bambino',
    'personalization_life_event_type_new_family_member' => 'Nuovo membro di famiglia',
    'personalization_life_event_type_new_pet' => 'Nuovo animale domestico',
    'personalization_life_event_type_end_of_relationship' => 'Fine di una relazione',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Perdita di un caro',
    'personalization_life_event_type_moved' => 'Trasferimento',
    'personalization_life_event_type_bought_a_home' => 'Comprato una casa',
    'personalization_life_event_type_home_improvement' => 'Miglioramento per la casa',
    'personalization_life_event_type_holidays' => 'Vacanze',
    'personalization_life_event_type_new_vehicle' => 'Nuovo veicolo',
    'personalization_life_event_type_new_roommate' => 'Nuovo coinquilino',
    'personalization_life_event_type_overcame_an_illness' => 'Superamento di una malattia',
    'personalization_life_event_type_quit_a_habit' => 'Fine di un vizio',
    'personalization_life_event_type_new_eating_habits' => 'Nuove abitudini alimentari',
    'personalization_life_event_type_weight_loss' => 'Perdita di peso',
    'personalization_life_event_type_wear_glass_or_contact' => 'Iniziato a indossare occhiali o lenti',
    'personalization_life_event_type_broken_bone' => 'Rotto un osso',
    'personalization_life_event_type_removed_braces' => 'Tolto l\'apparecchio',
    'personalization_life_event_type_surgery' => 'Subito un intervento',
    'personalization_life_event_type_dentist' => 'Trattamento odontoiatrico',
    'personalization_life_event_type_new_sport' => 'Iniziato a praticare un nuovo sport',
    'personalization_life_event_type_new_hobby' => 'Iniziato un nuovo hobby',
    'personalization_life_event_type_new_instrument' => 'Iniziato ad apprendere un nuovo strumento',
    'personalization_life_event_type_new_language' => 'Iniziato ad apprendere una nuova lingua',
    'personalization_life_event_type_tattoo_or_piercing' => 'Piercing o tatuaggio',
    'personalization_life_event_type_new_license' => 'Nuova patente',
    'personalization_life_event_type_travel' => 'Viaggio',
    'personalization_life_event_type_achievement_or_award' => 'Premio o riconoscimento',
    'personalization_life_event_type_changed_beliefs' => 'Cambio di credo',
    'personalization_life_event_type_first_word' => 'Prima parola',
    'personalization_life_event_type_first_kiss' => 'Primo bacio',

    'storage_title' => 'Memoria',
    'storage_account_info' => 'Il limite del tuo profilo è :accountLimit MB. Il tuo uso corrente è :currentAccountSize MB (circa :percentUsage%).',
    'storage_upgrade_notice' => 'Effettua l\'upgrade del tuo account per caricare foto e documenti.',
    'storage_description' => 'Qui puoi trovare tutti i documenti e le foto relativi ai tuoi contatti.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Qui puoi trovare tutte le impostazioni per utilizzare le risorse WebDAV per le esportazioni di CardDAV e CalDAV.',
    'dav_copy_help' => 'Copia negli appunti',
    'dav_clipboard_copied' => 'Valore copiato negli appunti',
    'dav_url_base' => 'Url di base per tutte le risorse CardDAV e CalDAV:',
    'dav_connect_help' => 'Puoi collegare i tuoi contatti e/o calendari con questo url di base sul tuo telefono o computer.',
    'dav_connect_help2' => 'Usa il tuo accesso (email) e crea un token API come password per autenticarsi.',
    'dav_url_carddav' => 'Url CardDAV per la risorsa Contatti:',
    'dav_url_caldav_birthdays' => 'Url CalDAV per le risorse di compleanni:',
    'dav_url_caldav_tasks' => 'Url CalDAV per le risorse di task:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Esporta tutti i contatti in un file',
    'dav_caldav_birthdays_export' => 'Esporta tutti i compleanni in un file',
    'dav_caldav_tasks_export' => 'Esporta tutte le attività in un file',

    'archive_title' => 'Archivia tutti i contatti nel tuo profilo',
    'archive_desc' => 'Questo archivierà tutti i contatti nel tuo profilo.',
    'archive_cta' => 'Archivia tutti i tuoi contatti',

    'logs_title' => 'Tutto ciò che è successo a questo profilo',
    'logs_actor' => 'Attore',
    'logs_timestamp' => 'Data e ora',
    'logs_description' => 'Descrizione',
    'logs_subject' => 'Soggetto',
    'logs_size' => 'Dimensione (Kb)',
    'logs_object' => 'Oggetto',
];
