"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    policyService
  } = services;
  router.get({
    path: _constants.NODE_API.POLICIES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string()
      })
    }
  }, policyService.getPolicies);
  router.put({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, policyService.putPolicy);
  router.get({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, policyService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, policyService.deletePolicy);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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