/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SelectedElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLSourceDocument
extends StyleElement {
    private Expression href = null;
    private Set<Accumulator> accumulators = new HashSet<Accumulator>();
    private boolean streaming = true;
    private ParseOptions parseOptions;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isWithinDeclaredStreamableConstruct() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        this.parseOptions = new ParseOptions(this.getConfiguration().getParseOptions());
        AttributeCollection atts = this.getAttributeList();
        String hrefAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String useAccumulatorsAtt = null;
        String streamableAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("href")) {
                hrefAtt = atts.getValue(a);
                this.href = this.makeAttributeValueTemplate(hrefAtt, a);
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-accumulators")) {
                useAccumulatorsAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("streamable")) {
                streamableAtt = atts.getValue(a);
                continue;
            }
            if ("http://saxon.sf.net/".equals(atts.getURI(a))) {
                String local = atts.getLocalName(a);
                if (local.equals("dtd-validation")) {
                    this.parseOptions.setDTDValidationMode(this.processBooleanAttribute(f, atts.getValue(a)) ? 1 : 4);
                    continue;
                }
                if (local.equals("expand-attribute-defaults")) {
                    this.parseOptions.setExpandAttributeDefaults(this.processBooleanAttribute(f, atts.getValue(a)));
                    continue;
                }
                if (local.equals("line-numbering")) {
                    this.parseOptions.setLineNumbering(this.processBooleanAttribute(f, atts.getValue(a)));
                    continue;
                }
                if (local.equals("xinclude")) {
                    this.parseOptions.setXIncludeAware(this.processBooleanAttribute(f, atts.getValue(a)));
                    continue;
                }
                if (local.equals("validation-params")) continue;
                if (local.equals("strip-space")) {
                    String value = Whitespace.normalizeWhitespace(atts.getValue(a)).toString();
                    if (value.equals("#all")) {
                        this.parseOptions.setSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance());
                        continue;
                    }
                    if (value.equals("#none")) {
                        this.parseOptions.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                        continue;
                    }
                    if (!value.equals("#ignorable")) continue;
                    this.parseOptions.setSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
                    continue;
                }
                this.checkUnknownAttribute(atts.getNodeName(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (hrefAtt == null) {
            this.reportAbsence("href");
        }
        if (validationAtt != null) {
            int validation = this.validateValidationAttribute(validationAtt);
            this.parseOptions.setSchemaValidationMode(validation);
        }
        if (typeAtt != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.parseOptions.setSchemaValidationMode(8);
            this.parseOptions.setTopLevelType(this.getSchemaType(typeAtt));
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (this.getLocalPart().equals("stream")) {
            streamableAtt = "yes";
        }
        this.streaming = streamableAtt != null ? this.processStreamableAtt(streamableAtt) : this.getLocalPart().equals("stream");
        if (useAccumulatorsAtt == null) {
            useAccumulatorsAtt = "";
        }
        AccumulatorRegistry registry = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry();
        this.accumulators = registry.getUsedAccumulators(useAccumulatorsAtt, this);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.href = this.typeCheck("select", this.href);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:source-document instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Configuration config = this.getConfiguration();
        this.parseOptions.setSpaceStrippingRule(this.getPackageData().getSpaceStrippingRule());
        this.parseOptions.setApplicableAccumulators(this.accumulators);
        Expression action = this.compileSequenceConstructor(exec, decl, false);
        if (action == null) {
            return Literal.makeEmptySequence();
        }
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            action = action.simplify();
            action = action.typeCheck(visitor, config.makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false));
            if (this.streaming && "EE".equals(this.getCompilation().getCompilerInfo().getTargetEdition())) {
                return config.makeStreamInstruction(this.href, action, this.parseOptions, null, this.allocateLocation(), this.makeRetainedStaticContext());
            }
            HashTrieMap options = new HashTrieMap();
            int validation = this.parseOptions.getSchemaValidationMode();
            if (validation == 0) {
                validation = 4;
            }
            options = options.addEntry(StringValue.makeStringValue("validation"), StringValue.makeStringValue(Validation.toString(validation)));
            if (this.parseOptions.getTopLevelType() != null) {
                options = options.addEntry(StringValue.makeStringValue("type"), new QNameValue(this.parseOptions.getTopLevelType().getStructuredQName(), BuiltInAtomicType.QNAME));
            }
            if (this.parseOptions.getSpaceStrippingRule() != null) {
                SpaceStrippingRule rule = this.parseOptions.getSpaceStrippingRule();
                Object str = null;
                if (rule == AllElementsSpaceStrippingRule.getInstance()) {
                    str = "all";
                } else if (rule == NoElementsSpaceStrippingRule.getInstance()) {
                    str = "none";
                } else if (rule instanceof SelectedElementsSpaceStrippingRule) {
                    str = "package-defined";
                }
                options = options.addEntry(StringValue.makeStringValue("strip-space"), StringValue.makeStringValue((CharSequence)str));
            }
            if (this.accumulators != null) {
                ArrayList<QNameValue> list = new ArrayList<QNameValue>();
                for (Accumulator acc : this.accumulators) {
                    list.add(new QNameValue(acc.getAccumulatorName(), BuiltInAtomicType.QNAME));
                }
                options = options.addEntry(StringValue.makeStringValue("accumulators"), SequenceExtent.makeSequenceExtent(list));
            }
            SystemFunction docFn = VendorFunctionSetHE.getInstance().makeFunction("doc", 2);
            docFn.setRetainedStaticContext(this.makeRetainedStaticContext());
            Expression docCall = docFn.makeFunctionCall(this.href, Literal.makeLiteral(options));
            docCall.setRetainedStaticContext(this.makeRetainedStaticContext());
            docCall.setLocation(this.allocateLocation());
            return new ForEach(docCall, action);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

