/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSearchTerm;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSortPredicate;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionParameterMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionParameterModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionRecordMapper;
import org.apache.guacamole.auth.jdbc.connection.ConnectionRecordModel;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnectionRecord;
import org.apache.guacamole.auth.jdbc.permission.ConnectionPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.protocol.GuacamoleClientInformation;

public class ConnectionService
extends ModeledChildDirectoryObjectService<ModeledConnection, Connection, ConnectionModel> {
    @Inject
    private ConnectionMapper connectionMapper;
    @Inject
    private ConnectionPermissionMapper connectionPermissionMapper;
    @Inject
    private ConnectionParameterMapper parameterMapper;
    @Inject
    private ConnectionRecordMapper connectionRecordMapper;
    @Inject
    private Provider<ModeledConnection> connectionProvider;
    @Inject
    private GuacamoleTunnelService tunnelService;

    @Override
    protected ModeledDirectoryObjectMapper<ConnectionModel> getObjectMapper() {
        return this.connectionMapper;
    }

    @Override
    protected ObjectPermissionMapper getPermissionMapper() {
        return this.connectionPermissionMapper;
    }

    @Override
    protected ModeledConnection getObjectInstance(ModeledAuthenticatedUser currentUser, ConnectionModel model) {
        ModeledConnection connection = this.connectionProvider.get();
        connection.init(currentUser, model);
        return connection;
    }

    @Override
    protected ConnectionModel getModelInstance(ModeledAuthenticatedUser currentUser, Connection object) {
        ConnectionModel model = new ConnectionModel();
        ModeledConnection connection = this.getObjectInstance(currentUser, model);
        connection.setParentIdentifier(object.getParentIdentifier());
        connection.setName(object.getName());
        connection.setConfiguration(object.getConfiguration());
        connection.setAttributes(object.getAttributes());
        return model;
    }

    @Override
    protected boolean hasCreatePermission(ModeledAuthenticatedUser user) throws GuacamoleException {
        SystemPermissionSet permissionSet = user.getUser().getEffectivePermissions().getSystemPermissions();
        return permissionSet.hasPermission(SystemPermission.Type.CREATE_CONNECTION);
    }

    @Override
    protected ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getConnectionPermissions();
    }

    @Override
    protected ObjectPermissionSet getParentEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getConnectionGroupPermissions();
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, Connection object, ConnectionModel model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Connection names must not be blank.");
        }
        ConnectionModel existing = this.connectionMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null) {
            throw new GuacamoleClientException("The connection \"" + model.getName() + "\" already exists.");
        }
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, ModeledConnection object, ConnectionModel model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Connection names must not be blank.");
        }
        ConnectionModel existing = this.connectionMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null && !existing.getObjectID().equals(model.getObjectID())) {
            throw new GuacamoleClientException("The connection \"" + model.getName() + "\" already exists.");
        }
    }

    private Collection<ConnectionParameterModel> getParameterModels(ModeledConnection connection) {
        Map parameters = connection.getConfiguration().getParameters();
        ArrayList<ConnectionParameterModel> parameterModels = new ArrayList<ConnectionParameterModel>(parameters.size());
        for (Map.Entry parameterEntry : parameters.entrySet()) {
            String name = (String)parameterEntry.getKey();
            String value = (String)parameterEntry.getValue();
            if (value == null || value.isEmpty()) continue;
            ConnectionParameterModel model = new ConnectionParameterModel();
            model.setConnectionIdentifier(connection.getIdentifier());
            model.setName(name);
            model.setValue(value);
            parameterModels.add(model);
        }
        return parameterModels;
    }

    @Override
    public ModeledConnection createObject(ModeledAuthenticatedUser user, Connection object) throws GuacamoleException {
        ModeledConnection connection = (ModeledConnection)super.createObject(user, object);
        connection.setConfiguration(object.getConfiguration());
        Collection<ConnectionParameterModel> parameterModels = this.getParameterModels(connection);
        if (!parameterModels.isEmpty()) {
            this.parameterMapper.insert(parameterModels);
        }
        return connection;
    }

    @Override
    public void updateObject(ModeledAuthenticatedUser user, ModeledConnection object) throws GuacamoleException {
        super.updateObject(user, object);
        Collection<ConnectionParameterModel> parameterModels = this.getParameterModels(object);
        this.parameterMapper.delete(object.getIdentifier());
        if (!parameterModels.isEmpty()) {
            this.parameterMapper.insert(parameterModels);
        }
    }

    public Set<String> getIdentifiersWithin(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        if (user.isPrivileged()) {
            return this.connectionMapper.selectIdentifiersWithin(identifier);
        }
        return this.connectionMapper.selectReadableIdentifiersWithin((UserModel)user.getUser().getModel(), identifier, user.getEffectiveUserGroups());
    }

    public Map<String, String> retrieveParameters(ModeledAuthenticatedUser user, String identifier) {
        boolean canRetrieveParameters;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        try {
            canRetrieveParameters = this.hasObjectPermission(user, identifier, ObjectPermission.Type.UPDATE);
        }
        catch (GuacamoleException e) {
            return parameterMap;
        }
        if (canRetrieveParameters) {
            for (ConnectionParameterModel parameter : this.parameterMapper.select(identifier)) {
                parameterMap.put(parameter.getName(), parameter.getValue());
            }
        }
        return parameterMap;
    }

    protected ConnectionRecord getObjectInstance(ConnectionRecordModel model) {
        return new ModeledConnectionRecord(model);
    }

    protected List<ConnectionRecord> getObjectInstances(List<ConnectionRecordModel> models) {
        ArrayList<ConnectionRecord> objects = new ArrayList<ConnectionRecord>(models.size());
        for (ConnectionRecordModel model : models) {
            objects.add(this.getObjectInstance(model));
        }
        return objects;
    }

    public List<ConnectionRecord> retrieveHistory(ModeledAuthenticatedUser user, ModeledConnection connection) throws GuacamoleException {
        String identifier = connection.getIdentifier();
        ArrayList<ConnectionRecord> records = new ArrayList<ConnectionRecord>(this.tunnelService.getActiveConnections(connection));
        Collections.reverse(records);
        records.addAll(this.retrieveHistory(identifier, user, Collections.emptyList(), Collections.emptyList(), Integer.MAX_VALUE));
        return records;
    }

    public List<ConnectionRecord> retrieveHistory(String identifier, ModeledAuthenticatedUser user, Collection<ActivityRecordSearchTerm> requiredContents, List<ActivityRecordSortPredicate> sortPredicates, int limit) throws GuacamoleException {
        List<ConnectionRecordModel> searchResults = user.isPrivileged() ? this.connectionRecordMapper.search(identifier, requiredContents, sortPredicates, limit) : this.connectionRecordMapper.searchReadable(identifier, (UserModel)user.getUser().getModel(), requiredContents, sortPredicates, limit, user.getEffectiveUserGroups());
        return this.getObjectInstances(searchResults);
    }

    public List<ConnectionRecord> retrieveHistory(ModeledAuthenticatedUser user, Collection<ActivityRecordSearchTerm> requiredContents, List<ActivityRecordSortPredicate> sortPredicates, int limit) throws GuacamoleException {
        return this.retrieveHistory(null, user, requiredContents, sortPredicates, limit);
    }

    public GuacamoleTunnel connect(ModeledAuthenticatedUser user, ModeledConnection connection, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        if (this.hasObjectPermission(user, connection.getIdentifier(), ObjectPermission.Type.READ)) {
            return this.tunnelService.getGuacamoleTunnel(user, connection, info, tokens);
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

