/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.explorer.HexDumpModel;
import net.sf.mpxj.mpp.MPPUtility;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class HexDumpController {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final HexDumpModel m_model;

    public HexDumpController(HexDumpModel hexDumpModel) {
        this.m_model = hexDumpModel;
        hexDumpModel.addPropertyChangeListener("columns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HexDumpController.this.updateTables();
            }
        });
        hexDumpModel.addPropertyChangeListener("offset", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HexDumpController.this.updateTables();
            }
        });
        hexDumpModel.addPropertyChangeListener("selectedCell", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HexDumpController.this.updateSelection();
            }
        });
    }

    public void viewDocument(DocumentEntry documentEntry) {
        DocumentInputStream documentInputStream = null;
        try {
            documentInputStream = new DocumentInputStream(documentEntry);
            byte[] byArray = new byte[((InputStream)documentInputStream).available()];
            ((InputStream)documentInputStream).read(byArray);
            this.m_model.setData(byArray);
            this.updateTables();
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                StreamHelper.closeQuietly(documentInputStream);
                throw throwable;
            }
        }
        StreamHelper.closeQuietly(documentInputStream);
    }

    protected void updateTables() {
        byte[] byArray = this.m_model.getData();
        int n = this.m_model.getColumns();
        int n2 = byArray.length / n + 1;
        int n3 = this.m_model.getOffset();
        Object[][] objectArray = new String[n2][n];
        Object[][] objectArray2 = new String[n2][n];
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n3; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuilder.setLength(0);
            stringBuilder.append(HEX_DIGITS[(by & 0xF0) >> 4]);
            stringBuilder.append(HEX_DIGITS[by & 0xF]);
            char c = (char)by;
            if (c > '\u00c8' || c < '\u001b') {
                c = ' ';
            }
            objectArray[n4][n5] = stringBuilder.toString();
            objectArray2[n4][n5] = Character.toString(c);
            if (++n5 != n) continue;
            n5 = 0;
            ++n4;
        }
        Object[] objectArray3 = new String[n];
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray3){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        DefaultTableModel defaultTableModel2 = new DefaultTableModel(objectArray2, objectArray3){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.m_model.setSizeValueLabel(Integer.toString(byArray.length));
        this.m_model.setHexTableModel(defaultTableModel);
        this.m_model.setAsciiTableModel(defaultTableModel2);
        this.m_model.setCurrentSelectionIndex(0);
        this.m_model.setPreviousSelectionIndex(0);
    }

    protected void updateSelection() {
        Comparable<Double> comparable;
        byte[] byArray = this.m_model.getData();
        int n = this.m_model.getOffset();
        Point point = this.m_model.getSelectedCell();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        int n2 = point.y * this.m_model.getColumns() + point.x;
        String string = point.y + "," + point.x;
        String string2 = Integer.toString(Math.abs(this.m_model.getCurrentSelectionIndex() - n2));
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        if (n2 + n + 2 <= byArray.length) {
            Date date;
            string3 = Integer.toString(MPPUtility.getShort(byArray, n2 + n));
            string8 = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n2 + n)).toString();
            comparable = MPPUtility.getPercentage(byArray, n2 + n);
            if (comparable != null) {
                string10 = ((Double)comparable).toString();
            }
            if ((date = MPPUtility.getDate(byArray, n2 + n)) != null) {
                string11 = simpleDateFormat.format(date);
            }
            string12 = simpleDateFormat2.format(MPPUtility.getTime(byArray, n2 + n));
        }
        string14 = MPPUtility.getWorkTimeUnits(MPPUtility.getByte(byArray, n2 + n)).toString();
        if (n2 + n + 4 <= byArray.length && (comparable = MPPUtility.getTimestamp(byArray, n2 + n)) != null) {
            string13 = simpleDateFormat3.format((Date)comparable);
        }
        if (n2 + n + 6 <= byArray.length) {
            string4 = Long.toString(MPPUtility.getLong6(byArray, n2 + n));
        }
        if (n2 + n + 8 <= byArray.length) {
            string5 = Long.toString(MPPUtility.getLong(byArray, n2 + n));
            string6 = Double.toString(MPPUtility.getDouble(byArray, n2 + n));
            string7 = Duration.getInstance(MPPUtility.getDouble(byArray, n2 + n) / 60000.0, TimeUnit.HOURS).toString();
        }
        if (n2 + n + 16 <= byArray.length) {
            string9 = MPPUtility.getGUID(byArray, n2 + n).toString().toUpperCase();
        }
        this.m_model.setPreviousSelectionIndex(this.m_model.getCurrentSelectionIndex());
        this.m_model.setCurrentSelectionIndex(n2);
        this.m_model.setPreviousSelectionValueLabel(this.m_model.getCurrentSelectionValueLabel());
        this.m_model.setCurrentSelectionValueLabel(string);
        this.m_model.setSelectionDifferenceValueLabel(string2);
        this.m_model.setShortValueLabel(string3);
        this.m_model.setLongSixValueLabel(string4);
        this.m_model.setLongValueLabel(string5);
        this.m_model.setDoubleValueLabel(string6);
        this.m_model.setDurationValueLabel(string7);
        this.m_model.setTimeUnitsValueLabel(string8);
        this.m_model.setGuidValueLabel(string9);
        this.m_model.setPercentageValueLabel(string10);
        this.m_model.setDateValueLabel(string11);
        this.m_model.setTimeValueLabel(string12);
        this.m_model.setTimestampValueLabel(string13);
        this.m_model.setWorkUnitsValueLabel(string14);
    }
}

