/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public final class SequenceOutputter
extends SequenceWriter {
    private ArrayList list;
    private Controller controller;

    public SequenceOutputter() {
        this.list = new ArrayList(50);
    }

    public SequenceOutputter(Controller controller, int estimatedSize) {
        this.list = new ArrayList(estimatedSize);
        this.controller = controller;
    }

    public SequenceOutputter(Controller controller) {
        this.list = new ArrayList(50);
        this.controller = controller;
    }

    public void reset() {
        this.list = new ArrayList(Math.max(this.list.size() + 10, 50));
        if (this.controller != null && this.adviseReuse()) {
            this.controller.reuseSequenceOutputter(this);
        }
    }

    public void write(Item item) {
        this.list.add(item);
    }

    public ValueRepresentation getSequence() {
        switch (this.list.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                return (Item)this.list.get(0);
            }
        }
        return new SequenceExtent(this.list);
    }

    public SequenceIterator iterate() {
        if (this.list.isEmpty()) {
            return EmptyIterator.getInstance();
        }
        return new ListIterator(this.list);
    }

    public ArrayList getList() {
        return this.list;
    }

    public Item getFirstItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (Item)this.list.get(0);
    }

    public Item popLastItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (Item)this.list.remove(this.list.size() - 1);
    }
}

