/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER_CIK},
	{501, PKT3_COPY_DATA},
	{511, PKT3_PFP_SYNC_ME},
	{523, PKT3_SURFACE_SYNC},
	{536, PKT3_ME_INITIALIZE},
	{550, PKT3_COND_WRITE},
	{561, PKT3_EVENT_WRITE},
	{573, PKT3_EVENT_WRITE_EOP},
	{589, PKT3_EVENT_WRITE_EOS},
	{605, PKT3_RELEASE_MEM},
	{617, PKT3_CONTEXT_REG_RMW},
	{633, PKT3_ONE_REG_WRITE},
	{647, PKT3_ACQUIRE_MEM},
	{659, PKT3_REWIND},
	{666, PKT3_LOAD_UCONFIG_REG},
	{683, PKT3_LOAD_SH_REG},
	{695, PKT3_LOAD_CONTEXT_REG},
	{712, PKT3_LOAD_SH_REG_INDEX},
	{730, PKT3_SET_CONFIG_REG},
	{745, PKT3_SET_CONTEXT_REG},
	{761, PKT3_SET_SH_REG},
	{772, PKT3_SET_SH_REG_OFFSET},
	{790, PKT3_SET_UCONFIG_REG},
	{806, PKT3_SET_UCONFIG_REG_INDEX},
	{828, PKT3_LOAD_CONST_RAM},
	{843, PKT3_WRITE_CONST_RAM},
	{859, PKT3_DUMP_CONST_RAM},
	{874, PKT3_INCREMENT_CE_COUNTER},
	{895, PKT3_INCREMENT_DE_COUNTER},
	{916, PKT3_WAIT_ON_CE_COUNTER},
	{935, PKT3_SET_SH_REG_INDEX},
	{952, PKT3_LOAD_CONTEXT_REG_INDEX},
	{975, PKT3_IT_OPCODE_C},
	{987, PKT3_CP_DMA},
	{994, PKT3_DMA_DATA},
};

static const struct si_reg gfx10_reg_table[] = {
	{1003, 1028, 10, 0},
	{1016, 1032, 20, 10},
	{1031, 1036, 10, 30},
	{1047, 1040, 12, 40},
	{1068, 1044, 4, 52},
	{1086, 1048, 3, 56},
	{1104, 1052, 11, 59},
	{1119, 1056},
	{1133, 1060, 1, 70},
	{1147, 1064},
	{1164, 1076, 9, 71},
	{1180, 1080},
	{1197, 1116, 5, 80},
	{1212, 1120, 7, 85},
	{1227, 1124, 2, 92},
	{1247, 1128, 1, 94},
	{1266, 1132, 4, 95},
	{1286, 1136, 7, 99},
	{1302, 2480},
	{1316, 2484},
	{1330, 2488},
	{1344, 2492},
	{1358, 2496},
	{1372, 2500},
	{1386, 2504},
	{1400, 2508},
	{1414, 2512},
	{1428, 2516},
	{1442, 2520},
	{1457, 2524},
	{1472, 2528},
	{1487, 2532},
	{1502, 2536},
	{1517, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{1575, 2560},
	{1599, 2564},
	{1623, 2568},
	{1647, 32776, 27, 106},
	{1660, 32784, 21, 133},
	{1672, 32788, 14, 154},
	{1688, 32792, 14, 154},
	{1704, 32796, 15, 168},
	{1717, 32824, 14, 154},
	{1733, 32828, 14, 154},
	{1749, 33296, 21, 183},
	{1763, 33300, 28, 204},
	{1780, 33304, 15, 232},
	{1801, 33308, 28, 247},
	{1815, 33312, 32, 275},
	{1832, 33316, 13, 307},
	{1853, 33320, 9, 320},
	{1871, 33324, 1, 329},
	{1894, 33344, 2, 330},
	{1915, 33348},
	{1935, 33352, 1, 332},
	{1958, 33356, 9, 333},
	{1976, 33436, 1, 342},
	{1999, 36096},
	{2025, 36100, 2, 343},
	{2051, 36104},
	{2077, 36108, 2, 343},
	{2103, 36112, 2, 345},
	{2124, 36116, 4, 347},
	{2145, 36120, 4, 351},
	{2172, 36124, 17, 355},
	{2193, 36128, 6, 372},
	{2216, 36132},
	{2245, 36140},
	{2275, 36144},
	{2307, 36148},
	{2338, 36152},
	{2371, 36348, 5, 378},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 10, 387},
	{2452, 36656, 14, 397},
	{2470, 36660, 4, 411},
	{2488, 36664, 12, 415},
	{2506, 36668, 2, 427},
	{2524, 37120, 9, 429},
	{2540, 39160, 5, 438},
	{2555, 39184, 5, 443},
	{2569, 39188, 5, 443},
	{2583, 39192, 5, 443},
	{2597, 39196, 5, 443},
	{2611, 39200, 5, 443},
	{2625, 39204, 5, 443},
	{2639, 39208, 5, 443},
	{2653, 39212, 5, 443},
	{2667, 39216, 5, 443},
	{2681, 39220, 5, 443},
	{2695, 39224, 5, 443},
	{2710, 39228, 5, 443},
	{2725, 39232, 5, 443},
	{2740, 39236, 5, 443},
	{2755, 39240, 5, 443},
	{2770, 39244, 5, 443},
	{2785, 39248, 5, 443},
	{2800, 39252, 5, 443},
	{2815, 39256, 5, 443},
	{2830, 39260, 5, 443},
	{2845, 39264, 5, 443},
	{2860, 39268, 5, 443},
	{2875, 39272, 5, 443},
	{2890, 39276, 5, 443},
	{2905, 39280, 5, 443},
	{2920, 39284, 5, 443},
	{2935, 39288, 5, 443},
	{2950, 39292, 5, 443},
	{2965, 39296, 5, 443},
	{2980, 39300, 5, 443},
	{2995, 39304, 5, 443},
	{3010, 39308, 5, 443},
	{3025, 39312, 4, 448},
	{3044, 39316, 4, 448},
	{3063, 39320, 4, 448},
	{3082, 39324, 4, 448},
	{3101, 39328, 4, 448},
	{3120, 39332, 4, 448},
	{3139, 39336, 4, 448},
	{3158, 39340, 4, 448},
	{3177, 39344, 4, 448},
	{3196, 39348, 4, 448},
	{3215, 39352, 4, 448},
	{3235, 39356, 4, 448},
	{3255, 39360, 4, 448},
	{3275, 39364, 4, 448},
	{3295, 39368, 4, 448},
	{3315, 39372, 4, 448},
	{3335, 40960},
	{3353, 40964, 4, 452},
	{3371, 40968, 3, 456},
	{3389, 40972, 9, 459},
	{3407, 40976, 2, 468},
	{3425, 40980, 7, 470},
	{3443, 40984, 10, 477},
	{3461, 40988},
	{3479, 45060, 1, 487},
	{3503, 45080},
	{3528, 45084, 3, 488},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 492},
	{3618, 45100, 10, 503},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{4064, 45168},
	{4091, 45172},
	{4118, 45176},
	{4145, 45180},
	{4172, 45184},
	{4199, 45188},
	{4226, 45192},
	{4253, 45196},
	{4280, 45200},
	{4307, 45204},
	{4334, 45208},
	{4361, 45212},
	{4388, 45216},
	{4415, 45220},
	{4442, 45224},
	{4469, 45228},
	{4496, 45248, 8, 513},
	{4519, 45252, 5, 521},
	{4552, 45256, 1, 526},
	{4579, 45260, 1, 526},
	{4606, 45264, 1, 526},
	{4633, 45268, 1, 526},
	{4660, 45316, 1, 487},
	{4684, 45332},
	{4709, 45336, 3, 488},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 528},
	{4824, 45356, 14, 540},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5270, 45424},
	{5297, 45428},
	{5324, 45432},
	{5351, 45436},
	{5378, 45440},
	{5405, 45444},
	{5432, 45448},
	{5459, 45452},
	{5486, 45456},
	{5513, 45460},
	{5540, 45464},
	{5567, 45468},
	{5594, 45472},
	{5621, 45476},
	{5648, 45480},
	{5675, 45484},
	{5702, 45504, 8, 513},
	{5725, 45508, 5, 521},
	{5758, 45512, 1, 526},
	{5785, 45516, 1, 526},
	{5812, 45520, 1, 526},
	{5839, 45524, 1, 526},
	{5866, 45548, 9, 554},
	{5893, 45552, 6, 563},
	{5920, 45556, 5, 569},
	{5947, 45568},
	{5972, 45572, 2, 574},
	{5996, 45576},
	{6028, 45580},
	{6060, 45584},
	{6084, 45588, 1, 491},
	{6108, 45596, 4, 576},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 13, 580},
	{6198, 45612, 9, 593},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{6644, 45680},
	{6671, 45684},
	{6698, 45688},
	{6725, 45692},
	{6752, 45696},
	{6779, 45700},
	{6806, 45704},
	{6833, 45708},
	{6860, 45712},
	{6887, 45716},
	{6914, 45720},
	{6941, 45724},
	{6968, 45728},
	{6995, 45732},
	{7022, 45736},
	{7049, 45740},
	{7076, 45760, 8, 513},
	{7101, 45764, 5, 521},
	{7136, 45768, 1, 526},
	{7165, 45772, 1, 526},
	{7194, 45776, 1, 526},
	{7223, 45780, 1, 526},
	{7252, 45808, 6, 563},
	{7279, 45852, 4, 576},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7345, 45864, 10, 602},
	{7369, 45868, 6, 563},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{7815, 46068, 5, 569},
	{7842, 46080},
	{7867, 46084, 1, 487},
	{7891, 46088},
	{7923, 46092},
	{7955, 46096},
	{7979, 46100, 1, 491},
	{8003, 46108, 4, 612},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 12, 616},
	{8093, 46124, 9, 628},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{8539, 46192},
	{8566, 46196},
	{8593, 46200},
	{8620, 46204},
	{8647, 46208},
	{8674, 46212},
	{8701, 46216},
	{8728, 46220},
	{8755, 46224},
	{8782, 46228},
	{8809, 46232},
	{8836, 46236},
	{8863, 46240},
	{8890, 46244},
	{8917, 46248},
	{8944, 46252},
	{8971, 46272, 8, 513},
	{8996, 46276, 5, 521},
	{9031, 46280, 1, 526},
	{9060, 46284, 1, 526},
	{9089, 46288, 1, 526},
	{9118, 46292, 1, 526},
	{9147, 46324, 5, 569},
	{9174, 46364, 4, 576},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9240, 46376, 9, 637},
	{9264, 46380, 5, 569},
	{9288, 46384},
	{9314, 46388},
	{9340, 46392},
	{9366, 46396},
	{9392, 46400},
	{9418, 46404},
	{9444, 46408},
	{9470, 46412},
	{9496, 46416},
	{9522, 46420},
	{9548, 46424},
	{9575, 46428},
	{9602, 46432},
	{9629, 46436},
	{9656, 46440},
	{9683, 46444},
	{9710, 47104, 13, 646},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 1, 663},
	{9973, 47160},
	{10002, 47164, 1, 663},
	{10031, 47168},
	{10064, 47172, 1, 663},
	{10097, 47176, 12, 664},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 6, 688},
	{10170, 47192},
	{10197, 47196},
	{10224, 47200, 2, 694},
	{10245, 47204},
	{10272, 47208},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 5, 697},
	{10403, 47232},
	{10423, 47236},
	{10446, 47240, 9, 702},
	{10463, 47248, 1, 526},
	{10484, 47252, 1, 526},
	{10505, 47256, 1, 526},
	{10526, 47260, 1, 526},
	{10547, 47264, 1, 711},
	{10565, 47268, 1, 712},
	{10584, 47272},
	{10606, 47276, 3, 713},
	{10623, 47280},
	{10652, 47284, 1, 716},
	{10681, 47288, 3, 713},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{11025, 47604, 2, 717},
	{11049, 47608},
	{11070, 47612},
	{11086, 163840, 10, 719},
	{11104, 163844, 11, 729},
	{11121, 163848, 7, 740},
	{11135, 163852, 23, 747},
	{11154, 163856, 16, 770},
	{11174, 163860},
	{11193, 163868, 2, 786},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{11330, 163896, 3, 793},
	{11346, 163900, 8, 796},
	{11364, 163904, 14, 804},
	{11374, 163908, 9, 818},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{11464, 163928, 2, 827},
	{11482, 163932, 1, 829},
	{11500, 163944, 1, 830},
	{11518, 163948, 1, 830},
	{11542, 163952, 1, 830},
	{11561, 163956, 1, 830},
	{11586, 163960, 1, 830},
	{11608, 163964, 9, 831},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13647, 164692, 3, 890},
	{13669, 164696, 2, 893},
	{13697, 164700, 7, 895},
	{13726, 164704, 1, 902},
	{13747, 164708, 1, 903},
	{13757, 164712, 1, 904},
	{13765, 164768, 4, 905},
	{13787, 164772, 4, 905},
	{13808, 164776, 4, 909},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13904, 164880, 10, 913},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{13986, 164900, 8, 923},
	{14001, 164904, 4, 931},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16507, 165404},
	{16530, 165444, 12, 949},
	{16550, 165448, 12, 949},
	{16570, 165452, 12, 949},
	{16590, 165456, 12, 949},
	{16610, 165460, 12, 949},
	{16630, 165464, 12, 949},
	{16650, 165468, 12, 949},
	{16670, 165472, 12, 949},
	{16690, 165476, 12, 949},
	{16710, 165480, 12, 949},
	{16730, 165484, 12, 949},
	{16751, 165488, 12, 949},
	{16772, 165492, 12, 949},
	{16793, 165496, 12, 949},
	{16814, 165500, 12, 949},
	{16835, 165504, 12, 949},
	{16856, 165508, 12, 949},
	{16877, 165512, 12, 949},
	{16898, 165516, 12, 949},
	{16919, 165520, 12, 949},
	{16940, 165524, 9, 961},
	{16961, 165528, 9, 961},
	{16982, 165532, 9, 961},
	{17003, 165536, 9, 961},
	{17024, 165540, 9, 961},
	{17045, 165544, 9, 961},
	{17066, 165548, 9, 961},
	{17087, 165552, 9, 961},
	{17108, 165556, 9, 961},
	{17129, 165560, 9, 961},
	{17150, 165564, 9, 961},
	{17171, 165568, 9, 961},
	{17192, 165572, 3, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 6, 996},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17316, 165640, 1, 1009},
	{17338, 165644, 5, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17402, 165716, 8, 1024},
	{17420, 165720, 8, 1032},
	{17441, 165724, 17, 1040},
	{17462, 165728, 6, 1057},
	{17480, 165732, 6, 1057},
	{17498, 165736, 6, 1057},
	{17516, 165740, 6, 1057},
	{17534, 165744, 6, 1057},
	{17552, 165748, 6, 1057},
	{17570, 165752, 6, 1057},
	{17588, 165756, 6, 1057},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 1073},
	{17869, 165864},
	{17882, 165872, 8, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17938, 165884, 1, 1083},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 4, 1106},
	{18007, 165900, 17, 1110},
	{18025, 165904, 20, 1127},
	{18041, 165908, 16, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 28, 1173},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18183, 165936, 7, 1232},
	{18212, 165940, 2, 1239},
	{18234, 165944, 2, 1241},
	{18249, 165948, 5, 1243},
	{18279, 165952, 5, 1248},
	{18294, 165956},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 1265},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 1285},
	{18647, 166468, 3, 1300},
	{18666, 166472, 7, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 1338},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 8, 1343},
	{18906, 166528},
	{18917, 166532, 3, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 1354},
	{19000, 166548, 2, 1357},
	{19027, 166552, 5, 1359},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 6, 1364},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 9, 1373},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19731, 166732, 2, 1397},
	{19750, 166736, 5, 1399},
	{19772, 166740, 19, 1404},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 12, 1426},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 3, 1446},
	{20148, 166804, 8, 1449},
	{20167, 166808, 4, 1457},
	{20193, 166812, 3, 1354},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 5, 1477},
	{20285, 166880, 6, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21000, 166976, 4, 1527},
	{21021, 166980, 12, 1531},
	{21041, 166984, 2, 1543},
	{21061, 166988, 20, 1545},
	{21099, 166992, 2, 1565},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 3, 1572},
	{21230, 167024, 19, 1575},
	{21245, 167028, 8, 1594},
	{21262, 167032, 12, 1602},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21404, 167060},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 3, 1572},
	{21485, 167084, 19, 1575},
	{21500, 167088, 8, 1594},
	{21517, 167092, 12, 1602},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21659, 167120},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 3, 1572},
	{21740, 167144, 19, 1575},
	{21755, 167148, 8, 1594},
	{21772, 167152, 12, 1602},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21914, 167180},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 3, 1572},
	{21995, 167204, 19, 1575},
	{22010, 167208, 8, 1594},
	{22027, 167212, 12, 1602},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22169, 167240},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 3, 1572},
	{22250, 167264, 19, 1575},
	{22265, 167268, 8, 1594},
	{22282, 167272, 12, 1602},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22424, 167300},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 3, 1572},
	{22505, 167324, 19, 1575},
	{22520, 167328, 8, 1594},
	{22537, 167332, 12, 1602},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22679, 167360},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 3, 1572},
	{22760, 167384, 19, 1575},
	{22775, 167388, 8, 1594},
	{22792, 167392, 12, 1602},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22934, 167420},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 3, 1572},
	{23015, 167444, 19, 1575},
	{23030, 167448, 8, 1594},
	{23047, 167452, 12, 1602},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{23189, 167480},
	{23208, 167488, 1, 1615},
	{23227, 167492, 1, 1615},
	{23246, 167496, 1, 1615},
	{23265, 167500, 1, 1615},
	{23284, 167504, 1, 1615},
	{23303, 167508, 1, 1615},
	{23322, 167512, 1, 1615},
	{23341, 167516, 1, 1615},
	{23360, 167520, 1, 1615},
	{23385, 167524, 1, 1615},
	{23410, 167528, 1, 1615},
	{23435, 167532, 1, 1615},
	{23460, 167536, 1, 1615},
	{23485, 167540, 1, 1615},
	{23510, 167544, 1, 1615},
	{23535, 167548, 1, 1615},
	{23560, 167552, 1, 1615},
	{23585, 167556, 1, 1615},
	{23610, 167560, 1, 1615},
	{23635, 167564, 1, 1615},
	{23660, 167568, 1, 1615},
	{23685, 167572, 1, 1615},
	{23710, 167576, 1, 1615},
	{23735, 167580, 1, 1615},
	{23760, 167584, 1, 1615},
	{23783, 167588, 1, 1615},
	{23806, 167592, 1, 1615},
	{23829, 167596, 1, 1615},
	{23852, 167600, 1, 1615},
	{23875, 167604, 1, 1615},
	{23898, 167608, 1, 1615},
	{23921, 167612, 1, 1615},
	{23944, 167616, 3, 1616},
	{23962, 167620, 3, 1616},
	{23980, 167624, 3, 1616},
	{23998, 167628, 3, 1616},
	{24016, 167632, 3, 1616},
	{24034, 167636, 3, 1616},
	{24052, 167640, 3, 1616},
	{24070, 167644, 3, 1616},
	{24088, 167648, 8, 1619},
	{24106, 167652, 8, 1619},
	{24124, 167656, 8, 1619},
	{24142, 167660, 8, 1619},
	{24160, 167664, 8, 1619},
	{24178, 167668, 8, 1619},
	{24196, 167672, 8, 1619},
	{24214, 167676, 8, 1619},
	{24232, 196608, 1, 1627},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 1, 1629},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 1, 1631},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25474, 196808, 1, 1633},
	{25495, 196812, 1, 1633},
	{25518, 196816, 1, 1633},
	{25534, 196852, 1, 1634},
	{25556, 196856, 1, 1634},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{25698, 196896, 1, 1633},
	{25721, 196908, 1, 663},
	{25740, 196912},
	{25758, 196916},
	{25785, 196920},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 4, 1639},
	{26032, 196968},
	{26047, 196972},
	{26071, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 1, 1643},
	{26247, 197032, 2, 1644},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 1, 1646},
	{26319, 197048, 2, 1647},
	{26337, 197052},
	{26355, 197056, 2, 1649},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 1649},
	{26437, 197080, 5, 1651},
	{26457, 197084, 7, 1656},
	{26476, 197088, 7, 1656},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 13, 1665},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 2, 1678},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 7, 1682},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 7, 1682},
	{26795, 197160, 7, 1689},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 4, 1700},
	{26879, 197180, 2, 1704},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26925, 197192, 1, 1707},
	{26939, 197196, 1, 1708},
	{26953, 197200, 1, 1709},
	{26975, 197204, 1, 1710},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{27085, 197232, 2, 1713},
	{27107, 197236, 2, 1715},
	{27129, 197240, 2, 1713},
	{27152, 197244, 2, 1715},
	{27175, 197248, 2, 1713},
	{27197, 197252, 2, 1715},
	{27219, 197364, 1, 1717},
	{27240, 197368, 1, 1718},
	{27260, 197372, 1, 1719},
	{27280, 197376, 1, 1718},
	{27297, 197380, 1, 1719},
	{27314, 197384, 1, 1720},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 1733},
	{27638, 197464, 3, 1737},
	{27660, 197468, 1, 1740},
	{27680, 197472, 1, 1741},
	{27694, 197476, 1, 1742},
	{27708, 197480, 1, 1743},
	{27720, 197484, 1, 1744},
	{27736, 197488, 1, 1741},
	{27753, 197492, 1, 1742},
	{27770, 197496, 1, 1743},
	{27785, 197500, 1, 1744},
	{27804, 197552, 1, 1745},
	{27829, 197556, 1, 1745},
	{27853, 197560, 1, 1746},
	{27873, 197568},
	{27899, 197572, 1, 1628},
	{27928, 197576},
	{27953, 197580, 1, 1628},
	{27981, 197584},
	{28004, 197588, 1, 1628},
	{28030, 197592},
	{28052, 197596, 1, 1628},
	{28077, 197600},
	{28096, 197604, 1, 1628},
	{28118, 197608, 1, 1343},
	{28132, 197612},
	{28149, 197616, 1, 1628},
	{28169, 197620, 8, 1747},
	{28186, 197624, 13, 1755},
	{28203, 197628},
	{28220, 197632, 1, 1698},
	{28240, 197636},
	{28257, 197640, 1, 1663},
	{28277, 197644, 2, 1768},
	{28296, 197888, 8, 1770},
	{28317, 197892, 8, 1770},
	{28338, 198656, 6, 1778},
	{28353, 198912},
	{28372, 198916},
	{28391, 198920, 1, 1784},
	{28410, 198924, 1, 1343},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{28557, 198948},
	{28573, 198952},
	{28588, 198956, 2, 1357},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 1786},
	{28686, 198976},
	{28705, 198980},
	{28724, 198984},
	{28740, 198988, 1, 830},
	{28759, 198992},
	{28779, 198996, 1, 830},
	{28802, 199000},
	{28820, 199004, 1, 830},
	{28841, 199008, 9, 1788},
	{28866, 199012},
	{28882, 199016},
	{28903, 199020, 4, 1797},
	{28911, 199024},
	{28925, 199028},
	{28939, 199032},
	{28953, 199036, 3, 1801},
	{28968, 199040, 2, 1804},
	{28980, 199044, 1, 830},
	{29002, 199048, 3, 1806},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29676, 199952},
	{29703, 199956},
	{29730, 199960},
	{29757, 199964},
	{29784, 199968, 7, 1819},
	{29795, 199972, 2, 1826},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 1829},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 10, 1847},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 1861},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{30609, 200960},
	{30631, 200964},
	{30655, 200968},
	{30679, 200972},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{30945, 213040},
	{30968, 213044},
	{30991, 213048},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{31290, 213504},
	{31309, 213508},
	{31328, 213512},
	{31347, 213516},
	{31366, 213520},
	{31385, 213524},
	{31404, 213528},
	{31423, 213532},
	{31442, 213536},
	{31461, 213540},
	{31480, 213544},
	{31499, 213548},
	{31518, 213552},
	{31537, 213556},
	{31556, 213560},
	{31575, 213564},
	{31594, 213568},
	{31613, 213572},
	{31632, 213576},
	{31651, 213580},
	{31670, 213584},
	{31690, 213588},
	{31710, 213592},
	{31730, 213596},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33290, 215424},
	{33311, 215428},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{33804, 216576},
	{33825, 216580},
	{33846, 216584},
	{33867, 216588},
	{33888, 216592},
	{33909, 216596},
	{33930, 216600},
	{33951, 216604},
	{33972, 216640},
	{33993, 216644},
	{34014, 216648},
	{34035, 216652},
	{34056, 216656},
	{34077, 216660},
	{34098, 216664},
	{34119, 216668},
	{34140, 216704},
	{34161, 216708},
	{34182, 216712},
	{34203, 216716},
	{34224, 216720},
	{34245, 216724},
	{34266, 216728},
	{34287, 216732},
	{34308, 216832},
	{34328, 216836},
	{34348, 216840},
	{34368, 216844},
	{34388, 216848},
	{34408, 216852},
	{34428, 216856},
	{34448, 216860},
	{34468, 216864},
	{34489, 216868},
	{34510, 216872},
	{34531, 216876},
	{34552, 216880},
	{34573, 216884},
	{34594, 216888},
	{34615, 216892},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{35020, 217856},
	{35040, 217860},
	{35060, 217864},
	{35080, 217868},
	{35100, 217872},
	{35120, 217876},
	{35140, 217880},
	{35160, 217884},
	{35180, 217984},
	{35205, 217988, 2, 1870},
	{35230, 218016},
	{35256, 218020, 2, 1870},
	{35282, 218080},
	{35307, 218084},
	{35332, 218088},
	{35357, 218092},
	{35382, 218096},
	{35408, 218100},
	{35434, 218224},
	{35456, 218228},
	{35478, 218232},
	{35500, 218236},
	{35522, 218240},
	{35542, 218244},
	{35562, 218248},
	{35582, 218252},
	{35602, 218624},
	{35624, 218628},
	{35646, 218632},
	{35668, 218636},
	{35690, 218640},
	{35712, 218644},
	{35734, 218648},
	{35756, 218652},
	{35778, 218656},
	{35800, 218660},
	{35822, 218664},
	{35844, 218668},
	{35866, 218672},
	{35888, 218676},
	{35910, 218680},
	{35932, 218684},
	{35954, 218880},
	{35975, 218884},
	{35996, 218888},
	{36017, 218892},
	{36038, 218896},
	{36059, 218900},
	{36080, 218904},
	{36101, 218908},
	{36122, 219136},
	{36142, 219140},
	{36162, 219144},
	{36182, 219148},
	{36202, 219152},
	{36222, 219156},
	{36242, 219160},
	{36262, 219164},
	{36282, 219392},
	{36302, 219396},
	{36322, 221184, 5, 1872},
	{36346, 221188, 4, 1877},
	{36371, 221192, 5, 1872},
	{36395, 221196, 5, 1872},
	{36419, 221200, 4, 1877},
	{36444, 221204, 5, 1872},
	{36468, 221208, 4, 1877},
	{36493, 221212, 5, 1872},
	{36517, 221216, 4, 1881},
	{36533, 221220, 5, 1872},
	{36557, 221224, 3, 1885},
	{36591, 221228, 3, 1888},
	{36625, 221232, 3, 1891},
	{36650, 221236, 3, 1894},
	{36675, 221240, 3, 1891},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 20, 1903},
	{36842, 221444, 20, 1903},
	{36867, 221448, 15, 1923},
	{36895, 221452, 15, 1923},
	{36923, 221456, 15, 1923},
	{36951, 221460, 15, 1923},
	{36979, 221492, 8, 1938},
	{37007, 221496, 8, 1938},
	{37035, 221696, 5, 1946},
	{37058, 221700, 4, 1951},
	{37082, 221704, 5, 1946},
	{37105, 221708, 4, 1951},
	{37129, 221712, 5, 1946},
	{37152, 221716, 4, 1951},
	{37176, 221720, 5, 1946},
	{37199, 221724, 4, 1951},
	{37223, 221728, 2, 1955},
	{37246, 221736, 2, 1955},
	{37269, 221744, 2, 1955},
	{37292, 221752, 2, 1955},
	{37315, 221760, 2, 1955},
	{37338, 221768, 2, 1955},
	{37361, 221776, 2, 1955},
	{37385, 221784, 2, 1955},
	{37409, 222208, 5, 1957},
	{37435, 222212, 4, 1962},
	{37462, 222216, 5, 1957},
	{37488, 222220, 4, 1962},
	{37515, 222224, 5, 1957},
	{37541, 222228, 4, 1962},
	{37568, 222232, 5, 1957},
	{37594, 222236, 4, 1962},
	{37621, 222464, 5, 1957},
	{37647, 222468, 4, 1962},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 5, 1957},
	{37880, 222724, 5, 1957},
	{37904, 222728, 5, 1957},
	{37928, 222732, 5, 1957},
	{37952, 222736, 4, 1962},
	{37977, 222740, 4, 1962},
	{38002, 222744, 4, 1962},
	{38027, 222748, 4, 1962},
	{38052, 222752, 1, 1872},
	{38076, 222756, 1, 1872},
	{38100, 222760, 8, 1966},
	{38121, 222976, 4, 1974},
	{38144, 222980, 4, 1974},
	{38167, 222984, 4, 1974},
	{38190, 222988, 4, 1974},
	{38213, 222992, 4, 1974},
	{38236, 222996, 4, 1974},
	{38259, 223000, 4, 1974},
	{38282, 223004, 4, 1974},
	{38305, 223008, 4, 1974},
	{38328, 223012, 4, 1974},
	{38351, 223016, 4, 1974},
	{38375, 223020, 4, 1974},
	{38399, 223024, 4, 1974},
	{38423, 223028, 4, 1974},
	{38447, 223032, 4, 1974},
	{38471, 223036, 4, 1974},
	{38495, 223104, 9, 1978},
	{38515, 223112, 1, 1987},
	{38536, 223232, 5, 1957},
	{38561, 223236, 4, 1962},
	{38587, 223240, 8, 1988},
	{38610, 223488, 3, 1996},
	{38633, 223492, 3, 1996},
	{38656, 223496, 3, 1996},
	{38679, 223500, 3, 1996},
	{38702, 223504, 2, 1999},
	{38726, 223508, 2, 1999},
	{38750, 223744, 5, 1957},
	{38774, 223748, 5, 1957},
	{38798, 223752, 5, 1957},
	{38822, 223756, 5, 1957},
	{38846, 223760, 4, 1962},
	{38871, 224000, 5, 2001},
	{38894, 224004, 4, 2006},
	{38918, 224008, 3, 2010},
	{38941, 224256, 5, 2001},
	{38964, 224260, 4, 2006},
	{38988, 224264, 3, 2010},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{39157, 224768, 5, 1957},
	{39182, 224772, 4, 1951},
	{39208, 224776, 5, 1957},
	{39233, 224780, 4, 1951},
	{39259, 224784, 3, 2013},
	{39284, 224788, 3, 2013},
	{39309, 224832, 5, 1957},
	{39334, 224836, 4, 1951},
	{39360, 224840, 5, 1957},
	{39385, 224844, 4, 1951},
	{39411, 224848, 3, 2013},
	{39436, 224852, 3, 2013},
	{39461, 224896, 5, 1957},
	{39486, 224900, 4, 1951},
	{39512, 224904, 3, 2013},
	{39537, 224908, 3, 2013},
	{39562, 224912, 3, 2013},
	{39587, 225024, 5, 1957},
	{39611, 225028, 4, 1951},
	{39636, 225032, 3, 2013},
	{39660, 225036, 3, 2013},
	{39684, 225040, 3, 2013},
	{39708, 225048, 5, 1957},
	{39733, 225052, 4, 1951},
	{39759, 225056, 3, 2013},
	{39784, 225060, 3, 2013},
	{39809, 225064, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40246, 225812},
	{40265, 225816, 2, 2052},
	{40291, 225820, 2, 2054},
	{40314, 225824},
	{40337, 225828, 2, 2056},
	{40364, 225832},
	{40391, 225836, 2, 2058},
	{40416, 225840, 2, 2060},
	{40444, 225844, 2, 2062},
	{40472, 225848, 2, 2064},
	{40495, 225852, 2, 2066},
	{40518, 225856},
	{40551, 225860, 2, 2068},
	{40584, 225864},
	{40616, 225868, 2, 2068},
	{40648, 225872, 2, 2070},
	{40667, 225876, 2, 2072},
	{40694, 225880},
	{40721, 225884, 2, 2074},
	{40748, 225888, 2, 2076},
	{40775, 225892, 10, 2078},
	{40796, 225896, 8, 2088},
	{40815, 225900, 8, 2096},
	{40834, 225904, 2, 2104},
	{40858, 225908, 2, 2106},
	{40890, 225912, 2, 2108},
	{40920, 225916, 4, 2110},
	{40956, 225920, 3, 2114},
	{40989, 225924, 1, 2117},
	{41007, 225932, 1, 2118},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{41092, 226060, 4, 2122},
	{41118, 226064, 3, 2126},
	{41147, 226068, 1, 687},
	{41176, 226072, 3, 2126},
	{41205, 226076, 1, 687},
	{41234, 226192, 1, 2129},
	{41255, 226196, 1, 2129},
	{41282, 226304, 5, 2028},
	{41306, 226308, 4, 2033},
	{41331, 226312, 2, 2037},
	{41355, 226316, 5, 2028},
	{41379, 226320, 4, 2033},
	{41404, 226324, 2, 2037},
	{41428, 226328, 10, 2130},
	{41450, 226432, 5, 2140},
	{41477, 226436, 5, 2140},
	{41504, 226440, 6, 2145},
	{41536, 226480, 5, 2140},
	{41564, 226484, 5, 2140},
	{41592, 226488, 5, 2140},
	{41620, 226492, 5, 2140},
	{41648, 226496, 5, 2140},
	{41676, 226500, 5, 2140},
	{41704, 226504, 5, 2140},
	{41732, 226508, 5, 2140},
	{41760, 226512, 6, 2145},
	{41793, 226544, 5, 1957},
	{41822, 226548, 5, 1957},
	{41851, 226552, 4, 1962},
	{41881, 226556, 4, 1962},
	{41911, 226560, 8, 1988},
	{41938, 226564, 8, 1988},
	{41965, 226608, 5, 1957},
	{41995, 226612, 4, 1962},
	{42026, 226616, 8, 1988},
	{42054, 226688, 5, 2028},
	{42078, 226692, 4, 2033},
	{42103, 226696, 3, 2151},
	{42127, 226700, 2, 2154},
	{42153, 226704, 2, 2154},
	{42179, 226816, 5, 1957},
	{42205, 226820, 4, 1962},
	{42232, 226824, 5, 1957},
	{42258, 226828, 5, 1957},
	{42284, 226832, 5, 1957},
	{42310, 226836, 1, 1872},
	{42336, 226840, 1, 1872},
	{42362, 226844, 1, 1872},
	{42388, 226848, 1, 1872},
	{42414, 226880, 4, 1962},
	{42441, 226884, 4, 1962},
	{42468, 226888, 4, 1962},
	{42495, 227072, 5, 1957},
	{42520, 227076, 4, 1951},
	{42546, 227080, 3, 2013},
	{42571, 227084, 3, 2013},
	{42596, 227088, 3, 2013},
	{42621, 227200, 5, 1957},
	{42645, 227204, 4, 1951},
	{42670, 227208, 3, 2013},
	{42694, 227212, 3, 2013},
	{42718, 227216, 3, 2013},
	{42742, 227328, 5, 1957},
	{42766, 227332, 4, 1962},
	{42791, 227336, 8, 1988},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 2164},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 7, 2170},
	{42899, 1168, 12, 2177},
	{42914, 1280, 6, 2189},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
	{42941, 1414, 15, 2195},
};

static const struct si_reg gfx103_reg_table[] = {
	{42950, 40, 1, 2210},
	{42965, 44, 1, 2210},
	{1003, 1028, 8, 0},
	{1016, 1032, 20, 10},
	{1031, 1036, 10, 2211},
	{1047, 1040, 12, 40},
	{1068, 1044, 4, 52},
	{1086, 1048, 3, 56},
	{1104, 1052, 8, 2221},
	{1119, 1056},
	{1133, 1060, 1, 70},
	{1147, 1064},
	{1164, 1076, 2, 78},
	{1180, 1080},
	{1575, 1104},
	{1599, 1108},
	{1197, 1116, 5, 80},
	{1212, 1120, 6, 85},
	{1227, 1124, 2, 92},
	{1247, 1128, 1, 94},
	{1266, 1132, 4, 95},
	{1286, 1136, 5, 99},
	{42988, 1140, 1, 2229},
	{1302, 2480},
	{1316, 2484},
	{1330, 2488},
	{1344, 2492},
	{1358, 2496},
	{1372, 2500},
	{1386, 2504},
	{1400, 2508},
	{1414, 2512},
	{1428, 2516},
	{1442, 2520},
	{1457, 2524},
	{1472, 2528},
	{1487, 2532},
	{1502, 2536},
	{1517, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{1647, 32776, 29, 2230},
	{1660, 32784, 20, 2259},
	{1672, 32788, 14, 154},
	{1688, 32792, 14, 154},
	{1704, 32796, 15, 168},
	{1717, 32824, 14, 154},
	{1733, 32828, 14, 154},
	{1749, 33296, 21, 183},
	{1763, 33300, 28, 204},
	{1780, 33304, 15, 232},
	{1801, 33308, 28, 247},
	{1815, 33312, 32, 275},
	{1832, 33316, 13, 307},
	{1853, 33320, 9, 320},
	{1871, 33324, 1, 329},
	{43010, 33328, 1, 2279},
	{1894, 33344, 2, 330},
	{1915, 33348},
	{1935, 33352, 1, 332},
	{1958, 33356, 9, 333},
	{1976, 33436, 1, 342},
	{1999, 36096},
	{2025, 36100, 2, 343},
	{2051, 36104},
	{2077, 36108, 2, 343},
	{2103, 36112, 2, 345},
	{2124, 36116, 4, 347},
	{2145, 36120, 6, 2280},
	{2172, 36124, 20, 2286},
	{2193, 36128, 7, 2306},
	{2216, 36132},
	{2245, 36140},
	{2275, 36144},
	{2307, 36148},
	{2338, 36152},
	{43037, 36156, 3, 2313},
	{2371, 36348, 5, 378},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 11, 2316},
	{2452, 36656, 14, 397},
	{2470, 36660, 4, 411},
	{2488, 36664, 12, 415},
	{2506, 36668, 2, 427},
	{2524, 37168, 9, 2327},
	{2540, 39160, 6, 2336},
	{3335, 40960},
	{3353, 40964, 4, 452},
	{3371, 40968, 3, 456},
	{3389, 40972, 9, 459},
	{3407, 40976, 3, 2342},
	{3425, 40980, 8, 2345},
	{3443, 40984, 11, 2353},
	{3461, 40988},
	{3479, 45060, 1, 487},
	{3503, 45080},
	{3528, 45084, 3, 488},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 12, 2364},
	{3618, 45100, 10, 503},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{4064, 45168},
	{4091, 45172},
	{4118, 45176},
	{4145, 45180},
	{4172, 45184},
	{4199, 45188},
	{4226, 45192},
	{4253, 45196},
	{4280, 45200},
	{4307, 45204},
	{4334, 45208},
	{4361, 45212},
	{4388, 45216},
	{4415, 45220},
	{4442, 45224},
	{4469, 45228},
	{4496, 45248, 8, 513},
	{4552, 45256, 1, 526},
	{4579, 45260, 1, 526},
	{4606, 45264, 1, 526},
	{4633, 45268, 1, 526},
	{4660, 45316, 1, 487},
	{4684, 45332},
	{4709, 45336, 3, 488},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 528},
	{4824, 45356, 14, 540},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5270, 45424},
	{5297, 45428},
	{5324, 45432},
	{5351, 45436},
	{5378, 45440},
	{5405, 45444},
	{5432, 45448},
	{5459, 45452},
	{5486, 45456},
	{5513, 45460},
	{5540, 45464},
	{5567, 45468},
	{5594, 45472},
	{5621, 45476},
	{5648, 45480},
	{5675, 45484},
	{5702, 45504, 8, 513},
	{5758, 45512, 1, 526},
	{5785, 45516, 1, 526},
	{5812, 45520, 1, 526},
	{5839, 45524, 1, 526},
	{5866, 45548, 9, 554},
	{5947, 45568},
	{5972, 45572, 2, 574},
	{5996, 45576},
	{6028, 45580},
	{6060, 45584},
	{6084, 45588, 1, 491},
	{6108, 45596, 4, 576},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 13, 580},
	{6198, 45612, 9, 593},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{6644, 45680},
	{6671, 45684},
	{6698, 45688},
	{6725, 45692},
	{6752, 45696},
	{6779, 45700},
	{6806, 45704},
	{6833, 45708},
	{6860, 45712},
	{6887, 45716},
	{6914, 45720},
	{6941, 45724},
	{6968, 45728},
	{6995, 45732},
	{7022, 45736},
	{7049, 45740},
	{7076, 45760, 8, 513},
	{7136, 45768, 1, 526},
	{7165, 45772, 1, 526},
	{7194, 45776, 1, 526},
	{7223, 45780, 1, 526},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7842, 46080},
	{7867, 46084, 1, 487},
	{7891, 46088},
	{7923, 46092},
	{7955, 46096},
	{7979, 46100, 1, 491},
	{8003, 46108, 4, 612},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 12, 616},
	{8093, 46124, 9, 628},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{8539, 46192},
	{8566, 46196},
	{8593, 46200},
	{8620, 46204},
	{8647, 46208},
	{8674, 46212},
	{8701, 46216},
	{8728, 46220},
	{8755, 46224},
	{8782, 46228},
	{8809, 46232},
	{8836, 46236},
	{8863, 46240},
	{8890, 46244},
	{8917, 46248},
	{8944, 46252},
	{8971, 46272, 8, 513},
	{9031, 46280, 1, 526},
	{9060, 46284, 1, 526},
	{9089, 46288, 1, 526},
	{9118, 46292, 1, 526},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9710, 47104, 13, 646},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 1, 663},
	{9973, 47160},
	{10002, 47164, 1, 663},
	{10031, 47168},
	{10064, 47172, 1, 663},
	{10097, 47176, 12, 664},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 6, 688},
	{10170, 47192},
	{10197, 47196},
	{10224, 47200, 2, 694},
	{10245, 47204},
	{10272, 47208},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 5, 697},
	{10403, 47232},
	{10423, 47236},
	{10446, 47240, 9, 702},
	{10463, 47248, 1, 526},
	{10484, 47252, 1, 526},
	{10505, 47256, 1, 526},
	{10526, 47260, 1, 526},
	{10547, 47264, 1, 711},
	{10565, 47268, 1, 712},
	{10584, 47272},
	{10606, 47276, 3, 713},
	{10623, 47280},
	{10652, 47284, 1, 716},
	{10681, 47288, 3, 713},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{11025, 47604, 2, 717},
	{11049, 47608},
	{11070, 47612},
	{43061, 47616},
	{43078, 47620},
	{11086, 163840, 11, 2376},
	{11104, 163844, 11, 729},
	{11121, 163848, 7, 740},
	{11135, 163852, 23, 747},
	{11154, 163856, 18, 2387},
	{11174, 163860},
	{11193, 163868, 2, 786},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{11330, 163896, 3, 793},
	{11346, 163900, 8, 796},
	{11364, 163904, 14, 804},
	{11374, 163908, 9, 818},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{11464, 163928, 2, 827},
	{11482, 163932, 1, 829},
	{43095, 163940, 3, 2405},
	{11500, 163944, 1, 830},
	{11518, 163948, 1, 830},
	{11542, 163952, 1, 830},
	{11561, 163956, 1, 830},
	{11586, 163960, 1, 830},
	{11608, 163964, 13, 2408},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13647, 164692, 3, 890},
	{13669, 164696, 2, 893},
	{13697, 164700, 6, 2421},
	{13726, 164704, 1, 902},
	{13747, 164708, 1, 903},
	{13757, 164712, 1, 904},
	{43116, 164716},
	{43138, 164720},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13904, 164880, 14, 2427},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{13986, 164900, 8, 923},
	{14001, 164904, 4, 931},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16507, 165404},
	{16530, 165444, 13, 2441},
	{16550, 165448, 13, 2441},
	{16570, 165452, 13, 2441},
	{16590, 165456, 13, 2441},
	{16610, 165460, 13, 2441},
	{16630, 165464, 13, 2441},
	{16650, 165468, 13, 2441},
	{16670, 165472, 13, 2441},
	{16690, 165476, 13, 2441},
	{16710, 165480, 13, 2441},
	{16730, 165484, 13, 2441},
	{16751, 165488, 13, 2441},
	{16772, 165492, 13, 2441},
	{16793, 165496, 13, 2441},
	{16814, 165500, 13, 2441},
	{16835, 165504, 13, 2441},
	{16856, 165508, 13, 2441},
	{16877, 165512, 13, 2441},
	{16898, 165516, 13, 2441},
	{16919, 165520, 13, 2441},
	{16940, 165524, 10, 2454},
	{16961, 165528, 10, 2454},
	{16982, 165532, 10, 2454},
	{17003, 165536, 10, 2454},
	{17024, 165540, 10, 2454},
	{17045, 165544, 10, 2454},
	{17066, 165548, 10, 2454},
	{17087, 165552, 10, 2454},
	{17108, 165556, 10, 2454},
	{17129, 165560, 10, 2454},
	{17150, 165564, 10, 2454},
	{17171, 165568, 10, 2454},
	{17192, 165572, 4, 2464},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 6, 2468},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17316, 165640, 1, 1009},
	{17338, 165644, 5, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{43160, 165712, 8, 2474},
	{17402, 165716, 8, 2482},
	{17420, 165720, 8, 1032},
	{17441, 165724, 17, 1040},
	{17462, 165728, 6, 1057},
	{17480, 165732, 6, 1057},
	{17498, 165736, 6, 1057},
	{17516, 165740, 6, 1057},
	{17534, 165744, 6, 1057},
	{17552, 165748, 6, 1057},
	{17570, 165752, 6, 1057},
	{17588, 165756, 6, 1057},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 1073},
	{17869, 165864},
	{17882, 165872, 6, 2490},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17938, 165884, 1, 1083},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 5, 2496},
	{18007, 165900, 17, 1110},
	{18025, 165904, 20, 1127},
	{18041, 165908, 16, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 30, 2501},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18183, 165936, 5, 1232},
	{18234, 165944, 3, 2531},
	{18249, 165948, 5, 1243},
	{18279, 165952, 5, 1248},
	{18294, 165956},
	{43186, 165960, 6, 2534},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 1265},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 1285},
	{18647, 166468, 3, 1300},
	{18666, 166472, 6, 2540},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 1338},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 9, 2546},
	{18906, 166528},
	{18917, 166532, 3, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 1354},
	{19000, 166548, 2, 1357},
	{19027, 166552, 4, 2555},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 6, 1364},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 10, 2559},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19731, 166732, 2, 1397},
	{19750, 166736, 5, 1399},
	{19772, 166740, 20, 2569},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 12, 1426},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 3, 1446},
	{20148, 166804, 8, 1449},
	{20167, 166808, 4, 1457},
	{20193, 166812, 3, 1354},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 5, 1477},
	{20285, 166880, 8, 2589},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21000, 166976, 4, 1527},
	{21021, 166980, 12, 1531},
	{21041, 166984, 2, 1543},
	{21061, 166988, 20, 1545},
	{21099, 166992, 2, 1565},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 3, 1572},
	{21230, 167024, 19, 2597},
	{21245, 167028, 8, 1594},
	{21262, 167032, 14, 2616},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21404, 167060},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 3, 1572},
	{21485, 167084, 19, 2597},
	{21500, 167088, 8, 1594},
	{21517, 167092, 14, 2616},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21659, 167120},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 3, 1572},
	{21740, 167144, 19, 2597},
	{21755, 167148, 8, 1594},
	{21772, 167152, 14, 2616},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21914, 167180},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 3, 1572},
	{21995, 167204, 19, 2597},
	{22010, 167208, 8, 1594},
	{22027, 167212, 14, 2616},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22169, 167240},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 3, 1572},
	{22250, 167264, 19, 2597},
	{22265, 167268, 8, 1594},
	{22282, 167272, 14, 2616},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22424, 167300},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 3, 1572},
	{22505, 167324, 19, 2597},
	{22520, 167328, 8, 1594},
	{22537, 167332, 14, 2616},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22679, 167360},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 3, 1572},
	{22760, 167384, 19, 2597},
	{22775, 167388, 8, 1594},
	{22792, 167392, 14, 2616},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22934, 167420},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 3, 1572},
	{23015, 167444, 19, 2597},
	{23030, 167448, 8, 1594},
	{23047, 167452, 14, 2616},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{23189, 167480},
	{23208, 167488, 1, 1615},
	{23227, 167492, 1, 1615},
	{23246, 167496, 1, 1615},
	{23265, 167500, 1, 1615},
	{23284, 167504, 1, 1615},
	{23303, 167508, 1, 1615},
	{23322, 167512, 1, 1615},
	{23341, 167516, 1, 1615},
	{23360, 167520, 1, 1615},
	{23385, 167524, 1, 1615},
	{23410, 167528, 1, 1615},
	{23435, 167532, 1, 1615},
	{23460, 167536, 1, 1615},
	{23485, 167540, 1, 1615},
	{23510, 167544, 1, 1615},
	{23535, 167548, 1, 1615},
	{23560, 167552, 1, 1615},
	{23585, 167556, 1, 1615},
	{23610, 167560, 1, 1615},
	{23635, 167564, 1, 1615},
	{23660, 167568, 1, 1615},
	{23685, 167572, 1, 1615},
	{23710, 167576, 1, 1615},
	{23735, 167580, 1, 1615},
	{23760, 167584, 1, 1615},
	{23783, 167588, 1, 1615},
	{23806, 167592, 1, 1615},
	{23829, 167596, 1, 1615},
	{23852, 167600, 1, 1615},
	{23875, 167604, 1, 1615},
	{23898, 167608, 1, 1615},
	{23921, 167612, 1, 1615},
	{23944, 167616, 3, 1616},
	{23962, 167620, 3, 1616},
	{23980, 167624, 3, 1616},
	{23998, 167628, 3, 1616},
	{24016, 167632, 3, 1616},
	{24034, 167636, 3, 1616},
	{24052, 167640, 3, 1616},
	{24070, 167644, 3, 1616},
	{24088, 167648, 9, 2630},
	{24106, 167652, 9, 2630},
	{24124, 167656, 9, 2630},
	{24142, 167660, 9, 2630},
	{24160, 167664, 9, 2630},
	{24178, 167668, 9, 2630},
	{24196, 167672, 9, 2630},
	{24214, 167676, 9, 2630},
	{24232, 196608, 1, 1627},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 1, 1629},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 1, 1631},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25534, 196852, 1, 1634},
	{25556, 196856, 1, 1634},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{43201, 196896, 5, 2639},
	{25721, 196908, 1, 663},
	{25740, 196912},
	{25758, 196916},
	{25785, 196920},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 4, 1639},
	{26032, 196968},
	{26047, 196972},
	{26071, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 1, 1643},
	{26247, 197032, 2, 1644},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 1, 1646},
	{26319, 197048, 2, 1647},
	{26337, 197052},
	{26355, 197056, 2, 2644},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 2644},
	{26437, 197080, 5, 1651},
	{26457, 197084, 7, 1656},
	{26476, 197088, 7, 1656},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 13, 1665},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 2, 1678},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 7, 1682},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 7, 1682},
	{26795, 197160, 7, 1689},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 5, 2646},
	{26879, 197180, 2, 330},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26939, 197196, 1, 1708},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{27085, 197232, 2, 1713},
	{27107, 197236, 2, 1715},
	{27129, 197240, 2, 1713},
	{27152, 197244, 2, 1715},
	{27175, 197248, 2, 1713},
	{27197, 197252, 2, 1715},
	{43220, 197256},
	{43242, 197260},
	{43264, 197280},
	{43286, 197284},
	{43308, 197288},
	{43335, 197292},
	{43362, 197296},
	{43389, 197300},
	{27219, 197364, 1, 1717},
	{27240, 197368, 1, 1718},
	{27260, 197372, 1, 1719},
	{27297, 197380, 1, 1719},
	{27314, 197384, 1, 1720},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 1733},
	{27638, 197464, 5, 2651},
	{27660, 197468, 1, 1740},
	{27680, 197472, 1, 1741},
	{27694, 197476, 1, 1742},
	{27708, 197480, 1, 1743},
	{27720, 197484, 1, 1744},
	{27736, 197488, 1, 1741},
	{27753, 197492, 1, 1742},
	{27770, 197496, 1, 1743},
	{27785, 197500, 1, 1744},
	{27804, 197552, 1, 1745},
	{27829, 197556, 1, 1745},
	{27853, 197560, 1, 1746},
	{27873, 197568},
	{27899, 197572, 1, 1628},
	{27928, 197576},
	{27953, 197580, 1, 1628},
	{27981, 197584},
	{28004, 197588, 1, 1628},
	{28030, 197592},
	{28052, 197596, 1, 1628},
	{28077, 197600},
	{28096, 197604, 1, 1628},
	{28118, 197608, 1, 1343},
	{28132, 197612},
	{28149, 197616, 1, 1628},
	{28169, 197620, 8, 1747},
	{28186, 197624, 13, 1755},
	{28203, 197628},
	{28220, 197632, 1, 1698},
	{28240, 197636},
	{28257, 197640, 1, 1663},
	{28277, 197644, 2, 1768},
	{28296, 197888, 8, 1770},
	{28317, 197892, 8, 1770},
	{28338, 198656, 6, 1778},
	{28353, 198912},
	{28372, 198916},
	{28391, 198920, 1, 1784},
	{28410, 198924, 2, 2656},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{28557, 198948},
	{28573, 198952},
	{28588, 198956, 2, 1357},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 2658},
	{28686, 198976},
	{28705, 198980},
	{28724, 198984},
	{28740, 198988, 1, 830},
	{28759, 198992},
	{28779, 198996, 1, 830},
	{28802, 199000},
	{28820, 199004, 1, 830},
	{28841, 199008, 9, 1788},
	{28866, 199012},
	{28882, 199016},
	{28903, 199020, 4, 1797},
	{28911, 199024},
	{28925, 199028},
	{28939, 199032},
	{28953, 199036, 3, 1801},
	{28968, 199040, 2, 1804},
	{28980, 199044, 1, 830},
	{29002, 199048, 3, 1806},
	{43416, 199052, 2, 2660},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29676, 199952},
	{29703, 199956},
	{29730, 199960},
	{29757, 199964},
	{29784, 199968, 5, 2662},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 1829},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 11, 2667},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 1861},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{30609, 200960},
	{30631, 200964},
	{30655, 200968},
	{30679, 200972},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{30945, 213040},
	{30968, 213044},
	{30991, 213048},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{43428, 213648},
	{43448, 213652},
	{43468, 213656},
	{43488, 213660},
	{43508, 213664},
	{43528, 213668},
	{43548, 213672},
	{43568, 213676},
	{43588, 213680},
	{43613, 213684},
	{43638, 213688},
	{43663, 213692},
	{43688, 213696},
	{43713, 213700},
	{43738, 213704},
	{43763, 213708},
	{43788, 213712},
	{43811, 213716},
	{43834, 213720},
	{43857, 213724},
	{43880, 213728},
	{43903, 213732},
	{43926, 213736},
	{43949, 213740},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33290, 215424},
	{33311, 215428},
	{43972, 215432},
	{43992, 215436, 2, 1870},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{33804, 216576},
	{33825, 216580},
	{33846, 216584},
	{33867, 216588},
	{33888, 216592},
	{33909, 216596},
	{33930, 216600},
	{33951, 216604},
	{33972, 216640},
	{33993, 216644},
	{34014, 216648},
	{34035, 216652},
	{34056, 216656},
	{34077, 216660},
	{34098, 216664},
	{34119, 216668},
	{34140, 216704},
	{34161, 216708},
	{34182, 216712},
	{34203, 216716},
	{34224, 216720},
	{34245, 216724},
	{34266, 216728},
	{34287, 216732},
	{34308, 216832},
	{34328, 216836},
	{34348, 216840},
	{34368, 216844},
	{34388, 216848},
	{34408, 216852},
	{34428, 216856},
	{34448, 216860},
	{34468, 216864},
	{34489, 216868},
	{34510, 216872},
	{34531, 216876},
	{34552, 216880},
	{34573, 216884},
	{34594, 216888},
	{34615, 216892},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{35020, 217856},
	{35040, 217860},
	{35060, 217864},
	{35080, 217868},
	{35100, 217872},
	{35120, 217876},
	{35140, 217880},
	{35160, 217884},
	{35230, 218016},
	{35256, 218020, 2, 1870},
	{44012, 218024},
	{44035, 218028, 2, 1870},
	{35282, 218080},
	{35307, 218084},
	{35332, 218088},
	{35357, 218092},
	{35434, 218224},
	{35456, 218228},
	{35478, 218232},
	{35500, 218236},
	{35522, 218240},
	{35542, 218244},
	{35562, 218248},
	{35582, 218252},
	{35602, 218624},
	{35624, 218628},
	{35646, 218632},
	{35668, 218636},
	{35690, 218640},
	{35712, 218644},
	{35734, 218648},
	{35756, 218652},
	{35778, 218656},
	{35800, 218660},
	{35822, 218664},
	{35844, 218668},
	{35866, 218672},
	{35888, 218676},
	{35910, 218680},
	{35932, 218684},
	{35954, 218880},
	{35975, 218884},
	{35996, 218888},
	{36017, 218892},
	{36038, 218896},
	{36059, 218900},
	{36080, 218904},
	{36101, 218908},
	{36122, 219136},
	{36142, 219140},
	{36162, 219144},
	{36182, 219148},
	{36202, 219152},
	{36222, 219156},
	{36242, 219160},
	{36262, 219164},
	{36282, 219392},
	{36302, 219396},
	{44058, 219400},
	{44077, 219404, 2, 1870},
	{44096, 219520},
	{44125, 219524, 2, 1870},
	{44154, 219528},
	{44176, 219532},
	{44198, 219536},
	{44220, 219540},
	{44242, 219568},
	{44271, 219572, 2, 1870},
	{44300, 219576},
	{44322, 219580},
	{44344, 219584},
	{44366, 219588},
	{44388, 219616},
	{44417, 219620, 2, 1870},
	{44446, 219624},
	{44468, 219628},
	{44490, 219632},
	{44512, 219636},
	{44534, 219664},
	{44563, 219668, 2, 1870},
	{44592, 219672},
	{44614, 219676},
	{44636, 219680},
	{44658, 219684},
	{36322, 221184, 5, 1872},
	{36346, 221188, 4, 1877},
	{36371, 221192, 5, 1872},
	{36395, 221196, 5, 1872},
	{36419, 221200, 4, 1877},
	{36444, 221204, 5, 1872},
	{36468, 221208, 4, 1877},
	{36493, 221212, 5, 1872},
	{36517, 221216, 4, 1881},
	{36533, 221220, 5, 1872},
	{36557, 221224, 3, 1885},
	{36591, 221228, 3, 1888},
	{36625, 221232, 3, 1891},
	{36650, 221236, 3, 1894},
	{36675, 221240, 3, 1891},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 20, 1903},
	{36842, 221444, 20, 1903},
	{36867, 221448, 15, 1923},
	{36895, 221452, 15, 1923},
	{36923, 221456, 15, 1923},
	{36951, 221460, 15, 1923},
	{36979, 221492, 8, 1938},
	{37007, 221496, 8, 1938},
	{44680, 221840, 5, 1946},
	{44704, 221844, 4, 1951},
	{44729, 221848, 5, 1946},
	{44753, 221852, 4, 1951},
	{44778, 221856, 5, 1946},
	{44802, 221860, 4, 1951},
	{44827, 221864, 5, 1946},
	{44851, 221868, 4, 1951},
	{44876, 221872, 5, 1946},
	{44905, 221876, 4, 1951},
	{44935, 221880, 5, 1946},
	{44964, 221884, 4, 1951},
	{44994, 221888, 5, 1946},
	{45023, 221892, 4, 1951},
	{45053, 221896, 5, 1946},
	{45082, 221900, 4, 1951},
	{45112, 221904, 5, 1946},
	{45139, 221908, 4, 1951},
	{45167, 221912, 5, 1946},
	{45194, 221916, 4, 1951},
	{45222, 221920, 5, 1946},
	{45249, 221924, 4, 1951},
	{45277, 221928, 5, 1946},
	{45304, 221932, 4, 1951},
	{37409, 222208, 5, 1957},
	{37435, 222212, 4, 1962},
	{37462, 222216, 5, 1957},
	{37488, 222220, 4, 1962},
	{37515, 222224, 5, 1957},
	{37541, 222228, 4, 1962},
	{37568, 222232, 5, 1957},
	{37594, 222236, 4, 1962},
	{37621, 222464, 5, 1957},
	{37647, 222468, 4, 1962},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 5, 1957},
	{37880, 222724, 5, 1957},
	{37904, 222728, 5, 1957},
	{37928, 222732, 5, 1957},
	{37952, 222736, 4, 1962},
	{37977, 222740, 4, 1962},
	{38002, 222744, 4, 1962},
	{38027, 222748, 4, 1962},
	{38052, 222752, 1, 1872},
	{38076, 222756, 1, 1872},
	{38100, 222760, 8, 1966},
	{38121, 222976, 3, 2678},
	{38144, 222980, 3, 2678},
	{38167, 222984, 3, 2678},
	{38190, 222988, 3, 2678},
	{38213, 222992, 3, 2678},
	{38236, 222996, 3, 2678},
	{38259, 223000, 3, 2678},
	{38282, 223004, 3, 2678},
	{38305, 223008, 3, 2678},
	{38328, 223012, 3, 2678},
	{38351, 223016, 3, 2678},
	{38375, 223020, 3, 2678},
	{38399, 223024, 3, 2678},
	{38423, 223028, 3, 2678},
	{38447, 223032, 3, 2678},
	{38471, 223036, 3, 2678},
	{38495, 223104, 15, 2681},
	{38515, 223112, 1, 1987},
	{38536, 223232, 5, 1957},
	{38561, 223236, 4, 1962},
	{38587, 223240, 8, 1988},
	{45332, 223244, 5, 2140},
	{45354, 223248, 5, 2140},
	{45376, 223252, 6, 2145},
	{38610, 223488, 5, 1957},
	{38633, 223492, 5, 1957},
	{38656, 223496, 3, 2013},
	{38679, 223500, 3, 2013},
	{38702, 223504, 4, 1962},
	{38726, 223508, 4, 1962},
	{38750, 223744, 5, 1957},
	{38774, 223748, 5, 1957},
	{38798, 223752, 5, 1957},
	{38822, 223756, 5, 1957},
	{38846, 223760, 4, 1962},
	{45403, 223764, 4, 1962},
	{45428, 223768, 4, 1962},
	{45453, 223772, 4, 1962},
	{38871, 224000, 5, 1957},
	{38894, 224004, 4, 1962},
	{38918, 224008, 3, 2013},
	{38941, 224256, 5, 1957},
	{38964, 224260, 4, 1962},
	{38988, 224264, 3, 2013},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{39157, 224768, 5, 1957},
	{39182, 224772, 4, 1951},
	{39208, 224776, 5, 1957},
	{39233, 224780, 4, 1951},
	{39259, 224784, 3, 2013},
	{39284, 224788, 3, 2013},
	{39309, 224832, 5, 1957},
	{39334, 224836, 4, 1951},
	{39360, 224840, 5, 1957},
	{39385, 224844, 4, 1951},
	{39411, 224848, 3, 2013},
	{39436, 224852, 3, 2013},
	{39461, 224896, 5, 1957},
	{39486, 224900, 4, 1951},
	{39512, 224904, 3, 2013},
	{39537, 224908, 3, 2013},
	{39562, 224912, 3, 2013},
	{39587, 225024, 5, 1957},
	{39611, 225028, 4, 1951},
	{39636, 225032, 3, 2013},
	{39660, 225036, 3, 2013},
	{39684, 225040, 3, 2013},
	{39708, 225048, 5, 1957},
	{39733, 225052, 4, 1951},
	{39759, 225056, 3, 2013},
	{39784, 225060, 3, 2013},
	{39809, 225064, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40246, 225812},
	{40265, 225816, 2, 2052},
	{40291, 225820, 2, 2054},
	{40314, 225824},
	{40337, 225828, 2, 2056},
	{40364, 225832},
	{40391, 225836, 2, 2058},
	{40416, 225840, 2, 2060},
	{40444, 225844, 2, 2062},
	{40472, 225848, 2, 2064},
	{40495, 225852, 2, 2066},
	{40518, 225856},
	{40551, 225860, 2, 2068},
	{40584, 225864},
	{40616, 225868, 2, 2068},
	{40648, 225872, 2, 2070},
	{40667, 225876, 2, 2072},
	{40694, 225880},
	{40721, 225884, 2, 2696},
	{40748, 225888, 2, 2076},
	{40775, 225892, 17, 2698},
	{40796, 225896, 9, 2715},
	{40815, 225900, 19, 2724},
	{40834, 225904, 1, 2104},
	{40858, 225908, 1, 2106},
	{40890, 225912, 2, 2108},
	{40920, 225916, 4, 2110},
	{40956, 225920, 3, 2114},
	{40989, 225924, 1, 2117},
	{45478, 225928, 7, 2045},
	{41007, 225932, 1, 2118},
	{45511, 225936},
	{45538, 225940},
	{45564, 225944, 4, 2110},
	{45604, 225948, 2, 2743},
	{45638, 225952, 2, 2743},
	{45668, 225956, 2, 2072},
	{45699, 225960},
	{45730, 225964, 4, 2745},
	{45764, 225968, 3, 2114},
	{45801, 225972, 3, 2749},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{41092, 226060, 4, 2122},
	{41118, 226064, 3, 2126},
	{41147, 226068, 1, 687},
	{41176, 226072, 3, 2126},
	{41205, 226076, 1, 687},
	{41234, 226192, 1, 2129},
	{41282, 226304, 5, 2028},
	{41306, 226308, 4, 2033},
	{41331, 226312, 2, 2037},
	{41355, 226316, 5, 2028},
	{41379, 226320, 4, 2033},
	{41404, 226324, 2, 2037},
	{41428, 226328, 10, 2130},
	{41536, 226480, 5, 2140},
	{41564, 226484, 5, 2140},
	{41592, 226488, 5, 2140},
	{41620, 226492, 5, 2140},
	{41648, 226496, 5, 2140},
	{41676, 226500, 5, 2140},
	{41704, 226504, 5, 2140},
	{41732, 226508, 5, 2140},
	{41760, 226512, 6, 2145},
	{45842, 226516, 5, 2140},
	{45867, 226520, 5, 2140},
	{45892, 226524, 5, 2140},
	{45917, 226528, 5, 2140},
	{45942, 226532, 6, 2145},
	{41793, 226544, 5, 1957},
	{41822, 226548, 5, 1957},
	{41851, 226552, 4, 1962},
	{41881, 226556, 4, 1962},
	{41911, 226560, 8, 1988},
	{41938, 226564, 8, 1988},
	{42054, 226688, 5, 2028},
	{42078, 226692, 4, 2033},
	{42103, 226696, 3, 2151},
	{42127, 226700, 2, 2154},
	{42153, 226704, 2, 2154},
	{42179, 226816, 5, 1957},
	{42205, 226820, 4, 1962},
	{42232, 226824, 5, 1957},
	{42258, 226828, 5, 1957},
	{42284, 226832, 5, 1957},
	{42310, 226836, 1, 1872},
	{42336, 226840, 1, 1872},
	{42362, 226844, 1, 1872},
	{42388, 226848, 1, 1872},
	{42414, 226880, 4, 1962},
	{42441, 226884, 4, 1962},
	{42468, 226888, 4, 1962},
	{42495, 227072, 5, 1957},
	{42520, 227076, 4, 1951},
	{42546, 227080, 3, 2013},
	{42571, 227084, 3, 2013},
	{42596, 227088, 3, 2013},
	{42621, 227200, 5, 1957},
	{42645, 227204, 4, 1951},
	{42670, 227208, 3, 2013},
	{42694, 227212, 3, 2013},
	{42718, 227216, 3, 2013},
	{42742, 227328, 5, 1957},
	{42766, 227332, 4, 1962},
	{42791, 227336, 8, 1988},
	{45972, 227340, 5, 2140},
	{45993, 227344, 5, 2140},
	{46014, 227348, 6, 2145},
	{46040, 227456, 5, 2140},
	{46071, 227460, 5, 2140},
	{46102, 227464, 6, 2145},
	{46138, 227468, 1, 2752},
	{46162, 227472, 5, 1957},
	{46188, 227476, 4, 1962},
	{46215, 227480, 5, 1957},
	{46241, 227484, 4, 1962},
	{46268, 227504, 5, 2140},
	{46299, 227508, 5, 2140},
	{46330, 227512, 6, 2145},
	{46366, 227516, 1, 2752},
	{46390, 227520, 5, 1957},
	{46416, 227524, 4, 1962},
	{46443, 227528, 5, 1957},
	{46469, 227532, 4, 1962},
	{46496, 227552, 5, 2140},
	{46527, 227556, 5, 2140},
	{46558, 227560, 6, 2145},
	{46594, 227564, 1, 2752},
	{46618, 227568, 5, 1957},
	{46644, 227572, 4, 1962},
	{46671, 227576, 5, 1957},
	{46697, 227580, 4, 1962},
	{46724, 227600, 5, 2140},
	{46755, 227604, 5, 2140},
	{46786, 227608, 6, 2145},
	{46822, 227612, 1, 2752},
	{46846, 227616, 5, 1957},
	{46872, 227620, 4, 1962},
	{46899, 227624, 5, 1957},
	{46925, 227628, 4, 1962},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 2164},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 7, 2170},
	{42899, 1168, 12, 2177},
	{42914, 1280, 6, 2189},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
	{42941, 1414, 15, 2195},
};

static const struct si_reg gfx6_reg_table[] = {
	{1003, 68, 9, 2753},
	{1016, 72, 24, 2762},
	{1031, 76, 3, 2786},
	{46952, 80, 11, 2789},
	{1068, 84, 4, 2800},
	{1086, 88, 2, 2804},
	{1104, 92, 4, 2806},
	{1119, 96},
	{1133, 100, 1, 2810},
	{1147, 104},
	{46966, 108},
	{46983, 112, 13, 2811},
	{46999, 2480},
	{47014, 2484, 1, 2824},
	{47029, 2488},
	{47044, 2492, 1, 2824},
	{1302, 2496},
	{1316, 2500},
	{1330, 2504},
	{1344, 2508},
	{1358, 2512},
	{1372, 2516},
	{1386, 2520},
	{1400, 2524},
	{1414, 2528},
	{1428, 2532},
	{1442, 2536},
	{1457, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{47059, 3660, 21, 2825},
	{47072, 3664, 20, 2846},
	{47084, 3668, 16, 2866},
	{47097, 32768, 1, 2882},
	{47107, 32772, 2, 2883},
	{1647, 32776, 17, 2885},
	{47122, 32780, 2, 2902},
	{1660, 32784, 24, 2904},
	{1672, 32788, 11, 2928},
	{1688, 32792, 11, 2928},
	{47136, 32800, 6, 2939},
	{47152, 32804, 1, 2945},
	{47168, 32808},
	{28338, 32812, 6, 2946},
	{47184, 32816, 2, 2952},
	{47204, 32820, 1, 2954},
	{47226, 32848, 6, 2955},
	{47237, 32852, 22, 2961},
	{47257, 32856, 4, 2983},
	{47273, 32864, 2, 2987},
	{36817, 32880, 19, 2989},
	{36842, 32884, 19, 2989},
	{31014, 32888},
	{31035, 32892},
	{31056, 32896},
	{31077, 32900},
	{36867, 32920, 12, 3008},
	{36895, 32924, 12, 3008},
	{31098, 32936},
	{31122, 32940},
	{31146, 32944},
	{31170, 32948},
	{47287, 33008, 1, 3020},
	{47173, 33012},
	{47299, 33020},
	{47312, 33024},
	{47330, 33028},
	{47348, 33032},
	{47366, 33036},
	{47384, 33040},
	{47402, 33044},
	{47420, 33048},
	{47438, 33052},
	{47456, 33536, 10, 3021},
	{24232, 33792, 2, 3031},
	{24252, 33796, 1, 1628},
	{24272, 33800},
	{24292, 33804},
	{24312, 33808},
	{24333, 33812},
	{24354, 33816, 2, 3033},
	{24376, 33820},
	{24398, 33824},
	{24428, 33828},
	{24458, 33832},
	{24487, 33836},
	{24516, 33840},
	{24546, 33844},
	{24576, 33848},
	{24605, 33852},
	{24634, 33856},
	{24664, 33860},
	{24694, 33864},
	{24723, 33868},
	{24752, 33872},
	{24782, 33876},
	{24812, 33880},
	{24841, 33884},
	{24870, 33888, 2, 3035},
	{24892, 33892},
	{24914, 33896},
	{24937, 33900},
	{24960, 33904},
	{24983, 33908},
	{25006, 33912},
	{25029, 33916},
	{25052, 33920},
	{25076, 33924},
	{25100, 33928},
	{25124, 33932},
	{25148, 33936},
	{25172, 33940},
	{25196, 33944},
	{25220, 33948},
	{25244, 33952},
	{25266, 33956},
	{25288, 33960},
	{25309, 33964},
	{25330, 33968},
	{25354, 33972},
	{25378, 33976},
	{25402, 33980},
	{25426, 33984},
	{25450, 33988},
	{25578, 34044, 1, 1635},
	{25594, 34048},
	{25607, 34052},
	{25620, 34056},
	{25633, 34060},
	{25646, 34064},
	{25659, 34068},
	{25672, 34072},
	{25685, 34076},
	{25812, 34112, 2, 1636},
	{25825, 34116},
	{25996, 34144, 1, 1638},
	{26014, 34148, 3, 3037},
	{26032, 34152},
	{26047, 34156},
	{26071, 34160},
	{26095, 34164},
	{26114, 34168},
	{26133, 34172},
	{26157, 34176},
	{26181, 34180},
	{26205, 34184},
	{26229, 34212, 2, 3040},
	{26247, 34216, 1, 3042},
	{26265, 34220},
	{26283, 34224},
	{26301, 34228, 2, 3043},
	{26319, 34232, 1, 3045},
	{26337, 34236},
	{26355, 34240, 2, 1649},
	{26374, 34244, 5, 3046},
	{26393, 34256},
	{26417, 34260, 2, 1649},
	{26437, 34264, 5, 3046},
	{26511, 34284, 1, 1664},
	{26532, 34288, 23, 3051},
	{26546, 34292},
	{26560, 34296},
	{26574, 34300, 4, 3074},
	{26590, 34304},
	{26609, 34308, 1, 3078},
	{26631, 34312},
	{26650, 34316, 1, 3079},
	{26672, 34320, 9, 3080},
	{26690, 34324},
	{26710, 34328, 1, 3078},
	{26733, 34332},
	{26753, 34336, 1, 3079},
	{26776, 34340, 9, 3080},
	{26795, 34344, 5, 3089},
	{26807, 34348, 2, 1696},
	{26841, 34356, 1, 3094},
	{26859, 34360, 5, 2646},
	{26879, 34364, 1, 1704},
	{26896, 34368},
	{26912, 34372, 1, 1706},
	{26925, 34376, 1, 1707},
	{26939, 34380, 1, 1708},
	{26953, 34384, 1, 1709},
	{26975, 34388, 1, 1710},
	{26995, 34392, 1, 1711},
	{27017, 34396, 1, 1712},
	{47479, 34416, 15, 3095},
	{47496, 34420, 18, 3110},
	{47513, 34424, 31, 3128},
	{47530, 34428, 16, 3159},
	{47543, 34432, 24, 3175},
	{47551, 34436},
	{47569, 34440},
	{47588, 34444, 3, 3199},
	{47607, 34448},
	{47625, 34460, 1, 3202},
	{47646, 34512, 2, 3203},
	{47658, 34516, 1, 3205},
	{47670, 34520, 9, 3206},
	{47681, 34528, 4, 3215},
	{47694, 34532, 1, 3219},
	{47711, 34552, 1, 3220},
	{47723, 34556, 1, 3220},
	{47735, 34560, 1, 3220},
	{47747, 34564, 2, 3221},
	{47764, 34568, 2, 3223},
	{27330, 34572, 1, 1721},
	{27349, 34576, 1, 3225},
	{27368, 34580, 1, 1723},
	{27385, 34584, 1, 1724},
	{27403, 34588, 1, 3226},
	{27421, 34592, 1, 1726},
	{27437, 34596, 1, 1727},
	{27455, 34600, 1, 3227},
	{27473, 34604, 1, 1729},
	{27489, 34608, 1, 1724},
	{27504, 34612, 1, 3226},
	{27519, 34616, 1, 1726},
	{27532, 34620, 1, 1727},
	{27547, 34624, 1, 3227},
	{27562, 34628, 1, 1729},
	{27575, 34632, 1, 1730},
	{27589, 34636, 1, 3228},
	{27603, 34640, 1, 1732},
	{47785, 34644, 4, 3229},
	{47804, 34648, 4, 3233},
	{47823, 34652, 3, 3237},
	{47841, 34656, 2, 3240},
	{47861, 34660, 2, 3242},
	{47879, 34664, 2, 3244},
	{47892, 34668, 1, 3246},
	{47905, 34672, 1, 3247},
	{47919, 34676, 1, 3248},
	{47932, 34680, 3, 3249},
	{47945, 34684},
	{47957, 34688, 2, 3252},
	{47972, 34692, 2, 3254},
	{47988, 34696, 2, 3256},
	{48004, 34700, 1, 3258},
	{48016, 34708, 2, 3259},
	{48028, 34712, 2, 3261},
	{48042, 34716, 1, 3263},
	{48056, 34720, 2, 3264},
	{48074, 34724, 2, 3266},
	{48093, 34728, 2, 3268},
	{48112, 34780, 12, 3270},
	{36517, 34812, 4, 1881},
	{48130, 34944, 5, 3282},
	{48153, 34948, 2, 3287},
	{48176, 34952, 2, 3287},
	{48199, 34956, 2, 3287},
	{48222, 34960},
	{48241, 34964},
	{48260, 34968},
	{48279, 34972},
	{48298, 34976},
	{48317, 34980},
	{48336, 34984},
	{48355, 34988},
	{48374, 34992, 1, 3289},
	{48397, 34996, 1, 3290},
	{48421, 35000, 1, 3291},
	{48444, 35004, 1, 3292},
	{48469, 35008, 2, 3293},
	{48489, 35012, 8, 3295},
	{28353, 35016},
	{28372, 35020},
	{48512, 35024, 4, 3303},
	{48528, 35028, 1, 3307},
	{48548, 35032, 1, 3308},
	{48564, 35036, 5, 3309},
	{48579, 35040, 2, 3314},
	{48594, 35044},
	{48609, 35048, 2, 3316},
	{48623, 35052},
	{48637, 35056, 10, 3318},
	{48653, 35100, 1, 3328},
	{48679, 35104, 5, 3282},
	{48703, 35108, 5, 3282},
	{48727, 35112, 2, 3287},
	{48751, 35116, 2, 3287},
	{48775, 35120},
	{48795, 35124},
	{48815, 35128},
	{48835, 35132},
	{48855, 35136},
	{48875, 35140},
	{48895, 35144},
	{48915, 35148},
	{28391, 35160, 1, 3329},
	{28410, 35164, 1, 3330},
	{28425, 35168},
	{28458, 35172},
	{28491, 35176},
	{28524, 35180},
	{28614, 35184},
	{28630, 35188},
	{48935, 35196, 10, 3331},
	{48953, 35200, 2, 3341},
	{48970, 35204, 10, 3343},
	{28648, 35208, 1, 1785},
	{48987, 35212, 3, 3353},
	{28665, 35248, 2, 3356},
	{28686, 35256},
	{49002, 35260, 4, 3358},
	{49028, 35264, 4, 3358},
	{49056, 35328, 1, 3362},
	{49073, 35332},
	{49090, 35344, 1, 3363},
	{49108, 35348, 9, 3364},
	{49122, 35352, 10, 3373},
	{37409, 35360, 3, 3282},
	{37462, 35364, 3, 3282},
	{37515, 35368, 2, 2010},
	{37568, 35372, 2, 2010},
	{31750, 35376},
	{31772, 35380, 1, 1869},
	{31794, 35384},
	{31816, 35388, 1, 1869},
	{31838, 35392},
	{31860, 35396, 1, 1869},
	{31882, 35400},
	{31904, 35404, 1, 1869},
	{49139, 35408, 1, 3383},
	{49157, 35412, 1, 3384},
	{29018, 35424, 1, 1809},
	{37621, 35456, 3, 3385},
	{37674, 35460, 1, 1974},
	{37700, 35464, 1, 1974},
	{37726, 35468, 1, 1974},
	{37752, 35472, 1, 1974},
	{37778, 35476, 1, 1974},
	{37804, 35480, 1, 1974},
	{37830, 35484, 1, 1974},
	{31926, 35488},
	{31948, 35492},
	{31970, 35496},
	{31992, 35500},
	{32014, 35504},
	{32036, 35508},
	{32058, 35512},
	{32080, 35516},
	{32102, 35520},
	{32124, 35524},
	{32146, 35528},
	{32168, 35532},
	{32190, 35536},
	{32212, 35540},
	{32234, 35544},
	{32256, 35548},
	{29043, 35600, 2, 1810},
	{49179, 35620, 2, 3388},
	{49204, 35624, 10, 3390},
	{49221, 35788, 4, 3400},
	{49237, 35796, 4, 3404},
	{49256, 35800, 1, 3408},
	{49273, 35804},
	{49290, 35824, 26, 3409},
	{49304, 35840, 9, 3435},
	{49314, 35844, 9, 3444},
	{29784, 35848, 3, 3453},
	{49325, 35852, 3, 3456},
	{49344, 35856, 6, 3459},
	{49359, 35860, 4, 3465},
	{38495, 35864, 9, 3469},
	{49373, 35868, 4, 3478},
	{49393, 35872, 4, 3478},
	{49415, 35876, 4, 3482},
	{32518, 35968},
	{32537, 35972},
	{32556, 35976},
	{32575, 35980},
	{32594, 35984},
	{32613, 35988},
	{32632, 35992},
	{32651, 35996},
	{32670, 36000},
	{32689, 36004},
	{32708, 36008},
	{32727, 36012},
	{32746, 36016},
	{32765, 36020},
	{32784, 36024},
	{32803, 36028},
	{32822, 36032},
	{32841, 36036},
	{32860, 36040},
	{32879, 36044},
	{32898, 36048},
	{32918, 36052},
	{32938, 36056},
	{32958, 36060},
	{32978, 36064},
	{32998, 36068},
	{33018, 36072},
	{33038, 36076},
	{33058, 36080},
	{33078, 36084},
	{33098, 36088},
	{33118, 36092},
	{38121, 36096, 6, 3486},
	{38144, 36100, 6, 3486},
	{38167, 36104, 6, 3486},
	{38190, 36108, 6, 3486},
	{38213, 36112, 6, 3486},
	{38236, 36116, 6, 3486},
	{38259, 36120, 6, 3486},
	{38282, 36124, 6, 3486},
	{38305, 36128, 6, 3486},
	{38328, 36132, 6, 3486},
	{38351, 36136, 6, 3486},
	{38375, 36140, 6, 3486},
	{38399, 36144, 6, 3486},
	{38423, 36148, 6, 3486},
	{38447, 36152, 6, 3486},
	{38471, 36156, 6, 3486},
	{49435, 36224, 2, 3492},
	{49451, 36228, 2, 3492},
	{49467, 36232, 4, 3494},
	{49484, 36236, 4, 3494},
	{49502, 36320, 8, 3498},
	{49515, 36324},
	{49527, 36336},
	{49538, 36340},
	{49549, 36352},
	{49570, 36356, 1, 3506},
	{2124, 36360, 8, 3507},
	{2145, 36364, 3, 3515},
	{49591, 36368, 2, 3518},
	{29568, 36384},
	{29595, 36388},
	{29622, 36392},
	{29649, 36396},
	{2103, 36400, 2, 3520},
	{2193, 36404, 5, 3522},
	{49617, 36408, 15, 3527},
	{2172, 36412, 1, 3542},
	{49638, 36416},
	{49659, 36424, 1, 3543},
	{49683, 36440, 3, 3544},
	{49701, 36444, 4, 3547},
	{49720, 36448, 3, 3551},
	{49735, 36452},
	{49757, 36456},
	{49779, 36460},
	{49801, 36464},
	{49823, 36480, 4, 3554},
	{49838, 36484, 3, 3558},
	{49849, 36488, 3, 3561},
	{49860, 36492, 4, 3564},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 14, 3568},
	{3335, 36624},
	{3353, 36628, 5, 3582},
	{3371, 36632, 4, 3587},
	{3389, 36636, 11, 3591},
	{3407, 36640, 2, 3602},
	{3425, 36644, 2, 3604},
	{3443, 36648, 4, 3606},
	{3461, 36652},
	{2452, 36656, 13, 3610},
	{2470, 36660, 4, 411},
	{2488, 36664, 9, 3623},
	{2506, 36668, 3, 3632},
	{2524, 37120, 6, 429},
	{29809, 38156},
	{2540, 39160, 9, 3635},
	{2555, 39184, 6, 3644},
	{2569, 39188, 5, 3645},
	{2583, 39192, 5, 3645},
	{2597, 39196, 5, 3645},
	{2611, 39200, 5, 3645},
	{2625, 39204, 5, 3645},
	{2639, 39208, 5, 3645},
	{2653, 39212, 5, 3645},
	{2667, 39216, 5, 3645},
	{2681, 39220, 5, 3645},
	{2695, 39224, 5, 3645},
	{2710, 39228, 5, 3645},
	{2725, 39232, 5, 3645},
	{2740, 39236, 5, 3645},
	{2755, 39240, 5, 3645},
	{2770, 39244, 5, 3645},
	{2785, 39248, 5, 3645},
	{2800, 39252, 5, 3645},
	{2815, 39256, 5, 3645},
	{2830, 39260, 5, 3645},
	{2845, 39264, 5, 3645},
	{2860, 39268, 5, 3645},
	{2875, 39272, 5, 3645},
	{2890, 39276, 5, 3645},
	{2905, 39280, 5, 3645},
	{2920, 39284, 5, 3645},
	{2935, 39288, 5, 3645},
	{2950, 39292, 5, 3645},
	{2965, 39296, 5, 3645},
	{2980, 39300, 5, 3645},
	{2995, 39304, 5, 3645},
	{3010, 39308, 5, 3645},
	{49872, 45056},
	{49893, 45060, 1, 491},
	{49914, 45064},
	{49935, 45068, 1, 491},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 3650},
	{3618, 45100, 6, 3661},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{49956, 45312},
	{49977, 45316, 1, 491},
	{49998, 45320},
	{50019, 45324, 1, 491},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 3667},
	{4824, 45356, 10, 3679},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{50040, 45568},
	{50061, 45572, 1, 491},
	{50082, 45576},
	{50103, 45580, 1, 491},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 11, 3689},
	{6198, 45612, 4, 3700},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{50124, 45824},
	{50145, 45828, 1, 491},
	{50166, 45832},
	{50187, 45836, 1, 491},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7345, 45864, 12, 3667},
	{7369, 45868, 6, 3704},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{50208, 46080},
	{50229, 46084, 1, 491},
	{50250, 46088},
	{50271, 46092, 1, 491},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 10, 3710},
	{8093, 46124, 6, 3720},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{50292, 46336},
	{50313, 46340, 1, 491},
	{50334, 46344},
	{50355, 46348, 1, 491},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9240, 46376, 11, 3726},
	{9264, 46380, 5, 3737},
	{9288, 46384},
	{9314, 46388},
	{9340, 46392},
	{9366, 46396},
	{9392, 46400},
	{9418, 46404},
	{9444, 46408},
	{9470, 46412},
	{9496, 46416},
	{9522, 46420},
	{9548, 46424},
	{9575, 46428},
	{9602, 46432},
	{9629, 46436},
	{9656, 46440},
	{9683, 46444},
	{9710, 47104, 12, 3742},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{50376, 47148, 1, 3754},
	{9943, 47152},
	{9958, 47156, 2, 3755},
	{50396, 47160},
	{50411, 47164, 1, 663},
	{50426, 47168},
	{50441, 47172, 1, 663},
	{10097, 47176, 10, 3757},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 7, 3767},
	{50456, 47192, 2, 3774},
	{50487, 47196, 2, 3774},
	{10224, 47200, 2, 694},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{50518, 53300, 29, 3776},
	{50535, 55348, 29, 3776},
	{11086, 163840, 9, 719},
	{11104, 163844, 9, 3805},
	{11121, 163848, 4, 3814},
	{11135, 163852, 23, 747},
	{11154, 163856, 15, 770},
	{11174, 163860},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{50552, 163900, 7, 3818},
	{11364, 163904, 8, 3825},
	{11374, 163908, 5, 3833},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{50566, 163928, 2, 3838},
	{50580, 163932, 1, 3840},
	{11632, 163968},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13726, 164704, 1, 902},
	{50595, 164708, 1, 3841},
	{13757, 164712, 1, 904},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16530, 165444, 6, 949},
	{16550, 165448, 6, 949},
	{16570, 165452, 6, 949},
	{16590, 165456, 6, 949},
	{16610, 165460, 6, 949},
	{16630, 165464, 6, 949},
	{16650, 165468, 6, 949},
	{16670, 165472, 6, 949},
	{16690, 165476, 6, 949},
	{16710, 165480, 6, 949},
	{16730, 165484, 6, 949},
	{16751, 165488, 6, 949},
	{16772, 165492, 6, 949},
	{16793, 165496, 6, 949},
	{16814, 165500, 6, 949},
	{16835, 165504, 6, 949},
	{16856, 165508, 6, 949},
	{16877, 165512, 6, 949},
	{16898, 165516, 6, 949},
	{16919, 165520, 6, 949},
	{16940, 165524, 4, 961},
	{16961, 165528, 4, 961},
	{16982, 165532, 4, 961},
	{17003, 165536, 4, 961},
	{17024, 165540, 4, 961},
	{17045, 165544, 4, 961},
	{17066, 165548, 4, 961},
	{17087, 165552, 4, 961},
	{17108, 165556, 4, 961},
	{17129, 165560, 4, 961},
	{17150, 165564, 4, 961},
	{17171, 165568, 4, 961},
	{17192, 165572, 2, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 3, 3842},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17338, 165644, 4, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 3845},
	{17869, 165864},
	{17882, 165872, 5, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 3, 3846},
	{18007, 165900, 12, 1110},
	{18025, 165904, 19, 1127},
	{18041, 165908, 13, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 26, 1173},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 3849},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 1285},
	{18666, 166472, 4, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 3853},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 7, 3858},
	{18917, 166532, 2, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 3865},
	{19000, 166548, 1, 1357},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 6, 1364},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 7, 3868},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19772, 166740, 6, 1404},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 8, 3875},
	{19913, 166768, 6, 1438},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 2, 1446},
	{20148, 166804, 7, 3883},
	{20167, 166808, 4, 1457},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 4, 1477},
	{20285, 166880, 5, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 2, 3814},
	{21230, 167024, 15, 3890},
	{21245, 167028, 6, 1594},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 2, 3814},
	{21485, 167084, 15, 3890},
	{21500, 167088, 6, 1594},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 2, 3814},
	{21740, 167144, 15, 3890},
	{21755, 167148, 6, 1594},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 2, 3814},
	{21995, 167204, 15, 3890},
	{22010, 167208, 6, 1594},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 2, 3814},
	{22250, 167264, 15, 3890},
	{22265, 167268, 6, 1594},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 2, 3814},
	{22505, 167324, 15, 3890},
	{22520, 167328, 6, 1594},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 2, 3814},
	{22760, 167384, 15, 3890},
	{22775, 167388, 6, 1594},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 2, 3814},
	{23015, 167444, 15, 3890},
	{23030, 167448, 6, 1594},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{206, 880, 4, 3905},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 3909},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 9, 3914},
	{42914, 1280, 4, 3923},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
};

static const struct si_reg gfx7_reg_table[] = {
	{1003, 68, 9, 3927},
	{1016, 72, 24, 2762},
	{1031, 76, 3, 3936},
	{46952, 80, 11, 3939},
	{1068, 84, 4, 2800},
	{1086, 88, 2, 2804},
	{1104, 92, 4, 3950},
	{1119, 96},
	{1133, 100, 1, 2810},
	{1147, 104},
	{46966, 108},
	{46983, 112, 13, 2811},
	{46999, 2480},
	{47014, 2484, 1, 2824},
	{47029, 2488},
	{47044, 2492, 1, 2824},
	{1302, 2496},
	{1316, 2500},
	{1330, 2504},
	{1344, 2508},
	{1358, 2512},
	{1372, 2516},
	{1386, 2520},
	{1400, 2524},
	{1414, 2528},
	{1428, 2532},
	{1442, 2536},
	{1457, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{47059, 3660, 21, 2825},
	{47072, 3664, 20, 2846},
	{47084, 3668, 16, 2866},
	{1647, 32776, 17, 3954},
	{1660, 32784, 24, 2904},
	{1672, 32788, 11, 2928},
	{1688, 32792, 11, 2928},
	{1717, 32824, 11, 2928},
	{1733, 32828, 11, 2928},
	{1749, 33296, 16, 3971},
	{1763, 33300, 28, 204},
	{1780, 33304, 17, 3987},
	{1801, 33308, 18, 4004},
	{1815, 33312, 31, 4022},
	{1832, 33316, 7, 4053},
	{50605, 33320, 1, 3202},
	{1871, 33324, 1, 329},
	{1894, 33344, 1, 1704},
	{1915, 33348},
	{1976, 33436, 1, 342},
	{49549, 36352},
	{49570, 36356, 1, 3506},
	{2124, 36360, 9, 4060},
	{2145, 36364, 3, 3515},
	{49591, 36368, 2, 3518},
	{50620, 36372, 2, 4069},
	{50642, 36376, 1, 4071},
	{2103, 36400, 2, 3520},
	{2193, 36404, 5, 4072},
	{49617, 36408, 15, 3527},
	{2172, 36412, 1, 3542},
	{49638, 36416},
	{49659, 36424, 1, 3543},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 14, 3568},
	{3335, 36624},
	{3353, 36628, 5, 3582},
	{3371, 36632, 4, 3587},
	{3389, 36636, 11, 3591},
	{3407, 36640, 2, 3602},
	{3425, 36644, 2, 3604},
	{3443, 36648, 4, 3606},
	{3461, 36652},
	{2452, 36656, 13, 3610},
	{2470, 36660, 4, 411},
	{2488, 36664, 9, 3623},
	{2506, 36668, 3, 3632},
	{2524, 37120, 6, 429},
	{2540, 39160, 9, 3635},
	{2555, 39184, 5, 3645},
	{2569, 39188, 5, 3645},
	{2583, 39192, 5, 3645},
	{2597, 39196, 5, 3645},
	{2611, 39200, 5, 3645},
	{2625, 39204, 5, 3645},
	{2639, 39208, 5, 3645},
	{2653, 39212, 5, 3645},
	{2667, 39216, 5, 3645},
	{2681, 39220, 5, 3645},
	{2695, 39224, 5, 3645},
	{2710, 39228, 5, 3645},
	{2725, 39232, 5, 3645},
	{2740, 39236, 5, 3645},
	{2755, 39240, 5, 3645},
	{2770, 39244, 5, 3645},
	{2785, 39248, 5, 3645},
	{2800, 39252, 5, 3645},
	{2815, 39256, 5, 3645},
	{2830, 39260, 5, 3645},
	{2845, 39264, 5, 3645},
	{2860, 39268, 5, 3645},
	{2875, 39272, 5, 3645},
	{2890, 39276, 5, 3645},
	{2905, 39280, 5, 3645},
	{2920, 39284, 5, 3645},
	{2935, 39288, 5, 3645},
	{2950, 39292, 5, 3645},
	{2965, 39296, 5, 3645},
	{2980, 39300, 5, 3645},
	{2995, 39304, 5, 3645},
	{3010, 39308, 5, 3645},
	{3025, 39312, 4, 448},
	{3044, 39316, 4, 448},
	{3063, 39320, 4, 448},
	{3082, 39324, 4, 448},
	{3101, 39328, 4, 448},
	{3120, 39332, 4, 448},
	{3139, 39336, 4, 448},
	{3158, 39340, 4, 448},
	{3177, 39344, 4, 448},
	{3196, 39348, 4, 448},
	{3215, 39352, 4, 448},
	{3235, 39356, 4, 448},
	{3255, 39360, 4, 448},
	{3275, 39364, 4, 448},
	{3295, 39368, 4, 448},
	{3315, 39372, 4, 448},
	{49872, 45056},
	{49893, 45060, 1, 491},
	{49914, 45064},
	{49935, 45068, 1, 491},
	{3528, 45084, 3, 488},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 3650},
	{3618, 45100, 6, 503},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{49956, 45312},
	{49977, 45316, 1, 491},
	{49998, 45320},
	{50019, 45324, 1, 491},
	{4709, 45336, 3, 488},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 3667},
	{4824, 45356, 10, 540},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5893, 45552, 6, 563},
	{5920, 45556, 5, 569},
	{50040, 45568},
	{50061, 45572, 1, 491},
	{50082, 45576},
	{50103, 45580, 1, 491},
	{6108, 45596, 3, 488},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 11, 3689},
	{6198, 45612, 4, 554},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{7252, 45808, 6, 563},
	{50124, 45824},
	{50145, 45828, 1, 491},
	{50166, 45832},
	{50187, 45836, 1, 491},
	{7279, 45852, 3, 488},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7345, 45864, 12, 3667},
	{7369, 45868, 6, 563},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{7815, 46068, 5, 569},
	{50208, 46080},
	{50229, 46084, 1, 491},
	{50250, 46088},
	{50271, 46092, 1, 491},
	{8003, 46108, 2, 612},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 10, 3710},
	{8093, 46124, 6, 628},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{9147, 46324, 5, 569},
	{50292, 46336},
	{50313, 46340, 1, 491},
	{50334, 46344},
	{50355, 46348, 1, 491},
	{9174, 46364, 3, 488},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9240, 46376, 11, 3726},
	{9264, 46380, 5, 569},
	{9288, 46384},
	{9314, 46388},
	{9340, 46392},
	{9366, 46396},
	{9392, 46400},
	{9418, 46404},
	{9444, 46408},
	{9470, 46412},
	{9496, 46416},
	{9522, 46420},
	{9548, 46424},
	{9575, 46428},
	{9602, 46432},
	{9629, 46436},
	{9656, 46440},
	{9683, 46444},
	{9710, 47104, 12, 3742},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 2, 3755},
	{50396, 47160},
	{50411, 47164, 1, 663},
	{50426, 47168},
	{50441, 47172, 1, 663},
	{10097, 47176, 10, 3757},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 6, 688},
	{50456, 47192, 2, 3774},
	{50487, 47196, 2, 3774},
	{10224, 47200, 2, 694},
	{50670, 47204, 2, 3774},
	{50701, 47208, 2, 3774},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 4, 697},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{50518, 53300, 29, 3776},
	{50535, 55348, 29, 3776},
	{11086, 163840, 9, 719},
	{11104, 163844, 9, 3805},
	{11121, 163848, 4, 3814},
	{11135, 163852, 23, 747},
	{11154, 163856, 15, 770},
	{11174, 163860},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{50552, 163900, 7, 3818},
	{11364, 163904, 8, 3825},
	{11374, 163908, 5, 3833},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{50566, 163928, 2, 3838},
	{50580, 163932, 1, 3840},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13647, 164692, 3, 890},
	{13669, 164696, 2, 893},
	{13726, 164704, 1, 902},
	{50595, 164708, 1, 3841},
	{13757, 164712, 1, 904},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16530, 165444, 6, 949},
	{16550, 165448, 6, 949},
	{16570, 165452, 6, 949},
	{16590, 165456, 6, 949},
	{16610, 165460, 6, 949},
	{16630, 165464, 6, 949},
	{16650, 165468, 6, 949},
	{16670, 165472, 6, 949},
	{16690, 165476, 6, 949},
	{16710, 165480, 6, 949},
	{16730, 165484, 6, 949},
	{16751, 165488, 6, 949},
	{16772, 165492, 6, 949},
	{16793, 165496, 6, 949},
	{16814, 165500, 6, 949},
	{16835, 165504, 6, 949},
	{16856, 165508, 6, 949},
	{16877, 165512, 6, 949},
	{16898, 165516, 6, 949},
	{16919, 165520, 6, 949},
	{16940, 165524, 4, 961},
	{16961, 165528, 4, 961},
	{16982, 165532, 4, 961},
	{17003, 165536, 4, 961},
	{17024, 165540, 4, 961},
	{17045, 165544, 4, 961},
	{17066, 165548, 4, 961},
	{17087, 165552, 4, 961},
	{17108, 165556, 4, 961},
	{17129, 165560, 4, 961},
	{17150, 165564, 4, 961},
	{17171, 165568, 4, 961},
	{17192, 165572, 2, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 3, 3842},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17338, 165644, 4, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 3845},
	{17869, 165864},
	{17882, 165872, 5, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 3, 3846},
	{18007, 165900, 12, 1110},
	{18025, 165904, 19, 1127},
	{18041, 165908, 13, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 26, 1173},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 3849},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 1285},
	{18647, 166468, 2, 1300},
	{18666, 166472, 4, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 3853},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 7, 3858},
	{18906, 166528},
	{18917, 166532, 2, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 3865},
	{19000, 166548, 1, 1357},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 6, 1364},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 7, 3868},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19772, 166740, 6, 1404},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 8, 3875},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 2, 1446},
	{20148, 166804, 7, 3883},
	{20167, 166808, 4, 1457},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 4, 1477},
	{20285, 166880, 5, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 2, 3814},
	{21230, 167024, 15, 3890},
	{21245, 167028, 6, 1594},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 2, 3814},
	{21485, 167084, 15, 3890},
	{21500, 167088, 6, 1594},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 2, 3814},
	{21740, 167144, 15, 3890},
	{21755, 167148, 6, 1594},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 2, 3814},
	{21995, 167204, 15, 3890},
	{22010, 167208, 6, 1594},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 2, 3814},
	{22250, 167264, 15, 3890},
	{22265, 167268, 6, 1594},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 2, 3814},
	{22505, 167324, 15, 3890},
	{22520, 167328, 6, 1594},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 2, 3814},
	{22760, 167384, 15, 3890},
	{22775, 167388, 6, 1594},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 2, 3814},
	{23015, 167444, 15, 3890},
	{23030, 167448, 6, 1594},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{24232, 196608, 2, 3031},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 2, 3033},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 2, 3035},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 3, 4077},
	{26032, 196968},
	{26047, 196972},
	{26071, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 2, 3040},
	{26247, 197032, 1, 1644},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 2, 3043},
	{26319, 197048, 1, 1647},
	{26337, 197052},
	{26355, 197056, 2, 1649},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 1649},
	{26437, 197080, 5, 1651},
	{26457, 197084, 8, 4080},
	{26476, 197088, 8, 4080},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 23, 3051},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 4, 3074},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 9, 3080},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 9, 3080},
	{26795, 197160, 5, 3089},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 5, 2646},
	{26879, 197180, 1, 1704},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26925, 197192, 1, 1707},
	{26939, 197196, 1, 1708},
	{26953, 197200, 1, 1709},
	{26975, 197204, 1, 1710},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 4088},
	{27638, 197464, 4, 4092},
	{28338, 198656, 6, 2946},
	{28353, 198912},
	{28372, 198916},
	{28391, 198920, 1, 3329},
	{28410, 198924, 1, 3330},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 1786},
	{28686, 198976},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29784, 199968, 3, 3453},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 4096},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 9, 4100},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 1861},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{50732, 213504},
	{50751, 213508},
	{50770, 213512},
	{50789, 213516},
	{50808, 213520},
	{50827, 213524},
	{50846, 213528},
	{50865, 213532},
	{48222, 213536},
	{48241, 213540},
	{48260, 213544},
	{48279, 213548},
	{48298, 213552},
	{48317, 213556},
	{48336, 213560},
	{48355, 213564},
	{48775, 213568},
	{48795, 213572},
	{48815, 213576},
	{48835, 213580},
	{48855, 213584},
	{48875, 213588},
	{48895, 213592},
	{48915, 213596},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{50884, 216576},
	{50904, 216580},
	{50924, 216584},
	{50944, 216588},
	{50964, 216592},
	{50984, 216596},
	{51004, 216600},
	{51024, 216604},
	{51044, 216640},
	{51064, 216644},
	{51084, 216648},
	{51104, 216652},
	{51124, 216656},
	{51144, 216660},
	{51164, 216664},
	{51184, 216668},
	{51204, 216704},
	{51224, 216708},
	{51244, 216712},
	{51264, 216716},
	{51284, 216720},
	{51304, 216724},
	{51324, 216728},
	{51344, 216732},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{36322, 221184, 1, 1903},
	{36346, 221188, 2, 4109},
	{36371, 221192, 3, 4111},
	{36395, 221196, 1, 1903},
	{36419, 221200, 2, 4109},
	{36444, 221204, 1, 1903},
	{36468, 221208, 2, 4109},
	{36493, 221212, 3, 4111},
	{36517, 221216, 4, 1881},
	{36533, 221220, 3, 4111},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 19, 2989},
	{36842, 221444, 19, 2989},
	{36867, 221448, 12, 3008},
	{36895, 221452, 12, 3008},
	{36923, 221456, 12, 3008},
	{36951, 221460, 12, 3008},
	{51364, 221696, 2, 3287},
	{51387, 221700, 2, 3287},
	{51410, 221704, 2, 3287},
	{51433, 221708, 2, 3287},
	{48130, 221712, 5, 1957},
	{48153, 221716, 2, 3287},
	{48176, 221720, 2, 3287},
	{48199, 221724, 2, 3287},
	{51456, 221728, 4, 1962},
	{48679, 221744, 5, 1957},
	{48703, 221748, 5, 1957},
	{48727, 221752, 2, 3287},
	{48751, 221756, 2, 3287},
	{51480, 221760, 4, 1962},
	{51505, 221764, 4, 1962},
	{48653, 221776, 1, 3328},
	{37409, 222208, 3, 1957},
	{37435, 222212, 2, 1877},
	{37462, 222216, 3, 1957},
	{37488, 222220, 2, 1877},
	{37515, 222224, 2, 2013},
	{37568, 222228, 2, 2013},
	{37621, 222464, 3, 1957},
	{37647, 222468, 2, 1877},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 3, 1957},
	{37880, 222724, 3, 1957},
	{37904, 222728, 3, 1957},
	{37928, 222732, 3, 1957},
	{37952, 222736, 2, 1877},
	{37977, 222740, 2, 1877},
	{38002, 222744, 2, 1877},
	{38027, 222748, 2, 1877},
	{38052, 222752, 1, 2001},
	{38076, 222756, 1, 2001},
	{38100, 222760, 8, 1966},
	{38121, 222976, 6, 4114},
	{38144, 222980, 6, 4114},
	{38167, 222984, 6, 4114},
	{38190, 222988, 6, 4114},
	{38213, 222992, 6, 4114},
	{38236, 222996, 6, 4114},
	{38259, 223000, 6, 4114},
	{38282, 223004, 6, 4114},
	{38305, 223008, 6, 4114},
	{38328, 223012, 6, 4114},
	{38351, 223016, 6, 4114},
	{38375, 223020, 6, 4114},
	{38399, 223024, 6, 4114},
	{38423, 223028, 6, 4114},
	{38447, 223032, 6, 4114},
	{38471, 223036, 6, 4114},
	{38495, 223104, 9, 3469},
	{51530, 223108, 2, 3518},
	{38515, 223112, 1, 1987},
	{38610, 223488, 3, 1996},
	{38633, 223492, 3, 1996},
	{38656, 223496, 3, 1996},
	{38679, 223500, 3, 1996},
	{38702, 223504, 2, 1999},
	{38726, 223508, 2, 1999},
	{38750, 223744, 3, 1996},
	{38774, 223748, 3, 1996},
	{38798, 223752, 3, 1996},
	{38822, 223756, 3, 1996},
	{38846, 223760, 2, 1999},
	{38871, 224000, 5, 2001},
	{38894, 224004, 4, 2006},
	{38918, 224008, 5, 2001},
	{38941, 224256, 5, 2001},
	{38964, 224260, 4, 2006},
	{38988, 224264, 5, 2001},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{51550, 224768, 5, 1957},
	{51574, 224772, 4, 1951},
	{51599, 224776, 5, 1957},
	{51623, 224780, 4, 1951},
	{51648, 224784, 3, 2013},
	{51672, 224788, 3, 2013},
	{51696, 224832, 5, 1957},
	{51720, 224836, 4, 1951},
	{51745, 224840, 5, 1957},
	{51769, 224844, 4, 1951},
	{51794, 224848, 3, 2013},
	{51818, 224852, 3, 2013},
	{51842, 224896, 5, 1957},
	{51866, 224900, 4, 1951},
	{51891, 224904, 3, 2013},
	{51915, 224908, 3, 2013},
	{51939, 224912, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40291, 225812},
	{40314, 225816},
	{51963, 225820, 2, 4120},
	{51996, 225824, 2, 4120},
	{52029, 225828, 2, 4120},
	{52062, 225832, 2, 4120},
	{52094, 225836, 2, 4120},
	{52126, 225840, 2, 4120},
	{52158, 225844, 2, 4120},
	{52191, 225848, 2, 4120},
	{52223, 225856, 2, 4120},
	{52255, 225860, 2, 4120},
	{52288, 225864, 2, 4120},
	{52321, 225868, 2, 4120},
	{52354, 225872, 2, 4120},
	{52386, 225876, 2, 4120},
	{52418, 225880, 2, 4120},
	{52451, 225884, 2, 4120},
	{52484, 225888, 2, 4120},
	{52517, 225892, 2, 4120},
	{52550, 225896, 2, 4120},
	{40337, 225900},
	{40364, 225904},
	{40246, 225908},
	{40265, 225912},
	{52582, 225916, 2, 4120},
	{52616, 225920, 2, 4120},
	{52650, 225924, 2, 4120},
	{52684, 225928, 2, 4120},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 4122},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 9, 3914},
	{42914, 1280, 6, 4127},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
};

static const struct si_reg gfx8_reg_table[] = {
	{1003, 68, 10, 4133},
	{1016, 72, 23, 4143},
	{1031, 76, 4, 4166},
	{46952, 80, 11, 3939},
	{1068, 84, 4, 2800},
	{1086, 88, 2, 2804},
	{1104, 92, 6, 4170},
	{1119, 96},
	{1133, 100, 1, 2810},
	{1147, 104},
	{46966, 108},
	{46983, 112, 13, 4176},
	{1164, 116, 5, 4189},
	{46999, 2480},
	{47014, 2484, 1, 2824},
	{47029, 2488},
	{47044, 2492, 1, 2824},
	{1302, 2496},
	{1316, 2500},
	{1330, 2504},
	{1344, 2508},
	{1358, 2512},
	{1372, 2516},
	{1386, 2520},
	{1400, 2524},
	{1414, 2528},
	{1428, 2532},
	{1442, 2536},
	{1457, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{47059, 3660, 21, 2825},
	{47072, 3664, 20, 2846},
	{47084, 3668, 16, 2866},
	{1647, 32776, 18, 4194},
	{1660, 32784, 24, 2904},
	{1672, 32788, 11, 2928},
	{1688, 32792, 11, 2928},
	{1717, 32824, 11, 2928},
	{1733, 32828, 11, 2928},
	{1749, 33296, 15, 4212},
	{1763, 33300, 28, 204},
	{1780, 33304, 14, 4227},
	{1801, 33308, 21, 4241},
	{1815, 33312, 31, 4022},
	{1832, 33316, 9, 4262},
	{1871, 33324, 1, 329},
	{1894, 33344, 1, 330},
	{1915, 33348},
	{1976, 33436, 1, 342},
	{49638, 36416},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 14, 4271},
	{3335, 36624},
	{3353, 36628, 5, 4285},
	{3371, 36632, 4, 3587},
	{3389, 36636, 11, 3591},
	{3407, 36640, 2, 3602},
	{3425, 36644, 2, 3604},
	{3443, 36648, 8, 4290},
	{3461, 36652},
	{2452, 36656, 14, 4298},
	{2470, 36660, 4, 411},
	{2488, 36664, 10, 4312},
	{2506, 36668, 3, 3632},
	{2524, 37120, 6, 429},
	{2540, 39160, 9, 3635},
	{2555, 39184, 5, 3645},
	{2569, 39188, 5, 3645},
	{2583, 39192, 5, 3645},
	{2597, 39196, 5, 3645},
	{2611, 39200, 5, 3645},
	{2625, 39204, 5, 3645},
	{2639, 39208, 5, 3645},
	{2653, 39212, 5, 3645},
	{2667, 39216, 5, 3645},
	{2681, 39220, 5, 3645},
	{2695, 39224, 5, 3645},
	{2710, 39228, 5, 3645},
	{2725, 39232, 5, 3645},
	{2740, 39236, 5, 3645},
	{2755, 39240, 5, 3645},
	{2770, 39244, 5, 3645},
	{2785, 39248, 5, 3645},
	{2800, 39252, 5, 3645},
	{2815, 39256, 5, 3645},
	{2830, 39260, 5, 3645},
	{2845, 39264, 5, 3645},
	{2860, 39268, 5, 3645},
	{2875, 39272, 5, 3645},
	{2890, 39276, 5, 3645},
	{2905, 39280, 5, 3645},
	{2920, 39284, 5, 3645},
	{2935, 39288, 5, 3645},
	{2950, 39292, 5, 3645},
	{2965, 39296, 5, 3645},
	{2980, 39300, 5, 3645},
	{2995, 39304, 5, 3645},
	{3010, 39308, 5, 3645},
	{3025, 39312, 4, 448},
	{3044, 39316, 4, 448},
	{3063, 39320, 4, 448},
	{3082, 39324, 4, 448},
	{3101, 39328, 4, 448},
	{3120, 39332, 4, 448},
	{3139, 39336, 4, 448},
	{3158, 39340, 4, 448},
	{3177, 39344, 4, 448},
	{3196, 39348, 4, 448},
	{3215, 39352, 4, 448},
	{3235, 39356, 4, 448},
	{3255, 39360, 4, 448},
	{3275, 39364, 4, 448},
	{3295, 39368, 4, 448},
	{3315, 39372, 4, 448},
	{49872, 45056},
	{49893, 45060, 1, 491},
	{49914, 45064},
	{49935, 45068, 1, 491},
	{3528, 45084, 3, 488},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 3650},
	{3618, 45100, 6, 503},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{49956, 45312},
	{49977, 45316, 1, 491},
	{49998, 45320},
	{50019, 45324, 1, 491},
	{4709, 45336, 3, 488},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 3667},
	{4824, 45356, 11, 4322},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5893, 45552, 6, 563},
	{5920, 45556, 5, 569},
	{50040, 45568},
	{50061, 45572, 1, 491},
	{50082, 45576},
	{50103, 45580, 1, 491},
	{6108, 45596, 4, 576},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 11, 3689},
	{6198, 45612, 4, 554},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{7252, 45808, 6, 563},
	{50124, 45824},
	{50145, 45828, 1, 491},
	{50166, 45832},
	{50187, 45836, 1, 491},
	{7279, 45852, 4, 576},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7345, 45864, 12, 3667},
	{7369, 45868, 6, 563},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{7815, 46068, 5, 569},
	{50208, 46080},
	{50229, 46084, 1, 491},
	{50250, 46088},
	{50271, 46092, 1, 491},
	{8003, 46108, 3, 612},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 10, 3710},
	{8093, 46124, 6, 628},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{9147, 46324, 5, 569},
	{50292, 46336},
	{50313, 46340, 1, 491},
	{50334, 46344},
	{50355, 46348, 1, 491},
	{9174, 46364, 4, 576},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9240, 46376, 11, 3726},
	{9264, 46380, 5, 569},
	{9288, 46384},
	{9314, 46388},
	{9340, 46392},
	{9366, 46396},
	{9392, 46400},
	{9418, 46404},
	{9444, 46408},
	{9470, 46412},
	{9496, 46416},
	{9522, 46420},
	{9548, 46424},
	{9575, 46428},
	{9602, 46432},
	{9629, 46436},
	{9656, 46440},
	{9683, 46444},
	{9710, 47104, 12, 3742},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 2, 3755},
	{50396, 47160},
	{50411, 47164, 1, 663},
	{50426, 47168},
	{50441, 47172, 1, 663},
	{10097, 47176, 10, 3757},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 6, 688},
	{50456, 47192, 2, 3774},
	{50487, 47196, 2, 3774},
	{10224, 47200, 2, 694},
	{50670, 47204, 2, 3774},
	{50701, 47208, 2, 3774},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 5, 697},
	{10403, 47232},
	{10423, 47236},
	{10606, 47240, 3, 713},
	{10623, 47244},
	{10652, 47248, 1, 716},
	{52718, 47252, 2, 4333},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{11070, 47612},
	{50518, 53300, 29, 3776},
	{50535, 55348, 29, 3776},
	{11086, 163840, 10, 719},
	{11104, 163844, 9, 3805},
	{11121, 163848, 4, 3814},
	{11135, 163852, 23, 747},
	{11154, 163856, 15, 770},
	{11174, 163860},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{50552, 163900, 7, 3818},
	{11364, 163904, 10, 4335},
	{11374, 163908, 6, 4345},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{50566, 163928, 2, 3838},
	{50580, 163932, 1, 3840},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13647, 164692, 3, 890},
	{13669, 164696, 2, 893},
	{13726, 164704, 1, 902},
	{50595, 164708, 1, 3841},
	{13757, 164712, 1, 904},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{13986, 164900, 3, 4351},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16530, 165444, 12, 949},
	{16550, 165448, 12, 949},
	{16570, 165452, 12, 949},
	{16590, 165456, 12, 949},
	{16610, 165460, 12, 949},
	{16630, 165464, 12, 949},
	{16650, 165468, 12, 949},
	{16670, 165472, 12, 949},
	{16690, 165476, 12, 949},
	{16710, 165480, 12, 949},
	{16730, 165484, 12, 949},
	{16751, 165488, 12, 949},
	{16772, 165492, 12, 949},
	{16793, 165496, 12, 949},
	{16814, 165500, 12, 949},
	{16835, 165504, 12, 949},
	{16856, 165508, 12, 949},
	{16877, 165512, 12, 949},
	{16898, 165516, 12, 949},
	{16919, 165520, 12, 949},
	{16940, 165524, 9, 961},
	{16961, 165528, 9, 961},
	{16982, 165532, 9, 961},
	{17003, 165536, 9, 961},
	{17024, 165540, 9, 961},
	{17045, 165544, 9, 961},
	{17066, 165548, 9, 961},
	{17087, 165552, 9, 961},
	{17108, 165556, 9, 961},
	{17129, 165560, 9, 961},
	{17150, 165564, 9, 961},
	{17171, 165568, 9, 961},
	{17192, 165572, 2, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 3, 3842},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17338, 165644, 4, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 3845},
	{17869, 165864},
	{17882, 165872, 5, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 3, 4354},
	{18007, 165900, 12, 1110},
	{18025, 165904, 19, 1127},
	{18041, 165908, 13, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 27, 4357},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 3849},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 4384},
	{18647, 166468, 2, 1300},
	{18666, 166472, 4, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 3853},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 7, 4399},
	{18906, 166528},
	{18917, 166532, 2, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 4406},
	{19000, 166548, 1, 1357},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 7, 4409},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 8, 4416},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19750, 166736, 3, 1399},
	{19772, 166740, 10, 1404},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 10, 4424},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 2, 1446},
	{20148, 166804, 7, 3883},
	{20167, 166808, 4, 1457},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 4, 1477},
	{20285, 166880, 5, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 2, 3814},
	{21230, 167024, 18, 4434},
	{21245, 167028, 6, 1594},
	{21262, 167032, 9, 1602},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21404, 167060},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 2, 3814},
	{21485, 167084, 18, 4434},
	{21500, 167088, 6, 1594},
	{21517, 167092, 9, 1602},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21659, 167120},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 2, 3814},
	{21740, 167144, 18, 4434},
	{21755, 167148, 6, 1594},
	{21772, 167152, 9, 1602},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21914, 167180},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 2, 3814},
	{21995, 167204, 18, 4434},
	{22010, 167208, 6, 1594},
	{22027, 167212, 9, 1602},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22169, 167240},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 2, 3814},
	{22250, 167264, 18, 4434},
	{22265, 167268, 6, 1594},
	{22282, 167272, 9, 1602},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22424, 167300},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 2, 3814},
	{22505, 167324, 18, 4434},
	{22520, 167328, 6, 1594},
	{22537, 167332, 9, 1602},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22679, 167360},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 2, 3814},
	{22760, 167384, 18, 4434},
	{22775, 167388, 6, 1594},
	{22792, 167392, 9, 1602},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22934, 167420},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 2, 3814},
	{23015, 167444, 18, 4434},
	{23030, 167448, 6, 1594},
	{23047, 167452, 9, 1602},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{23189, 167480},
	{24232, 196608, 1, 1627},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 1, 1629},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 1, 1631},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25534, 196852, 2, 4452},
	{25556, 196856, 2, 4452},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 5, 4454},
	{26032, 196968},
	{26047, 196972},
	{26071, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 2, 3040},
	{26247, 197032, 3, 4459},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 2, 3043},
	{26319, 197048, 3, 4462},
	{26337, 197052},
	{26355, 197056, 2, 1649},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 1649},
	{26437, 197080, 5, 1651},
	{26457, 197084, 8, 4465},
	{26476, 197088, 8, 4465},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 26, 4473},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 4, 3074},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 9, 3080},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 9, 3080},
	{26795, 197160, 5, 3089},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 4, 1700},
	{26879, 197180, 1, 1704},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26925, 197192, 1, 1707},
	{26939, 197196, 1, 1708},
	{26953, 197200, 1, 1709},
	{26975, 197204, 1, 1710},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{52747, 197228, 1, 1706},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 4499},
	{27638, 197464, 4, 4092},
	{27660, 197468, 1, 1740},
	{27804, 197552, 1, 1745},
	{27829, 197556, 1, 1745},
	{27853, 197560, 1, 1746},
	{27873, 197568},
	{27899, 197572, 1, 1628},
	{27928, 197576},
	{27953, 197580, 1, 1628},
	{27981, 197584},
	{28004, 197588, 1, 1628},
	{28030, 197592},
	{28052, 197596, 1, 1628},
	{28077, 197600},
	{28096, 197604, 1, 1628},
	{28118, 197608, 1, 1343},
	{28132, 197612},
	{28149, 197616, 1, 1628},
	{28169, 197620, 8, 1747},
	{28338, 198656, 6, 2946},
	{28353, 198912},
	{28372, 198916},
	{28391, 198920, 1, 3329},
	{28410, 198924, 1, 1343},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 1786},
	{28686, 198976},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{49549, 199872},
	{49570, 199876, 1, 3506},
	{2124, 199880, 8, 4060},
	{2145, 199884, 3, 3515},
	{49591, 199888, 2, 3518},
	{2172, 199892, 1, 3542},
	{49617, 199896, 15, 3527},
	{50620, 199900, 1, 4069},
	{50642, 199904},
	{2103, 199908, 2, 3520},
	{2193, 199912, 5, 4072},
	{49659, 199916, 1, 3543},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29784, 199968, 6, 1819},
	{29795, 199972, 2, 1826},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 1829},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 9, 4100},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 4503},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{50732, 213504},
	{50751, 213508},
	{50770, 213512},
	{50789, 213516},
	{50808, 213520},
	{50827, 213524},
	{50846, 213528},
	{50865, 213532},
	{48222, 213536},
	{48241, 213540},
	{48260, 213544},
	{48279, 213548},
	{48298, 213552},
	{48317, 213556},
	{48336, 213560},
	{48355, 213564},
	{48775, 213568},
	{48795, 213572},
	{48815, 213576},
	{48835, 213580},
	{48855, 213584},
	{48875, 213588},
	{48895, 213592},
	{48915, 213596},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{50884, 216576},
	{50904, 216580},
	{50924, 216584},
	{50944, 216588},
	{50964, 216592},
	{50984, 216596},
	{51004, 216600},
	{51024, 216604},
	{51044, 216640},
	{51064, 216644},
	{51084, 216648},
	{51104, 216652},
	{51124, 216656},
	{51144, 216660},
	{51164, 216664},
	{51184, 216668},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{36322, 221184, 1, 1903},
	{36346, 221188, 2, 4109},
	{36371, 221192, 3, 4111},
	{36395, 221196, 1, 1903},
	{36419, 221200, 2, 4109},
	{36444, 221204, 1, 1903},
	{36468, 221208, 2, 4109},
	{36493, 221212, 3, 4111},
	{36517, 221216, 4, 1881},
	{36533, 221220, 3, 4111},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 19, 2989},
	{36842, 221444, 19, 2989},
	{36867, 221448, 12, 3008},
	{36895, 221452, 12, 3008},
	{36923, 221456, 12, 3008},
	{36951, 221460, 12, 3008},
	{51364, 221696, 2, 3287},
	{51387, 221700, 2, 3287},
	{51410, 221704, 2, 3287},
	{51433, 221708, 2, 3287},
	{48130, 221712, 5, 1957},
	{48153, 221716, 2, 3287},
	{48176, 221720, 2, 3287},
	{48199, 221724, 2, 3287},
	{51456, 221728, 4, 1962},
	{48679, 221744, 5, 1957},
	{48703, 221748, 5, 1957},
	{48727, 221752, 2, 3287},
	{48751, 221756, 2, 3287},
	{51480, 221760, 4, 1962},
	{51505, 221764, 4, 1962},
	{48653, 221776, 1, 3328},
	{37409, 222208, 3, 1957},
	{37435, 222212, 2, 1877},
	{37462, 222216, 3, 1957},
	{37488, 222220, 2, 1877},
	{37515, 222224, 2, 2013},
	{37568, 222228, 2, 2013},
	{37621, 222464, 3, 1957},
	{37647, 222468, 2, 1877},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 3, 1957},
	{37880, 222724, 3, 1957},
	{37904, 222728, 3, 1957},
	{37928, 222732, 3, 1957},
	{37952, 222736, 2, 1877},
	{37977, 222740, 2, 1877},
	{38002, 222744, 2, 1877},
	{38027, 222748, 2, 1877},
	{38052, 222752, 1, 2001},
	{38076, 222756, 1, 2001},
	{38100, 222760, 8, 1966},
	{38121, 222976, 6, 3486},
	{38144, 222980, 6, 3486},
	{38167, 222984, 6, 3486},
	{38190, 222988, 6, 3486},
	{38213, 222992, 6, 3486},
	{38236, 222996, 6, 3486},
	{38259, 223000, 6, 3486},
	{38282, 223004, 6, 3486},
	{38305, 223008, 6, 3486},
	{38328, 223012, 6, 3486},
	{38351, 223016, 6, 3486},
	{38375, 223020, 6, 3486},
	{38399, 223024, 6, 3486},
	{38423, 223028, 6, 3486},
	{38447, 223032, 6, 3486},
	{38471, 223036, 6, 3486},
	{38495, 223104, 9, 3469},
	{51530, 223108, 2, 3518},
	{38515, 223112, 1, 1987},
	{38610, 223488, 3, 1996},
	{38633, 223492, 3, 1996},
	{38656, 223496, 3, 1996},
	{38679, 223500, 3, 1996},
	{38702, 223504, 2, 1999},
	{38726, 223508, 2, 1999},
	{38750, 223744, 3, 1996},
	{38774, 223748, 3, 1996},
	{38798, 223752, 3, 1996},
	{38822, 223756, 3, 1996},
	{38846, 223760, 2, 1999},
	{38871, 224000, 5, 2001},
	{38894, 224004, 4, 2006},
	{38918, 224008, 5, 2001},
	{38941, 224256, 5, 2001},
	{38964, 224260, 4, 2006},
	{38988, 224264, 5, 2001},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{51550, 224768, 5, 1957},
	{51574, 224772, 4, 1951},
	{51599, 224776, 5, 1957},
	{51623, 224780, 4, 1951},
	{51648, 224784, 3, 2013},
	{51672, 224788, 3, 2013},
	{51696, 224832, 5, 1957},
	{51720, 224836, 4, 1951},
	{51745, 224840, 5, 1957},
	{51769, 224844, 4, 1951},
	{51794, 224848, 3, 2013},
	{51818, 224852, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40291, 225812},
	{40314, 225816},
	{51963, 225820, 2, 4120},
	{51996, 225824, 2, 4120},
	{52029, 225828, 2, 4120},
	{52062, 225832, 2, 4120},
	{52094, 225836, 2, 4120},
	{52126, 225840, 2, 4120},
	{52158, 225844, 2, 4120},
	{52191, 225848, 2, 4120},
	{52223, 225856, 2, 4120},
	{52255, 225860, 2, 4120},
	{52288, 225864, 2, 4120},
	{52321, 225868, 2, 4120},
	{52354, 225872, 2, 4120},
	{52386, 225876, 2, 4120},
	{52418, 225880, 2, 4120},
	{52451, 225884, 2, 4120},
	{52484, 225888, 2, 4120},
	{52550, 225896, 2, 4120},
	{40337, 225900},
	{40364, 225904},
	{40246, 225908},
	{40265, 225912},
	{52582, 225916, 2, 4120},
	{52616, 225920, 2, 4120},
	{52650, 225924, 2, 4120},
	{52684, 225928, 2, 4120},
	{41234, 226044, 1, 2129},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 4122},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 9, 3914},
	{42914, 1280, 6, 4127},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
};

static const struct si_reg gfx81_reg_table[] = {
	{1003, 68, 10, 4133},
	{1016, 72, 23, 4143},
	{1031, 76, 4, 4166},
	{46952, 80, 11, 3939},
	{1068, 84, 4, 2800},
	{1086, 88, 2, 2804},
	{1104, 92, 6, 4170},
	{1119, 96},
	{1133, 100, 1, 70},
	{1147, 104},
	{46966, 108},
	{46983, 112, 13, 4176},
	{1164, 116, 5, 4189},
	{46999, 2480},
	{47014, 2484, 1, 2824},
	{47029, 2488},
	{47044, 2492, 1, 2824},
	{1302, 2496},
	{1316, 2500},
	{1330, 2504},
	{1344, 2508},
	{1358, 2512},
	{1372, 2516},
	{1386, 2520},
	{1400, 2524},
	{1414, 2528},
	{1428, 2532},
	{1442, 2536},
	{1457, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{47059, 3660, 21, 2825},
	{47072, 3664, 20, 2846},
	{47084, 3668, 16, 2866},
	{1647, 32776, 18, 4194},
	{1660, 32784, 24, 2904},
	{1672, 32788, 11, 2928},
	{1688, 32792, 11, 2928},
	{1717, 32824, 11, 2928},
	{1733, 32828, 11, 2928},
	{1749, 33296, 15, 4212},
	{1763, 33300, 28, 204},
	{1780, 33304, 14, 4227},
	{1801, 33308, 21, 4241},
	{1815, 33312, 31, 4022},
	{1832, 33316, 9, 4262},
	{1871, 33324, 1, 329},
	{1894, 33344, 1, 330},
	{1915, 33348},
	{1976, 33436, 1, 342},
	{49638, 36416},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 14, 4271},
	{3335, 36624},
	{3353, 36628, 5, 4509},
	{3371, 36632, 4, 3587},
	{3389, 36636, 11, 3591},
	{3407, 36640, 2, 3602},
	{3425, 36644, 2, 3604},
	{3443, 36648, 8, 4290},
	{3461, 36652},
	{2452, 36656, 14, 4298},
	{2470, 36660, 4, 411},
	{2488, 36664, 10, 4312},
	{2506, 36668, 3, 3632},
	{2524, 37120, 6, 429},
	{2540, 39160, 9, 3635},
	{2555, 39184, 5, 3645},
	{2569, 39188, 5, 3645},
	{2583, 39192, 5, 3645},
	{2597, 39196, 5, 3645},
	{2611, 39200, 5, 3645},
	{2625, 39204, 5, 3645},
	{2639, 39208, 5, 3645},
	{2653, 39212, 5, 3645},
	{2667, 39216, 5, 3645},
	{2681, 39220, 5, 3645},
	{2695, 39224, 5, 3645},
	{2710, 39228, 5, 3645},
	{2725, 39232, 5, 3645},
	{2740, 39236, 5, 3645},
	{2755, 39240, 5, 3645},
	{2770, 39244, 5, 3645},
	{2785, 39248, 5, 3645},
	{2800, 39252, 5, 3645},
	{2815, 39256, 5, 3645},
	{2830, 39260, 5, 3645},
	{2845, 39264, 5, 3645},
	{2860, 39268, 5, 3645},
	{2875, 39272, 5, 3645},
	{2890, 39276, 5, 3645},
	{2905, 39280, 5, 3645},
	{2920, 39284, 5, 3645},
	{2935, 39288, 5, 3645},
	{2950, 39292, 5, 3645},
	{2965, 39296, 5, 3645},
	{2980, 39300, 5, 3645},
	{2995, 39304, 5, 3645},
	{3010, 39308, 5, 3645},
	{3025, 39312, 4, 448},
	{3044, 39316, 4, 448},
	{3063, 39320, 4, 448},
	{3082, 39324, 4, 448},
	{3101, 39328, 4, 448},
	{3120, 39332, 4, 448},
	{3139, 39336, 4, 448},
	{3158, 39340, 4, 448},
	{3177, 39344, 4, 448},
	{3196, 39348, 4, 448},
	{3215, 39352, 4, 448},
	{3235, 39356, 4, 448},
	{3255, 39360, 4, 448},
	{3275, 39364, 4, 448},
	{3295, 39368, 4, 448},
	{3315, 39372, 4, 448},
	{49872, 45056},
	{49893, 45060, 1, 491},
	{49914, 45064},
	{49935, 45068, 1, 491},
	{3528, 45084, 3, 488},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 3650},
	{3618, 45100, 6, 503},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{49956, 45312},
	{49977, 45316, 1, 491},
	{49998, 45320},
	{50019, 45324, 1, 491},
	{4709, 45336, 3, 488},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 3667},
	{4824, 45356, 11, 4322},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5893, 45552, 6, 563},
	{5920, 45556, 5, 569},
	{50040, 45568},
	{50061, 45572, 1, 491},
	{50082, 45576},
	{50103, 45580, 1, 491},
	{6108, 45596, 4, 576},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 11, 3689},
	{6198, 45612, 4, 554},
	{6222, 45616},
	{6248, 45620},
	{6274, 45624},
	{6300, 45628},
	{6326, 45632},
	{6352, 45636},
	{6378, 45640},
	{6404, 45644},
	{6430, 45648},
	{6456, 45652},
	{6482, 45656},
	{6509, 45660},
	{6536, 45664},
	{6563, 45668},
	{6590, 45672},
	{6617, 45676},
	{7252, 45808, 6, 563},
	{50124, 45824},
	{50145, 45828, 1, 491},
	{50166, 45832},
	{50187, 45836, 1, 491},
	{7279, 45852, 4, 576},
	{7303, 45856},
	{7324, 45860, 1, 491},
	{7345, 45864, 12, 3667},
	{7369, 45868, 6, 563},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{7815, 46068, 5, 569},
	{50208, 46080},
	{50229, 46084, 1, 491},
	{50250, 46088},
	{50271, 46092, 1, 491},
	{8003, 46108, 3, 612},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 10, 3710},
	{8093, 46124, 6, 628},
	{8117, 46128},
	{8143, 46132},
	{8169, 46136},
	{8195, 46140},
	{8221, 46144},
	{8247, 46148},
	{8273, 46152},
	{8299, 46156},
	{8325, 46160},
	{8351, 46164},
	{8377, 46168},
	{8404, 46172},
	{8431, 46176},
	{8458, 46180},
	{8485, 46184},
	{8512, 46188},
	{9147, 46324, 5, 569},
	{50292, 46336},
	{50313, 46340, 1, 491},
	{50334, 46344},
	{50355, 46348, 1, 491},
	{9174, 46364, 4, 576},
	{9198, 46368},
	{9219, 46372, 1, 491},
	{9240, 46376, 11, 3726},
	{9264, 46380, 5, 569},
	{9288, 46384},
	{9314, 46388},
	{9340, 46392},
	{9366, 46396},
	{9392, 46400},
	{9418, 46404},
	{9444, 46408},
	{9470, 46412},
	{9496, 46416},
	{9522, 46420},
	{9548, 46424},
	{9575, 46428},
	{9602, 46432},
	{9629, 46436},
	{9656, 46440},
	{9683, 46444},
	{9710, 47104, 12, 3742},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 2, 3755},
	{50396, 47160},
	{50411, 47164, 1, 663},
	{50426, 47168},
	{50441, 47172, 1, 663},
	{10097, 47176, 10, 3757},
	{10115, 47180, 11, 676},
	{10133, 47184, 1, 687},
	{10146, 47188, 6, 688},
	{50456, 47192, 2, 3774},
	{50487, 47196, 2, 3774},
	{10224, 47200, 2, 694},
	{50670, 47204, 2, 3774},
	{50701, 47208, 2, 3774},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 5, 697},
	{10403, 47232},
	{10423, 47236},
	{10606, 47240, 3, 713},
	{10623, 47244},
	{10652, 47248, 1, 716},
	{52718, 47252, 2, 4333},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{11070, 47612},
	{50518, 53300, 29, 3776},
	{50535, 55348, 29, 3776},
	{11086, 163840, 10, 719},
	{11104, 163844, 9, 3805},
	{11121, 163848, 4, 3814},
	{11135, 163852, 23, 747},
	{11154, 163856, 15, 770},
	{11174, 163860},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{50552, 163900, 7, 3818},
	{11364, 163904, 10, 4335},
	{11374, 163908, 6, 4345},
	{11390, 163912},
	{11405, 163916},
	{11426, 163920},
	{11442, 163924},
	{50566, 163928, 2, 3838},
	{50580, 163932, 1, 3840},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 875},
	{13647, 164692, 3, 890},
	{13669, 164696, 2, 893},
	{13726, 164704, 1, 902},
	{50595, 164708, 1, 3841},
	{13757, 164712, 1, 904},
	{13825, 164864},
	{13842, 164868},
	{13859, 164872},
	{13875, 164876},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{13986, 164900, 3, 4351},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16530, 165444, 12, 949},
	{16550, 165448, 12, 949},
	{16570, 165452, 12, 949},
	{16590, 165456, 12, 949},
	{16610, 165460, 12, 949},
	{16630, 165464, 12, 949},
	{16650, 165468, 12, 949},
	{16670, 165472, 12, 949},
	{16690, 165476, 12, 949},
	{16710, 165480, 12, 949},
	{16730, 165484, 12, 949},
	{16751, 165488, 12, 949},
	{16772, 165492, 12, 949},
	{16793, 165496, 12, 949},
	{16814, 165500, 12, 949},
	{16835, 165504, 12, 949},
	{16856, 165508, 12, 949},
	{16877, 165512, 12, 949},
	{16898, 165516, 12, 949},
	{16919, 165520, 12, 949},
	{16940, 165524, 9, 961},
	{16961, 165528, 9, 961},
	{16982, 165532, 9, 961},
	{17003, 165536, 9, 961},
	{17024, 165540, 9, 961},
	{17045, 165544, 9, 961},
	{17066, 165548, 9, 961},
	{17087, 165552, 9, 961},
	{17108, 165556, 9, 961},
	{17129, 165560, 9, 961},
	{17150, 165564, 9, 961},
	{17171, 165568, 9, 961},
	{17192, 165572, 2, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 3, 3842},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17338, 165644, 4, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17402, 165716, 8, 1024},
	{17420, 165720, 8, 1032},
	{17441, 165724, 17, 1040},
	{17462, 165728, 6, 1057},
	{17480, 165732, 6, 1057},
	{17498, 165736, 6, 1057},
	{17516, 165740, 6, 1057},
	{17534, 165744, 6, 1057},
	{17552, 165748, 6, 1057},
	{17570, 165752, 6, 1057},
	{17588, 165756, 6, 1057},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 3845},
	{17869, 165864},
	{17882, 165872, 5, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 4, 4514},
	{18007, 165900, 13, 1110},
	{18025, 165904, 19, 1127},
	{18041, 165908, 13, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 27, 4357},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 3849},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 4384},
	{18647, 166468, 2, 1300},
	{18666, 166472, 4, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 3853},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 7, 4399},
	{18906, 166528},
	{18917, 166532, 2, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 4406},
	{19000, 166548, 1, 1357},
	{19049, 166560},
	{19074, 166564},
	{19099, 166568, 7, 4409},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 8, 4416},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19750, 166736, 4, 4518},
	{19772, 166740, 10, 1404},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 10, 4424},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 2, 1446},
	{20148, 166804, 7, 3883},
	{20167, 166808, 4, 1457},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 4, 1477},
	{20285, 166880, 5, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21000, 166976, 1, 1527},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{21183, 167012, 2, 1569},
	{21199, 167016, 1, 1571},
	{21215, 167020, 2, 3814},
	{21230, 167024, 18, 4522},
	{21245, 167028, 6, 1594},
	{21262, 167032, 9, 1602},
	{21284, 167036},
	{21300, 167040, 1, 1614},
	{21322, 167044},
	{21338, 167048, 1, 1571},
	{21360, 167052},
	{21382, 167056},
	{21404, 167060},
	{21423, 167068},
	{21438, 167072, 2, 1569},
	{21454, 167076, 1, 1571},
	{21470, 167080, 2, 3814},
	{21485, 167084, 18, 4522},
	{21500, 167088, 6, 1594},
	{21517, 167092, 9, 1602},
	{21539, 167096},
	{21555, 167100, 1, 1614},
	{21577, 167104},
	{21593, 167108, 1, 1571},
	{21615, 167112},
	{21637, 167116},
	{21659, 167120},
	{21678, 167128},
	{21693, 167132, 2, 1569},
	{21709, 167136, 1, 1571},
	{21725, 167140, 2, 3814},
	{21740, 167144, 18, 4522},
	{21755, 167148, 6, 1594},
	{21772, 167152, 9, 1602},
	{21794, 167156},
	{21810, 167160, 1, 1614},
	{21832, 167164},
	{21848, 167168, 1, 1571},
	{21870, 167172},
	{21892, 167176},
	{21914, 167180},
	{21933, 167188},
	{21948, 167192, 2, 1569},
	{21964, 167196, 1, 1571},
	{21980, 167200, 2, 3814},
	{21995, 167204, 18, 4522},
	{22010, 167208, 6, 1594},
	{22027, 167212, 9, 1602},
	{22049, 167216},
	{22065, 167220, 1, 1614},
	{22087, 167224},
	{22103, 167228, 1, 1571},
	{22125, 167232},
	{22147, 167236},
	{22169, 167240},
	{22188, 167248},
	{22203, 167252, 2, 1569},
	{22219, 167256, 1, 1571},
	{22235, 167260, 2, 3814},
	{22250, 167264, 18, 4522},
	{22265, 167268, 6, 1594},
	{22282, 167272, 9, 1602},
	{22304, 167276},
	{22320, 167280, 1, 1614},
	{22342, 167284},
	{22358, 167288, 1, 1571},
	{22380, 167292},
	{22402, 167296},
	{22424, 167300},
	{22443, 167308},
	{22458, 167312, 2, 1569},
	{22474, 167316, 1, 1571},
	{22490, 167320, 2, 3814},
	{22505, 167324, 18, 4522},
	{22520, 167328, 6, 1594},
	{22537, 167332, 9, 1602},
	{22559, 167336},
	{22575, 167340, 1, 1614},
	{22597, 167344},
	{22613, 167348, 1, 1571},
	{22635, 167352},
	{22657, 167356},
	{22679, 167360},
	{22698, 167368},
	{22713, 167372, 2, 1569},
	{22729, 167376, 1, 1571},
	{22745, 167380, 2, 3814},
	{22760, 167384, 18, 4522},
	{22775, 167388, 6, 1594},
	{22792, 167392, 9, 1602},
	{22814, 167396},
	{22830, 167400, 1, 1614},
	{22852, 167404},
	{22868, 167408, 1, 1571},
	{22890, 167412},
	{22912, 167416},
	{22934, 167420},
	{22953, 167428},
	{22968, 167432, 2, 1569},
	{22984, 167436, 1, 1571},
	{23000, 167440, 2, 3814},
	{23015, 167444, 18, 4522},
	{23030, 167448, 6, 1594},
	{23047, 167452, 9, 1602},
	{23069, 167456},
	{23085, 167460, 1, 1614},
	{23107, 167464},
	{23123, 167468, 1, 1571},
	{23145, 167472},
	{23167, 167476},
	{23189, 167480},
	{24232, 196608, 1, 1627},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 1, 1629},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 1, 1631},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25534, 196852, 2, 4452},
	{25556, 196856, 2, 4452},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 5, 4454},
	{26032, 196968},
	{26047, 196972},
	{26071, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 2, 3040},
	{26247, 197032, 3, 4459},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 2, 3043},
	{26319, 197048, 3, 4462},
	{26337, 197052},
	{26355, 197056, 2, 1649},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 1649},
	{26437, 197080, 5, 1651},
	{26457, 197084, 8, 4465},
	{26476, 197088, 8, 4465},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 26, 4473},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 4, 3074},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 9, 3080},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 9, 3080},
	{26795, 197160, 5, 3089},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 4, 1700},
	{26879, 197180, 1, 1704},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26925, 197192, 1, 1707},
	{26939, 197196, 1, 1708},
	{26953, 197200, 1, 1709},
	{26975, 197204, 1, 1710},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{52747, 197228, 1, 1706},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 4499},
	{27638, 197464, 4, 4092},
	{27660, 197468, 1, 1740},
	{27804, 197552, 1, 1745},
	{27829, 197556, 1, 1745},
	{27853, 197560, 1, 1746},
	{27873, 197568},
	{27899, 197572, 1, 1628},
	{27928, 197576},
	{27953, 197580, 1, 1628},
	{27981, 197584},
	{28004, 197588, 1, 1628},
	{28030, 197592},
	{28052, 197596, 1, 1628},
	{28077, 197600},
	{28096, 197604, 1, 1628},
	{28118, 197608, 1, 1343},
	{28132, 197612},
	{28149, 197616, 1, 1628},
	{28169, 197620, 8, 1747},
	{28338, 198656, 6, 2946},
	{28353, 198912},
	{28372, 198916},
	{28391, 198920, 1, 3329},
	{28410, 198924, 1, 1343},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 1786},
	{28686, 198976},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{49549, 199872},
	{49570, 199876, 1, 3506},
	{2124, 199880, 8, 4060},
	{2145, 199884, 3, 3515},
	{49591, 199888, 2, 3518},
	{2172, 199892, 1, 3542},
	{49617, 199896, 15, 3527},
	{50620, 199900, 1, 4069},
	{50642, 199904},
	{2103, 199908, 2, 3520},
	{2193, 199912, 5, 4072},
	{49659, 199916, 1, 3543},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29784, 199968, 6, 1819},
	{29795, 199972, 2, 1826},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 1829},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 9, 4540},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 4503},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{50732, 213504},
	{50751, 213508},
	{50770, 213512},
	{50789, 213516},
	{50808, 213520},
	{50827, 213524},
	{50846, 213528},
	{50865, 213532},
	{48222, 213536},
	{48241, 213540},
	{48260, 213544},
	{48279, 213548},
	{48298, 213552},
	{48317, 213556},
	{48336, 213560},
	{48355, 213564},
	{48775, 213568},
	{48795, 213572},
	{48815, 213576},
	{48835, 213580},
	{48855, 213584},
	{48875, 213588},
	{48895, 213592},
	{48915, 213596},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{50884, 216576},
	{50904, 216580},
	{50924, 216584},
	{50944, 216588},
	{50964, 216592},
	{50984, 216596},
	{51004, 216600},
	{51024, 216604},
	{51044, 216640},
	{51064, 216644},
	{51084, 216648},
	{51104, 216652},
	{51124, 216656},
	{51144, 216660},
	{51164, 216664},
	{51184, 216668},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{36322, 221184, 1, 1903},
	{36346, 221188, 2, 4109},
	{36371, 221192, 3, 4111},
	{36395, 221196, 1, 1903},
	{36419, 221200, 2, 4109},
	{36444, 221204, 1, 1903},
	{36468, 221208, 2, 4109},
	{36493, 221212, 3, 4111},
	{36517, 221216, 4, 1881},
	{36533, 221220, 3, 4111},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 19, 2989},
	{36842, 221444, 19, 2989},
	{36867, 221448, 12, 3008},
	{36895, 221452, 12, 3008},
	{36923, 221456, 12, 3008},
	{36951, 221460, 12, 3008},
	{51364, 221696, 2, 3287},
	{51387, 221700, 2, 3287},
	{51410, 221704, 2, 3287},
	{51433, 221708, 2, 3287},
	{48130, 221712, 5, 1957},
	{48153, 221716, 2, 3287},
	{48176, 221720, 2, 3287},
	{48199, 221724, 2, 3287},
	{51456, 221728, 4, 1962},
	{48679, 221744, 5, 1957},
	{48703, 221748, 5, 1957},
	{48727, 221752, 2, 3287},
	{48751, 221756, 2, 3287},
	{51480, 221760, 4, 1962},
	{51505, 221764, 4, 1962},
	{48653, 221776, 1, 3328},
	{37409, 222208, 3, 1957},
	{37435, 222212, 2, 1877},
	{37462, 222216, 3, 1957},
	{37488, 222220, 2, 1877},
	{37515, 222224, 2, 2013},
	{37568, 222228, 2, 2013},
	{37621, 222464, 3, 1957},
	{37647, 222468, 2, 1877},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 3, 1957},
	{37880, 222724, 3, 1957},
	{37904, 222728, 3, 1957},
	{37928, 222732, 3, 1957},
	{37952, 222736, 2, 1877},
	{37977, 222740, 2, 1877},
	{38002, 222744, 2, 1877},
	{38027, 222748, 2, 1877},
	{38052, 222752, 1, 2001},
	{38076, 222756, 1, 2001},
	{38100, 222760, 8, 1966},
	{38121, 222976, 6, 3486},
	{38144, 222980, 6, 3486},
	{38167, 222984, 6, 3486},
	{38190, 222988, 6, 3486},
	{38213, 222992, 6, 3486},
	{38236, 222996, 6, 3486},
	{38259, 223000, 6, 3486},
	{38282, 223004, 6, 3486},
	{38305, 223008, 6, 3486},
	{38328, 223012, 6, 3486},
	{38351, 223016, 6, 3486},
	{38375, 223020, 6, 3486},
	{38399, 223024, 6, 3486},
	{38423, 223028, 6, 3486},
	{38447, 223032, 6, 3486},
	{38471, 223036, 6, 3486},
	{38495, 223104, 9, 3469},
	{51530, 223108, 2, 3518},
	{38515, 223112, 1, 1987},
	{38610, 223488, 3, 1996},
	{38633, 223492, 3, 1996},
	{38656, 223496, 3, 1996},
	{38679, 223500, 3, 1996},
	{38702, 223504, 2, 1999},
	{38726, 223508, 2, 1999},
	{38750, 223744, 3, 1996},
	{38774, 223748, 3, 1996},
	{38798, 223752, 3, 1996},
	{38822, 223756, 3, 1996},
	{38846, 223760, 2, 1999},
	{38871, 224000, 5, 2001},
	{38894, 224004, 4, 2006},
	{38918, 224008, 5, 2001},
	{38941, 224256, 5, 2001},
	{38964, 224260, 4, 2006},
	{38988, 224264, 5, 2001},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{51550, 224768, 5, 1957},
	{51574, 224772, 4, 1951},
	{51599, 224776, 5, 1957},
	{51623, 224780, 4, 1951},
	{51648, 224784, 3, 2013},
	{51672, 224788, 3, 2013},
	{51696, 224832, 5, 1957},
	{51720, 224836, 4, 1951},
	{51745, 224840, 5, 1957},
	{51769, 224844, 4, 1951},
	{51794, 224848, 3, 2013},
	{51818, 224852, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40291, 225812},
	{40314, 225816},
	{51963, 225820, 2, 4120},
	{51996, 225824, 2, 4120},
	{52029, 225828, 2, 4120},
	{52062, 225832, 2, 4120},
	{52094, 225836, 2, 4120},
	{52126, 225840, 2, 4120},
	{52158, 225844, 2, 4120},
	{52191, 225848, 2, 4120},
	{52223, 225856, 2, 4120},
	{52255, 225860, 2, 4120},
	{52288, 225864, 2, 4120},
	{52321, 225868, 2, 4120},
	{52354, 225872, 2, 4120},
	{52386, 225876, 2, 4120},
	{52418, 225880, 2, 4120},
	{52451, 225884, 2, 4120},
	{52484, 225888, 2, 4120},
	{52550, 225896, 2, 4120},
	{40337, 225900},
	{40364, 225904},
	{40246, 225908},
	{40265, 225912},
	{41234, 226044, 1, 2129},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 4122},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 9, 3914},
	{42914, 1280, 6, 4127},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
};

static const struct si_reg gfx9_reg_table[] = {
	{1003, 68, 14, 4549},
	{1016, 72, 23, 4563},
	{1031, 76, 7, 4586},
	{46952, 80, 11, 3939},
	{1068, 84, 4, 2800},
	{1086, 88, 2, 2804},
	{1104, 92, 7, 4593},
	{1119, 96},
	{1133, 100, 1, 70},
	{1147, 104},
	{46966, 108},
	{46983, 112, 13, 4600},
	{1164, 116, 7, 4613},
	{1180, 120},
	{1302, 2480},
	{1316, 2484},
	{1330, 2488},
	{1344, 2492},
	{1358, 2496},
	{1372, 2500},
	{1386, 2504},
	{1400, 2508},
	{1414, 2512},
	{1428, 2516},
	{1442, 2520},
	{1457, 2524},
	{1472, 2528},
	{1487, 2532},
	{1502, 2536},
	{1517, 2540},
	{1532, 2544},
	{1543, 2552},
	{1559, 2556},
	{1647, 32776, 25, 4620},
	{1660, 32784, 24, 4645},
	{1672, 32788, 12, 4669},
	{1688, 32792, 12, 4669},
	{1717, 32824, 12, 4669},
	{1733, 32828, 12, 4669},
	{1749, 33296, 16, 4681},
	{1763, 33300, 28, 204},
	{1780, 33304, 14, 232},
	{1801, 33308, 21, 4697},
	{1815, 33312, 31, 4022},
	{1832, 33316, 11, 307},
	{1871, 33324, 1, 329},
	{1894, 33344, 1, 330},
	{1915, 33348},
	{1935, 33352, 1, 332},
	{1976, 33436, 1, 342},
	{2380, 36608},
	{2398, 36612, 4, 383},
	{2416, 36616},
	{2434, 36620, 12, 4718},
	{3335, 36624},
	{3353, 36628, 8, 4730},
	{3371, 36632, 3, 3587},
	{3389, 36636, 8, 4738},
	{3407, 36640, 3, 4746},
	{3425, 36644, 7, 4749},
	{3443, 36648, 8, 4290},
	{3461, 36652},
	{2452, 36656, 14, 4298},
	{2470, 36660, 4, 411},
	{2488, 36664, 10, 4756},
	{2506, 36668, 3, 4766},
	{2540, 39160, 13, 4769},
	{2555, 39184, 5, 3645},
	{2569, 39188, 5, 3645},
	{2583, 39192, 5, 3645},
	{2597, 39196, 5, 3645},
	{2611, 39200, 5, 3645},
	{2625, 39204, 5, 3645},
	{2639, 39208, 5, 3645},
	{2653, 39212, 5, 3645},
	{2667, 39216, 5, 3645},
	{2681, 39220, 5, 3645},
	{2695, 39224, 5, 3645},
	{2710, 39228, 5, 3645},
	{2725, 39232, 5, 3645},
	{2740, 39236, 5, 3645},
	{2755, 39240, 5, 3645},
	{2770, 39244, 5, 3645},
	{2785, 39248, 5, 3645},
	{2800, 39252, 5, 3645},
	{2815, 39256, 5, 3645},
	{2830, 39260, 5, 3645},
	{2845, 39264, 5, 3645},
	{2860, 39268, 5, 3645},
	{2875, 39272, 5, 3645},
	{2890, 39276, 5, 3645},
	{2905, 39280, 5, 3645},
	{2920, 39284, 5, 3645},
	{2935, 39288, 5, 3645},
	{2950, 39292, 5, 3645},
	{2965, 39296, 5, 3645},
	{2980, 39300, 5, 3645},
	{2995, 39304, 5, 3645},
	{3010, 39308, 5, 3645},
	{3025, 39312, 4, 448},
	{3044, 39316, 4, 448},
	{3063, 39320, 4, 448},
	{3082, 39324, 4, 448},
	{3101, 39328, 4, 448},
	{3120, 39332, 4, 448},
	{3139, 39336, 4, 448},
	{3158, 39340, 4, 448},
	{3177, 39344, 4, 448},
	{3196, 39348, 4, 448},
	{3215, 39352, 4, 448},
	{3235, 39356, 4, 448},
	{3255, 39360, 4, 448},
	{3275, 39364, 4, 448},
	{3295, 39368, 4, 448},
	{3315, 39372, 4, 448},
	{3528, 45084, 4, 4782},
	{3552, 45088},
	{3573, 45092, 1, 491},
	{3594, 45096, 11, 4786},
	{3618, 45100, 10, 4797},
	{3642, 45104},
	{3668, 45108},
	{3694, 45112},
	{3720, 45116},
	{3746, 45120},
	{3772, 45124},
	{3798, 45128},
	{3824, 45132},
	{3850, 45136},
	{3876, 45140},
	{3902, 45144},
	{3929, 45148},
	{3956, 45152},
	{3983, 45156},
	{4010, 45160},
	{4037, 45164},
	{4064, 45168},
	{4091, 45172},
	{4118, 45176},
	{4145, 45180},
	{4172, 45184},
	{4199, 45188},
	{4226, 45192},
	{4253, 45196},
	{4280, 45200},
	{4307, 45204},
	{4334, 45208},
	{4361, 45212},
	{4388, 45216},
	{4415, 45220},
	{4442, 45224},
	{4469, 45228},
	{4709, 45336, 4, 4782},
	{4733, 45340, 1, 527},
	{4758, 45344},
	{4779, 45348, 1, 491},
	{4800, 45352, 12, 4807},
	{4824, 45356, 14, 4819},
	{4848, 45360},
	{4874, 45364},
	{4900, 45368},
	{4926, 45372},
	{4952, 45376},
	{4978, 45380},
	{5004, 45384},
	{5030, 45388},
	{5056, 45392},
	{5082, 45396},
	{5108, 45400},
	{5135, 45404},
	{5162, 45408},
	{5189, 45412},
	{5216, 45416},
	{5243, 45420},
	{5270, 45424},
	{5297, 45428},
	{5324, 45432},
	{5351, 45436},
	{5378, 45440},
	{5405, 45444},
	{5432, 45448},
	{5459, 45452},
	{5486, 45456},
	{5513, 45460},
	{5540, 45464},
	{5567, 45468},
	{5594, 45472},
	{5621, 45476},
	{5648, 45480},
	{5675, 45484},
	{5866, 45552, 9, 554},
	{5972, 45572, 2, 4833},
	{5996, 45576},
	{6028, 45580},
	{7303, 45584},
	{7324, 45588, 1, 491},
	{6108, 45596, 4, 4782},
	{6132, 45600},
	{6153, 45604, 1, 491},
	{6174, 45608, 12, 4835},
	{6198, 45612, 9, 4847},
	{7393, 45872},
	{7419, 45876},
	{7445, 45880},
	{7471, 45884},
	{7497, 45888},
	{7523, 45892},
	{7549, 45896},
	{7575, 45900},
	{7601, 45904},
	{7627, 45908},
	{7653, 45912},
	{7680, 45916},
	{7707, 45920},
	{7734, 45924},
	{7761, 45928},
	{7788, 45932},
	{52763, 45936},
	{52790, 45940},
	{52817, 45944},
	{52844, 45948},
	{52871, 45952},
	{52898, 45956},
	{52925, 45960},
	{52952, 45964},
	{52979, 45968},
	{53006, 45972},
	{53033, 45976},
	{53060, 45980},
	{53087, 45984},
	{53114, 45988},
	{53141, 45992},
	{53168, 45996},
	{7867, 46084, 1, 4833},
	{7891, 46088},
	{7923, 46092},
	{9198, 46096},
	{9219, 46100, 1, 491},
	{8003, 46108, 4, 4856},
	{8027, 46112},
	{8048, 46116, 1, 491},
	{8069, 46120, 11, 4860},
	{8093, 46124, 7, 4871},
	{9288, 46128},
	{9314, 46132},
	{9340, 46136},
	{9366, 46140},
	{9392, 46144},
	{9418, 46148},
	{9444, 46152},
	{9470, 46156},
	{9496, 46160},
	{9522, 46164},
	{9548, 46168},
	{9575, 46172},
	{9602, 46176},
	{9629, 46180},
	{9656, 46184},
	{9683, 46188},
	{53195, 46192},
	{53222, 46196},
	{53249, 46200},
	{53276, 46204},
	{53303, 46208},
	{53330, 46212},
	{53357, 46216},
	{53384, 46220},
	{53411, 46224},
	{53438, 46228},
	{53465, 46232},
	{53492, 46236},
	{53519, 46240},
	{53546, 46244},
	{53573, 46248},
	{53600, 46252},
	{53627, 46384},
	{53657, 46388},
	{53687, 46392},
	{53717, 46396},
	{53747, 46400},
	{53777, 46404},
	{53807, 46408},
	{53837, 46412},
	{53867, 46416},
	{53897, 46420},
	{53927, 46424},
	{53958, 46428},
	{53989, 46432},
	{54020, 46436},
	{54051, 46440},
	{54082, 46444},
	{54113, 46448},
	{54144, 46452},
	{54175, 46456},
	{54206, 46460},
	{54237, 46464},
	{54268, 46468},
	{54299, 46472},
	{54330, 46476},
	{54361, 46480},
	{54392, 46484},
	{54423, 46488},
	{54454, 46492},
	{54485, 46496},
	{54516, 46500},
	{54547, 46504},
	{54578, 46508},
	{9710, 47104, 11, 4878},
	{9737, 47108},
	{9751, 47112},
	{9765, 47116},
	{9779, 47120},
	{9795, 47124},
	{9811, 47128},
	{9827, 47132, 2, 659},
	{9848, 47136, 2, 659},
	{9869, 47140, 2, 659},
	{9890, 47144, 1, 661},
	{9918, 47148, 1, 662},
	{9943, 47152},
	{9958, 47156, 1, 663},
	{9973, 47160},
	{10002, 47164, 1, 663},
	{10031, 47168},
	{10064, 47172, 1, 663},
	{10097, 47176, 11, 4889},
	{10115, 47180, 12, 4900},
	{10133, 47184, 1, 687},
	{10146, 47188, 7, 4912},
	{50456, 47192, 2, 3774},
	{50487, 47196, 2, 3774},
	{10224, 47200, 2, 694},
	{50670, 47204, 2, 3774},
	{50701, 47208, 2, 3774},
	{10299, 47212},
	{10317, 47216},
	{10335, 47220},
	{10353, 47224, 1, 696},
	{10381, 47228, 5, 697},
	{10403, 47232},
	{10423, 47236},
	{10606, 47240, 3, 713},
	{10623, 47244},
	{10652, 47248, 1, 716},
	{10584, 47252},
	{54609, 47252},
	{54640, 47256},
	{54671, 47260},
	{54702, 47264},
	{10699, 47360},
	{10719, 47364},
	{10739, 47368},
	{10759, 47372},
	{10779, 47376},
	{10799, 47380},
	{10819, 47384},
	{10839, 47388},
	{10859, 47392},
	{10879, 47396},
	{10899, 47400},
	{10920, 47404},
	{10941, 47408},
	{10962, 47412},
	{10983, 47416},
	{11004, 47420},
	{11049, 47608},
	{11070, 47612},
	{11086, 163840, 10, 719},
	{11104, 163844, 9, 3805},
	{11121, 163848, 5, 4919},
	{11135, 163852, 23, 747},
	{11154, 163856, 16, 770},
	{11174, 163860},
	{11586, 163864, 1, 830},
	{50566, 163868, 2, 786},
	{11210, 163872},
	{11230, 163876},
	{11250, 163880, 1, 788},
	{11267, 163884},
	{11282, 163888, 2, 789},
	{11306, 163892, 2, 791},
	{11364, 163896, 13, 4924},
	{11374, 163900, 8, 4937},
	{11390, 163904},
	{11500, 163908, 1, 830},
	{11405, 163912},
	{11518, 163916, 1, 830},
	{11426, 163920},
	{11542, 163924, 1, 830},
	{11442, 163928},
	{11561, 163932, 1, 830},
	{11330, 163936, 3, 793},
	{54733, 163944, 1, 4945},
	{54744, 163948, 1, 4945},
	{11632, 163968},
	{11648, 163972, 1, 840},
	{11667, 164328, 1, 841},
	{11688, 164332, 1, 841},
	{11709, 164336, 1, 841},
	{11730, 164340, 1, 841},
	{11751, 164344},
	{11769, 164348},
	{11787, 164352, 2, 842},
	{11807, 164356, 3, 844},
	{11831, 164360, 2, 847},
	{11855, 164364, 1, 849},
	{11875, 164368, 2, 844},
	{11895, 164372, 2, 847},
	{11915, 164376, 2, 844},
	{11935, 164380, 2, 847},
	{11955, 164384, 2, 844},
	{11975, 164388, 2, 847},
	{11995, 164392, 2, 844},
	{12015, 164396, 2, 847},
	{12035, 164400, 7, 850},
	{12050, 164404, 2, 857},
	{12079, 164408, 8, 859},
	{12094, 164412, 8, 867},
	{12109, 164416, 3, 844},
	{12134, 164420, 2, 847},
	{12159, 164424},
	{12177, 164428},
	{12195, 164432, 3, 844},
	{12220, 164436, 2, 847},
	{12245, 164440, 3, 844},
	{12270, 164444, 2, 847},
	{12295, 164448, 3, 844},
	{12320, 164452, 2, 847},
	{12345, 164456, 3, 844},
	{12370, 164460, 2, 847},
	{12395, 164464, 3, 844},
	{12420, 164468, 2, 847},
	{12445, 164472, 3, 844},
	{12470, 164476, 2, 847},
	{12495, 164480, 3, 844},
	{12520, 164484, 2, 847},
	{12545, 164488, 3, 844},
	{12570, 164492, 2, 847},
	{12595, 164496, 3, 844},
	{12620, 164500, 2, 847},
	{12645, 164504, 3, 844},
	{12670, 164508, 2, 847},
	{12695, 164512, 3, 844},
	{12721, 164516, 2, 847},
	{12747, 164520, 3, 844},
	{12773, 164524, 2, 847},
	{12799, 164528, 3, 844},
	{12825, 164532, 2, 847},
	{12851, 164536, 3, 844},
	{12877, 164540, 2, 847},
	{12903, 164544, 3, 844},
	{12929, 164548, 2, 847},
	{12955, 164552, 3, 844},
	{12981, 164556, 2, 847},
	{13007, 164560},
	{13026, 164564},
	{13045, 164568},
	{13064, 164572},
	{13083, 164576},
	{13102, 164580},
	{13121, 164584},
	{13140, 164588},
	{13159, 164592},
	{13178, 164596},
	{13197, 164600},
	{13216, 164604},
	{13235, 164608},
	{13254, 164612},
	{13273, 164616},
	{13292, 164620},
	{13311, 164624},
	{13330, 164628},
	{13349, 164632},
	{13368, 164636},
	{13387, 164640},
	{13407, 164644},
	{13427, 164648},
	{13447, 164652},
	{13467, 164656},
	{13487, 164660},
	{13507, 164664},
	{13527, 164668},
	{13547, 164672},
	{13567, 164676},
	{13587, 164680},
	{13607, 164684},
	{13627, 164688, 15, 4946},
	{13647, 164692, 3, 4961},
	{13669, 164696, 2, 893},
	{13697, 164700, 3, 895},
	{13726, 164704, 1, 902},
	{13747, 164708, 1, 903},
	{13757, 164712, 1, 904},
	{13765, 164768, 4, 905},
	{13787, 164772, 4, 905},
	{13808, 164776, 4, 909},
	{13875, 164876},
	{13929, 164884},
	{13942, 164888},
	{13957, 164892},
	{13971, 164896},
	{13986, 164900, 9, 4964},
	{14025, 164908, 6, 935},
	{14044, 164912, 4, 941},
	{14062, 164916, 4, 945},
	{14083, 164924},
	{14102, 164928},
	{14122, 164932},
	{14141, 164936},
	{14161, 164940},
	{14180, 164944},
	{14200, 164948},
	{14221, 164952},
	{14243, 164956},
	{14264, 164960},
	{14286, 164964},
	{14307, 164968},
	{14329, 164972},
	{14350, 164976},
	{14372, 164980},
	{14393, 164984},
	{14415, 164988},
	{14436, 164992},
	{14458, 164996},
	{14479, 165000},
	{14501, 165004},
	{14522, 165008},
	{14544, 165012},
	{14565, 165016},
	{14587, 165020},
	{14608, 165024},
	{14630, 165028},
	{14651, 165032},
	{14673, 165036},
	{14694, 165040},
	{14716, 165044},
	{14737, 165048},
	{14759, 165052},
	{14780, 165056},
	{14802, 165060},
	{14823, 165064},
	{14845, 165068},
	{14866, 165072},
	{14888, 165076},
	{14909, 165080},
	{14931, 165084},
	{14952, 165088},
	{14974, 165092},
	{14995, 165096},
	{15017, 165100},
	{15038, 165104},
	{15060, 165108},
	{15081, 165112},
	{15103, 165116},
	{15124, 165120},
	{15146, 165124},
	{15167, 165128},
	{15189, 165132},
	{15210, 165136},
	{15232, 165140},
	{15253, 165144},
	{15275, 165148},
	{15296, 165152},
	{15318, 165156},
	{15339, 165160},
	{15361, 165164},
	{15383, 165168},
	{15406, 165172},
	{15428, 165176},
	{15451, 165180},
	{15473, 165184},
	{15496, 165188},
	{15518, 165192},
	{15541, 165196},
	{15563, 165200},
	{15586, 165204},
	{15608, 165208},
	{15631, 165212},
	{15653, 165216},
	{15676, 165220},
	{15698, 165224},
	{15721, 165228},
	{15743, 165232},
	{15766, 165236},
	{15788, 165240},
	{15811, 165244},
	{15833, 165248},
	{15856, 165252},
	{15878, 165256},
	{15901, 165260},
	{15923, 165264},
	{15946, 165268},
	{15968, 165272},
	{15991, 165276},
	{16013, 165280},
	{16036, 165284},
	{16058, 165288},
	{16081, 165292},
	{16103, 165296},
	{16126, 165300},
	{16148, 165304},
	{16171, 165308},
	{16185, 165312},
	{16199, 165316},
	{16213, 165320},
	{16227, 165324},
	{16241, 165328},
	{16255, 165332},
	{16269, 165336},
	{16283, 165340},
	{16297, 165344},
	{16311, 165348},
	{16325, 165352},
	{16339, 165356},
	{16353, 165360},
	{16367, 165364},
	{16381, 165368},
	{16395, 165372},
	{16409, 165376},
	{16423, 165380},
	{16437, 165384},
	{16451, 165388},
	{16465, 165392},
	{16479, 165396},
	{16493, 165400},
	{16507, 165404},
	{16530, 165444, 12, 949},
	{16550, 165448, 12, 949},
	{16570, 165452, 12, 949},
	{16590, 165456, 12, 949},
	{16610, 165460, 12, 949},
	{16630, 165464, 12, 949},
	{16650, 165468, 12, 949},
	{16670, 165472, 12, 949},
	{16690, 165476, 12, 949},
	{16710, 165480, 12, 949},
	{16730, 165484, 12, 949},
	{16751, 165488, 12, 949},
	{16772, 165492, 12, 949},
	{16793, 165496, 12, 949},
	{16814, 165500, 12, 949},
	{16835, 165504, 12, 949},
	{16856, 165508, 12, 949},
	{16877, 165512, 12, 949},
	{16898, 165516, 12, 949},
	{16919, 165520, 12, 949},
	{16940, 165524, 9, 961},
	{16961, 165528, 9, 961},
	{16982, 165532, 9, 961},
	{17003, 165536, 9, 961},
	{17024, 165540, 9, 961},
	{17045, 165544, 9, 961},
	{17066, 165548, 9, 961},
	{17087, 165552, 9, 961},
	{17108, 165556, 9, 961},
	{17129, 165560, 9, 961},
	{17150, 165564, 9, 961},
	{17171, 165568, 9, 961},
	{17192, 165572, 2, 970},
	{17210, 165580, 16, 973},
	{17227, 165584, 16, 973},
	{17245, 165588, 7, 989},
	{17266, 165592, 5, 996},
	{17284, 165600, 7, 1002},
	{17299, 165608, 2, 694},
	{17338, 165644, 4, 1010},
	{17360, 165648, 1, 1015},
	{17380, 165652, 8, 1016},
	{17402, 165716, 8, 1024},
	{17420, 165720, 8, 1032},
	{17441, 165724, 17, 1040},
	{17462, 165728, 6, 1057},
	{17480, 165732, 6, 1057},
	{17498, 165736, 6, 1057},
	{17516, 165740, 6, 1057},
	{17534, 165744, 6, 1057},
	{17552, 165748, 6, 1057},
	{17570, 165752, 6, 1057},
	{17588, 165756, 6, 1057},
	{17606, 165760, 9, 1063},
	{17624, 165764, 9, 1063},
	{17642, 165768, 9, 1063},
	{17660, 165772, 9, 1063},
	{17678, 165776, 9, 1063},
	{17696, 165780, 9, 1063},
	{17714, 165784, 9, 1063},
	{17732, 165788, 9, 1063},
	{54761, 165792, 1, 4945},
	{54776, 165796, 1, 4945},
	{54791, 165800, 1, 4945},
	{54806, 165804, 1, 4945},
	{54821, 165808, 1, 4945},
	{54836, 165812, 1, 4945},
	{54851, 165816, 1, 4945},
	{54866, 165820, 1, 4945},
	{17750, 165836, 1, 1072},
	{17764, 165840, 1, 1072},
	{17779, 165844},
	{17797, 165848},
	{17815, 165852},
	{17832, 165856},
	{17853, 165860, 1, 1073},
	{17869, 165864},
	{17882, 165872, 8, 1074},
	{17901, 165876},
	{17916, 165880, 1, 1082},
	{17965, 165888, 10, 1084},
	{17982, 165892, 12, 1094},
	{17990, 165896, 4, 4514},
	{18007, 165900, 16, 1110},
	{18025, 165904, 20, 1127},
	{18041, 165908, 15, 1147},
	{18060, 165912, 10, 1163},
	{18075, 165916, 28, 4973},
	{18093, 165920, 16, 1201},
	{18111, 165924, 4, 1217},
	{18135, 165928},
	{18160, 165932, 11, 1221},
	{18183, 165936, 6, 5001},
	{18212, 165940, 3, 5007},
	{18234, 165944, 2, 1241},
	{18249, 165948, 5, 1243},
	{18279, 165952, 6, 5010},
	{18312, 166400, 2, 1253},
	{18329, 166404, 2, 1255},
	{18348, 166408, 1, 1257},
	{18364, 166412, 4, 1258},
	{18383, 166416, 1, 1262},
	{18404, 166420, 1, 1263},
	{18417, 166424},
	{18440, 166428},
	{18463, 166432, 1, 1264},
	{18483, 166436, 4, 1265},
	{18503, 166440, 1, 1269},
	{18524, 166444, 1, 1270},
	{18539, 166448, 6, 1271},
	{18561, 166452, 6, 1271},
	{18583, 166456, 8, 1277},
	{18609, 166460, 8, 1277},
	{18635, 166464, 15, 4384},
	{18647, 166468, 3, 1300},
	{18666, 166472, 7, 1303},
	{18684, 166476, 24, 1310},
	{18702, 166480},
	{18714, 166484, 1, 1334},
	{18728, 166488, 1, 1335},
	{18742, 166492, 1, 1336},
	{18756, 166496, 1, 1337},
	{18779, 166500, 1, 1337},
	{18802, 166504, 1, 1337},
	{18825, 166508, 5, 1338},
	{18846, 166512},
	{18857, 166516},
	{18870, 166520},
	{18887, 166524, 7, 5016},
	{18906, 166528},
	{18917, 166532, 3, 1351},
	{18936, 166536},
	{18958, 166540},
	{18980, 166544, 3, 5023},
	{54881, 166548, 1, 5026},
	{19027, 166552, 4, 5027},
	{19049, 166560},
	{19074, 166564},
	{19118, 166572, 1, 1370},
	{19141, 166576, 1, 1370},
	{19164, 166580, 1, 1371},
	{19178, 166584, 1, 1372},
	{19193, 166588, 8, 5031},
	{19210, 166592, 4, 1382},
	{19237, 166596, 4, 1386},
	{19264, 166600, 4, 1390},
	{19283, 166608},
	{19309, 166612, 1, 1394},
	{19334, 166620},
	{19362, 166624},
	{19388, 166628, 1, 1394},
	{19413, 166636},
	{19441, 166640},
	{19467, 166644, 1, 1394},
	{19492, 166652},
	{19520, 166656},
	{19546, 166660, 1, 1394},
	{19571, 166668},
	{19599, 166696},
	{19630, 166700},
	{19673, 166704, 1, 1395},
	{19711, 166712, 1, 1396},
	{19750, 166736, 5, 1399},
	{19772, 166740, 13, 5039},
	{19793, 166744, 3, 1423},
	{19810, 166748, 1, 1370},
	{19831, 166752, 1, 1370},
	{19854, 166756, 1, 1370},
	{19877, 166760, 1, 1370},
	{19900, 166764, 8, 5052},
	{19913, 166768, 6, 1438},
	{19930, 166772},
	{19954, 166776, 2, 1444},
	{19984, 166780},
	{20008, 166784},
	{20038, 166788},
	{20069, 166792},
	{20098, 166796},
	{20128, 166800, 2, 1446},
	{20148, 166804, 8, 1449},
	{20167, 166808, 4, 1457},
	{20193, 166812, 3, 5023},
	{20217, 166868, 8, 1461},
	{20243, 166872, 8, 1469},
	{20269, 166876, 5, 1477},
	{20285, 166880, 6, 1482},
	{20301, 166884, 3, 1488},
	{20316, 166888},
	{20339, 166892},
	{20362, 166896},
	{20385, 166900},
	{20408, 166904, 8, 1491},
	{20442, 166908, 8, 1499},
	{20476, 166912, 8, 1507},
	{20510, 166916, 8, 1515},
	{20544, 166920, 8, 1491},
	{20578, 166924, 8, 1499},
	{20612, 166928, 8, 1507},
	{20646, 166932, 8, 1515},
	{20680, 166936, 8, 1491},
	{20714, 166940, 8, 1499},
	{20748, 166944, 8, 1507},
	{20782, 166948, 8, 1515},
	{20816, 166952, 8, 1491},
	{20850, 166956, 8, 1499},
	{20884, 166960, 8, 1507},
	{20918, 166964, 8, 1515},
	{20952, 166968, 2, 1523},
	{20976, 166972, 2, 1525},
	{21000, 166976, 3, 1527},
	{21021, 166980, 11, 5060},
	{21041, 166984, 2, 1543},
	{21061, 166988, 18, 5071},
	{21099, 166992, 1, 1565},
	{21119, 167000, 1, 1567},
	{21147, 167004, 1, 1568},
	{21168, 167008},
	{23208, 167012, 1, 1615},
	{23944, 167016, 3, 1616},
	{21215, 167020, 3, 5089},
	{21230, 167024, 16, 5092},
	{21245, 167028, 10, 5108},
	{21262, 167032, 11, 1602},
	{21284, 167036},
	{23360, 167040, 1, 1615},
	{21322, 167044},
	{23560, 167048, 1, 1615},
	{21360, 167052},
	{21382, 167056},
	{21404, 167060},
	{23760, 167064, 1, 1615},
	{21423, 167068},
	{23227, 167072, 1, 1615},
	{23962, 167076, 3, 1616},
	{21470, 167080, 3, 5089},
	{21485, 167084, 16, 5092},
	{21500, 167088, 10, 5108},
	{21517, 167092, 11, 1602},
	{21539, 167096},
	{23385, 167100, 1, 1615},
	{21577, 167104},
	{23585, 167108, 1, 1615},
	{21615, 167112},
	{21637, 167116},
	{21659, 167120},
	{23783, 167124, 1, 1615},
	{21678, 167128},
	{23246, 167132, 1, 1615},
	{23980, 167136, 3, 1616},
	{21725, 167140, 3, 5089},
	{21740, 167144, 16, 5092},
	{21755, 167148, 10, 5108},
	{21772, 167152, 11, 1602},
	{21794, 167156},
	{23410, 167160, 1, 1615},
	{21832, 167164},
	{23610, 167168, 1, 1615},
	{21870, 167172},
	{21892, 167176},
	{21914, 167180},
	{23806, 167184, 1, 1615},
	{21933, 167188},
	{23265, 167192, 1, 1615},
	{23998, 167196, 3, 1616},
	{21980, 167200, 3, 5089},
	{21995, 167204, 16, 5092},
	{22010, 167208, 10, 5108},
	{22027, 167212, 11, 1602},
	{22049, 167216},
	{23435, 167220, 1, 1615},
	{22087, 167224},
	{23635, 167228, 1, 1615},
	{22125, 167232},
	{22147, 167236},
	{22169, 167240},
	{23829, 167244, 1, 1615},
	{22188, 167248},
	{23284, 167252, 1, 1615},
	{24016, 167256, 3, 1616},
	{22235, 167260, 3, 5089},
	{22250, 167264, 16, 5092},
	{22265, 167268, 10, 5108},
	{22282, 167272, 11, 1602},
	{22304, 167276},
	{23460, 167280, 1, 1615},
	{22342, 167284},
	{23660, 167288, 1, 1615},
	{22380, 167292},
	{22402, 167296},
	{22424, 167300},
	{23852, 167304, 1, 1615},
	{22443, 167308},
	{23303, 167312, 1, 1615},
	{24034, 167316, 3, 1616},
	{22490, 167320, 3, 5089},
	{22505, 167324, 16, 5092},
	{22520, 167328, 10, 5108},
	{22537, 167332, 11, 1602},
	{22559, 167336},
	{23485, 167340, 1, 1615},
	{22597, 167344},
	{23685, 167348, 1, 1615},
	{22635, 167352},
	{22657, 167356},
	{22679, 167360},
	{23875, 167364, 1, 1615},
	{22698, 167368},
	{23322, 167372, 1, 1615},
	{24052, 167376, 3, 1616},
	{22745, 167380, 3, 5089},
	{22760, 167384, 16, 5092},
	{22775, 167388, 10, 5108},
	{22792, 167392, 11, 1602},
	{22814, 167396},
	{23510, 167400, 1, 1615},
	{22852, 167404},
	{23710, 167408, 1, 1615},
	{22890, 167412},
	{22912, 167416},
	{22934, 167420},
	{23898, 167424, 1, 1615},
	{22953, 167428},
	{23341, 167432, 1, 1615},
	{24070, 167436, 3, 1616},
	{23000, 167440, 3, 5089},
	{23015, 167444, 16, 5092},
	{23030, 167448, 10, 5108},
	{23047, 167452, 11, 1602},
	{23069, 167456},
	{23535, 167460, 1, 1615},
	{23107, 167464},
	{23735, 167468, 1, 1615},
	{23145, 167472},
	{23167, 167476},
	{23189, 167480},
	{23921, 167484, 1, 1615},
	{24232, 196608, 1, 1627},
	{24252, 196612, 1, 1628},
	{24272, 196616},
	{24292, 196620},
	{24312, 196624},
	{24333, 196628},
	{24354, 196632, 1, 1629},
	{24376, 196636, 1, 1630},
	{24398, 196640},
	{24428, 196644},
	{24458, 196648},
	{24487, 196652},
	{24516, 196656},
	{24546, 196660},
	{24576, 196664},
	{24605, 196668},
	{24634, 196672},
	{24664, 196676},
	{24694, 196680},
	{24723, 196684},
	{24752, 196688},
	{24782, 196692},
	{24812, 196696},
	{24841, 196700},
	{24870, 196704, 1, 1631},
	{24892, 196708, 1, 1632},
	{24914, 196712},
	{24937, 196716},
	{24960, 196720},
	{24983, 196724},
	{25006, 196728},
	{25029, 196732},
	{25052, 196736},
	{25076, 196740},
	{25100, 196744},
	{25124, 196748},
	{25148, 196752},
	{25172, 196756},
	{25196, 196760},
	{25220, 196764},
	{25244, 196768},
	{25266, 196772},
	{25288, 196776},
	{25309, 196780},
	{25330, 196784},
	{25354, 196788},
	{25378, 196792},
	{25402, 196796},
	{25426, 196800},
	{25450, 196804},
	{25534, 196852, 1, 4456},
	{25556, 196856, 1, 4456},
	{25578, 196860, 1, 1635},
	{25594, 196864},
	{25607, 196868},
	{25620, 196872},
	{25633, 196876},
	{25646, 196880},
	{25659, 196884},
	{25672, 196888},
	{25685, 196892},
	{25740, 196912},
	{25758, 196916},
	{25785, 196920},
	{25812, 196928, 2, 1636},
	{25825, 196932},
	{25838, 196936},
	{25861, 196940},
	{25884, 196944},
	{25912, 196948},
	{25940, 196952},
	{25968, 196956},
	{25996, 196960, 1, 1638},
	{26014, 196964, 4, 5118},
	{54911, 196968},
	{54929, 196972},
	{54956, 196976},
	{26095, 196980},
	{26114, 196984},
	{26133, 196988},
	{26157, 196992},
	{26181, 196996},
	{26205, 197000},
	{26229, 197028, 1, 1643},
	{26247, 197032, 2, 5122},
	{26265, 197036},
	{26283, 197040},
	{26301, 197044, 1, 1646},
	{26319, 197048, 2, 5124},
	{26337, 197052},
	{26355, 197056, 2, 1649},
	{26374, 197060, 5, 1651},
	{26393, 197072},
	{26417, 197076, 2, 1649},
	{26437, 197080, 5, 1651},
	{26457, 197084, 5, 5126},
	{26476, 197088, 5, 5126},
	{26494, 197092, 1, 1663},
	{26511, 197100, 1, 1664},
	{26532, 197104, 13, 1665},
	{26546, 197108},
	{26560, 197112},
	{26574, 197116, 2, 1678},
	{26590, 197120},
	{26609, 197124, 1, 1680},
	{26631, 197128},
	{26650, 197132, 1, 1681},
	{26672, 197136, 7, 1682},
	{26690, 197140},
	{26710, 197144, 1, 1680},
	{26733, 197148},
	{26753, 197152, 1, 1681},
	{26776, 197156, 7, 1682},
	{26795, 197160, 6, 5131},
	{26807, 197164, 2, 1696},
	{26824, 197168, 1, 1698},
	{26841, 197172, 1, 1699},
	{26859, 197176, 4, 1700},
	{26879, 197180, 1, 1704},
	{26896, 197184},
	{26912, 197188, 1, 1706},
	{26925, 197192, 1, 1707},
	{26939, 197196, 1, 1708},
	{26953, 197200, 1, 1709},
	{26975, 197204, 1, 1710},
	{26995, 197208, 1, 1711},
	{27017, 197212, 1, 1712},
	{27037, 197216, 1, 1707},
	{27054, 197220, 1, 1708},
	{27071, 197224},
	{52747, 197228, 1, 1706},
	{27219, 197364, 1, 1717},
	{27240, 197368, 1, 1718},
	{27260, 197372, 1, 1719},
	{27280, 197376, 1, 1718},
	{27297, 197380, 1, 1719},
	{27314, 197384, 1, 1720},
	{27330, 197388, 1, 1721},
	{27349, 197392, 1, 1722},
	{27368, 197396, 1, 1723},
	{27385, 197400, 1, 1724},
	{27403, 197404, 1, 1725},
	{27421, 197408, 1, 1726},
	{27437, 197412, 1, 1727},
	{27455, 197416, 1, 1728},
	{27473, 197420, 1, 1729},
	{27489, 197424, 1, 1724},
	{27504, 197428, 1, 1725},
	{27519, 197432, 1, 1726},
	{27532, 197436, 1, 1727},
	{27547, 197440, 1, 1728},
	{27562, 197444, 1, 1729},
	{27575, 197448, 1, 1730},
	{27589, 197452, 1, 1731},
	{27603, 197456, 1, 1732},
	{27615, 197460, 4, 5137},
	{27638, 197464, 3, 1737},
	{27660, 197468, 1, 1740},
	{27804, 197552, 1, 1745},
	{27829, 197556, 1, 1745},
	{27853, 197560, 1, 1746},
	{27873, 197568},
	{27899, 197572, 1, 1628},
	{27928, 197576},
	{27953, 197580, 1, 1628},
	{27981, 197584},
	{28004, 197588, 1, 1628},
	{28030, 197592},
	{28052, 197596, 1, 1628},
	{28077, 197600},
	{28096, 197604, 1, 1628},
	{28118, 197608, 1, 1343},
	{28132, 197612},
	{28149, 197616, 1, 1628},
	{28169, 197620, 8, 1747},
	{28186, 197624, 13, 1755},
	{28203, 197628},
	{28220, 197632, 1, 1698},
	{28240, 197636},
	{28257, 197640, 1, 1663},
	{28277, 197644, 2, 1768},
	{28296, 197888, 8, 5141},
	{28317, 197892, 8, 5141},
	{28338, 198656, 6, 2946},
	{28372, 198916},
	{28391, 198920, 1, 1784},
	{28410, 198924, 2, 5149},
	{28425, 198928},
	{28458, 198932},
	{28491, 198936},
	{28524, 198940},
	{13825, 198944},
	{13842, 198948},
	{13859, 198952},
	{19000, 198956, 2, 1357},
	{28614, 198960},
	{28630, 198964},
	{28648, 198968, 1, 1785},
	{28665, 198972, 2, 1786},
	{28686, 198976},
	{28980, 198980, 1, 830},
	{28724, 198984},
	{28740, 198988, 1, 830},
	{28759, 198992},
	{28779, 198996, 1, 830},
	{28802, 199000},
	{28820, 199004, 1, 830},
	{19099, 199008, 9, 1788},
	{28882, 199016},
	{29018, 199168, 1, 1809},
	{29043, 199172, 2, 1810},
	{29068, 199184, 2, 1812},
	{29094, 199188, 2, 1812},
	{29120, 199192, 2, 1812},
	{29146, 199212, 2, 1812},
	{29172, 199296, 2, 1814},
	{29200, 199300, 1, 1816},
	{29224, 199304, 1, 1817},
	{29248, 199308, 1, 1818},
	{29281, 199312, 1, 1818},
	{29309, 199328, 2, 1814},
	{29338, 199332, 1, 1816},
	{29363, 199336, 1, 1817},
	{29388, 199340, 1, 1818},
	{29422, 199344, 1, 1818},
	{29451, 199360, 2, 1814},
	{29475, 199364, 1, 1816},
	{29495, 199368, 1, 1817},
	{29515, 199372, 1, 1818},
	{29544, 199376, 1, 1818},
	{18294, 199380},
	{49549, 199872},
	{49570, 199876, 1, 3506},
	{2124, 199880, 7, 4060},
	{2145, 199884, 3, 3515},
	{49591, 199888, 2, 3518},
	{2172, 199892, 1, 3542},
	{49617, 199896, 15, 5151},
	{50620, 199900, 1, 4069},
	{50642, 199904},
	{2103, 199908, 2, 3520},
	{2193, 199912, 6, 5166},
	{49659, 199916, 1, 3543},
	{49638, 199920},
	{29568, 199936},
	{29595, 199940},
	{29622, 199944},
	{29649, 199948},
	{29784, 199968, 6, 1819},
	{29795, 199972, 2, 1826},
	{29809, 200192},
	{29828, 200196, 1, 840},
	{29850, 200448},
	{29874, 200452, 1, 1828},
	{29897, 200456},
	{29921, 200460, 1, 1828},
	{29944, 200464},
	{29968, 200468, 1, 1828},
	{29991, 200472},
	{30015, 200476, 1, 1828},
	{30038, 200696},
	{30057, 200700, 1, 1828},
	{30075, 200704},
	{30087, 200708},
	{30099, 200712},
	{30117, 200716},
	{30136, 200720},
	{30154, 200724},
	{30166, 200728},
	{30178, 200732},
	{30196, 200736},
	{30214, 200740},
	{30233, 200744, 4, 1829},
	{30247, 200748, 2, 1833},
	{30265, 200752, 2, 1835},
	{30279, 200756, 2, 1837},
	{30293, 200760, 2, 1839},
	{30310, 200764, 2, 1841},
	{30327, 200768},
	{30340, 200772, 2, 1843},
	{30352, 200776},
	{30366, 200780},
	{30382, 200784},
	{30396, 200788},
	{30412, 200792},
	{30427, 200796},
	{30444, 200800},
	{30459, 200804},
	{30476, 200808, 2, 1845},
	{30498, 200812, 10, 5172},
	{30515, 200816, 2, 1857},
	{30536, 200820, 2, 1859},
	{30548, 200824},
	{30563, 200828, 6, 4503},
	{30578, 200832, 2, 1867},
	{30592, 200836},
	{2524, 200960, 9, 429},
	{54983, 200964, 11, 5182},
	{55001, 200968, 2, 5193},
	{55019, 200972, 4, 5195},
	{30705, 212992},
	{30725, 212996},
	{30745, 213000},
	{30765, 213004},
	{30785, 213008},
	{30805, 213012},
	{30825, 213016},
	{30845, 213020},
	{30865, 213024},
	{30885, 213028},
	{30905, 213032},
	{30925, 213036},
	{30945, 213040},
	{30968, 213044},
	{30991, 213048},
	{31014, 213248},
	{31035, 213252},
	{31056, 213260},
	{31077, 213264},
	{31098, 213268},
	{31122, 213272},
	{31146, 213276},
	{31170, 213280},
	{31194, 213284},
	{31218, 213288},
	{31242, 213292},
	{31266, 213296},
	{50732, 213504},
	{50751, 213508},
	{50770, 213512},
	{50789, 213516},
	{50808, 213520},
	{50827, 213524},
	{50846, 213528},
	{50865, 213532},
	{48222, 213536},
	{48241, 213540},
	{48260, 213544},
	{48279, 213548},
	{48298, 213552},
	{48317, 213556},
	{48336, 213560},
	{48355, 213564},
	{48775, 213568},
	{48795, 213572},
	{48815, 213576},
	{48835, 213580},
	{48855, 213584},
	{48875, 213588},
	{48895, 213592},
	{48915, 213596},
	{31750, 214016},
	{31772, 214020, 1, 1869},
	{31794, 214024},
	{31816, 214028, 1, 1869},
	{31838, 214032},
	{31860, 214036, 1, 1869},
	{31882, 214040},
	{31904, 214044, 1, 1869},
	{31926, 214272},
	{31948, 214276},
	{31970, 214280},
	{31992, 214284},
	{32014, 214288},
	{32036, 214292},
	{32058, 214296},
	{32080, 214300},
	{32102, 214304},
	{32124, 214308},
	{32146, 214312},
	{32168, 214316},
	{32190, 214320},
	{32212, 214324},
	{32234, 214328},
	{32256, 214332},
	{32278, 214528},
	{32298, 214532},
	{32318, 214536},
	{32338, 214540},
	{32358, 214544},
	{32378, 214548},
	{32398, 214552},
	{32418, 214556},
	{32438, 214560},
	{32458, 214564},
	{32478, 214568},
	{32498, 214572},
	{32518, 214784},
	{32537, 214788},
	{32556, 214792},
	{32575, 214796},
	{32594, 214800},
	{32613, 214804},
	{32632, 214808},
	{32651, 214812},
	{32670, 214816},
	{32689, 214820},
	{32708, 214824},
	{32727, 214828},
	{32746, 214832},
	{32765, 214836},
	{32784, 214840},
	{32803, 214844},
	{32822, 214848},
	{32841, 214852},
	{32860, 214856},
	{32879, 214860},
	{32898, 214864},
	{32918, 214868},
	{32938, 214872},
	{32958, 214876},
	{32978, 214880},
	{32998, 214884},
	{33018, 214888},
	{33038, 214892},
	{33058, 214896},
	{33078, 214900},
	{33098, 214904},
	{33118, 214908},
	{33138, 215296},
	{33157, 215300},
	{33176, 215304},
	{33195, 215308},
	{33214, 215312},
	{33233, 215316},
	{33252, 215320},
	{33271, 215324},
	{33332, 215552},
	{33352, 215556},
	{33372, 215560},
	{33392, 215564},
	{33412, 215568},
	{33432, 215572},
	{33452, 215576},
	{33472, 215580},
	{33492, 215808},
	{33511, 215812},
	{33530, 215816},
	{33549, 215820},
	{33568, 216064},
	{33587, 216068},
	{33606, 216072},
	{33625, 216076},
	{33644, 216320},
	{33664, 216324},
	{33684, 216328},
	{33704, 216332},
	{33724, 216336},
	{33744, 216340},
	{33764, 216344},
	{33784, 216348},
	{50884, 216576},
	{50904, 216580},
	{50924, 216584},
	{50944, 216588},
	{50964, 216592},
	{50984, 216596},
	{51004, 216600},
	{51024, 216604},
	{51044, 216640},
	{51064, 216644},
	{51084, 216648},
	{51104, 216652},
	{51124, 216656},
	{51144, 216660},
	{51164, 216664},
	{51184, 216668},
	{34636, 217112},
	{34655, 217116},
	{34674, 217120},
	{34693, 217124},
	{34712, 217128},
	{34731, 217132},
	{34750, 217136},
	{34769, 217140},
	{34788, 217344},
	{34807, 217348},
	{34826, 217352},
	{34845, 217356},
	{34864, 217360},
	{34883, 217364},
	{34902, 217368},
	{34921, 217372},
	{34940, 217600},
	{34960, 217604},
	{34980, 217608},
	{35000, 217612},
	{35020, 217856},
	{35040, 217860},
	{35060, 217864},
	{35080, 217868},
	{35100, 217872},
	{35120, 217876},
	{35140, 217880},
	{35160, 217884},
	{35183, 218112},
	{35208, 218116, 2, 1870},
	{35232, 218144},
	{35258, 218148, 2, 1870},
	{36322, 221184, 5, 5199},
	{36346, 221188, 4, 5204},
	{36371, 221192, 5, 5199},
	{36395, 221196, 5, 5199},
	{36419, 221200, 4, 5204},
	{36444, 221204, 5, 5199},
	{36468, 221208, 4, 5204},
	{36493, 221212, 5, 5199},
	{36517, 221216, 4, 1881},
	{36533, 221220, 5, 5199},
	{36557, 221224, 3, 1885},
	{36591, 221228, 3, 1888},
	{36625, 221232, 3, 1891},
	{36650, 221236, 3, 1894},
	{36675, 221240, 3, 5208},
	{36700, 221248},
	{36715, 221252, 1, 1818},
	{36738, 221256},
	{36761, 221260},
	{36779, 221264, 2, 1897},
	{36797, 221268, 4, 1899},
	{36817, 221440, 22, 5211},
	{36842, 221444, 22, 5211},
	{36867, 221448, 13, 5233},
	{36895, 221452, 13, 5233},
	{36923, 221456, 13, 5233},
	{36951, 221460, 13, 5233},
	{51364, 221696, 2, 3287},
	{51387, 221700, 2, 3287},
	{51410, 221704, 2, 3287},
	{51433, 221708, 2, 3287},
	{48130, 221712, 5, 1957},
	{48153, 221716, 2, 3287},
	{48176, 221720, 2, 3287},
	{48199, 221724, 2, 3287},
	{51456, 221728, 4, 1962},
	{48679, 221744, 5, 1957},
	{48703, 221748, 5, 1957},
	{48727, 221752, 2, 3287},
	{48751, 221756, 2, 3287},
	{51480, 221760, 4, 1962},
	{51505, 221764, 4, 1962},
	{48653, 221776, 1, 3328},
	{37409, 222208, 5, 1957},
	{37435, 222212, 4, 1962},
	{37462, 222216, 5, 1957},
	{37488, 222220, 4, 1962},
	{37515, 222224, 3, 2013},
	{37568, 222228, 3, 2013},
	{37621, 222464, 5, 1957},
	{37647, 222468, 4, 1962},
	{37674, 222472, 1, 1872},
	{37700, 222476, 1, 1872},
	{37726, 222480, 1, 1872},
	{37752, 222484, 1, 1872},
	{37778, 222488, 1, 1872},
	{37804, 222492, 1, 1872},
	{37830, 222496, 1, 1872},
	{37856, 222720, 5, 1957},
	{37880, 222724, 5, 1957},
	{37904, 222728, 5, 1957},
	{37928, 222732, 5, 1957},
	{37952, 222736, 4, 1962},
	{37977, 222740, 4, 1962},
	{38002, 222744, 4, 1962},
	{38027, 222748, 4, 1962},
	{38052, 222752, 1, 2001},
	{38076, 222756, 1, 2001},
	{38100, 222760, 8, 1966},
	{38121, 222976, 6, 3486},
	{38144, 222980, 6, 3486},
	{38167, 222984, 6, 3486},
	{38190, 222988, 6, 3486},
	{38213, 222992, 6, 3486},
	{38236, 222996, 6, 3486},
	{38259, 223000, 6, 3486},
	{38282, 223004, 6, 3486},
	{38305, 223008, 6, 3486},
	{38328, 223012, 6, 3486},
	{38351, 223016, 6, 3486},
	{38375, 223020, 6, 3486},
	{38399, 223024, 6, 3486},
	{38423, 223028, 6, 3486},
	{38447, 223032, 6, 3486},
	{38471, 223036, 6, 3486},
	{38495, 223104, 9, 3469},
	{51530, 223108, 2, 3518},
	{38515, 223112, 1, 1987},
	{38610, 223488, 5, 1957},
	{38633, 223492, 5, 1957},
	{38656, 223496, 3, 2013},
	{38679, 223500, 3, 2013},
	{38702, 223504, 4, 1962},
	{38726, 223508, 4, 1962},
	{38750, 223744, 5, 1957},
	{38774, 223748, 5, 1957},
	{38798, 223752, 5, 1957},
	{38822, 223756, 5, 1957},
	{38846, 223760, 4, 1962},
	{38871, 224000, 5, 2001},
	{38894, 224004, 4, 2006},
	{38918, 224008, 3, 2010},
	{38941, 224256, 5, 2001},
	{38964, 224260, 4, 2006},
	{38988, 224264, 3, 2010},
	{39011, 224512, 5, 1957},
	{39035, 224516, 4, 1962},
	{39060, 224520, 5, 1957},
	{39084, 224524, 4, 1962},
	{39109, 224528, 3, 2013},
	{39133, 224532, 3, 2013},
	{51550, 224768, 5, 1957},
	{51574, 224772, 4, 1951},
	{51599, 224776, 5, 1957},
	{51623, 224780, 4, 1951},
	{51648, 224784, 3, 2013},
	{51672, 224788, 3, 2013},
	{51696, 224832, 5, 1957},
	{51720, 224836, 4, 1951},
	{51745, 224840, 5, 1957},
	{51769, 224844, 4, 1951},
	{51794, 224848, 3, 2013},
	{51818, 224852, 3, 2013},
	{39834, 225280, 12, 2016},
	{39856, 225284, 5, 2028},
	{39879, 225288, 4, 2033},
	{39903, 225292, 2, 2037},
	{39926, 225296, 2, 2037},
	{39949, 225300, 2, 2037},
	{39972, 225536, 5, 1957},
	{39995, 225540, 4, 1962},
	{40019, 225544, 5, 1957},
	{40042, 225548, 4, 1962},
	{40066, 225552, 5, 1957},
	{40089, 225560, 5, 1957},
	{40112, 225792, 4, 2039},
	{40133, 225796},
	{40162, 225800, 2, 2043},
	{40191, 225804},
	{40217, 225808, 7, 2045},
	{40291, 225812},
	{40314, 225816},
	{51963, 225820, 2, 4120},
	{51996, 225824, 2, 4120},
	{52029, 225828, 2, 4120},
	{52062, 225832, 2, 4120},
	{52094, 225836, 2, 4120},
	{52126, 225840, 2, 4120},
	{52158, 225844, 2, 4120},
	{52191, 225848, 2, 4120},
	{52223, 225856, 2, 4120},
	{52255, 225860, 2, 4120},
	{52288, 225864, 2, 4120},
	{52321, 225868, 2, 4120},
	{52354, 225872, 2, 4120},
	{52386, 225876, 2, 4120},
	{52418, 225880, 2, 4120},
	{52451, 225884, 2, 4120},
	{52484, 225888, 2, 4120},
	{52550, 225896, 2, 4120},
	{40337, 225900},
	{40364, 225904},
	{40246, 225908},
	{40265, 225912},
	{55039, 225932, 2, 4120},
	{55072, 225936, 2, 5246},
	{41255, 226040, 1, 2129},
	{41234, 226044, 1, 2129},
	{41027, 226048, 2, 2119},
	{41044, 226052, 1, 2121},
	{41068, 226056, 1, 2121},
	{41092, 226060, 4, 2122},
	{41118, 226064, 3, 2126},
	{41147, 226068, 1, 687},
	{41176, 226072, 3, 2126},
	{41205, 226076, 1, 687},
	{41282, 226304, 5, 2028},
	{41306, 226308, 4, 2033},
	{41331, 226312, 2, 2037},
	{41355, 226316, 5, 2028},
	{41379, 226320, 4, 2033},
	{41404, 226324, 2, 2037},
	{41428, 226328, 10, 2130},
	{41453, 226560, 5, 2140},
	{41480, 226564, 5, 2140},
	{41507, 226568, 6, 2145},
	{41538, 226608, 5, 2140},
	{41566, 226612, 5, 2140},
	{41594, 226616, 5, 2140},
	{41622, 226620, 5, 2140},
	{41650, 226624, 5, 2140},
	{41678, 226628, 5, 2140},
	{41706, 226632, 5, 2140},
	{41734, 226636, 5, 2140},
	{41762, 226640, 6, 2145},
	{206, 880, 4, 2156},
	{42813, 881},
	{26660, 882},
	{42825, 1008},
	{42836, 1009},
	{26848, 1010, 3, 2160},
	{42847, 1040, 1, 2163},
	{42860, 1041, 5, 2164},
	{42873, 1042, 1, 2169},
	{42886, 1043, 1, 1681},
	{26682, 1045, 7, 2170},
	{42914, 1280, 6, 2189},
	{42929, 1281},
	{26619, 1282},
	{42813, 1283},
	{26660, 1284},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{55105, 0xF},
	{55114, 0xF0},
	{55124, 0x100},
	{55135, 0x200},
	{55140, 0x400},
	{55267, 0x1FF000, 257, 0},
	{55275, 0x800000},
	{55285, 0x8000000},
	{55298, 0x10000000},
	{55304, 0xE0000000},
	/* 10 */
	{55308, 0x1},
	{55312, 0x6},
	{55321, 0x18},
	{55331, 0x20},
	{55336, 0x40},
	{55344, 0x80},
	{55354, 0x100},
	{55365, 0x200},
	{55371, 0x400},
	{55376, 0x800},
	{55382, 0x1000},
	{55393, 0x2000},
	{55398, 0x4000},
	{55403, 0x8000},
	{55154, 0x10000},
	{55418, 0x20000},
	{55426, 0x40000},
	{55438, 0x80000},
	{55446, 0x800000},
	{55457, 0x8000000},
	/* 30 */
	{55469, 0x1FF, 257, 0},
	{55474, 0x400},
	{55482, 0x800},
	{55495, 0x7000},
	{55503, 0x8000},
	{55514, 0xF0000},
	{55525, 0xF00000},
	{55541, 0x1000000},
	{55555, 0x10000000},
	{55567, 0xE0000000},
	/* 40 */
	{50388, 0xF},
	{55575, 0x30},
	{55583, 0xC0},
	{55591, 0xF00},
	{55597, 0x1000},
	{28897, 0x6000},
	{55603, 0x8000},
	{55615, 0xF0000},
	{55621, 0xF00000},
	{55627, 0x7000000},
	{55636, 0x38000000},
	{55645, 0xC0000000},
	/* 52 */
	{55651, 0xFF},
	{55661, 0xFF00},
	{55671, 0xFF0000},
	{55681, 0xF000000},
	/* 56 */
	{55691, 0x1FF},
	{55700, 0x1FF000},
	{55709, 0xF000000},
	/* 59 */
	{55726, 0xF},
	{55733, 0x70},
	{55741, 0x80},
	{55755, 0xF00},
	{55764, 0x7000},
	{55773, 0x8000},
	{55786, 0x3F0000},
	{55791, 0xC00000},
	{55801, 0x1000000},
	{55815, 0x2000000},
	{55827, 0xFC000000},
	/* 70 */
	{1141, 0xFFFF},
	/* 71 */
	{55555, 0x1},
	{55834, 0x2},
	{55840, 0x4},
	{55854, 0x8},
	{55869, 0x3F0},
	{55874, 0x1F800},
	{55786, 0xFC0000},
	{55879, 0x1000000},
	{55889, 0xFE000000},
	/* 80 */
	{50388, 0x1F},
	{55575, 0x300},
	{55898, 0x3C00},
	{55905, 0x10000},
	{28897, 0xC0000},
	/* 85 */
	{55627, 0xF},
	{55583, 0x30},
	{55645, 0x300},
	{55636, 0x7000},
	{55911, 0x1F0000},
	{55621, 0xF000000},
	{55917, 0x60000000},
	/* 92 */
	{55930, 0x1},
	{55938, 0x6},
	/* 94 */
	{55953, 0x3},
	/* 95 */
	{30361, 0x3F},
	{10110, 0xFC0},
	{10128, 0x3F000},
	{30336, 0xFC0000},
	/* 99 */
	{55962, 0x3},
	{55976, 0x80},
	{55994, 0x300},
	{56004, 0x400},
	{56017, 0x800},
	{55546, 0x1000},
	{56024, 0x2000},
	/* 106 */
	{56034, 0xF},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56163, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56263, 0x4000},
	{56278, 0x8000},
	{56289, 0x10000},
	{56297, 0x20000},
	{56306, 0x40000},
	{56323, 0x80000},
	{56338, 0x100000},
	{56351, 0x200000},
	{56361, 0x400000},
	{56378, 0x800000},
	{56395, 0x1000000},
	{56404, 0x2000000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	{56440, 0x80000000},
	/* 133 */
	{56451, 0xF},
	{56474, 0x20},
	{56490, 0x80},
	{56513, 0x100},
	{56536, 0x200},
	{56555, 0x1000},
	{56564, 0x2000},
	{56573, 0x4000},
	{56581, 0x8000},
	{56590, 0x10000},
	{56605, 0x100000},
	{56613, 0x200000},
	{56621, 0x400000},
	{56630, 0x800000},
	{56639, 0x1000000},
	{56647, 0x2000000},
	{56655, 0x4000000},
	{56663, 0x10000000},
	{56405, 0x20000000},
	{56681, 0x40000000},
	{56689, 0x80000000},
	/* 154 */
	{56555, 0x2},
	{56564, 0x4},
	{56700, 0x8},
	{56404, 0x10},
	{56711, 0x20},
	{56297, 0x200000},
	{56630, 0x400000},
	{56647, 0x1000000},
	{56573, 0x2000000},
	{56605, 0x4000000},
	{56621, 0x8000000},
	{56639, 0x20000000},
	{56655, 0x40000000},
	{56681, 0x80000000},
	/* 168 */
	{56722, 0x20},
	{56751, 0x40},
	{56782, 0x80},
	{56811, 0x100},
	{56831, 0x200},
	{56851, 0x400},
	{56871, 0x800},
	{56891, 0x2000},
	{56899, 0x4000},
	{56907, 0x8000},
	{56711, 0x10000},
	{56918, 0x10000000},
	{56932, 0x20000000},
	{56700, 0x40000000},
	{56941, 0x80000000},
	/* 183 */
	{56950, 0x1},
	{56960, 0x2},
	{56970, 0x4},
	{56979, 0x8},
	{56988, 0x10},
	{56999, 0x20},
	{57010, 0x40},
	{57020, 0x80},
	{57030, 0x400},
	{57040, 0x800},
	{57057, 0x1000},
	{57065, 0x2000},
	{57078, 0x4000},
	{57096, 0x8000},
	{57107, 0x10000},
	{57116, 0x20000},
	{57137, 0x40000},
	{57148, 0x80000},
	{57175, 0x20000000},
	{57188, 0x40000000},
	{56422, 0x80000000},
	/* 204 */
	{57201, 0x1},
	{57216, 0x2},
	{57236, 0x4},
	{57252, 0x8},
	{57270, 0x10},
	{57290, 0x20},
	{57309, 0x40},
	{57328, 0x80},
	{57341, 0x100},
	{57355, 0x200},
	{57379, 0x400},
	{57395, 0x800},
	{57411, 0x1000},
	{57427, 0x2000},
	{57443, 0x10000},
	{57458, 0x20000},
	{57478, 0x40000},
	{57494, 0x80000},
	{57512, 0x100000},
	{57532, 0x200000},
	{57551, 0x400000},
	{57570, 0x800000},
	{57583, 0x1000000},
	{57597, 0x2000000},
	{57621, 0x4000000},
	{57637, 0x8000000},
	{57653, 0x10000000},
	{57669, 0x20000000},
	/* 232 */
	{57685, 0x8},
	{57704, 0x10},
	{57724, 0x40},
	{57743, 0x100},
	{57764, 0x200},
	{57782, 0x400},
	{57805, 0x2000},
	{57827, 0x10000},
	{57848, 0x20000},
	{57866, 0x40000},
	{57889, 0x200000},
	{57911, 0x400000},
	{57935, 0x800000},
	{57959, 0x1000000},
	{57982, 0x2000000},
	/* 247 */
	{58004, 0x1},
	{58023, 0x2},
	{58032, 0x10},
	{58047, 0x20},
	{58061, 0x40},
	{58080, 0x80},
	{58099, 0x100},
	{58114, 0x200},
	{58131, 0x400},
	{58153, 0x800},
	{58175, 0x1000},
	{58190, 0x2000},
	{57030, 0x4000},
	{58205, 0x8000},
	{58214, 0x10000},
	{57065, 0x20000},
	{58223, 0x40000},
	{58233, 0x80000},
	{58247, 0x100000},
	{58261, 0x200000},
	{58275, 0x400000},
	{57096, 0x800000},
	{58292, 0x1000000},
	{58305, 0x4000000},
	{58318, 0x8000000},
	{58331, 0x30000000},
	{58350, 0x40000000},
	{56413, 0x80000000},
	/* 275 */
	{58363, 0x1},
	{58381, 0x2},
	{58395, 0x4},
	{58414, 0x8},
	{58433, 0x10},
	{58448, 0x20},
	{58466, 0x40},
	{58484, 0x80},
	{58501, 0x100},
	{58516, 0x200},
	{58530, 0x400},
	{58547, 0x800},
	{58571, 0x1000},
	{58589, 0x2000},
	{58607, 0x4000},
	{58628, 0x8000},
	{58652, 0x10000},
	{58678, 0x20000},
	{58695, 0x40000},
	{58715, 0x80000},
	{58735, 0x100000},
	{58755, 0x200000},
	{58776, 0x400000},
	{58799, 0x800000},
	{58820, 0x1000000},
	{58839, 0x2000000},
	{58856, 0x4000000},
	{58872, 0x8000000},
	{58888, 0x10000000},
	{58904, 0x20000000},
	{58923, 0x40000000},
	{58935, 0x80000000},
	/* 307 */
	{58947, 0x1},
	{58966, 0x2},
	{58986, 0x4},
	{59006, 0x8},
	{59026, 0x20},
	{59047, 0x40},
	{57911, 0x80},
	{57935, 0x100},
	{59068, 0x200},
	{59095, 0x400},
	{59122, 0x800},
	{59143, 0x1000},
	{59162, 0x2000},
	/* 320 */
	{59181, 0x1},
	{59195, 0x4},
	{59210, 0x8},
	{59227, 0x80},
	{59239, 0x100},
	{59252, 0x400},
	{59267, 0x800},
	{59282, 0x1000},
	{59297, 0x2000},
	/* 329 */
	{1883, 0x3F},
	/* 330 */
	{1901, 0x1FF},
	{59312, 0x80000000},
	/* 332 */
	{1883, 0x7},
	/* 333 */
	{59337, 0x1000},
	{59359, 0x4000},
	{59384, 0x20000},
	{59405, 0x40000},
	{59429, 0x400000},
	{59456, 0x800000},
	{59481, 0x1000000},
	{59504, 0x8000000},
	{59524, 0x40000000},
	/* 342 */
	{1888, 0xF},
	/* 343 */
	{10089, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{783, 0x1FFFFFFF},
	{59540, 0x80000000},
	/* 347 */
	{59550, 0x3},
	{59559, 0xF0},
	{59567, 0x200},
	{59574, 0x1FC00},
	/* 351 */
	{59845, 0xFFF, 2049, 257},
	{60007, 0xFF0000, 129, 2306},
	{60019, 0x3000000},
	{60032, 0x80000000},
	/* 355 */
	{1011, 0x3},
	{60047, 0x4},
	{60056, 0x8},
	{60067, 0x10},
	{60080, 0x20},
	{49675, 0x1C0},
	{60094, 0x200},
	{60107, 0x400},
	{60120, 0x800},
	{60132, 0x1000},
	{60150, 0x2000},
	{60161, 0xC000},
	{60176, 0x30000},
	{60184, 0x40000},
	{60203, 0x80000},
	{60220, 0x40000000},
	{60232, 0x80000000},
	/* 372 */
	{60246, 0xFFF},
	{60261, 0xFFF000},
	{60273, 0x1000000},
	{56284, 0x2000000},
	{60281, 0x4000000},
	{60301, 0x8000000},
	/* 378 */
	{13954, 0xF},
	{60389, 0x3F0, 33, 2435},
	{60393, 0x400},
	{60268, 0x800},
	{60399, 0x1000},
	/* 383 */
	{60402, 0xFFFF},
	{19704, 0x3FFF0000},
	{60418, 0x40000000},
	{60432, 0x80000000},
	/* 387 */
	{60447, 0x7},
	{60457, 0x38},
	{60467, 0x1C0},
	{60477, 0xE00},
	{17331, 0x7F000, 293, 2468},
	{64714, 0x600000},
	{64727, 0x800000},
	{64742, 0x1000000},
	{64848, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{64859, 0x7},
	{64867, 0x38},
	{64875, 0x1C0},
	{64883, 0xE00},
	{64899, 0x7000},
	{64918, 0x8000},
	{64937, 0x70000},
	{64953, 0x80000},
	{64968, 0x100000},
	{64982, 0x7E00000},
	{64993, 0x8000000},
	{65005, 0x10000000},
	{65023, 0x60000000},
	{65035, 0x80000000},
	/* 411 */
	{65048, 0xFFF},
	{65056, 0xFFF000},
	{65064, 0xF000000},
	{65073, 0xF0000000},
	/* 415 */
	{65080, 0x3FFF},
	{65089, 0xFFF},
	{65106, 0x3000},
	{65124, 0xFC000},
	{65137, 0x300000},
	{65151, 0xC00000},
	{65165, 0x3000000},
	{65174, 0xC000000},
	{65185, 0x10000000},
	{65204, 0x20000000},
	{65219, 0x40000000},
	{65234, 0x80000000},
	/* 427 */
	{65089, 0xFFF},
	{65106, 0xC0000000},
	/* 429 */
	{65250, 0x1FFFFF},
	{65269, 0xE00000},
	{65288, 0x1000000},
	{65310, 0x2000000},
	{65332, 0x4000000},
	{65348, 0x8000000},
	{65365, 0x10000000},
	{65383, 0x20000000},
	{65399, 0xC0000000},
	/* 438 */
	{65420, 0x7},
	{65430, 0x38},
	{65451, 0xC0},
	{65472, 0x180000},
	{65491, 0xC000000},
	/* 443 */
	{65861, 0x3C, 16, 2765},
	{66289, 0x7C0, 19, 2781},
	{66479, 0x3800, 7, 2800},
	{66638, 0x1C00000, 5, 2807},
	{66658, 0x6000000},
	/* 448 */
	{66763, 0x3, 4, 2812},
	{66870, 0xC, 4, 2816},
	{66982, 0x30, 4, 2820},
	{67069, 0xC0, 4, 2824},
	/* 452 */
	{60402, 0xFF},
	{65048, 0xFFF00},
	{17331, 0x1FF00000, 293, 2468},
	{67079, 0xC0000000},
	/* 456 */
	{67088, 0xFFF},
	{66875, 0xFFFC000},
	{64742, 0x80000000},
	/* 459 */
	{60447, 0x7},
	{60457, 0x38},
	{60467, 0x1C0},
	{60477, 0xE00},
	{67097, 0xF000},
	{67108, 0xF0000},
	{67119, 0x1F00000},
	{67223, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 468 */
	{18477, 0x1FFF},
	{67234, 0x1FFF0000},
	/* 470 */
	{67245, 0xF},
	{67257, 0xF0},
	{67265, 0xFFF00},
	{67278, 0x700000},
	{67287, 0x800000},
	{67302, 0x2000000},
	{67317, 0x4000000},
	/* 477 */
	{67329, 0xFF},
	{67345, 0x400},
	{67357, 0x18000},
	{67385, 0x60000},
	{67411, 0x80000},
	{67429, 0x100000},
	{67451, 0x200000},
	{67466, 0x400000},
	{67482, 0x800000},
	{67498, 0xFF000000},
	/* 487 */
	{67519, 0xFFFF},
	/* 488 */
	{67519, 0xFFFF},
	{67525, 0x3F0000},
	{67536, 0x3C00000},
	/* 491 */
	{67555, 0xFF},
	/* 492 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{67640, 0x1000000},
	{67657, 0x2000000},
	{56004, 0x4000000},
	{55275, 0x20000000},
	/* 503 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{67703, 0x80},
	{67715, 0xFF00},
	{55267, 0x1FF0000, 257, 0},
	{67730, 0x2000000},
	{67752, 0x4000000},
	{67777, 0x8000000},
	{67791, 0xF0000000},
	/* 513 */
	{67807, 0x1},
	{67824, 0x1E},
	{67850, 0x1E0},
	{67883, 0x200},
	{67904, 0x7C00},
	{67928, 0x8000},
	{67953, 0x10000},
	{67972, 0xE0000},
	/* 521 */
	{68009, 0x7},
	{68038, 0x38},
	{68070, 0x40},
	{68086, 0xFF00},
	{68115, 0xFF0000},
	/* 526 */
	{68147, 0x7F},
	/* 527 */
	{67530, 0x3F},
	/* 528 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{68174, 0x4000000},
	{67657, 0x8000000},
	{56004, 0x10000000},
	{55275, 0x80000000},
	/* 540 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68200, 0x100},
	{68212, 0x200},
	{68224, 0x400},
	{68236, 0x800},
	{68248, 0x1000},
	{55267, 0x3FE000, 257, 0},
	{68254, 0x400000},
	{68265, 0x1000000},
	{67777, 0x8000000},
	{67791, 0xF0000000},
	/* 554 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55267, 0xFF80, 257, 0},
	{68160, 0x30000},
	{68190, 0x40000},
	{55700, 0x7F80000},
	{68282, 0x8000000},
	{67777, 0x10000000},
	/* 563 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{55267, 0x1FF00, 257, 0},
	{55700, 0x1FF00000},
	/* 569 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55700, 0xFF80},
	{55267, 0x1FF0000, 257, 0},
	/* 574 */
	{67519, 0xFFFF},
	{68294, 0x7F0000},
	/* 576 */
	{67519, 0xFFFF},
	{67525, 0x3F0000},
	{67536, 0x3C00000},
	{68319, 0xFC000000},
	/* 580 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{68174, 0x1000000},
	{67657, 0x2000000},
	{56004, 0x4000000},
	{68336, 0x8000000},
	{68345, 0x60000000},
	{55275, 0x80000000},
	/* 593 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55267, 0xFF80, 257, 0},
	{68362, 0x30000},
	{68190, 0x40000},
	{55700, 0x7F80000},
	{67777, 0x8000000},
	{67791, 0xF0000000},
	/* 602 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{68174, 0x4000000},
	{55275, 0x80000000},
	/* 612 */
	{67525, 0x3F},
	{67536, 0x3C0},
	{68319, 0xFC00},
	{67519, 0xFFFF0000},
	/* 616 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{67657, 0x1000000},
	{56004, 0x2000000},
	{68336, 0x4000000},
	{68379, 0x30000000},
	{55275, 0x40000000},
	/* 628 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68396, 0x100},
	{55267, 0x3FE00, 257, 0},
	{55700, 0x7FC0000},
	{67777, 0x8000000},
	{67791, 0xF0000000},
	/* 637 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{55275, 0x40000000},
	/* 646 */
	{68407, 0x1},
	{68425, 0x2},
	{68439, 0x4},
	{68458, 0x8},
	{68478, 0x10},
	{68498, 0x20},
	{68520, 0x40},
	{68531, 0x400},
	{68549, 0x800},
	{10394, 0x1000},
	{68567, 0x2000},
	{68581, 0x4000},
	{68589, 0x8000},
	/* 659 */
	{68599, 0xFFFF},
	{68615, 0xFFFF0000},
	/* 661 */
	{9898, 0x1},
	/* 662 */
	{9926, 0x1},
	/* 663 */
	{402, 0xFF},
	/* 664 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{68634, 0x1000000},
	{55275, 0x4000000},
	{68336, 0x20000000},
	{67657, 0x40000000},
	{56004, 0x80000000},
	/* 676 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68640, 0x80},
	{68650, 0x100},
	{68660, 0x200},
	{68396, 0x400},
	{68670, 0x1800},
	{68685, 0x6000},
	{55700, 0xFF8000},
	{55267, 0x7F000000, 257, 0},
	/* 687 */
	{402, 0xF},
	/* 688 */
	{68697, 0x3FF},
	{68710, 0xF000},
	{68720, 0x3F0000},
	{68735, 0x400000},
	{68750, 0x800000},
	{68766, 0x7000000},
	/* 694 */
	{68781, 0xFFF},
	{68787, 0x1FFF000},
	/* 696 */
	{10361, 0x1},
	/* 697 */
	{68796, 0x3},
	{65944, 0x4},
	{68806, 0x8},
	{68816, 0x10},
	{68826, 0x1FFE0},
	/* 702 */
	{67807, 0x1},
	{67824, 0x1E},
	{67850, 0x1E0},
	{67883, 0x200},
	{67904, 0x7C00},
	{67928, 0x8000},
	{67953, 0x10000},
	{67972, 0xE0000},
	{68839, 0x7F00000},
	/* 711 */
	{67791, 0xF},
	/* 712 */
	{452, 0x7FF},
	/* 713 */
	{68876, 0x3FFFFFFF},
	{68884, 0x40000000},
	{68893, 0x80000000},
	/* 716 */
	{11643, 0xFFFF},
	/* 717 */
	{68902, 0x3FF},
	{59713, 0x400},
	/* 719 */
	{68912, 0x1},
	{68931, 0x2},
	{68952, 0x4},
	{68963, 0x8},
	{68976, 0x10},
	{68995, 0x20},
	{69020, 0x40},
	{69043, 0x80},
	{69057, 0xF00},
	{69069, 0x1000},
	/* 729 */
	{69087, 0x1},
	{69111, 0x2},
	{69132, 0x4},
	{69166, 0x8},
	{69201, 0x70},
	{69213, 0xF00},
	{69226, 0xF000},
	{69239, 0xF0000},
	{69252, 0xF00000},
	{69266, 0xF000000},
	{69284, 0xF0000000},
	/* 740 */
	{69301, 0x7FF},
	{69313, 0x1800},
	{69328, 0xFFE000},
	{69338, 0x1000000},
	{69350, 0x2000000},
	{69368, 0x3C000000},
	{69374, 0xC0000000},
	/* 747 */
	{69439, 0x3, 4, 3075},
	{69456, 0xC, 4, 3075},
	{69474, 0x30, 4, 3075},
	{69492, 0x40},
	{69513, 0x80},
	{69528, 0x100},
	{69549, 0x200},
	{69567, 0x400},
	{69584, 0x800},
	{69597, 0x1000},
	{69616, 0x6000, 4, 3075},
	{69635, 0x8000},
	{69659, 0x10000},
	{69682, 0x20000},
	{69699, 0x40000},
	{69784, 0x180000, 4, 3079},
	{69803, 0x3E00000},
	{69820, 0x4000000},
	{69844, 0x8000000},
	{69858, 0x10000000},
	{69878, 0x20000000},
	{69892, 0x40000000},
	{69912, 0x80000000},
	/* 770 */
	{69986, 0x3, 4, 3083},
	{70015, 0x1C},
	{70046, 0x20},
	{70082, 0x40},
	{70117, 0x80},
	{70145, 0x100},
	{70167, 0x200},
	{70185, 0x400},
	{70217, 0x800},
	{70338, 0x7000, 8, 3087},
	{70348, 0x38000},
	{70361, 0x1C0000},
	{70374, 0x200000},
	{70390, 0x400000},
	{70408, 0x800000},
	{70426, 0x2000000},
	/* 786 */
	{70454, 0x3FFF},
	{55099, 0x3FFF0000},
	/* 788 */
	{11261, 0xFF},
	/* 789 */
	{70460, 0xFFFF},
	{70465, 0xFFFF0000},
	/* 791 */
	{70470, 0xFFFF},
	{70475, 0xFFFF0000},
	/* 793 */
	{70489, 0x3, 4, 3095},
	{70503, 0x4},
	{70528, 0x8},
	/* 796 */
	{70546, 0xF},
	{70554, 0xF0},
	{70562, 0x1F00},
	{70570, 0x6000},
	{70578, 0x18000},
	{70586, 0x60000},
	{70594, 0x180000},
	{64742, 0xF0000000},
	/* 804 */
	{17331, 0x3, 4, 3099},
	{70633, 0xC},
	{67119, 0x1F0},
	{70688, 0x600, 4, 3103},
	{70703, 0x800},
	{70717, 0x1000},
	{70736, 0xE000},
	{70753, 0xF0000},
	{67345, 0x100000},
	{70760, 0x7800000},
	{70784, 0x8000000},
	{70799, 0x10000000},
	{70809, 0x20000000},
	{70829, 0x80000000},
	/* 818 */
	{17331, 0x1, 2, 3107},
	{67119, 0x1F0},
	{70688, 0x600, 4, 3103},
	{70703, 0x800},
	{70717, 0x1000},
	{70736, 0xE000},
	{67345, 0x100000},
	{70784, 0x8000000},
	{70872, 0x20000000},
	/* 827 */
	{70546, 0x7FF},
	{70554, 0x3FF800},
	/* 829 */
	{70546, 0x3FFFFF},
	/* 830 */
	{10089, 0xFF},
	/* 831 */
	{70944, 0x3, 4, 3109},
	{70956, 0xC, 4, 3109},
	{70968, 0x30, 4, 3109},
	{70984, 0xC0, 4, 3109},
	{71054, 0x30000, 4, 3113},
	{71066, 0xC0000, 4, 3113},
	{71078, 0x300000, 4, 3113},
	{71094, 0x1000000},
	{71105, 0x2000000},
	/* 840 */
	{30570, 0xFF},
	/* 841 */
	{71116, 0xFF},
	/* 842 */
	{71134, 0xFFFF},
	{71150, 0xFFFF0000},
	/* 844 */
	{70460, 0x7FFF},
	{70465, 0x7FFF0000},
	{71166, 0x80000000},
	/* 847 */
	{70470, 0x7FFF},
	{70475, 0x7FFF0000},
	/* 849 */
	{71254, 0xFFFF, 32769, 3117},
	/* 850 */
	{71264, 0xF},
	{71271, 0xF0},
	{71280, 0xF00},
	{71288, 0x3F000},
	{71299, 0xFC0000},
	{71310, 0xF000000},
	{71321, 0xF0000000},
	/* 857 */
	{71332, 0x1FF},
	{71351, 0x1FF0000},
	/* 859 */
	{71370, 0xF},
	{71385, 0xF0},
	{71400, 0xF00},
	{71415, 0xF000},
	{71430, 0xF0000},
	{71445, 0xF00000},
	{71460, 0xF000000},
	{71475, 0xF0000000},
	/* 867 */
	{71490, 0xF},
	{71505, 0xF0},
	{71520, 0xF00},
	{71535, 0xF000},
	{71550, 0xF0000},
	{71565, 0xF00000},
	{71580, 0xF000000},
	{71595, 0xF0000000},
	/* 875 */
	{71702, 0x3, 4, 35886},
	{71714, 0xC, 4, 35886},
	{71826, 0x30, 4, 35890},
	{71883, 0x40, 2, 35894},
	{71939, 0x80, 2, 35896},
	{72043, 0x300, 4, 35898},
	{72151, 0xC00, 4, 35902},
	{72260, 0x3000, 4, 35906},
	{72373, 0xC000, 4, 35910},
	{72475, 0x30000, 4, 35914},
	{72621, 0xC0000, 4, 35918},
	{72768, 0x300000, 4, 35922},
	{72868, 0x3000000, 4, 35926},
	{73014, 0xC000000, 4, 35930},
	{73161, 0x30000000, 4, 35934},
	/* 890 */
	{73281, 0x3, 4, 35938},
	{73452, 0xC, 4, 35942},
	{73624, 0x30, 4, 35946},
	/* 893 */
	{69266, 0x3},
	{69284, 0xC},
	/* 895 */
	{9911, 0x1},
	{73637, 0x6},
	{65491, 0x60},
	{73644, 0x100},
	{73679, 0x3000},
	{73686, 0x30000},
	{73700, 0x100000},
	/* 902 */
	{73718, 0x80000000},
	/* 903 */
	{55583, 0x3},
	/* 904 */
	{10141, 0xF},
	/* 905 */
	{73733, 0xFF},
	{73742, 0xFF00},
	{73752, 0xFF0000},
	{73763, 0xFF000000},
	/* 909 */
	{73773, 0xFF},
	{73781, 0xFF00},
	{73790, 0xFF0000},
	{73799, 0xFF000000},
	/* 913 */
	{73807, 0x3, 4, 3109},
	{73823, 0xC, 4, 3109},
	{73839, 0x30, 4, 3109},
	{73853, 0xC0, 4, 3109},
	{73869, 0x30000, 4, 3113},
	{73885, 0xC0000, 4, 3113},
	{73901, 0x300000, 4, 3113},
	{73915, 0xC00000, 4, 3113},
	{73931, 0x40000000},
	{73946, 0x80000000},
	/* 923 */
	{73961, 0x1},
	{73988, 0x7C},
	{74017, 0x100},
	{74046, 0x200},
	{74077, 0x400},
	{74105, 0x1000},
	{74133, 0x2000},
	{74163, 0x4000},
	/* 931 */
	{74189, 0x1},
	{74209, 0xE},
	{74226, 0x30},
	{74247, 0xF00},
	/* 935 */
	{74505, 0xF, 16, 35950},
	{74517, 0xF0, 16, 35950},
	{74530, 0xF00, 16, 35950},
	{74543, 0xF000, 16, 35950},
	{74558, 0xF0000, 16, 35950},
	{74574, 0xF00000, 16, 35950},
	/* 941 */
	{74590, 0xFF},
	{74605, 0xFF00},
	{74617, 0xFF0000},
	{74634, 0xFF000000},
	/* 945 */
	{74647, 0xFF},
	{74665, 0xFF00},
	{74680, 0xFF0000},
	{74700, 0xFF000000},
	/* 949 */
	{783, 0x3F},
	{74716, 0x300},
	{74728, 0x400},
	{74739, 0x1E000},
	{74748, 0x20000},
	{74762, 0x40000},
	{74766, 0x80000},
	{74783, 0x100000},
	{74801, 0x600000},
	{74819, 0x800000},
	{74839, 0x1000000},
	{74851, 0x2000000},
	/* 961 */
	{783, 0x3F},
	{74716, 0x300},
	{74728, 0x400},
	{74762, 0x40000},
	{74766, 0x80000},
	{74783, 0x100000},
	{74801, 0x600000},
	{74839, 0x1000000},
	{74851, 0x2000000},
	/* 970 */
	{74863, 0x3E},
	{74879, 0x40},
	{74892, 0x80},
	/* 973 */
	{74905, 0x1},
	{74922, 0x2},
	{74939, 0x4},
	{74958, 0x8},
	{74979, 0x10},
	{74997, 0x20},
	{75015, 0x40},
	{75035, 0x80},
	{75056, 0x100},
	{75072, 0x200},
	{75088, 0x400},
	{75104, 0x800},
	{75120, 0x1000},
	{75135, 0x2000},
	{75149, 0x4000},
	{75169, 0x8000},
	/* 989 */
	{75186, 0x1},
	{75201, 0x2},
	{75324, 0x1C, 5, 35966},
	{75342, 0xE0, 5, 35966},
	{75360, 0x700, 5, 35966},
	{75378, 0x3800, 5, 35966},
	{75396, 0x4000},
	/* 996 */
	{75413, 0x3F},
	{75424, 0x40},
	{75434, 0x80},
	{75451, 0x100},
	{75467, 0x4000},
	{75487, 0x8000},
	/* 1002 */
	{75497, 0x1},
	{75515, 0x10},
	{75535, 0x100},
	{75554, 0x1000},
	{75575, 0x30000},
	{75594, 0x100000},
	{75608, 0x1000000},
	/* 1009 */
	{75716, 0xF, 5, 35971},
	/* 1010 */
	{75735, 0xF, 5, 35971},
	{75754, 0xF0, 5, 35971},
	{75773, 0xF00, 5, 35971},
	{75792, 0xF000, 5, 35971},
	{75811, 0xF0000, 5, 35971},
	/* 1015 */
	{76030, 0xF, 10, 35976},
	/* 1016 */
	{76046, 0xF, 10, 35976},
	{76065, 0xF0, 10, 35976},
	{76084, 0xF00, 10, 35976},
	{76103, 0xF000, 10, 35976},
	{76122, 0xF0000, 10, 35976},
	{76141, 0xF00000, 10, 35976},
	{76160, 0xF000000, 10, 35976},
	{76179, 0xF0000000, 10, 35976},
	/* 1024 */
	{76433, 0xF, 11, 35986},
	{76438, 0xF0, 11, 35986},
	{76443, 0xF00, 11, 35986},
	{76448, 0xF000, 11, 35986},
	{76453, 0xF0000, 11, 35986},
	{76458, 0xF00000, 11, 35986},
	{76463, 0xF000000, 11, 35986},
	{76468, 0xF0000000, 11, 35986},
	/* 1032 */
	{76547, 0xF, 16, 35997},
	{76560, 0xF0},
	{76573, 0xF00},
	{76586, 0xF000},
	{76599, 0xF0000},
	{76612, 0xF00000},
	{76625, 0xF000000},
	{76638, 0xF0000000},
	/* 1040 */
	{76651, 0x1},
	{76674, 0x2},
	{76697, 0x10},
	{76720, 0x20},
	{76743, 0x100},
	{76766, 0x200},
	{76789, 0x1000},
	{76812, 0x2000},
	{76835, 0x10000},
	{76858, 0x20000},
	{76881, 0x100000},
	{76904, 0x200000},
	{76927, 0x1000000},
	{76950, 0x2000000},
	{76973, 0x10000000},
	{76996, 0x20000000},
	{77019, 0x80000000},
	/* 1057 */
	{77310, 0x7, 8, 36013},
	{77324, 0x70, 8, 36013},
	{77472, 0x700, 8, 36021},
	{77487, 0x70000, 8, 36013},
	{77501, 0x700000, 8, 36013},
	{77515, 0x7000000, 8, 36021},
	/* 1063 */
	{77970, 0x1F, 21, 36029},
	{77472, 0xE0, 5, 36050},
	{78075, 0x1F00, 21, 36029},
	{78091, 0x1F0000, 21, 36029},
	{77515, 0xE00000, 5, 36050},
	{78106, 0x1F000000, 21, 36029},
	{78122, 0x20000000},
	{9911, 0x40000000},
	{78143, 0x80000000},
	/* 1072 */
	{78156, 0x7},
	/* 1073 */
	{11638, 0xFFFF},
	/* 1074 */
	{78247, 0x3, 4, 36055},
	{78293, 0xC, 2, 36059},
	{78304, 0x10},
	{78319, 0x20},
	{78327, 0x40},
	{78338, 0x80},
	{78352, 0x100},
	{78369, 0xE0000000},
	/* 1082 */
	{78382, 0xFFFFFFF},
	/* 1083 */
	{78394, 0x3FF},
	/* 1084 */
	{78417, 0x1},
	{69447, 0x2},
	{78432, 0x4},
	{78447, 0x8},
	{70342, 0x70, 8, 3087},
	{78467, 0x80},
	{78483, 0x700, 8, 3087},
	{78495, 0x700000, 8, 3087},
	{78510, 0x40000000},
	{78544, 0x80000000},
	/* 1094 */
	{78579, 0x7},
	{78598, 0x70},
	{78614, 0x700},
	{78638, 0x7000},
	{78664, 0x10000},
	{78691, 0x20000},
	{78713, 0x40000},
	{78732, 0x80000},
	{78750, 0x100000},
	{78777, 0x200000},
	{78804, 0x7000000},
	{78829, 0x8000000},
	/* 1106 */
	{78860, 0x1},
	{78878, 0x8},
	{1011, 0x70, 8, 36061},
	{78151, 0xFF0000, 256, 36069},
	/* 1110 */
	{79298, 0x1},
	{79314, 0x2},
	{79345, 0x4},
	{69505, 0x30, 4, 36325},
	{79424, 0x40},
	{79436, 0x80},
	{79460, 0x100},
	{79479, 0x200},
	{79497, 0x400},
	{79510, 0x800},
	{79532, 0x1000},
	{79622, 0x6000, 4, 36329},
	{79644, 0x8000},
	{79662, 0x10000},
	{79693, 0x20000},
	{79712, 0x700000},
	{79737, 0x800000},
	/* 1127 */
	{79770, 0x1},
	{79780, 0x2},
	{79790, 0x4},
	{79800, 0x8},
	{79810, 0x10},
	{79820, 0x20},
	{79830, 0x2000},
	{79849, 0xC000},
	{79861, 0x10000},
	{79874, 0x20000},
	{79892, 0x40000},
	{79915, 0x80000},
	{79933, 0x100000},
	{79953, 0x200000},
	{79965, 0x400000},
	{79987, 0x1000000},
	{80011, 0x2000000},
	{80037, 0x4000000},
	{80056, 0x8000000},
	{80074, 0x10000000},
	/* 1147 */
	{80094, 0x1},
	{80105, 0x2},
	{19205, 0x4},
	{80125, 0x18, 2, 36333},
	{80191, 0xE0, 3, 36335},
	{80212, 0x700, 3, 36335},
	{80232, 0x800},
	{80257, 0x1000},
	{80281, 0x2000},
	{80305, 0x10000},
	{80330, 0x80000},
	{80349, 0x100000},
	{80364, 0x200000},
	{80382, 0x400000},
	{80420, 0x800000},
	{80443, 0x1000000},
	/* 1163 */
	{80464, 0x1},
	{80482, 0x2},
	{80501, 0x4},
	{80519, 0x8},
	{80538, 0x10},
	{80556, 0x20},
	{80575, 0x100},
	{80586, 0x200},
	{80596, 0x400},
	{80607, 0x800},
	/* 1173 */
	{80623, 0x1},
	{80639, 0x2},
	{80655, 0x4},
	{80671, 0x8},
	{80687, 0x10},
	{80703, 0x20},
	{80719, 0x40},
	{80735, 0x80},
	{80751, 0x100},
	{80767, 0x200},
	{80783, 0x400},
	{80799, 0x800},
	{80815, 0x1000},
	{80831, 0x2000},
	{80847, 0x4000},
	{80863, 0x8000},
	{80879, 0x10000},
	{80898, 0x20000},
	{80916, 0x40000},
	{80943, 0x80000},
	{80965, 0x100000},
	{80983, 0x200000},
	{81003, 0x400000},
	{81026, 0x800000},
	{81049, 0x1000000},
	{81074, 0x2000000},
	{81094, 0x4000000},
	{81117, 0x8000000},
	/* 1201 */
	{81136, 0x1},
	{81155, 0x2},
	{81173, 0x4},
	{81191, 0x8},
	{81209, 0x10},
	{81227, 0x20},
	{81244, 0x40},
	{81261, 0x80},
	{81282, 0x100},
	{81299, 0x200},
	{81316, 0x400},
	{81332, 0x800},
	{81348, 0x1000},
	{81364, 0x2000},
	{81380, 0x4000},
	{81405, 0x100000},
	/* 1217 */
	{81425, 0x3},
	{81444, 0x4},
	{81463, 0x8},
	{81480, 0x10},
	/* 1221 */
	{81495, 0x1},
	{81519, 0x2},
	{81539, 0x4},
	{81560, 0x8},
	{81585, 0x10},
	{81605, 0x20},
	{81621, 0x40},
	{81638, 0x80},
	{81659, 0xFF00},
	{81680, 0x40000000},
	{81701, 0x80000000},
	/* 1232 */
	{81723, 0x1},
	{81495, 0x2},
	{81519, 0x4},
	{81539, 0x8},
	{81560, 0x10},
	{81748, 0x20},
	{81761, 0x40},
	/* 1239 */
	{81790, 0x1},
	{81801, 0x2},
	/* 1241 */
	{81819, 0x1},
	{81836, 0x2},
	/* 1243 */
	{81860, 0x1},
	{81885, 0x2},
	{81906, 0x4},
	{81928, 0x8},
	{81954, 0x10},
	/* 1248 */
	{81971, 0x1E},
	{81983, 0xE0},
	{81997, 0xF00},
	{82013, 0x70000},
	{82024, 0x780000},
	/* 1253 */
	{66875, 0xFFFF},
	{66768, 0xFFFF0000},
	/* 1255 */
	{82037, 0xFFFF},
	{18878, 0xFFFF0000},
	/* 1257 */
	{66768, 0xFFFF},
	/* 1258 */
	{82046, 0xFFFF},
	{82059, 0xFF0000},
	{82072, 0x10000000},
	{82090, 0x60000000},
	/* 1262 */
	{82106, 0x7},
	/* 1263 */
	{82118, 0x3},
	/* 1264 */
	{18471, 0xFF},
	/* 1265 */
	{18493, 0x1F, 22, 36338},
	{82477, 0x4000},
	{82490, 0x8000},
	{82503, 0x70000},
	/* 1269 */
	{18513, 0xF},
	/* 1270 */
	{18519, 0xF},
	/* 1271 */
	{82514, 0x1},
	{82524, 0x2},
	{82534, 0x4},
	{82544, 0x8},
	{19704, 0xFF00},
	{82554, 0xFF0000},
	/* 1277 */
	{82560, 0xF},
	{13866, 0xF0},
	{82567, 0xF00},
	{71157, 0xF000},
	{82574, 0xF0000},
	{82581, 0xF00000},
	{82590, 0xF000000},
	{11798, 0xF0000000},
	/* 1285 */
	{1011, 0x7, 6, 36360},
	{82670, 0x8},
	{82726, 0x30, 4, 36366},
	{82735, 0x7C0},
	{82746, 0x800},
	{82759, 0x1000},
	{82770, 0x2000},
	{82782, 0x4000},
	{82795, 0x8000},
	{82813, 0x10000},
	{82829, 0x20000},
	{82848, 0x40000},
	{82862, 0x80000},
	{82880, 0x100000},
	{82898, 0x600000},
	/* 1300 */
	{82905, 0x7FF},
	{82925, 0x3FF800},
	{82945, 0xFFC00000},
	/* 1303 */
	{82969, 0x1},
	{82981, 0x2},
	{83002, 0x4},
	{83022, 0x8},
	{83047, 0x10},
	{83068, 0x20},
	{83091, 0x40},
	/* 1310 */
	{83121, 0x1},
	{83131, 0x2},
	{83146, 0x4},
	{83171, 0x8},
	{83189, 0x70},
	{83205, 0x80},
	{83210, 0x100},
	{83233, 0x200},
	{83252, 0x400},
	{83274, 0x800},
	{83290, 0x1000},
	{83306, 0x2000},
	{83322, 0x4000},
	{83341, 0x8000},
	{83367, 0x10000},
	{83382, 0x20000},
	{83422, 0x40000},
	{83449, 0x80000},
	{83472, 0xF00000},
	{83488, 0x1000000},
	{83518, 0x2000000},
	{83542, 0x4000000},
	{83563, 0x8000000},
	{83593, 0x70000000},
	/* 1334 */
	{18718, 0x7FF},
	/* 1335 */
	{18732, 0x7FF},
	/* 1336 */
	{18746, 0xF},
	/* 1337 */
	{783, 0x7FFF},
	/* 1338 */
	{83617, 0x3F, 4, 36370},
	{83630, 0x3F00, 4, 36370},
	{83645, 0x3F0000, 4, 36370},
	{83660, 0xFC00000, 4, 36370},
	{83675, 0x80000000},
	/* 1343 */
	{214, 0x3, 3, 36374},
	{83812, 0xC, 4, 36377},
	{83892, 0x30, 4, 36381},
	{83952, 0xC0, 3, 36385},
	{83965, 0x100},
	{78319, 0x200},
	{83969, 0x400},
	{83978, 0x3800},
	/* 1351 */
	{18921, 0x1},
	{83984, 0x2},
	{84005, 0x4},
	/* 1354 */
	{85188, 0x3F, 64, 36388},
	{60407, 0x7FFFC00},
	{85199, 0x8000000},
	/* 1357 */
	{19018, 0x1},
	{85214, 0x2},
	/* 1359 */
	{85229, 0x1},
	{85243, 0x2},
	{85259, 0x4},
	{85277, 0x8},
	{85293, 0x10},
	/* 1364 */
	{85304, 0xFFFF},
	{85319, 0x10000},
	{85338, 0x20000},
	{85352, 0x40000},
	{85371, 0x80000},
	{85385, 0x100000},
	/* 1370 */
	{19132, 0x7FFF},
	/* 1371 */
	{19168, 0x1},
	/* 1372 */
	{19182, 0x1},
	/* 1373 */
	{70736, 0x1},
	{85402, 0x2},
	{85413, 0x4},
	{85430, 0x8},
	{85447, 0x3F0},
	{85464, 0xFC00},
	{85481, 0x10000},
	{85505, 0x20000},
	{67416, 0x40000},
	/* 1382 */
	{85522, 0x7, 8, 3087},
	{85535, 0xFF0},
	{85549, 0xFF000},
	{69466, 0x1000000},
	/* 1386 */
	{85562, 0x7, 8, 3087},
	{85575, 0xFF0},
	{85589, 0xFF000},
	{69484, 0x1000000},
	/* 1390 */
	{9787, 0xFF},
	{9803, 0xFF00},
	{85602, 0xFF0000},
	{85608, 0xFF000000},
	/* 1394 */
	{19704, 0x3FF},
	/* 1395 */
	{19697, 0x1FF},
	/* 1396 */
	{19718, 0x7FF},
	/* 1397 */
	{85614, 0x1FF},
	{85630, 0x3FE00},
	/* 1399 */
	{85646, 0xFF},
	{85660, 0xFF00},
	{85670, 0xFF0000},
	{85681, 0x1F000000},
	{85693, 0xE0000000},
	/* 1404 */
	{85753, 0x3, 4, 36452},
	{85784, 0x4, 2, 36456},
	{19787, 0x18, 4, 36458},
	{85866, 0x20, 2, 36462},
	{85931, 0xC0, 4, 36464},
	{85937, 0x100},
	{68265, 0x200},
	{85948, 0x400},
	{85968, 0x800},
	{85988, 0x1000},
	{86002, 0x2000},
	{86013, 0x4000},
	{86029, 0x78000},
	{86049, 0x180000},
	{86064, 0x200000},
	{86074, 0x400000},
	{86084, 0x800000},
	{86094, 0x1000000},
	{86109, 0x2000000},
	/* 1423 */
	{86129, 0xFF},
	{86141, 0x3F00},
	{86157, 0xFC000},
	/* 1426 */
	{220, 0x3, 3, 36468},
	{86263, 0x1C, 4, 36471},
	{86340, 0xE0, 4, 36475},
	{86349, 0x100},
	{86369, 0x200},
	{86380, 0x3C00},
	{86402, 0x4000},
	{83952, 0x18000, 3, 36385},
	{86436, 0x60000, 4, 36479},
	{86495, 0x80000, 3, 36483},
	{86547, 0x100000, 3, 36486},
	{83978, 0x3800000},
	/* 1438 */
	{86559, 0x1},
	{86580, 0x300},
	{86602, 0xC00},
	{86624, 0x3000},
	{86646, 0xC000},
	{86668, 0x10000},
	/* 1444 */
	{86681, 0xFF},
	{86709, 0x100},
	/* 1446 */
	{9911, 0x1},
	{20144, 0x1FC},
	{86737, 0x80000000},
	/* 1449 */
	{86769, 0x1},
	{86784, 0x2},
	{86799, 0x4},
	{86814, 0x8},
	{86829, 0x70},
	{86841, 0x80},
	{86861, 0xF00},
	{86878, 0x80000000},
	/* 1457 */
	{86899, 0xF},
	{86918, 0xF0},
	{86937, 0xF00},
	{86956, 0xF000},
	/* 1461 */
	{86975, 0xF},
	{86986, 0xF0},
	{86997, 0xF00},
	{87008, 0xF000},
	{87019, 0xF0000},
	{87030, 0xF00000},
	{87041, 0xF000000},
	{87052, 0xF0000000},
	/* 1469 */
	{87063, 0xF},
	{87074, 0xF0},
	{87085, 0xF00},
	{87097, 0xF000},
	{87109, 0xF0000},
	{87121, 0xF00000},
	{87133, 0xF000000},
	{87145, 0xF0000000},
	/* 1477 */
	{87157, 0x200},
	{87175, 0x400},
	{87186, 0x800},
	{87211, 0x1000},
	{87233, 0x2000},
	/* 1482 */
	{87255, 0x7},
	{87272, 0x10},
	{87294, 0x1E000},
	{87310, 0x700000},
	{87331, 0x3000000},
	{87411, 0xC000000, 4, 36489},
	/* 1488 */
	{87437, 0x1},
	{87498, 0x6, 4, 36493},
	{87714, 0x38, 8, 36497},
	/* 1491 */
	{87725, 0xF},
	{87730, 0xF0},
	{87735, 0xF00},
	{87740, 0xF000},
	{87745, 0xF0000},
	{87750, 0xF00000},
	{87755, 0xF000000},
	{87760, 0xF0000000},
	/* 1499 */
	{87765, 0xF},
	{87770, 0xF0},
	{87775, 0xF00},
	{87780, 0xF000},
	{87785, 0xF0000},
	{87790, 0xF00000},
	{87795, 0xF000000},
	{87800, 0xF0000000},
	/* 1507 */
	{87805, 0xF},
	{87810, 0xF0},
	{87815, 0xF00},
	{87820, 0xF000},
	{87825, 0xF0000},
	{87831, 0xF00000},
	{87837, 0xF000000},
	{87843, 0xF0000000},
	/* 1515 */
	{87849, 0xF},
	{87855, 0xF0},
	{87861, 0xF00},
	{87867, 0xF000},
	{87873, 0xF0000},
	{87879, 0xF00000},
	{87885, 0xF000000},
	{87891, 0xF0000000},
	/* 1523 */
	{87897, 0xFFFF},
	{87910, 0xFFFF0000},
	/* 1525 */
	{87923, 0xFFFF},
	{87936, 0xFFFF0000},
	/* 1527 */
	{87949, 0x3},
	{67730, 0x4},
	{67752, 0x8},
	{87978, 0x60},
	/* 1531 */
	{88091, 0x3, 4, 36505},
	{88104, 0x4},
	{88115, 0x8},
	{88224, 0x70, 5, 36509},
	{88242, 0x380, 5, 36509},
	{88260, 0x1C00},
	{88283, 0x3E000},
	{88309, 0x40000},
	{88331, 0x7F80000},
	{88347, 0x8000000},
	{88369, 0x10000000},
	{88456, 0x60000000, 3, 36514},
	/* 1543 */
	{88473, 0xFFFF},
	{88489, 0xFFFF0000},
	/* 1545 */
	{88508, 0x1},
	{88525, 0x1E},
	{88549, 0x20},
	{88567, 0x3C0},
	{88592, 0x400},
	{88622, 0x800},
	{88637, 0x1000},
	{88652, 0x2000},
	{88687, 0x4000},
	{88723, 0x8000},
	{88813, 0x30000, 3, 36517},
	{88837, 0x40000},
	{88873, 0x80000},
	{88909, 0x100000},
	{88935, 0x200000},
	{88959, 0x400000},
	{88979, 0x800000},
	{89000, 0x1000000},
	{89025, 0x6000000},
	{89049, 0x18000000},
	/* 1565 */
	{89077, 0x7FF},
	{89098, 0xFF0000},
	/* 1567 */
	{89116, 0xFF},
	/* 1568 */
	{89132, 0x7F},
	/* 1569 */
	{89145, 0x7FF},
	{89154, 0x7FF00000},
	/* 1571 */
	{89145, 0x3FFFFF},
	/* 1572 */
	{69301, 0x1FFF},
	{69328, 0x3FFE000},
	{89169, 0x3C000000},
	/* 1575 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 32, 36524},
	{65511, 0x80},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{89932, 0x80000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	{90231, 0x8000000},
	{90257, 0x10000000},
	{90325, 0x60000000, 3, 36576},
	{90341, 0x80000000},
	/* 1594 */
	{90355, 0x1F},
	{90371, 0x3E0},
	{90393, 0xC00},
	{70633, 0x7000},
	{90411, 0x18000},
	{90425, 0x20000},
	{90443, 0x40000},
	{90469, 0x80000},
	/* 1602 */
	{73961, 0x1},
	{90499, 0x2},
	{67357, 0xC, 3, 36579},
	{90613, 0x10, 2, 36582},
	{67385, 0x60},
	{67482, 0x180},
	{90639, 0x200},
	{90662, 0x3C00},
	{90682, 0x3C000},
	{74077, 0x40000},
	{90704, 0x80000},
	{90737, 0x100000},
	/* 1614 */
	{89145, 0x3FFF},
	/* 1615 */
	{90761, 0xFF},
	/* 1616 */
	{90771, 0x3FFF},
	{90783, 0xFFFC000},
	{67257, 0xF0000000},
	/* 1619 */
	{90794, 0x1FFF},
	{90805, 0x2000},
	{90817, 0x7C000},
	{90831, 0xF80000},
	{90845, 0x3000000},
	{90859, 0x4000000},
	{64742, 0x38000000},
	{90878, 0x40000000},
	/* 1627 */
	{9994, 0xFFFFFFFC},
	/* 1628 */
	{10023, 0xFFFF},
	/* 1629 */
	{24357, 0xFFFFFFFC},
	/* 1630 */
	{24379, 0xFFFF},
	/* 1631 */
	{24873, 0xFFFFFFFC},
	/* 1632 */
	{24895, 0xFFFF},
	/* 1633 */
	{90895, 0xFFFFFFC},
	/* 1634 */
	{90911, 0x6000000},
	/* 1635 */
	{90924, 0x1},
	/* 1636 */
	{90943, 0xFF},
	{90957, 0x30000},
	/* 1638 */
	{90971, 0xFFFFFFFC},
	/* 1639 */
	{90983, 0xFFFF},
	{90995, 0x10000},
	{90911, 0x6000000},
	{26682, 0xE0000000},
	/* 1643 */
	{26232, 0xFFFFFFFC},
	/* 1644 */
	{26250, 0xFFFF},
	{90911, 0xC00000},
	/* 1646 */
	{26304, 0xFFFFFFFC},
	/* 1647 */
	{26322, 0xFFFF},
	{90911, 0xC00000},
	/* 1649 */
	{91005, 0x3},
	{26362, 0xFFFFFFF8},
	/* 1651 */
	{26381, 0xFFFF},
	{91019, 0x10000},
	{91035, 0x100000},
	{91051, 0x3000000},
	{91067, 0xE0000000},
	/* 1656 */
	{91078, 0x400},
	{91091, 0x6000},
	{91108, 0x8000},
	{91120, 0x300000},
	{91131, 0x6000000},
	{91148, 0x8000000},
	{91160, 0x60000000},
	/* 1663 */
	{91171, 0xFF},
	/* 1664 */
	{91190, 0x3F},
	/* 1665 */
	{91208, 0x8},
	{91225, 0x10},
	{91242, 0x20},
	{91269, 0x8000},
	{91289, 0x40000},
	{91306, 0x400000},
	{91322, 0x800000},
	{91336, 0x2000000},
	{91350, 0x4000000},
	{91364, 0x8000000},
	{91385, 0x10000000},
	{91410, 0x20000000},
	{91431, 0x40000000},
	/* 1678 */
	{91455, 0x3000000},
	{1024, 0x80000000},
	/* 1680 */
	{26619, 0xFFFF},
	/* 1681 */
	{26660, 0xFFFF},
	/* 1682 */
	{91460, 0x3FFFFFF},
	{91471, 0x4000000},
	{91475, 0x8000000},
	{91479, 0x10000000},
	{91484, 0x20000000},
	{91489, 0x40000000},
	{91498, 0x80000000},
	/* 1689 */
	{91505, 0x1},
	{91525, 0x2},
	{91539, 0x30},
	{91551, 0x1FF0000},
	{91564, 0x10000000},
	{91579, 0x20000000},
	{91593, 0xC0000000},
	/* 1696 */
	{91603, 0x3FFFFFF},
	{91616, 0x10000000},
	/* 1698 */
	{91635, 0xFF},
	/* 1699 */
	{91654, 0xFF},
	/* 1700 */
	{91660, 0x1},
	{91674, 0x2},
	{91686, 0x10000},
	{91700, 0x1000000},
	/* 1704 */
	{1901, 0xFF},
	{59312, 0x80000000},
	/* 1706 */
	{26915, 0xFFFFF},
	/* 1707 */
	{26928, 0xFFFFF},
	/* 1708 */
	{26942, 0xFFFFF},
	/* 1709 */
	{26956, 0xFFFFF},
	/* 1710 */
	{26978, 0xFFFFF},
	/* 1711 */
	{26998, 0xFFFFF},
	/* 1712 */
	{27020, 0xFFFFF},
	/* 1713 */
	{91713, 0x3},
	{9994, 0xFFFFFFFC},
	/* 1715 */
	{10023, 0xFFFF},
	{91713, 0xFFFF0000},
	/* 1717 */
	{91718, 0xFFF},
	/* 1718 */
	{91733, 0xFFFFF},
	/* 1719 */
	{91747, 0xFFFFF},
	/* 1720 */
	{91761, 0xFFFFF},
	/* 1721 */
	{27336, 0xFFFFFFE0},
	/* 1722 */
	{27355, 0xFFFF},
	/* 1723 */
	{27374, 0xFFF},
	/* 1724 */
	{27391, 0xFFFFFFFC},
	/* 1725 */
	{27409, 0xFFFF},
	/* 1726 */
	{27427, 0xFFFFF},
	/* 1727 */
	{27443, 0xFFFFFFFC},
	/* 1728 */
	{27461, 0xFFFF},
	/* 1729 */
	{27479, 0xFFFFF},
	/* 1730 */
	{27578, 0xFFFFFFFC},
	/* 1731 */
	{27592, 0xFFFF},
	/* 1732 */
	{27606, 0xFFFFF},
	/* 1733 */
	{42941, 0xFFF000},
	{90911, 0x6000000},
	{91774, 0x8000000},
	{91787, 0x10000000},
	/* 1737 */
	{91795, 0x30000},
	{91803, 0x7000000},
	{91811, 0xE0000000},
	/* 1740 */
	{27672, 0xFFFFFFF},
	/* 1741 */
	{27683, 0xFFFFFFFC},
	/* 1742 */
	{27697, 0xFFFF},
	/* 1743 */
	{27711, 0xFFFFF},
	/* 1744 */
	{91820, 0xFFFFF},
	/* 1745 */
	{1024, 0x3},
	/* 1746 */
	{27861, 0x1},
	/* 1747 */
	{91833, 0x1},
	{91847, 0x2},
	{91864, 0x4},
	{91880, 0x8},
	{91895, 0x10},
	{91914, 0x20},
	{91932, 0x40},
	{91953, 0x80},
	/* 1755 */
	{91974, 0x1},
	{91990, 0x2},
	{92006, 0x40},
	{92024, 0x80},
	{92042, 0x100},
	{92060, 0x200},
	{92078, 0x400},
	{92096, 0x800},
	{92114, 0x1000},
	{92132, 0x2000},
	{92150, 0x4000},
	{92167, 0x80000},
	{92183, 0x200000},
	/* 1768 */
	{92199, 0xFF},
	{1024, 0x80000000},
	/* 1770 */
	{92217, 0xF},
	{92229, 0xF0},
	{92238, 0xF00},
	{92247, 0xF000},
	{92257, 0x30000},
	{92267, 0xC0000},
	{9911, 0x100000},
	{10394, 0xFFE00000},
	/* 1778 */
	{92274, 0xFF},
	{92238, 0xFF00},
	{92229, 0xFF0000},
	{92289, 0x20000000},
	{92309, 0x40000000},
	{92335, 0x80000000},
	/* 1784 */
	{18493, 0x3F, 22, 36338},
	/* 1785 */
	{38, 0xFFFF},
	/* 1786 */
	{92355, 0x1FF},
	{92421, 0x600, 4, 36584},
	/* 1788 */
	{85304, 0xFFFF},
	{85319, 0x10000},
	{85338, 0x20000},
	{85352, 0x40000},
	{85371, 0x80000},
	{85385, 0x100000},
	{92441, 0x200000},
	{92459, 0x400000},
	{92475, 0x800000},
	/* 1797 */
	{92487, 0x1FF},
	{92501, 0x3FE00},
	{92515, 0x40000},
	{92533, 0x80000},
	/* 1801 */
	{92550, 0x7},
	{92559, 0x78},
	{92568, 0x100},
	/* 1804 */
	{92578, 0x1},
	{92589, 0x7FE},
	/* 1806 */
	{92602, 0x1},
	{92616, 0x2},
	{92630, 0x4},
	/* 1809 */
	{29024, 0xFFFFFF},
	/* 1810 */
	{92644, 0xF},
	{92656, 0xFF00},
	/* 1812 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1814 */
	{92670, 0x1},
	{92691, 0x2},
	/* 1816 */
	{92719, 0x3FFF},
	/* 1817 */
	{92727, 0x3FFF},
	/* 1818 */
	{1888, 0xFFFF},
	/* 1819 */
	{92735, 0x1},
	{92747, 0x2},
	{92759, 0x4},
	{29799, 0x8},
	{68545, 0x10},
	{30224, 0x10000},
	{92770, 0x60000},
	/* 1826 */
	{92783, 0x1},
	{69852, 0x2},
	/* 1828 */
	{24951, 0x7FFFFFFF},
	/* 1829 */
	{92787, 0x3F},
	{92792, 0xC0},
	{92800, 0x300},
	{92806, 0xFFFFFC00},
	/* 1833 */
	{30224, 0x1},
	{92267, 0xFFFFFFFE},
	/* 1835 */
	{8, 0xFFFF},
	{92267, 0xFFFF0000},
	/* 1837 */
	{38, 0xFFFF},
	{92267, 0xFFFF0000},
	/* 1839 */
	{30302, 0xFF},
	{92267, 0xFFFFFF00},
	/* 1841 */
	{30319, 0xFF},
	{92267, 0xFFFFFF00},
	/* 1843 */
	{1, 0xFF},
	{92267, 0xFFFFFF00},
	/* 1845 */
	{452, 0x3F},
	{92267, 0xFFFFFFC0},
	/* 1847 */
	{80911, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{88792, 0x4000},
	{92814, 0x8000},
	{92826, 0x7FF0000},
	{92837, 0x8000000},
	{92848, 0x10000000},
	{92858, 0x20000000},
	{92792, 0xC0000000},
	/* 1857 */
	{30523, 0xFFFF},
	{92267, 0xFFFF0000},
	/* 1859 */
	{452, 0xF},
	{92267, 0xFFFFFFF0},
	/* 1861 */
	{92865, 0xFFFF},
	{92876, 0xF0000},
	{92889, 0xF00000},
	{92267, 0x3F000000},
	{92897, 0x40000000},
	{9911, 0x80000000},
	/* 1867 */
	{29037, 0x7FFFFFFF},
	{30585, 0x80000000},
	/* 1869 */
	{31131, 0xFFFF},
	/* 1870 */
	{31135, 0xFFFF},
	{92906, 0xFFFF0000},
	/* 1872 */
	{92920, 0x3FF},
	{92929, 0xFFC00},
	{92939, 0xF00000},
	{92948, 0xF000000},
	{92959, 0xF0000000},
	/* 1877 */
	{92970, 0x3FF},
	{92980, 0xFFC00},
	{92990, 0xF000000},
	{93001, 0xF0000000},
	/* 1881 */
	{93221, 0xF, 6, 36588},
	{93456, 0xF0, 6, 36594},
	{93629, 0x300, 4, 36600},
	{93649, 0x400},
	/* 1885 */
	{452, 0x7},
	{70331, 0x40000000},
	{9911, 0x80000000},
	/* 1888 */
	{452, 0x1F},
	{70331, 0x40000000},
	{9911, 0x80000000},
	/* 1891 */
	{452, 0xF},
	{11261, 0x40000000},
	{9911, 0x80000000},
	/* 1894 */
	{452, 0x1F},
	{11261, 0x40000000},
	{9911, 0x80000000},
	/* 1897 */
	{11226, 0xFFFF},
	{11246, 0xFFFF0000},
	/* 1899 */
	{93671, 0x1},
	{93698, 0x2},
	{93725, 0x4},
	{1011, 0x100},
	/* 1903 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{93802, 0x2000},
	{93828, 0x4000},
	{93854, 0x10000},
	{93881, 0x20000},
	{93907, 0x40000},
	{93933, 0x80000},
	{93961, 0x100000},
	{93987, 0x200000},
	{94013, 0x400000},
	{94039, 0x1000000},
	{94066, 0x2000000},
	{94093, 0x4000000},
	{94120, 0x8000000},
	{94147, 0x10000000},
	{94173, 0x20000000},
	{94202, 0x40000000},
	{94228, 0x80000000},
	/* 1923 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{93802, 0x1000},
	{93828, 0x2000},
	{93854, 0x8000},
	{93881, 0x10000},
	{93961, 0x20000},
	{93987, 0x40000},
	{93907, 0x100000},
	{94066, 0x200000},
	{94228, 0x400000},
	{94255, 0x800000},
	{94120, 0x1000000},
	{94284, 0x2000000},
	/* 1938 */
	{94255, 0x2},
	{94313, 0x4},
	{94342, 0x8},
	{94370, 0x10},
	{94396, 0x20},
	{94422, 0x40},
	{94449, 0x80},
	{94284, 0x100},
	/* 1946 */
	{94476, 0x3FF},
	{92929, 0xFFC00},
	{94486, 0xF00000},
	{94496, 0xF000000},
	{94507, 0xF0000000},
	/* 1951 */
	{92970, 0x3FF},
	{92980, 0xFFC00},
	{94518, 0xF000000},
	{94529, 0xF0000000},
	/* 1955 */
	{94476, 0x3FF},
	{94540, 0xF0000000},
	/* 1957 */
	{92920, 0x3FF},
	{92929, 0xFFC00},
	{94486, 0xF00000},
	{94507, 0xF000000},
	{94540, 0xF0000000},
	/* 1962 */
	{92970, 0x3FF},
	{92980, 0xFFC00},
	{94529, 0xF000000},
	{94518, 0xF0000000},
	/* 1966 */
	{94550, 0xF},
	{94559, 0xF0},
	{94568, 0xF00},
	{94577, 0xF000},
	{94586, 0xF0000},
	{94595, 0xF00000},
	{94604, 0xF000000},
	{94613, 0xF0000000},
	/* 1974 */
	{92920, 0x1FF},
	{94622, 0xF000},
	{92939, 0xF00000},
	{94540, 0xF0000000},
	/* 1978 */
	{55932, 0x1},
	{85931, 0x2, 4, 36464},
	{85866, 0x4, 2, 36462},
	{19787, 0x8, 4, 36458},
	{85784, 0x10, 2, 36456},
	{85753, 0x20, 4, 36452},
	{94636, 0x40},
	{94642, 0x300},
	{94652, 0x2000},
	/* 1987 */
	{94666, 0x1},
	/* 1988 */
	{94675, 0x3},
	{94689, 0xC},
	{94703, 0x30},
	{94717, 0xC0},
	{94731, 0xF00},
	{94746, 0xF000},
	{94761, 0xF0000},
	{94776, 0xF00000},
	/* 1996 */
	{36876, 0x3FF},
	{94791, 0xFFC00},
	{94486, 0xF00000},
	/* 1999 */
	{94811, 0x3FF},
	{94831, 0xFFC00},
	/* 2001 */
	{92920, 0xFF},
	{92929, 0x3FC00},
	{94486, 0xF00000},
	{94507, 0xF000000},
	{94540, 0xF0000000},
	/* 2006 */
	{92970, 0xFF},
	{92980, 0x3FC00},
	{94529, 0xF000000},
	{94518, 0xF0000000},
	/* 2010 */
	{92920, 0xFF},
	{94486, 0xF00000},
	{94540, 0xF0000000},
	/* 2013 */
	{92920, 0x3FF},
	{94486, 0xF00000},
	{94540, 0xF0000000},
	/* 2016 */
	{94851, 0x1},
	{95086, 0xE, 6, 36604},
	{95100, 0x10},
	{95121, 0x3E0},
	{95139, 0x400},
	{95224, 0x800, 2, 36610},
	{95241, 0x1000},
	{95259, 0xE000},
	{95274, 0x20000},
	{95300, 0x1C0000},
	{95323, 0x200000},
	{95351, 0xC00000},
	/* 2028 */
	{92920, 0x1FF},
	{92929, 0x7FC00},
	{94486, 0xF00000},
	{94507, 0xF000000},
	{94540, 0xF0000000},
	/* 2033 */
	{92970, 0x1FF},
	{92980, 0x7FC00},
	{94529, 0xF000000},
	{94518, 0xF0000000},
	/* 2037 */
	{92920, 0x1FF},
	{94540, 0xF0000000},
	/* 2039 */
	{65921, 0xFFF},
	{95376, 0x3000},
	{10394, 0xC000},
	{95394, 0xFFFF0000},
	/* 2043 */
	{40178, 0xFFFF},
	{10394, 0xFFFF0000},
	/* 2045 */
	{40225, 0xFF},
	{65921, 0x700},
	{95418, 0xF800},
	{95434, 0x1F0000},
	{95447, 0x3E00000},
	{95460, 0x7C000000},
	{10394, 0x80000000},
	/* 2052 */
	{95473, 0xFF},
	{10394, 0xFFFFFF00},
	/* 2054 */
	{95495, 0x1FF},
	{10394, 0xFFFFFE00},
	/* 2056 */
	{95495, 0xFF},
	{10394, 0xFFFFFF00},
	/* 2058 */
	{40399, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2060 */
	{40424, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2062 */
	{40452, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2064 */
	{40480, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2066 */
	{40503, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2068 */
	{95512, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2070 */
	{10394, 0x1F},
	{95517, 0xFFFFFFE0},
	/* 2072 */
	{95536, 0x7F},
	{10394, 0xFFFFFF80},
	/* 2074 */
	{95536, 0x1FF},
	{10394, 0xFFFFFE00},
	/* 2076 */
	{95512, 0xFF},
	{10394, 0xFFFFFF00},
	/* 2078 */
	{95541, 0xFF},
	{95562, 0x100},
	{95572, 0x200},
	{95580, 0x400},
	{95594, 0x800},
	{95605, 0x1000},
	{95624, 0x2000},
	{95648, 0x4000},
	{95662, 0x8000},
	{10394, 0xFFFF0000},
	/* 2088 */
	{95672, 0x1},
	{95696, 0x2},
	{95720, 0x4},
	{95737, 0x8},
	{95754, 0x10},
	{95773, 0x20},
	{95790, 0x3C0},
	{10394, 0xFFFFFC00},
	/* 2096 */
	{95805, 0x1},
	{95817, 0x2},
	{95829, 0x4},
	{95839, 0x8},
	{95860, 0x10},
	{95877, 0x20},
	{95894, 0x40},
	{10394, 0xFFFFFF80},
	/* 2104 */
	{95918, 0xFFFF},
	{10394, 0xFFFF0000},
	/* 2106 */
	{95928, 0xFF},
	{10394, 0xFFFFFF00},
	/* 2108 */
	{95945, 0x7FFFF},
	{10394, 0xFFF80000},
	/* 2110 */
	{95434, 0xFF},
	{95447, 0xFF00},
	{95460, 0xFF0000},
	{95960, 0xFF000000},
	/* 2114 */
	{40225, 0xFF},
	{95418, 0xFF00},
	{10394, 0xFFFF0000},
	/* 2117 */
	{95973, 0x1},
	/* 2118 */
	{95997, 0x1},
	/* 2119 */
	{93221, 0x7, 6, 36588},
	{93649, 0x400},
	/* 2121 */
	{36876, 0xFF},
	/* 2122 */
	{9911, 0x1},
	{96015, 0x2},
	{18974, 0x4},
	{10394, 0xFFFFFFF8},
	/* 2126 */
	{96027, 0xF},
	{96032, 0x30},
	{10394, 0xFFFFFFC0},
	/* 2129 */
	{96039, 0x1},
	/* 2130 */
	{96059, 0x3},
	{96083, 0xC},
	{96107, 0x30},
	{96122, 0xC0},
	{96146, 0x300},
	{96170, 0x3C00},
	{96187, 0x7C000},
	{96205, 0x1F80000},
	{96241, 0x2000000},
	{96257, 0x4000000},
	/* 2140 */
	{92920, 0xFF},
	{96275, 0xFF00},
	{94540, 0xF000000},
	{9911, 0x10000000},
	{11261, 0x20000000},
	/* 2145 */
	{96288, 0xF},
	{96308, 0xFF00},
	{96322, 0xFF0000},
	{96335, 0x1000000},
	{96346, 0x2000000},
	{96356, 0x4000000},
	/* 2151 */
	{92920, 0x1FF},
	{94540, 0xF000000},
	{96377, 0xF0000000},
	/* 2154 */
	{92920, 0x3FF},
	{96387, 0xF0000000},
	/* 2156 */
	{91795, 0xF00, 6, 36612},
	{96439, 0x10000},
	{96451, 0x100000},
	{96466, 0xC0000000, 4, 36618},
	/* 2160 */
	{96477, 0xFFFFF},
	{96485, 0x100000},
	{55154, 0x800000},
	/* 2163 */
	{42929, 0xFFFFFFFF},
	/* 2164 */
	{26619, 0xFFFF},
	{91795, 0x300000, 4, 36622},
	{96506, 0x8000000, 2, 36618},
	{96528, 0x60000000, 4, 36626},
	{96536, 0x80000000},
	/* 2169 */
	{42813, 0xFFFFFFFF},
	/* 2170 */
	{91460, 0x3FFFFFF},
	{91471, 0x4000000, 2, 36630},
	{91475, 0x8000000, 2, 36630},
	{91479, 0x10000000, 2, 36632},
	{91484, 0x20000000, 2, 36632},
	{91489, 0x40000000},
	{96574, 0x80000000},
	/* 2177 */
	{85188, 0x3F},
	{96593, 0xF00},
	{96605, 0x1000},
	{96612, 0x2000},
	{96620, 0x4000},
	{96628, 0x8000},
	{96636, 0x10000},
	{96659, 0x60000, 4, 36634},
	{96684, 0x80000},
	{96696, 0x100000},
	{96704, 0x200000},
	{96748, 0xC00000, 3, 36638},
	/* 2189 */
	{96506, 0x1, 2, 36618},
	{91091, 0x6000},
	{91795, 0x300000, 4, 36622},
	{91131, 0x6000000},
	{96528, 0x60000000, 4, 36626},
	{96536, 0x80000000},
	/* 2195 */
	{96793, 0x3, 4, 36641},
	{96809, 0xC, 4, 36645},
	{96605, 0x10},
	{96612, 0x20},
	{96834, 0x40},
	{96841, 0x80},
	{96620, 0x100},
	{96628, 0x200},
	{96636, 0x400},
	{96659, 0x1800, 4, 36634},
	{96684, 0x2000},
	{96696, 0x4000},
	{96704, 0x8000},
	{96748, 0x30000, 3, 36638},
	{96849, 0x40000},
	/* 2210 */
	{96861, 0xFFFFF},
	/* 2211 */
	{55469, 0x1FF, 257, 0},
	{55474, 0x400},
	{55482, 0x800},
	{55495, 0x7000},
	{55503, 0x8000},
	{55514, 0xF0000},
	{55525, 0xF00000},
	{55541, 0x1000000},
	{96871, 0x10000000},
	{55567, 0xE0000000},
	/* 2221 */
	{55726, 0xF},
	{55733, 0x70},
	{55741, 0x80},
	{55755, 0xF00},
	{55764, 0x7000},
	{55791, 0xC00000},
	{55801, 0x1000000},
	{55827, 0xFC000000},
	/* 2229 */
	{43003, 0xFFFFF},
	/* 2230 */
	{56034, 0xF},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56163, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56263, 0x4000},
	{56278, 0x8000},
	{56289, 0x10000},
	{56297, 0x20000},
	{56306, 0x40000},
	{96881, 0x80000},
	{56338, 0x100000},
	{56351, 0x200000},
	{56361, 0x400000},
	{56378, 0x800000},
	{96901, 0x1000000},
	{96918, 0x2000000},
	{56395, 0x4000000},
	{56404, 0x8000000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	{56440, 0x80000000},
	/* 2259 */
	{56451, 0xF},
	{56490, 0x80},
	{56513, 0x100},
	{56536, 0x200},
	{56555, 0x1000},
	{56564, 0x2000},
	{56573, 0x4000},
	{56581, 0x8000},
	{56590, 0x10000},
	{56605, 0x100000},
	{56613, 0x200000},
	{56621, 0x400000},
	{56630, 0x800000},
	{56639, 0x1000000},
	{56647, 0x2000000},
	{56655, 0x4000000},
	{56663, 0x10000000},
	{56405, 0x20000000},
	{56681, 0x40000000},
	{56689, 0x80000000},
	/* 2279 */
	{43017, 0xFFFF},
	/* 2280 */
	{59845, 0x7FF, 2049, 257},
	{96935, 0x1000},
	{60007, 0xFF0000, 129, 2306},
	{60019, 0x3000000},
	{96960, 0x1C000000},
	{60032, 0x80000000},
	/* 2286 */
	{1011, 0x3},
	{60047, 0x4},
	{60056, 0x8},
	{60067, 0x10},
	{60080, 0x20},
	{49675, 0x1C0},
	{60094, 0x200},
	{60107, 0x400},
	{60120, 0x800},
	{60132, 0x1000},
	{60150, 0x2000},
	{60161, 0xC000},
	{60176, 0x30000},
	{60184, 0x40000},
	{60203, 0x80000},
	{96972, 0x700000},
	{96987, 0x10000000},
	{97010, 0x20000000},
	{60220, 0x40000000},
	{60232, 0x80000000},
	/* 2306 */
	{60246, 0xFFF},
	{60261, 0xFFF000},
	{60273, 0x1000000},
	{56284, 0x2000000},
	{60281, 0x4000000},
	{60301, 0x8000000},
	{97026, 0xF0000000},
	/* 2313 */
	{97037, 0x1},
	{97047, 0x2},
	{97057, 0x10},
	/* 2316 */
	{60447, 0x7},
	{60457, 0x38},
	{60467, 0x1C0},
	{60477, 0xE00},
	{17331, 0x7F000, 293, 2468},
	{64714, 0x600000},
	{64727, 0x800000},
	{64742, 0x1000000},
	{97085, 0xC000000},
	{64848, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2327 */
	{65250, 0x1FFFFF},
	{65269, 0xE00000},
	{65288, 0x1000000},
	{65310, 0x2000000},
	{97097, 0x4000000},
	{65348, 0x8000000},
	{65365, 0x10000000},
	{65383, 0x20000000},
	{65399, 0xC0000000},
	/* 2336 */
	{65420, 0x7},
	{65430, 0x38},
	{65451, 0xC0},
	{97120, 0x700},
	{65472, 0x180000},
	{65491, 0xC000000},
	/* 2342 */
	{18477, 0x1FFF},
	{21193, 0x3FFF},
	{67234, 0x1FFF0000},
	/* 2345 */
	{67245, 0xF},
	{67257, 0xF0},
	{67265, 0xFFF00},
	{67278, 0x700000},
	{67287, 0x800000},
	{67302, 0x2000000},
	{67317, 0x4000000},
	{71096, 0x80000000},
	/* 2353 */
	{67329, 0xFF},
	{97085, 0x300},
	{67345, 0x400},
	{67357, 0x18000},
	{67385, 0x60000},
	{67411, 0x80000},
	{67429, 0x100000},
	{67451, 0x200000},
	{67466, 0x400000},
	{67482, 0x800000},
	{67498, 0xFF000000},
	/* 2364 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{67630, 0x800000},
	{67640, 0x1000000},
	{67657, 0x2000000},
	{56004, 0x4000000},
	{97129, 0x8000000},
	{55275, 0x20000000},
	/* 2376 */
	{68912, 0x1},
	{68931, 0x2},
	{68952, 0x4},
	{68963, 0x8},
	{68976, 0x10},
	{68995, 0x20},
	{69020, 0x40},
	{69043, 0x80},
	{69057, 0xF00},
	{69069, 0x1000},
	{97148, 0x2000},
	/* 2387 */
	{69986, 0x3, 4, 3083},
	{70015, 0x1C},
	{70046, 0x20},
	{70082, 0x40},
	{70117, 0x80},
	{70145, 0x100},
	{70167, 0x200},
	{70185, 0x400},
	{70217, 0x800},
	{70338, 0x7000, 8, 3087},
	{70348, 0x38000},
	{70361, 0x1C0000},
	{70374, 0x200000},
	{70390, 0x400000},
	{70408, 0x800000},
	{70426, 0x2000000},
	{97166, 0x4000000},
	{97186, 0x18000000},
	/* 2405 */
	{97317, 0x7, 5, 36649},
	{97349, 0x30},
	{97369, 0xC0},
	/* 2408 */
	{70944, 0x3, 4, 3109},
	{70956, 0xC, 4, 3109},
	{70968, 0x30, 4, 3109},
	{70984, 0xC0, 4, 3109},
	{71054, 0x30000, 4, 3113},
	{71066, 0xC0000, 4, 3113},
	{71078, 0x300000, 4, 3113},
	{71094, 0x1000000},
	{71105, 0x2000000},
	{97389, 0x4000000},
	{97399, 0x8000000},
	{97409, 0x10000000},
	{97423, 0x20000000},
	/* 2421 */
	{9911, 0x1},
	{73637, 0x6},
	{65491, 0x60},
	{73679, 0x3000},
	{73686, 0x30000},
	{73700, 0x300000},
	/* 2427 */
	{73807, 0x3, 4, 3109},
	{73823, 0xC, 4, 3109},
	{73839, 0x30, 4, 3109},
	{73853, 0xC0, 4, 3109},
	{73869, 0x30000, 4, 3113},
	{73885, 0xC0000, 4, 3113},
	{73901, 0x300000, 4, 3113},
	{73915, 0xC00000, 4, 3113},
	{97438, 0x1000000},
	{97454, 0x2000000},
	{97470, 0x4000000},
	{97484, 0x8000000},
	{73931, 0x40000000},
	{73946, 0x80000000},
	/* 2441 */
	{783, 0x3F},
	{74716, 0x300},
	{74728, 0x400},
	{97500, 0x800},
	{74739, 0x1E000},
	{74748, 0x20000},
	{74762, 0x40000},
	{74766, 0x80000},
	{74783, 0x100000},
	{74801, 0x600000},
	{74819, 0x800000},
	{74839, 0x1000000},
	{74851, 0x2000000},
	/* 2454 */
	{783, 0x3F},
	{74716, 0x300},
	{74728, 0x400},
	{97500, 0x800},
	{74762, 0x40000},
	{74766, 0x80000},
	{74783, 0x100000},
	{74801, 0x600000},
	{74839, 0x1000000},
	{74851, 0x2000000},
	/* 2464 */
	{74863, 0x3E},
	{74879, 0x40},
	{74892, 0x80},
	{97514, 0x1F00},
	/* 2468 */
	{75413, 0x3F},
	{75434, 0x80},
	{75451, 0x100},
	{97532, 0x3E00},
	{75467, 0x4000},
	{75487, 0x8000},
	/* 2474 */
	{97548, 0x1},
	{97573, 0x2},
	{97598, 0x4},
	{97623, 0x8},
	{97648, 0x10},
	{97673, 0x20},
	{97698, 0x40},
	{97723, 0x80},
	/* 2482 */
	{76433, 0xF, 12, 36654},
	{76438, 0xF0, 12, 36654},
	{76443, 0xF00, 12, 36654},
	{76448, 0xF000, 12, 36654},
	{76453, 0xF0000, 12, 36654},
	{76458, 0xF00000, 12, 36654},
	{76463, 0xF000000, 12, 36654},
	{76468, 0xF0000000, 12, 36654},
	/* 2490 */
	{78247, 0x3, 4, 36055},
	{78293, 0xC, 2, 36059},
	{78304, 0x10},
	{78319, 0x20},
	{78327, 0x40},
	{78369, 0xE0000000},
	/* 2496 */
	{78860, 0x1},
	{97770, 0x2},
	{78878, 0x8},
	{1011, 0x70, 8, 36061},
	{78151, 0xFF0000, 256, 36069},
	/* 2501 */
	{80623, 0x1},
	{80639, 0x2},
	{80655, 0x4},
	{80671, 0x8},
	{80687, 0x10},
	{80703, 0x20},
	{80719, 0x40},
	{80735, 0x80},
	{80751, 0x100},
	{80767, 0x200},
	{80783, 0x400},
	{80799, 0x800},
	{80815, 0x1000},
	{80831, 0x2000},
	{80847, 0x4000},
	{80863, 0x8000},
	{80879, 0x10000},
	{80898, 0x20000},
	{80916, 0x40000},
	{80943, 0x80000},
	{80965, 0x100000},
	{80983, 0x200000},
	{81003, 0x400000},
	{81026, 0x800000},
	{81049, 0x1000000},
	{81074, 0x2000000},
	{81117, 0x8000000},
	{97793, 0x10000000},
	{97810, 0x20000000},
	{97835, 0x40000000},
	/* 2531 */
	{81819, 0x1},
	{81836, 0x2},
	{97861, 0x3FC},
	/* 2534 */
	{97880, 0x7, 5, 36649},
	{97906, 0x38, 5, 36649},
	{97935, 0x1C0, 5, 36649},
	{97960, 0xE00, 5, 36649},
	{97986, 0x2000},
	{98009, 0x4000},
	/* 2540 */
	{82969, 0x1},
	{82981, 0x2},
	{83002, 0x4},
	{83022, 0x8},
	{83068, 0x20},
	{83091, 0x40},
	/* 2546 */
	{214, 0x3, 3, 36374},
	{83812, 0xC, 4, 36377},
	{83892, 0x30, 4, 36381},
	{83952, 0xC0, 3, 36385},
	{83965, 0x100},
	{78319, 0x200},
	{83969, 0x400},
	{83978, 0x3800},
	{98036, 0x4000},
	/* 2555 */
	{85243, 0x2},
	{85277, 0x8},
	{85293, 0x10},
	{98061, 0x40},
	/* 2559 */
	{70736, 0x1},
	{85402, 0x2},
	{85413, 0x4},
	{85430, 0x8},
	{85447, 0x3F0},
	{85464, 0xFC00},
	{85481, 0x10000},
	{85505, 0x20000},
	{67416, 0x40000},
	{98139, 0x180000, 3, 36666},
	/* 2569 */
	{85753, 0x3, 4, 36452},
	{85784, 0x4, 2, 36456},
	{19787, 0x18, 4, 36458},
	{85866, 0x20, 2, 36462},
	{85931, 0xC0, 4, 36464},
	{85937, 0x100},
	{68265, 0x200},
	{85948, 0x400},
	{85968, 0x800},
	{85988, 0x1000},
	{86002, 0x2000},
	{86013, 0x4000},
	{86029, 0x78000},
	{86049, 0x180000},
	{86064, 0x200000},
	{86074, 0x400000},
	{86084, 0x800000},
	{86094, 0x1000000},
	{86109, 0x2000000},
	{98158, 0x4000000},
	/* 2589 */
	{87255, 0x7},
	{87272, 0x10},
	{87294, 0x1E000},
	{87310, 0x700000},
	{87331, 0x3000000},
	{87411, 0xC000000, 4, 36489},
	{98182, 0x10000000},
	{98207, 0x20000000},
	/* 2597 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 25, 36669},
	{65511, 0x80},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{89932, 0x80000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	{90231, 0x8000000},
	{90257, 0x10000000},
	{90325, 0x60000000, 3, 36576},
	{98248, 0x80000000},
	/* 2616 */
	{73961, 0x1},
	{90499, 0x2},
	{67357, 0xC, 3, 36579},
	{90613, 0x10, 2, 36582},
	{67385, 0x60},
	{67482, 0x180},
	{90639, 0x200},
	{90662, 0x3C00},
	{90682, 0x3C000},
	{74077, 0x40000},
	{90704, 0x80000},
	{90737, 0x100000},
	{98259, 0x200000},
	{98279, 0x400000},
	/* 2630 */
	{90794, 0x1FFF},
	{90805, 0x2000},
	{90817, 0x7C000},
	{90831, 0xF80000},
	{90845, 0x3000000},
	{90859, 0x4000000},
	{64742, 0x38000000},
	{90878, 0x40000000},
	{98300, 0x80000000},
	/* 2639 */
	{98321, 0xFFFFFF},
	{10143, 0x7000000},
	{98327, 0x8000000},
	{1, 0x70000000},
	{98338, 0x80000000},
	/* 2644 */
	{98349, 0x1},
	{26362, 0xFFFFFFF8},
	/* 2646 */
	{91660, 0x1},
	{91674, 0x2},
	{98358, 0x8000},
	{91686, 0x10000},
	{91700, 0x1000000},
	/* 2651 */
	{91795, 0x30000},
	{98373, 0x300000},
	{98388, 0xC00000},
	{91803, 0x7000000},
	{91811, 0xE0000000},
	/* 2656 */
	{214, 0x3, 3, 36374},
	{98036, 0x4000},
	/* 2658 */
	{92355, 0x3FF},
	{92421, 0xC00, 4, 36584},
	/* 2660 */
	{97362, 0x3},
	{97382, 0x30},
	/* 2662 */
	{92735, 0x1},
	{92747, 0x2},
	{92759, 0x4},
	{30224, 0x10000},
	{92770, 0x60000},
	/* 2667 */
	{80911, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{88792, 0x4000},
	{92814, 0x8000},
	{92826, 0x7FF0000},
	{92837, 0x8000000},
	{92848, 0x10000000},
	{92858, 0x20000000},
	{98398, 0x40000000},
	{92792, 0x80000000},
	/* 2678 */
	{92920, 0x1FF},
	{92939, 0xF00000},
	{94540, 0xF0000000},
	/* 2681 */
	{55932, 0x1},
	{85931, 0x2, 4, 36464},
	{85866, 0x4, 2, 36462},
	{19787, 0x8, 4, 36458},
	{85784, 0x10, 2, 36456},
	{85753, 0x20, 4, 36452},
	{94636, 0x40},
	{94642, 0x300},
	{94652, 0x2000},
	{98410, 0x4000},
	{98432, 0x8000},
	{98454, 0x10000},
	{98476, 0x20000},
	{98498, 0x40000},
	{98520, 0x80000},
	/* 2696 */
	{95536, 0x7FF},
	{10394, 0xFFFFF800},
	/* 2698 */
	{95541, 0xFF},
	{95562, 0x100},
	{95572, 0x200},
	{95580, 0x400},
	{95594, 0x800},
	{95605, 0x1000},
	{95624, 0x2000},
	{95648, 0x4000},
	{95662, 0x8000},
	{98542, 0x10000},
	{98555, 0x20000},
	{98566, 0x40000},
	{98583, 0x80000},
	{98597, 0x100000},
	{98609, 0x200000},
	{98625, 0x400000},
	{10394, 0xFF800000},
	/* 2715 */
	{95672, 0x1},
	{95696, 0x2},
	{95720, 0x4},
	{98641, 0x8},
	{95790, 0xF0},
	{98661, 0x100},
	{98681, 0x200},
	{98696, 0x400},
	{10394, 0xFFFFF800},
	/* 2724 */
	{95805, 0x1},
	{98721, 0x2},
	{98744, 0x4},
	{95894, 0x8},
	{98758, 0x10},
	{95817, 0x20},
	{98785, 0x40},
	{95829, 0x80},
	{98800, 0x100},
	{95839, 0x200},
	{98813, 0x400},
	{95860, 0x800},
	{98837, 0x1000},
	{95877, 0x2000},
	{98857, 0x4000},
	{98877, 0x8000},
	{98894, 0x10000},
	{98914, 0x20000},
	{98931, 0x40000},
	/* 2743 */
	{783, 0xFFFF},
	{10394, 0xFFFF0000},
	/* 2745 */
	{98951, 0xFF},
	{98965, 0xFF00},
	{98988, 0xFF0000},
	{10394, 0xFF000000},
	/* 2749 */
	{99015, 0xFF},
	{99031, 0xFF00},
	{10394, 0xFFFF0000},
	/* 2752 */
	{99047, 0xFFFF},
	/* 2753 */
	{55105, 0xF},
	{55114, 0xF0},
	{55124, 0x100},
	{55135, 0x200},
	{55140, 0x400},
	{99054, 0x800},
	{55267, 0x7F000, 257, 0},
	{55298, 0x10000000},
	{55304, 0xE0000000},
	/* 2762 */
	{55308, 0x1},
	{55312, 0x6},
	{99063, 0x18},
	{55331, 0x20},
	{55336, 0x40},
	{55344, 0x80},
	{55354, 0x100},
	{55365, 0x200},
	{55371, 0x400},
	{55376, 0x800},
	{55382, 0x1000},
	{55393, 0x2000},
	{55398, 0x4000},
	{99073, 0x8000},
	{55154, 0x10000},
	{55418, 0x20000},
	{55426, 0x40000},
	{55438, 0x80000},
	{99086, 0x100000},
	{99100, 0x200000},
	{99113, 0x400000},
	{99122, 0x800000},
	{99131, 0x7000000},
	{55457, 0x8000000},
	/* 2786 */
	{55469, 0x7F, 257, 0},
	{55514, 0x3F0000},
	{55567, 0xE0000000},
	/* 2789 */
	{50388, 0xF},
	{55575, 0x30},
	{55583, 0xC0},
	{55591, 0xF00},
	{55597, 0x1000},
	{28897, 0x2000},
	{55615, 0xF0000},
	{55621, 0xF00000},
	{55627, 0x7000000},
	{55636, 0x38000000},
	{55645, 0xC0000000},
	/* 2800 */
	{55651, 0x3F},
	{55661, 0x3F00},
	{55671, 0x3F0000},
	{55681, 0xF000000},
	/* 2804 */
	{55691, 0xFF},
	{55700, 0x1FF000},
	/* 2806 */
	{55726, 0xF},
	{55733, 0x70},
	{55755, 0x1F00},
	{55764, 0xE000},
	/* 2810 */
	{1141, 0xFF},
	/* 2811 */
	{99151, 0x7},
	{99159, 0x8},
	{99170, 0x10},
	{99183, 0xE0},
	{99199, 0x300},
	{99209, 0xC00},
	{99219, 0x70000},
	{55889, 0x380000},
	{99231, 0xC00000},
	{99238, 0x1000000},
	{99245, 0x6000000},
	{69579, 0x8000000},
	{99253, 0x10000000},
	/* 2824 */
	{10023, 0xFF},
	/* 2825 */
	{99270, 0x1},
	{99286, 0x2},
	{56378, 0x4},
	{99301, 0x8},
	{99317, 0x10},
	{56351, 0x20},
	{99326, 0x40},
	{99337, 0x80},
	{99347, 0x100},
	{99357, 0x200},
	{99367, 0x400},
	{99378, 0x800},
	{99389, 0x1000},
	{99401, 0x2000},
	{99410, 0x4000},
	{99420, 0x8000},
	{96901, 0x10000},
	{96918, 0x20000},
	{99429, 0x40000},
	{99447, 0x80000},
	{99462, 0x100000},
	/* 2846 */
	{99478, 0x2},
	{99493, 0x4},
	{99511, 0x8},
	{56475, 0x10},
	{99526, 0x20},
	{99542, 0x40},
	{99556, 0x100},
	{99565, 0x200},
	{99574, 0x400},
	{99595, 0x800},
	{99604, 0x1000},
	{99613, 0x2000},
	{99623, 0x4000},
	{99632, 0x10000},
	{99641, 0x20000},
	{99649, 0x80000},
	{99658, 0x100000},
	{99670, 0x200000},
	{99683, 0x400000},
	{99696, 0x20000000},
	/* 2866 */
	{99705, 0x1},
	{99715, 0x2},
	{99725, 0x4},
	{99735, 0x8},
	{99745, 0x10},
	{99755, 0x20},
	{99765, 0x40},
	{99775, 0x80},
	{99785, 0x100},
	{99795, 0x200},
	{99805, 0x400},
	{99815, 0x800},
	{99825, 0x1000},
	{99835, 0x2000},
	{99845, 0x4000},
	{99855, 0x8000},
	/* 2882 */
	{99865, 0xFF},
	/* 2883 */
	{99878, 0x3F},
	{99897, 0xFC0},
	/* 2885 */
	{56034, 0xF},
	{56263, 0x1},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56395, 0x100},
	{56163, 0x200},
	{57333, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	/* 2902 */
	{99908, 0xF},
	{99917, 0xF0},
	/* 2904 */
	{56451, 0xF},
	{99926, 0x20},
	{56490, 0x80},
	{56513, 0x100},
	{56536, 0x200},
	{56555, 0x1000},
	{56564, 0x2000},
	{56573, 0x4000},
	{56581, 0x8000},
	{99942, 0x10000},
	{99957, 0x20000},
	{99966, 0x40000},
	{99981, 0x80000},
	{56605, 0x100000},
	{99989, 0x200000},
	{56621, 0x400000},
	{56630, 0x800000},
	{56639, 0x1000000},
	{56647, 0x2000000},
	{56655, 0x4000000},
	{56663, 0x10000000},
	{56405, 0x20000000},
	{56681, 0x40000000},
	{56689, 0x80000000},
	/* 2928 */
	{56555, 0x2},
	{56564, 0x4},
	{56630, 0x400000},
	{99957, 0x800000},
	{56647, 0x1000000},
	{56573, 0x2000000},
	{56605, 0x4000000},
	{56621, 0x8000000},
	{56639, 0x20000000},
	{56655, 0x40000000},
	{56681, 0x80000000},
	/* 2939 */
	{99997, 0x1},
	{100011, 0x4},
	{100026, 0x10000},
	{100041, 0x20000},
	{100056, 0x40000},
	{100071, 0x80000},
	/* 2945 */
	{100086, 0x3F},
	/* 2946 */
	{92274, 0xFF},
	{100103, 0xFF00},
	{92229, 0xFF0000},
	{100112, 0x20000000},
	{92309, 0x40000000},
	{92335, 0x80000000},
	/* 2952 */
	{100132, 0xF},
	{100149, 0x1F00},
	/* 2954 */
	{47209, 0xFF},
	/* 2955 */
	{100164, 0x2},
	{100175, 0x20},
	{100186, 0x40},
	{100207, 0x80},
	{100227, 0xF00},
	{100249, 0x1000},
	/* 2961 */
	{100275, 0x1},
	{100283, 0x2},
	{100291, 0x2},
	{100300, 0x8},
	{100316, 0x10},
	{100332, 0x40},
	{100353, 0x80},
	{100374, 0x100},
	{100395, 0x200},
	{100403, 0x200},
	{100424, 0x400},
	{100445, 0x800},
	{100466, 0x1000},
	{100487, 0x2000},
	{100508, 0x4000},
	{100529, 0x8000},
	{100550, 0x10000},
	{100571, 0x20000},
	{100592, 0x40000},
	{100613, 0x80000},
	{100634, 0x100000},
	{100655, 0x200000},
	/* 2983 */
	{100676, 0x3FFFC},
	{100689, 0x300000},
	{100701, 0xC00000},
	{47262, 0x80000000},
	/* 2987 */
	{100711, 0x1},
	{100728, 0x80000},
	/* 2989 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{100748, 0x1000},
	{93802, 0x2000},
	{93828, 0x4000},
	{93854, 0x10000},
	{93881, 0x20000},
	{93907, 0x40000},
	{93933, 0x80000},
	{93961, 0x100000},
	{93987, 0x200000},
	{94013, 0x400000},
	{100775, 0x800000},
	{94039, 0x1000000},
	{94066, 0x2000000},
	{94093, 0x4000000},
	{100801, 0x8000000},
	{100827, 0x10000000},
	/* 3008 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{93802, 0x1000},
	{93828, 0x2000},
	{93854, 0x8000},
	{93881, 0x10000},
	{93961, 0x20000},
	{93987, 0x40000},
	{100748, 0x80000},
	{93907, 0x100000},
	{94066, 0x200000},
	/* 3020 */
	{47287, 0x3FFFF},
	/* 3021 */
	{100853, 0x1},
	{100866, 0x2},
	{100870, 0x4},
	{100892, 0x8},
	{100906, 0x10},
	{100920, 0x20},
	{100938, 0x40},
	{100956, 0x80},
	{28897, 0x2000000},
	{98106, 0xC000000},
	/* 3031 */
	{91009, 0x3},
	{9994, 0xFFFFFFFC},
	/* 3033 */
	{100971, 0x3},
	{24357, 0xFFFFFFFC},
	/* 3035 */
	{100992, 0x3},
	{24873, 0xFFFFFFFC},
	/* 3037 */
	{90983, 0xFF},
	{90995, 0x30000},
	{26682, 0xE0000000},
	/* 3040 */
	{101013, 0x3},
	{26232, 0xFFFFFFFC},
	/* 3042 */
	{26250, 0xFF},
	/* 3043 */
	{101030, 0x3},
	{26304, 0xFFFFFFFC},
	/* 3045 */
	{26322, 0xFF},
	/* 3046 */
	{26381, 0xFF},
	{91019, 0x10000},
	{91035, 0x100000},
	{91051, 0x3000000},
	{91067, 0xE0000000},
	/* 3051 */
	{91974, 0x1},
	{91990, 0x2},
	{92006, 0x40},
	{92024, 0x80},
	{92042, 0x100},
	{92060, 0x200},
	{92078, 0x400},
	{92096, 0x800},
	{92114, 0x1000},
	{92132, 0x2000},
	{92150, 0x4000},
	{91269, 0x8000},
	{101047, 0x10000},
	{91289, 0x40000},
	{92167, 0x80000},
	{92183, 0x200000},
	{91306, 0x400000},
	{91322, 0x800000},
	{91336, 0x2000000},
	{91350, 0x4000000},
	{91364, 0x8000000},
	{91385, 0x10000000},
	{91410, 0x20000000},
	/* 3074 */
	{92199, 0xFF},
	{91455, 0x3000000},
	{101065, 0x40000000},
	{1024, 0x80000000},
	/* 3078 */
	{26619, 0xFF},
	/* 3079 */
	{26660, 0xFF},
	/* 3080 */
	{91460, 0x1FFFFF},
	{91498, 0x200000},
	{101079, 0xC00000},
	{101088, 0x3000000},
	{91471, 0x4000000},
	{91475, 0x8000000},
	{91479, 0x10000000},
	{91484, 0x20000000},
	{91489, 0x40000000},
	/* 3089 */
	{91539, 0x30},
	{91551, 0xF0000},
	{91564, 0x10000000},
	{91579, 0x20000000},
	{91593, 0xC0000000},
	/* 3094 */
	{91654, 0x1},
	/* 3095 */
	{101097, 0x1},
	{101122, 0x2},
	{101160, 0x4},
	{101201, 0x8},
	{101224, 0x10},
	{101247, 0x20},
	{101271, 0x40},
	{101301, 0x80},
	{101330, 0x100},
	{101361, 0x400},
	{101387, 0x800},
	{101416, 0x1000},
	{101441, 0x2000},
	{59026, 0x4000},
	{59047, 0x8000},
	/* 3110 */
	{101476, 0x1},
	{101503, 0x4},
	{101530, 0x10},
	{101559, 0x400},
	{101588, 0x800},
	{101617, 0x1000},
	{101645, 0x2000},
	{101675, 0x4000},
	{101702, 0x8000},
	{101730, 0x10000},
	{101756, 0x20000},
	{101782, 0x800000},
	{101807, 0x1000000},
	{101833, 0x2000000},
	{101858, 0x4000000},
	{101882, 0x8000000},
	{101907, 0x10000000},
	{101936, 0x10000000},
	/* 3128 */
	{101964, 0x1},
	{101990, 0x2},
	{102016, 0x4},
	{102043, 0x10},
	{102069, 0x20},
	{102091, 0x40},
	{102112, 0x80},
	{102144, 0x100},
	{102171, 0x200},
	{102193, 0x400},
	{102217, 0x800},
	{102242, 0x1000},
	{102265, 0x2000},
	{102292, 0x4000},
	{102317, 0x8000},
	{102345, 0x10000},
	{102370, 0x20000},
	{102395, 0x40000},
	{102420, 0x80000},
	{102449, 0x100000},
	{102480, 0x200000},
	{102508, 0x400000},
	{102535, 0x800000},
	{102565, 0x1000000},
	{102592, 0x2000000},
	{102619, 0x4000000},
	{102646, 0x8000000},
	{102672, 0x10000000},
	{102696, 0x20000000},
	{102728, 0x40000000},
	{102755, 0x80000000},
	/* 3159 */
	{58363, 0x1},
	{102781, 0x40},
	{102800, 0x80},
	{102820, 0x100},
	{102839, 0x200},
	{102853, 0x400},
	{102866, 0x1000},
	{102888, 0x2000},
	{102911, 0x4000},
	{102932, 0x8000},
	{102949, 0x20000},
	{102964, 0x40000},
	{102978, 0x80000},
	{102992, 0x100000},
	{103008, 0x200000},
	{103021, 0x400000},
	/* 3175 */
	{103040, 0x80},
	{103055, 0x100},
	{58047, 0x200},
	{58061, 0x400},
	{58080, 0x800},
	{58099, 0x1000},
	{103070, 0x2000},
	{102844, 0x8000},
	{103078, 0x10000},
	{102858, 0x20000},
	{103087, 0x40000},
	{58175, 0x80000},
	{58190, 0x100000},
	{103098, 0x200000},
	{56352, 0x400000},
	{58223, 0x800000},
	{57040, 0x1000000},
	{103116, 0x2000000},
	{103013, 0x4000000},
	{57030, 0x8000000},
	{58114, 0x10000000},
	{58131, 0x20000000},
	{58153, 0x40000000},
	{56405, 0x80000000},
	/* 3199 */
	{1883, 0x3F},
	{103129, 0x3F00},
	{103144, 0x3F0000},
	/* 3202 */
	{47631, 0x1F},
	/* 3203 */
	{103159, 0xF},
	{103182, 0x3F00},
	/* 3205 */
	{103203, 0xF},
	/* 3206 */
	{103222, 0x10},
	{103243, 0x40},
	{103265, 0x100},
	{103286, 0x1000000},
	{103294, 0x2000000},
	{103302, 0x4000000},
	{103311, 0x8000000},
	{103320, 0x10000000},
	{103328, 0x20000000},
	/* 3215 */
	{103336, 0xFF},
	{103357, 0x700},
	{103378, 0xFF00000},
	{103398, 0x70000000},
	/* 3219 */
	{103418, 0x1},
	/* 3220 */
	{103439, 0xFFFFF},
	/* 3221 */
	{103447, 0xFFFFFFF},
	{103463, 0xF0000000},
	/* 3223 */
	{103479, 0xFFFF},
	{103494, 0xFFFF0000},
	/* 3225 */
	{27355, 0xFF},
	/* 3226 */
	{27409, 0xFF},
	/* 3227 */
	{27461, 0xFF},
	/* 3228 */
	{27592, 0xFF},
	/* 3229 */
	{103510, 0xFF},
	{103520, 0xFF00},
	{103530, 0xFF0000},
	{103543, 0xFF000000},
	/* 3233 */
	{103556, 0xFF},
	{103569, 0xFF00},
	{103582, 0xFF0000},
	{103595, 0xFF000000},
	/* 3237 */
	{103608, 0xFF},
	{103619, 0xFF00},
	{103630, 0xFF0000},
	/* 3240 */
	{103641, 0x3F},
	{103655, 0x3F00},
	/* 3242 */
	{103669, 0xFF},
	{103680, 0xFF00},
	/* 3244 */
	{103691, 0x7FF},
	{103704, 0x7FF0000},
	/* 3246 */
	{103716, 0x1FF},
	/* 3247 */
	{103724, 0x7FF},
	/* 3248 */
	{103736, 0x3FF},
	/* 3249 */
	{47935, 0x7FF},
	{103744, 0x3000},
	{103755, 0x30000},
	/* 3252 */
	{103769, 0x3FF},
	{103786, 0x3FF0000},
	/* 3254 */
	{103803, 0x3FF},
	{103822, 0x3FF0000},
	/* 3256 */
	{103841, 0x3FF},
	{103860, 0x3FF0000},
	/* 3258 */
	{103879, 0x3FF},
	/* 3259 */
	{103888, 0x3FF},
	{103897, 0x3FF0000},
	/* 3261 */
	{103906, 0x7FF},
	{103919, 0x7FF0000},
	/* 3263 */
	{103931, 0x7FF},
	/* 3264 */
	{103943, 0x3FF},
	{103960, 0x3FF0000},
	/* 3266 */
	{103977, 0x3FF},
	{103996, 0x3FF0000},
	/* 3268 */
	{104015, 0x3FF},
	{104034, 0x3FF0000},
	/* 3270 */
	{104053, 0x4000},
	{104079, 0x20000},
	{104109, 0x80000},
	{104132, 0x100000},
	{104156, 0x400000},
	{104180, 0x800000},
	{104202, 0x1000000},
	{104228, 0x4000000},
	{104252, 0x8000000},
	{104284, 0x20000000},
	{104306, 0x40000000},
	{104328, 0x80000000},
	/* 3282 */
	{92920, 0xFF},
	{92929, 0xFFC00},
	{94486, 0xF00000},
	{94507, 0xF000000},
	{94540, 0xF0000000},
	/* 3287 */
	{92920, 0xFF},
	{94540, 0xF0000000},
	/* 3289 */
	{104350, 0x3FF},
	/* 3290 */
	{48401, 0x1FF},
	/* 3291 */
	{48425, 0x3F},
	/* 3292 */
	{48448, 0x3F},
	/* 3293 */
	{78156, 0x7},
	{104361, 0x70000},
	/* 3295 */
	{48493, 0x3},
	{104374, 0x20},
	{104393, 0xC0},
	{104407, 0x200},
	{104419, 0x800},
	{104440, 0x1000},
	{104457, 0x2000},
	{104478, 0x1F0000},
	/* 3303 */
	{104487, 0x7F},
	{82670, 0x80},
	{104508, 0x3FFF00},
	{82735, 0xFFC00000},
	/* 3307 */
	{104525, 0x1F},
	/* 3308 */
	{104536, 0x3},
	/* 3309 */
	{99981, 0x1},
	{104554, 0x2},
	{104566, 0x4},
	{104582, 0x8},
	{104594, 0x10},
	/* 3314 */
	{104606, 0x3F},
	{104621, 0x40},
	/* 3316 */
	{104641, 0x3F},
	{104655, 0x40},
	/* 3318 */
	{99957, 0x1},
	{104674, 0x2},
	{104692, 0x4},
	{104705, 0x8},
	{104717, 0x10},
	{104729, 0x20},
	{104741, 0x40},
	{104753, 0x80},
	{104765, 0x100},
	{104777, 0x200},
	/* 3328 */
	{104791, 0xFF},
	/* 3329 */
	{18493, 0x3F, 29, 36694},
	/* 3330 */
	{214, 0x3, 2, 36374},
	/* 3331 */
	{104999, 0xF},
	{105008, 0xFF0},
	{105023, 0x1000000},
	{105038, 0x2000000},
	{105050, 0x4000000},
	{105061, 0x8000000},
	{105076, 0x10000000},
	{105091, 0x20000000},
	{105103, 0x40000000},
	{105117, 0x80000000},
	/* 3341 */
	{9911, 0x1},
	{10141, 0x1E},
	/* 3343 */
	{104999, 0xF},
	{105008, 0xFF0},
	{105023, 0x1000000},
	{105038, 0x2000000},
	{105050, 0x4000000},
	{105061, 0x8000000},
	{105076, 0x10000000},
	{105103, 0x20000000},
	{105130, 0x20000000},
	{105117, 0x80000000},
	/* 3353 */
	{105145, 0x1},
	{105158, 0x7E},
	{105175, 0x80},
	/* 3356 */
	{92355, 0x7F},
	{92421, 0x600, 4, 36584},
	/* 3358 */
	{105200, 0x6},
	{105210, 0x8},
	{105230, 0x10},
	{105239, 0xFFFF0000},
	/* 3362 */
	{105252, 0x1F},
	/* 3363 */
	{105266, 0x80000000},
	/* 3364 */
	{105274, 0x1},
	{105295, 0x6},
	{105308, 0x8},
	{105331, 0x10},
	{105351, 0x20},
	{105370, 0x10000000},
	{105381, 0x20000000},
	{105392, 0x40000000},
	{105403, 0x80000000},
	/* 3373 */
	{104999, 0xF},
	{105008, 0xFF0},
	{105023, 0x1000000},
	{105414, 0x2000000},
	{105429, 0x4000000},
	{105061, 0x8000000},
	{105076, 0x10000000},
	{105444, 0x20000000},
	{105460, 0x40000000},
	{105476, 0x80000000},
	/* 3383 */
	{105493, 0x80000000},
	/* 3384 */
	{18477, 0xFF},
	/* 3385 */
	{92920, 0x1FF},
	{92929, 0xFFC00},
	{94486, 0xF00000},
	/* 3388 */
	{105501, 0xFFFF},
	{105523, 0xFFFF0000},
	/* 3390 */
	{104999, 0xF},
	{105008, 0xFF0},
	{105023, 0x1000000},
	{105414, 0x2000000},
	{105429, 0x4000000},
	{105061, 0x8000000},
	{105076, 0x10000000},
	{105130, 0x20000000},
	{105545, 0x40000000},
	{105560, 0x80000000},
	/* 3400 */
	{105575, 0x3F},
	{105602, 0x7FC0},
	{105628, 0x1F8000},
	{105650, 0xFF800000},
	/* 3404 */
	{105675, 0x3F},
	{105699, 0xFC0},
	{105723, 0x3F000},
	{105743, 0xFC0000},
	/* 3408 */
	{105763, 0x3F},
	/* 3409 */
	{105777, 0x1},
	{105803, 0x2},
	{105826, 0x4},
	{105851, 0x8},
	{105882, 0x10},
	{105916, 0x20},
	{105936, 0xC0},
	{105963, 0x100},
	{105991, 0x200},
	{106026, 0x400},
	{106056, 0x800},
	{106091, 0x1000},
	{106121, 0x2000},
	{106144, 0x4000},
	{106183, 0x8000},
	{106215, 0x10000},
	{106251, 0x20000},
	{106281, 0x40000},
	{106327, 0x80000},
	{106368, 0x100000},
	{106418, 0x200000},
	{106468, 0x400000},
	{106519, 0x800000},
	{106567, 0x1000000},
	{105392, 0x40000000},
	{105403, 0x80000000},
	/* 3435 */
	{92267, 0xFF},
	{99054, 0x100},
	{106613, 0x200},
	{106632, 0x400},
	{106653, 0x800},
	{106672, 0x1000},
	{106694, 0x2000},
	{106715, 0x4000},
	{106738, 0x8000},
	/* 3444 */
	{106768, 0x3},
	{106784, 0xC},
	{106800, 0x30},
	{106816, 0x40},
	{106831, 0x80},
	{106849, 0x100},
	{106864, 0x200},
	{106883, 0x400},
	{106901, 0x800},
	/* 3453 */
	{106922, 0x1},
	{106938, 0x2},
	{106954, 0x4},
	/* 3456 */
	{106974, 0x7F},
	{106978, 0x380},
	{106982, 0x1FFC00},
	/* 3459 */
	{106986, 0x3F},
	{106999, 0xF00},
	{107011, 0x10000000},
	{107020, 0x20000000},
	{100956, 0x40000000},
	{100925, 0x80000000},
	/* 3465 */
	{107034, 0xF},
	{107054, 0xF00},
	{107071, 0x30000},
	{107087, 0xC0000},
	/* 3469 */
	{55932, 0x1},
	{85931, 0x2, 4, 36464},
	{85866, 0x4, 2, 36462},
	{19787, 0x8, 4, 36458},
	{85784, 0x10, 2, 36456},
	{85753, 0x20, 4, 36452},
	{94636, 0x40},
	{94642, 0x1F00},
	{94652, 0x2000},
	/* 3478 */
	{107107, 0xF0000},
	{107125, 0xF00000},
	{107143, 0xF000000},
	{107161, 0xF0000000},
	/* 3482 */
	{56284, 0x1},
	{107179, 0x2},
	{107198, 0xFFF0},
	{107213, 0xFFF0000},
	/* 3486 */
	{92920, 0x1FF},
	{94622, 0xF000},
	{107228, 0xF0000},
	{92939, 0xF00000},
	{107244, 0xF000000},
	{94540, 0xF0000000},
	/* 3492 */
	{107254, 0xFFFF},
	{107270, 0xFFFF0000},
	/* 3494 */
	{104999, 0xF},
	{105008, 0xFF0},
	{105103, 0x40000000},
	{105117, 0x80000000},
	/* 3498 */
	{50388, 0xF},
	{55575, 0x30},
	{107286, 0xFC0},
	{107296, 0x1000},
	{107306, 0x2000},
	{99865, 0x4000},
	{107317, 0x8000},
	{452, 0xFFFF0000},
	/* 3506 */
	{38, 0x3FFFFF},
	/* 3507 */
	{107327, 0x1F},
	{107334, 0x20},
	{60094, 0x80},
	{107341, 0x3000},
	{60107, 0x4000},
	{60120, 0x8000},
	{107352, 0xFFFF0000},
	{107352, 0xFFFF0000},
	/* 3515 */
	{2161, 0xFFFF},
	{107364, 0xFF0000},
	{60132, 0x1000000},
	/* 3518 */
	{107373, 0xFFFF},
	{107382, 0xFFFF0000},
	/* 3520 */
	{2119, 0x3FFFFFFF},
	{107391, 0xC0000000},
	/* 3522 */
	{60246, 0x7},
	{60261, 0x70000},
	{107403, 0x20000000},
	{56284, 0x40000000},
	{68610, 0x80000000},
	/* 3527 */
	{107411, 0x7},
	{107419, 0x38},
	{107427, 0x1C0},
	{107435, 0xE00},
	{107443, 0x7000},
	{107451, 0x38000},
	{107459, 0x1C0000},
	{1011, 0x600000},
	{107467, 0x1800000},
	{107480, 0x2000000},
	{55331, 0x4000000},
	{107493, 0x18000000},
	{107504, 0x20000000},
	{60067, 0x40000000},
	{65018, 0x80000000},
	/* 3542 */
	{107514, 0x80000000},
	/* 3543 */
	{49675, 0x7},
	/* 3544 */
	{107527, 0x3FFF},
	{107537, 0x3FFF0000},
	{107547, 0xC0000000},
	/* 3547 */
	{107560, 0x3FFF},
	{107576, 0x3FF0000},
	{107601, 0x78000000},
	{107626, 0x80000000},
	/* 3551 */
	{69307, 0x1},
	{68879, 0x2},
	{11261, 0x4},
	/* 3554 */
	{107640, 0xFF},
	{107649, 0xFF00},
	{107658, 0xFF0000},
	{107667, 0xFF000000},
	/* 3558 */
	{107676, 0x3F},
	{107684, 0x1F00},
	{107693, 0x1FF0000},
	/* 3561 */
	{107702, 0x3F},
	{107710, 0x1F00},
	{107719, 0x1FF0000},
	/* 3564 */
	{50388, 0xF},
	{55575, 0x30},
	{30508, 0x1C0},
	{55621, 0x1E00},
	/* 3568 */
	{60447, 0x7, 8, 36723},
	{60457, 0x38, 8, 36723},
	{60467, 0x1C0, 8, 36723},
	{60477, 0xE00, 8, 36723},
	{107992, 0x7000, 8, 36731},
	{108384, 0x78000, 16, 36739},
	{108396, 0x180000},
	{64714, 0x600000},
	{64727, 0x800000},
	{83965, 0x1000000},
	{108409, 0x2000000},
	{108421, 0x4000000},
	{83978, 0x38000000},
	{220, 0xC0000000, 4, 36755},
	/* 3582 */
	{60402, 0xFF},
	{65048, 0xFFF00},
	{108384, 0x3F00000, 64, 36759},
	{107992, 0x3C000000, 16, 36823},
	{83978, 0xC0000000},
	/* 3587 */
	{66768, 0x3FFF},
	{66875, 0xFFFC000},
	{67278, 0x70000000},
	{110479, 0x80000000},
	/* 3591 */
	{60447, 0x7, 8, 36723},
	{60457, 0x38, 8, 36723},
	{60467, 0x1C0, 8, 36723},
	{60477, 0xE00, 8, 36723},
	{67097, 0xF000},
	{67108, 0xF0000},
	{110490, 0x1F00000},
	{110503, 0x2000000},
	{83978, 0x4000000},
	{83965, 0x8000000},
	{220, 0xF0000000, 16, 36839},
	/* 3602 */
	{18477, 0x1FFF},
	{21193, 0x7FFE000},
	/* 3604 */
	{67234, 0x1FFF},
	{110814, 0x3FFE000},
	/* 3606 */
	{67265, 0xFFF},
	{67329, 0xFF000},
	{67302, 0x100000},
	{110825, 0xFFE00000},
	/* 3610 */
	{64859, 0x7, 8, 36855},
	{64867, 0x38, 8, 36855},
	{64875, 0x1C0, 8, 36855},
	{64883, 0xE00},
	{64899, 0x7000, 8, 36863},
	{64918, 0x8000},
	{64937, 0x70000},
	{64953, 0x80000},
	{64968, 0x100000},
	{64982, 0x7E00000},
	{64993, 0x8000000},
	{65005, 0x10000000},
	{65023, 0x60000000, 3, 36871},
	/* 3623 */
	{65080, 0x3FFF},
	{65124, 0xFC000},
	{65137, 0x300000, 4, 36874},
	{65151, 0xC00000, 4, 36874},
	{65165, 0x3000000, 3, 36878},
	{65174, 0xC000000, 3, 36881},
	{65185, 0x10000000},
	{111566, 0x20000000},
	{111583, 0x40000000},
	/* 3632 */
	{65089, 0xFFF},
	{111599, 0x20000000},
	{65106, 0xC0000000, 4, 36884},
	/* 3635 */
	{65420, 0x7},
	{65430, 0x70},
	{111741, 0x700},
	{65472, 0x3000},
	{111762, 0x70000},
	{111786, 0x700000},
	{111795, 0x3000000},
	{111815, 0x30000000},
	{111824, 0x40000000},
	/* 3644 */
	{111874, 0x3, 4, 36888},
	{65861, 0x3C, 16, 2765},
	{66289, 0x7C0, 18, 2781},
	{66479, 0x3800, 7, 2800},
	{66638, 0x1C00000, 5, 2807},
	{66658, 0x6000000},
	/* 3650 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{67640, 0x1000000},
	{111901, 0xE000000},
	{111911, 0x10000000},
	/* 3661 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{67703, 0x80},
	{67715, 0xFF00},
	{55267, 0x7F0000, 257, 0},
	/* 3667 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{68174, 0x4000000},
	{111901, 0x38000000},
	{111911, 0x40000000},
	/* 3679 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68200, 0x100},
	{68212, 0x200},
	{68224, 0x400},
	{68236, 0x800},
	{68248, 0x1000},
	{55267, 0xFE000, 257, 0},
	/* 3689 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68174, 0x1000000},
	{111901, 0xE000000},
	{111911, 0x10000000},
	/* 3700 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55267, 0x3F80, 257, 0},
	/* 3704 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{55267, 0x7F00, 257, 0},
	{55700, 0x1FF00000},
	/* 3710 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{111901, 0x7000000},
	{111911, 0x8000000},
	/* 3720 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68396, 0x100},
	{55267, 0xFE00, 257, 0},
	/* 3726 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{111901, 0x1C000000},
	{111911, 0x20000000},
	/* 3737 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55700, 0xFF80},
	{55267, 0x7F0000, 257, 0},
	/* 3742 */
	{68407, 0x1},
	{68425, 0x2},
	{68439, 0x4},
	{68458, 0x8},
	{68478, 0x10},
	{68498, 0x20},
	{68520, 0x40},
	{111921, 0x380},
	{68531, 0x400},
	{68549, 0x800},
	{99113, 0x1000},
	{68581, 0x4000},
	/* 3754 */
	{50384, 0xFFF},
	/* 3755 */
	{402, 0xFF},
	{99122, 0x100},
	/* 3757 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68634, 0x1000000},
	{111911, 0x2000000},
	/* 3767 */
	{68697, 0x3F},
	{111941, 0x3F},
	{68710, 0xF000},
	{68720, 0x3F0000},
	{68735, 0x400000},
	{68750, 0x800000},
	{68766, 0x7000000},
	/* 3774 */
	{111959, 0xFFFF},
	{111969, 0xFFFF0000},
	/* 3776 */
	{42983, 0x1},
	{111979, 0x2},
	{111988, 0x4},
	{111997, 0x8},
	{112005, 0x10},
	{112017, 0x20},
	{112029, 0x40},
	{112041, 0x80},
	{112053, 0x100},
	{112064, 0x200},
	{112074, 0x400},
	{112082, 0x800},
	{112108, 0x1000},
	{112121, 0x2000},
	{112132, 0x4000},
	{112142, 0x8000},
	{112156, 0x10000},
	{112172, 0x20000},
	{112188, 0x40000},
	{112204, 0x80000},
	{112215, 0x100000},
	{112232, 0x200000},
	{112248, 0x400000},
	{112267, 0x2000000},
	{112281, 0x4000000},
	{112290, 0x8000000},
	{112304, 0x30000000},
	{112319, 0x40000000},
	{112328, 0x80000000},
	/* 3805 */
	{69087, 0x1},
	{69111, 0x2},
	{69201, 0x70},
	{69213, 0xF00},
	{69226, 0xF000},
	{69239, 0xF0000},
	{69252, 0xF00000},
	{69266, 0xF000000},
	{69284, 0xF0000000},
	/* 3814 */
	{69301, 0x7FF},
	{69328, 0xFFE000},
	{69338, 0x1000000},
	{69350, 0x2000000},
	/* 3818 */
	{112342, 0xF},
	{65861, 0xF0, 16, 2765},
	{66289, 0x1F00, 18, 2781},
	{66763, 0x6000, 4, 2812},
	{66870, 0x18000, 4, 2816},
	{66982, 0x60000, 4, 2820},
	{67069, 0x180000, 4, 2824},
	/* 3825 */
	{17331, 0x3, 4, 3099},
	{70633, 0xC},
	{66479, 0xE000, 7, 2800},
	{90355, 0x700000},
	{70784, 0x8000000},
	{70799, 0x10000000},
	{70809, 0x20000000},
	{70829, 0x80000000},
	/* 3833 */
	{17331, 0x1, 2, 3107},
	{66479, 0xE000, 7, 2800},
	{90355, 0x700000},
	{70784, 0x8000000},
	{70872, 0x20000000},
	/* 3838 */
	{112361, 0x7FF},
	{112376, 0x3FF800},
	/* 3840 */
	{112392, 0x3FFFFF},
	/* 3841 */
	{50598, 0x3},
	/* 3842 */
	{75413, 0x3F},
	{75424, 0x40},
	{75467, 0x4000},
	/* 3845 */
	{11638, 0xFF},
	/* 3846 */
	{78878, 0x8},
	{1011, 0x70, 6, 36061},
	{78151, 0xFF0000, 256, 36069},
	/* 3849 */
	{18493, 0x1F, 29, 36694},
	{82477, 0x4000},
	{82490, 0x8000},
	{82503, 0x70000},
	/* 3853 */
	{83617, 0x3F, 3, 36370},
	{83630, 0x3F00, 3, 36370},
	{83645, 0x3F0000, 3, 36370},
	{83660, 0xFC00000, 3, 36370},
	{83675, 0x80000000},
	/* 3858 */
	{214, 0x3, 2, 36374},
	{83812, 0xC, 4, 36377},
	{83892, 0x30, 3, 36381},
	{83952, 0xC0, 4, 36892},
	{83965, 0x100},
	{78319, 0x200},
	{83969, 0x400},
	/* 3865 */
	{85188, 0x3F, 60, 36896},
	{60407, 0x7FC0000},
	{85199, 0x8000000},
	/* 3868 */
	{89941, 0x1},
	{85402, 0x2},
	{112534, 0x4},
	{112557, 0x8},
	{112565, 0x3F0},
	{112580, 0xFC00},
	{85481, 0x10000},
	/* 3875 */
	{220, 0x3, 3, 36468},
	{86263, 0x1C, 4, 36471},
	{86340, 0xE0, 4, 36475},
	{86349, 0x100},
	{86369, 0x200},
	{86380, 0x3C00},
	{86402, 0x4000},
	{83952, 0x18000, 4, 36892},
	/* 3883 */
	{86769, 0x1},
	{86784, 0x2},
	{86799, 0x4},
	{86814, 0x8},
	{86829, 0x70},
	{86861, 0xF00},
	{86878, 0x80000000},
	/* 3890 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 24, 36524},
	{65511, 0x80},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{89932, 0x80000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	/* 3905 */
	{91795, 0xF00, 5, 36612},
	{96439, 0x10000},
	{96451, 0x100000},
	{96466, 0xC0000000, 4, 36618},
	/* 3909 */
	{26619, 0xFFFF},
	{91795, 0x300000, 2, 36622},
	{96506, 0x8000000, 2, 36618},
	{96528, 0x60000000, 3, 36626},
	{96536, 0x80000000},
	/* 3914 */
	{91460, 0x1FFFFF},
	{96574, 0x200000},
	{101079, 0xC00000, 4, 36956},
	{101088, 0x3000000, 4, 36956},
	{91471, 0x4000000, 2, 36630},
	{91475, 0x8000000, 2, 36630},
	{91479, 0x10000000, 2, 36632},
	{91484, 0x20000000, 2, 36632},
	{91489, 0x40000000},
	/* 3923 */
	{96506, 0x1, 2, 36618},
	{91795, 0x300000, 2, 36622},
	{96528, 0x60000000, 3, 36626},
	{96536, 0x80000000},
	/* 3927 */
	{55105, 0xF},
	{55114, 0xF0},
	{55124, 0x100},
	{55135, 0x200},
	{55140, 0x400},
	{99054, 0x800},
	{55267, 0x1FF000, 257, 0},
	{55298, 0x10000000},
	{55304, 0xE0000000},
	/* 3936 */
	{55469, 0x1FF, 257, 0},
	{55514, 0x3F0000},
	{55567, 0xE0000000},
	/* 3939 */
	{50388, 0xF},
	{55575, 0x30},
	{55583, 0xC0},
	{55591, 0xF00},
	{55597, 0x1000},
	{28897, 0x6000},
	{55615, 0xF0000},
	{55621, 0xF00000},
	{55627, 0x7000000},
	{55636, 0x38000000},
	{55645, 0xC0000000},
	/* 3950 */
	{55726, 0xF},
	{55733, 0x70},
	{55755, 0xF00},
	{55764, 0x7000},
	/* 3954 */
	{56034, 0xF},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56163, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56263, 0x4000},
	{56395, 0x1000000},
	{57333, 0x2000000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	/* 3971 */
	{56950, 0x1},
	{56960, 0x2},
	{56970, 0x4},
	{56979, 0x8},
	{56988, 0x10},
	{56999, 0x20},
	{57010, 0x40},
	{57020, 0x80},
	{103040, 0x100},
	{103055, 0x200},
	{57030, 0x400},
	{57040, 0x800},
	{57057, 0x1000},
	{57175, 0x20000000},
	{57188, 0x40000000},
	{56422, 0x80000000},
	/* 3987 */
	{112620, 0x1},
	{112641, 0x2},
	{57685, 0x8},
	{57704, 0x10},
	{57724, 0x40},
	{57743, 0x100},
	{57764, 0x200},
	{57782, 0x400},
	{112662, 0x800},
	{112683, 0x1000},
	{57805, 0x2000},
	{57827, 0x10000},
	{57848, 0x20000},
	{57866, 0x40000},
	{112706, 0x80000},
	{112727, 0x100000},
	{57889, 0x200000},
	/* 4004 */
	{58004, 0x1},
	{58023, 0x2},
	{103040, 0x4},
	{103055, 0x8},
	{58032, 0x10},
	{58047, 0x20},
	{58061, 0x40},
	{58080, 0x80},
	{58099, 0x100},
	{58114, 0x200},
	{58131, 0x400},
	{58153, 0x800},
	{58175, 0x1000},
	{58190, 0x2000},
	{57030, 0x4000},
	{58205, 0x8000},
	{58350, 0x40000000},
	{56413, 0x80000000},
	/* 4022 */
	{58363, 0x1},
	{58381, 0x2},
	{58395, 0x4},
	{58414, 0x8},
	{58433, 0x10},
	{58448, 0x20},
	{58466, 0x40},
	{58484, 0x80},
	{58501, 0x100},
	{112750, 0x200},
	{58547, 0x800},
	{58571, 0x1000},
	{58589, 0x2000},
	{58607, 0x4000},
	{58628, 0x8000},
	{58652, 0x10000},
	{58678, 0x20000},
	{58695, 0x40000},
	{58715, 0x80000},
	{58735, 0x100000},
	{58755, 0x200000},
	{58776, 0x400000},
	{58799, 0x800000},
	{58820, 0x1000000},
	{58839, 0x2000000},
	{58856, 0x4000000},
	{58872, 0x8000000},
	{58888, 0x10000000},
	{58904, 0x20000000},
	{58923, 0x40000000},
	{58935, 0x80000000},
	/* 4053 */
	{58947, 0x1},
	{58966, 0x2},
	{58986, 0x4},
	{59006, 0x8},
	{101730, 0x10},
	{59026, 0x20},
	{59047, 0x40},
	/* 4060 */
	{107327, 0x1F},
	{107334, 0x20},
	{60094, 0x80},
	{55410, 0xF00},
	{107341, 0x3000},
	{60107, 0x4000},
	{60120, 0x8000},
	{107352, 0xFFFF0000},
	{107352, 0xFFFF0000},
	/* 4069 */
	{10023, 0xF},
	{83965, 0x10},
	/* 4071 */
	{112772, 0xFFFF},
	/* 4072 */
	{60246, 0x3FF},
	{60261, 0x3FF0000},
	{107403, 0x20000000},
	{56284, 0x40000000},
	{68610, 0x80000000},
	/* 4077 */
	{90983, 0xFFFF},
	{90995, 0x10000},
	{26682, 0xE0000000},
	/* 4080 */
	{112782, 0x1000},
	{91091, 0x6000},
	{112790, 0x8000},
	{91120, 0x300000},
	{112803, 0x1000000},
	{91131, 0x6000000},
	{112811, 0x8000000},
	{91160, 0x60000000},
	/* 4088 */
	{112824, 0x7F},
	{112836, 0x3F000},
	{11618, 0x6000000},
	{91774, 0x8000000},
	/* 4092 */
	{27672, 0xFFFF},
	{91795, 0x30000},
	{91803, 0x7000000},
	{91811, 0xE0000000},
	/* 4096 */
	{92787, 0x3F},
	{92792, 0xC0},
	{92800, 0x100},
	{92806, 0xFFFFFE00},
	/* 4100 */
	{80911, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{88792, 0x4000},
	{92814, 0x8000},
	{92826, 0x7FF0000},
	{92837, 0x8000000},
	{92848, 0x10000000},
	{92792, 0xE0000000},
	/* 4109 */
	{92970, 0x3F},
	{92980, 0xFC00},
	/* 4111 */
	{92920, 0x3F},
	{92929, 0xFC00},
	{94486, 0xF00000},
	/* 4114 */
	{92920, 0xFF},
	{94622, 0xF000},
	{107228, 0xF0000},
	{92939, 0xF00000},
	{107244, 0xF000000},
	{94540, 0xF0000000},
	/* 4120 */
	{51975, 0xFF},
	{10394, 0xFFFFFF00},
	/* 4122 */
	{26619, 0xFFFF},
	{91795, 0x300000, 4, 36960},
	{96506, 0x8000000, 2, 36618},
	{96528, 0x60000000, 4, 36626},
	{96536, 0x80000000},
	/* 4127 */
	{96506, 0x1, 2, 36618},
	{91091, 0x6000},
	{91795, 0x300000, 4, 36960},
	{91131, 0x6000000},
	{96528, 0x60000000, 4, 36626},
	{96536, 0x80000000},
	/* 4133 */
	{55105, 0xF},
	{55114, 0xF0},
	{55124, 0x100},
	{55135, 0x200},
	{55140, 0x400},
	{99054, 0x800},
	{55267, 0x1FF000, 257, 0},
	{112853, 0x8000000},
	{55298, 0x10000000},
	{55304, 0xE0000000},
	/* 4143 */
	{55308, 0x1},
	{55312, 0x6},
	{55321, 0x18},
	{55331, 0x20},
	{55336, 0x40},
	{55344, 0x80},
	{55354, 0x100},
	{55365, 0x200},
	{55371, 0x400},
	{55376, 0x800},
	{55382, 0x1000},
	{55393, 0x2000},
	{55398, 0x4000},
	{99073, 0x8000},
	{55154, 0x10000},
	{55418, 0x20000},
	{55426, 0x40000},
	{55438, 0x80000},
	{99086, 0x100000},
	{99100, 0x200000},
	{112864, 0x400000},
	{99122, 0x800000},
	{55457, 0x8000000},
	/* 4166 */
	{55469, 0x1FF, 257, 0},
	{55474, 0x400},
	{55514, 0x3F0000},
	{55567, 0xE0000000},
	/* 4170 */
	{55726, 0xF},
	{55733, 0x70},
	{55755, 0xF00},
	{55764, 0x7000},
	{55773, 0x8000},
	{55786, 0xF0000},
	/* 4176 */
	{99151, 0x7},
	{99159, 0x8},
	{99170, 0x10},
	{99183, 0xE0},
	{99199, 0x300},
	{99209, 0xC00},
	{99219, 0xF0000},
	{55889, 0xF00000},
	{99231, 0x3000000},
	{99238, 0x4000000},
	{99245, 0x18000000},
	{69579, 0x20000000},
	{99253, 0x40000000},
	/* 4189 */
	{112877, 0x1},
	{55834, 0x2},
	{55840, 0x4},
	{55869, 0xF0},
	{55874, 0xF00},
	/* 4194 */
	{56034, 0xF},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56163, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56263, 0x4000},
	{56395, 0x1000000},
	{57333, 0x2000000},
	{112884, 0x4000000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	/* 4212 */
	{56950, 0x1},
	{56960, 0x2},
	{56970, 0x4},
	{56979, 0x8},
	{56988, 0x10},
	{56999, 0x20},
	{57010, 0x40},
	{57020, 0x80},
	{57030, 0x400},
	{57040, 0x800},
	{57057, 0x1000},
	{112900, 0x2000},
	{57175, 0x20000000},
	{57188, 0x40000000},
	{56422, 0x80000000},
	/* 4227 */
	{57685, 0x8},
	{57704, 0x10},
	{57724, 0x40},
	{57743, 0x100},
	{57764, 0x200},
	{57782, 0x400},
	{57805, 0x2000},
	{57827, 0x10000},
	{57848, 0x20000},
	{57866, 0x40000},
	{57889, 0x200000},
	{112913, 0x400000},
	{112937, 0x800000},
	{112961, 0x1000000},
	/* 4241 */
	{58004, 0x1},
	{58023, 0x2},
	{58032, 0x10},
	{58047, 0x20},
	{58061, 0x40},
	{58080, 0x80},
	{58099, 0x100},
	{58114, 0x200},
	{58131, 0x400},
	{58153, 0x800},
	{58175, 0x1000},
	{58190, 0x2000},
	{57030, 0x4000},
	{58205, 0x8000},
	{58214, 0x10000},
	{112900, 0x20000},
	{58305, 0x4000000},
	{58318, 0x8000000},
	{58331, 0x30000000},
	{58350, 0x40000000},
	{56413, 0x80000000},
	/* 4262 */
	{58947, 0x1},
	{58966, 0x2},
	{58986, 0x4},
	{59006, 0x8},
	{59026, 0x20},
	{59047, 0x40},
	{112913, 0x80},
	{112937, 0x100},
	{112961, 0x200},
	/* 4271 */
	{60447, 0x7, 8, 36723},
	{60457, 0x38, 8, 36723},
	{60467, 0x1C0, 8, 36723},
	{60477, 0xE00, 8, 36723},
	{107992, 0x7000, 8, 36964},
	{108384, 0x78000, 16, 36739},
	{108396, 0x180000},
	{64714, 0x600000},
	{64727, 0x800000},
	{83965, 0x1000000},
	{108409, 0x2000000},
	{108421, 0x4000000},
	{83978, 0x38000000},
	{220, 0xC0000000, 4, 36755},
	/* 4285 */
	{60402, 0xFF},
	{65048, 0xFFF00},
	{108384, 0x3F00000, 64, 36759},
	{107992, 0x3C000000, 16, 36972},
	{83978, 0xC0000000},
	/* 4290 */
	{67265, 0xFFF},
	{67329, 0xFF000},
	{67302, 0x100000},
	{67451, 0x200000},
	{67466, 0x400000},
	{67482, 0x800000},
	{113144, 0xF000000},
	{113160, 0xF0000000},
	/* 4298 */
	{64859, 0x7, 8, 36855},
	{64867, 0x38, 8, 36855},
	{64875, 0x1C0, 8, 36855},
	{64883, 0xE00},
	{64899, 0x7000, 8, 36863},
	{64918, 0x8000},
	{64937, 0x70000},
	{64953, 0x80000},
	{64968, 0x100000},
	{64982, 0x7E00000},
	{64993, 0x8000000},
	{65005, 0x10000000},
	{65023, 0x60000000, 3, 36871},
	{113176, 0x80000000},
	/* 4312 */
	{65080, 0x3FFF},
	{65124, 0xFC000},
	{65137, 0x300000, 4, 36874},
	{65151, 0xC00000, 4, 36874},
	{65165, 0x3000000, 3, 36878},
	{65174, 0xC000000, 4, 36988},
	{65185, 0x10000000},
	{111566, 0x20000000},
	{111583, 0x40000000},
	{65204, 0x80000000},
	/* 4322 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68200, 0x100},
	{68212, 0x200},
	{68224, 0x400},
	{68236, 0x800},
	{68248, 0x1000},
	{55267, 0x3FE000, 257, 0},
	{68265, 0x1000000},
	/* 4333 */
	{83965, 0x1},
	{83978, 0x6},
	/* 4335 */
	{17331, 0x3, 4, 3099},
	{70633, 0xC},
	{66479, 0xE000, 7, 2800},
	{90355, 0x700000},
	{70760, 0x7800000},
	{70784, 0x8000000},
	{70799, 0x10000000},
	{70809, 0x20000000},
	{113222, 0x40000000},
	{70829, 0x80000000},
	/* 4345 */
	{17331, 0x1, 2, 3107},
	{66479, 0xE000, 7, 2800},
	{90355, 0x700000},
	{70784, 0x8000000},
	{70872, 0x20000000},
	{113222, 0x40000000},
	/* 4351 */
	{73961, 0x1},
	{113239, 0x2},
	{73988, 0x7C},
	/* 4354 */
	{78878, 0x8},
	{1011, 0x70, 7, 36061},
	{78151, 0xFF0000, 256, 36069},
	/* 4357 */
	{80623, 0x1},
	{80639, 0x2},
	{80655, 0x4},
	{80671, 0x8},
	{80687, 0x10},
	{80703, 0x20},
	{80719, 0x40},
	{80735, 0x80},
	{80751, 0x100},
	{80767, 0x200},
	{80783, 0x400},
	{80799, 0x800},
	{80815, 0x1000},
	{80831, 0x2000},
	{80847, 0x4000},
	{80863, 0x8000},
	{80879, 0x10000},
	{80898, 0x20000},
	{80916, 0x40000},
	{80943, 0x80000},
	{80965, 0x100000},
	{80983, 0x200000},
	{81003, 0x400000},
	{81026, 0x800000},
	{81049, 0x1000000},
	{81074, 0x2000000},
	{81117, 0x4000000},
	/* 4384 */
	{1011, 0x7, 6, 36360},
	{82670, 0x8},
	{82726, 0x30, 4, 36366},
	{82735, 0x7C0},
	{82746, 0x800},
	{82759, 0x1000},
	{82770, 0x2000},
	{93127, 0x4000},
	{113278, 0x8000},
	{113289, 0x10000},
	{82829, 0x20000},
	{82848, 0x40000},
	{82862, 0x80000},
	{82880, 0x100000},
	{82898, 0x600000},
	/* 4399 */
	{214, 0x3, 3, 36374},
	{83812, 0xC, 4, 36377},
	{83892, 0x30, 4, 36381},
	{83952, 0x40, 2, 36385},
	{78319, 0x200},
	{83969, 0x400},
	{83978, 0x1800},
	/* 4406 */
	{85188, 0x3F, 61, 36992},
	{60407, 0x7FC0000},
	{85199, 0x8000000},
	/* 4409 */
	{85304, 0xFFFF},
	{85319, 0x10000},
	{85338, 0x20000},
	{85352, 0x40000},
	{85371, 0x80000},
	{85385, 0x100000},
	{86029, 0xF0000000},
	/* 4416 */
	{89941, 0x1},
	{85402, 0x2},
	{112534, 0x4},
	{112557, 0x8},
	{112565, 0x3F0},
	{112580, 0xFC00},
	{85481, 0x10000},
	{113300, 0x20000},
	/* 4424 */
	{220, 0x3, 3, 36468},
	{86263, 0x1C, 4, 36471},
	{86340, 0xE0, 4, 36475},
	{86349, 0x100},
	{86369, 0x200},
	{86380, 0x3C00},
	{86402, 0x4000},
	{83952, 0x8000, 2, 36385},
	{86436, 0x60000, 3, 36479},
	{83978, 0x180000},
	/* 4434 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 24, 36524},
	{65511, 0x80},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{89932, 0x80000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	{90231, 0x8000000},
	{90257, 0x10000000},
	{90325, 0x60000000, 3, 36576},
	/* 4452 */
	{11618, 0x2000000},
	{83978, 0x18000000},
	/* 4454 */
	{90983, 0xFFFF},
	{90995, 0x10000},
	{90911, 0x2000000},
	{83978, 0x18000000},
	{26682, 0xE0000000},
	/* 4459 */
	{26250, 0xFFFF},
	{83978, 0x300000},
	{90911, 0x400000},
	/* 4462 */
	{26322, 0xFFFF},
	{83978, 0x300000},
	{90911, 0x400000},
	/* 4465 */
	{113314, 0xC00},
	{112782, 0x1000},
	{91091, 0x2000},
	{91120, 0x300000},
	{113324, 0xC00000},
	{112803, 0x1000000},
	{91131, 0x2000000},
	{91160, 0x60000000},
	/* 4473 */
	{91974, 0x1},
	{91990, 0x2},
	{113334, 0x4},
	{91208, 0x8},
	{92006, 0x40},
	{92024, 0x80},
	{92042, 0x100},
	{92060, 0x200},
	{92078, 0x400},
	{92096, 0x800},
	{92114, 0x1000},
	{92132, 0x2000},
	{92150, 0x4000},
	{91269, 0x8000},
	{91289, 0x40000},
	{92167, 0x80000},
	{92183, 0x200000},
	{91306, 0x400000},
	{91322, 0x800000},
	{91336, 0x2000000},
	{91350, 0x4000000},
	{91364, 0x8000000},
	{91385, 0x10000000},
	{91410, 0x20000000},
	{91431, 0x40000000},
	{113351, 0x80000000},
	/* 4499 */
	{112824, 0x7F},
	{112836, 0x3F000},
	{11618, 0x2000000},
	{83978, 0x18000000},
	/* 4503 */
	{92865, 0xFFFF},
	{92889, 0xF0000},
	{92876, 0x300000},
	{92267, 0x3FC00000},
	{92897, 0x40000000},
	{9911, 0x80000000},
	/* 4509 */
	{60402, 0xFF},
	{65048, 0xFFF00},
	{108384, 0x3F00000, 64, 37053},
	{107992, 0x3C000000, 16, 36972},
	{83978, 0xC0000000},
	/* 4514 */
	{78860, 0x1},
	{78878, 0x8},
	{1011, 0x70, 7, 36061},
	{78151, 0xFF0000, 256, 36069},
	/* 4518 */
	{85646, 0xFF},
	{85660, 0xFF00},
	{85670, 0xFF0000},
	{85681, 0xFF000000},
	/* 4522 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 31, 36524},
	{65511, 0x80},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{89932, 0x80000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	{90231, 0x8000000},
	{90257, 0x10000000},
	{90325, 0x60000000, 3, 36576},
	/* 4540 */
	{80911, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{88792, 0x4000},
	{92814, 0x8000},
	{92826, 0xFFF0000},
	{92837, 0x10000000},
	{92848, 0x20000000},
	{92792, 0xC0000000},
	/* 4549 */
	{55105, 0xF},
	{55114, 0xF0},
	{55124, 0x100},
	{55135, 0x200},
	{55140, 0x400},
	{99054, 0x800},
	{55267, 0x1FF000, 257, 0},
	{55275, 0x800000},
	{113669, 0x1000000},
	{113682, 0x2000000},
	{55285, 0x4000000},
	{112853, 0x8000000},
	{55298, 0x10000000},
	{55304, 0xE0000000},
	/* 4563 */
	{55308, 0x1},
	{55312, 0x6},
	{55321, 0x18},
	{55331, 0x20},
	{55336, 0x40},
	{55344, 0x80},
	{55354, 0x100},
	{55365, 0x200},
	{55371, 0x400},
	{55376, 0x800},
	{55382, 0x1000},
	{55393, 0x2000},
	{55398, 0x4000},
	{99073, 0x8000},
	{55154, 0x10000},
	{55418, 0x20000},
	{55426, 0x40000},
	{55438, 0x80000},
	{99086, 0x100000},
	{99100, 0x200000},
	{112864, 0x400000},
	{55446, 0x800000},
	{55457, 0x8000000},
	/* 4586 */
	{55469, 0x1FF, 257, 0},
	{55474, 0x400},
	{55482, 0x800},
	{55495, 0x7000},
	{55514, 0x3F0000},
	{55555, 0x10000000},
	{55567, 0xE0000000},
	/* 4593 */
	{55726, 0xF},
	{55733, 0x70},
	{55755, 0xF00},
	{55764, 0x7000},
	{55773, 0x8000},
	{55786, 0x1F0000},
	{55791, 0xC00000},
	/* 4600 */
	{99151, 0x7},
	{99159, 0x8},
	{99170, 0x10},
	{99183, 0xE0},
	{99199, 0x300},
	{99209, 0xC00},
	{99219, 0xF0000},
	{99231, 0x3000000},
	{99238, 0x4000000},
	{99245, 0x18000000},
	{69579, 0x20000000},
	{99253, 0x40000000},
	{113695, 0x80000000},
	/* 4613 */
	{112877, 0x1},
	{55834, 0x2},
	{55840, 0x4},
	{55869, 0x1F0},
	{55874, 0xF800},
	{55786, 0x7C0000},
	{55889, 0xFE000000},
	/* 4620 */
	{56034, 0xF},
	{56057, 0x10},
	{56080, 0x20},
	{56103, 0x40},
	{56123, 0x80},
	{56143, 0x100},
	{56163, 0x200},
	{56183, 0x400},
	{56203, 0x800},
	{56223, 0x1000},
	{56243, 0x2000},
	{56263, 0x4000},
	{56278, 0x8000},
	{56289, 0x10000},
	{56297, 0x20000},
	{56306, 0x40000},
	{56323, 0x80000},
	{56338, 0x100000},
	{56395, 0x1000000},
	{57333, 0x2000000},
	{112884, 0x4000000},
	{56413, 0x10000000},
	{56422, 0x20000000},
	{56431, 0x40000000},
	{56440, 0x80000000},
	/* 4645 */
	{56451, 0xF},
	{56474, 0x20},
	{56490, 0x80},
	{56513, 0x100},
	{56536, 0x200},
	{56555, 0x1000},
	{56564, 0x2000},
	{56573, 0x4000},
	{56581, 0x8000},
	{99942, 0x10000},
	{99957, 0x20000},
	{99966, 0x40000},
	{99981, 0x80000},
	{56605, 0x100000},
	{99989, 0x200000},
	{56621, 0x400000},
	{56630, 0x800000},
	{56639, 0x1000000},
	{56647, 0x2000000},
	{56655, 0x4000000},
	{56663, 0x10000000},
	{56405, 0x20000000},
	{56681, 0x40000000},
	{56689, 0x80000000},
	/* 4669 */
	{56555, 0x2},
	{56564, 0x4},
	{56297, 0x200000},
	{56630, 0x400000},
	{99957, 0x800000},
	{56647, 0x1000000},
	{56573, 0x2000000},
	{56605, 0x4000000},
	{56621, 0x8000000},
	{56639, 0x20000000},
	{56655, 0x40000000},
	{56681, 0x80000000},
	/* 4681 */
	{56950, 0x1},
	{56960, 0x2},
	{56970, 0x4},
	{56979, 0x8},
	{56988, 0x10},
	{56999, 0x20},
	{57010, 0x40},
	{57020, 0x80},
	{57030, 0x400},
	{57040, 0x800},
	{57057, 0x1000},
	{57065, 0x2000},
	{57078, 0x4000},
	{57175, 0x20000000},
	{57188, 0x40000000},
	{56422, 0x80000000},
	/* 4697 */
	{58004, 0x1},
	{58023, 0x2},
	{58032, 0x10},
	{58047, 0x20},
	{58061, 0x40},
	{58080, 0x80},
	{58099, 0x100},
	{58114, 0x200},
	{58131, 0x400},
	{58153, 0x800},
	{58175, 0x1000},
	{58190, 0x2000},
	{57030, 0x4000},
	{58205, 0x8000},
	{58214, 0x10000},
	{57065, 0x20000},
	{58305, 0x4000000},
	{58318, 0x8000000},
	{58331, 0x30000000},
	{58350, 0x40000000},
	{56413, 0x80000000},
	/* 4718 */
	{60447, 0x7, 8, 36723},
	{60457, 0x38, 8, 36723},
	{60467, 0x1C0, 8, 36723},
	{60477, 0xE00, 8, 36723},
	{107992, 0x7000, 8, 37117},
	{108384, 0x78000, 16, 36739},
	{113740, 0x80000},
	{113755, 0x100000},
	{64714, 0x600000},
	{64727, 0x800000},
	{82564, 0x8000000},
	{220, 0xC0000000, 4, 36755},
	/* 4730 */
	{60402, 0xFF},
	{65048, 0xFFF00},
	{108384, 0x3F00000, 64, 37125},
	{114239, 0x3F00000, 61, 37189},
	{107992, 0x3C000000, 16, 37250},
	{114746, 0x3C000000, 16, 37266},
	{82564, 0x40000000},
	{114763, 0x80000000},
	/* 4738 */
	{60447, 0x7, 8, 36723},
	{60457, 0x38, 8, 36723},
	{60467, 0x1C0, 8, 36723},
	{60477, 0xE00, 8, 36723},
	{67097, 0xF000},
	{67108, 0xF0000},
	{67119, 0x1F00000},
	{220, 0xF0000000, 16, 36839},
	/* 4746 */
	{18477, 0x1FFF},
	{21193, 0x1FFFE000},
	{67223, 0xE0000000, 6, 2828},
	/* 4749 */
	{67234, 0x1FFF},
	{67245, 0x1E000},
	{114775, 0x1FE0000},
	{90805, 0x2000000},
	{67411, 0x4000000},
	{114793, 0x8000000},
	{67257, 0xF0000000},
	/* 4756 */
	{65080, 0x3FFF},
	{65124, 0xFC000},
	{65137, 0x300000, 4, 36874},
	{65151, 0xC00000, 4, 36874},
	{65165, 0x3000000, 3, 36878},
	{65174, 0xC000000, 4, 36988},
	{65185, 0x10000000},
	{65219, 0x20000000},
	{111583, 0x40000000},
	{65204, 0x80000000},
	/* 4766 */
	{65089, 0xFFF},
	{65035, 0x1000},
	{65106, 0xC0000000, 4, 36884},
	/* 4769 */
	{65420, 0x7},
	{65430, 0x38},
	{65451, 0xC0},
	{111741, 0x700},
	{67069, 0x7000, 4, 2824},
	{111762, 0x70000},
	{65472, 0x180000},
	{111786, 0xE00000},
	{111795, 0x3000000},
	{65491, 0xC000000},
	{111815, 0x30000000},
	{111824, 0x40000000},
	{114809, 0x80000000},
	/* 4782 */
	{67519, 0xFFFF},
	{67525, 0x3F0000},
	{67536, 0x3C00000},
	{114819, 0x3C000000},
	/* 4786 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{67640, 0x1000000},
	{111911, 0x10000000},
	{55275, 0x20000000},
	/* 4797 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{67703, 0x80},
	{67715, 0xFF00},
	{55267, 0x1FF0000, 257, 0},
	{67730, 0x2000000},
	{67752, 0x4000000},
	{68282, 0x8000000},
	{67777, 0x10000000},
	/* 4807 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68160, 0x3000000},
	{68174, 0x4000000},
	{111911, 0x40000000},
	{55275, 0x80000000},
	/* 4819 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68190, 0x80},
	{68200, 0x100},
	{68212, 0x200},
	{68224, 0x400},
	{68236, 0x800},
	{68248, 0x1000},
	{55267, 0x3FE000, 257, 0},
	{68254, 0x400000},
	{68265, 0x1000000},
	{68282, 0x8000000},
	{67777, 0x10000000},
	/* 4833 */
	{68319, 0x7F},
	{68294, 0x3F80},
	/* 4835 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68174, 0x1000000},
	{111911, 0x10000000},
	{68345, 0x60000000},
	{55275, 0x80000000},
	/* 4847 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55267, 0xFF80, 257, 0},
	{68362, 0x30000},
	{68190, 0x40000},
	{55700, 0x7F80000},
	{68282, 0x8000000},
	{67777, 0x10000000},
	/* 4856 */
	{67525, 0x3F},
	{67536, 0x3C0},
	{114819, 0x3C00},
	{67519, 0xFFFF0000},
	/* 4860 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{111911, 0x8000000},
	{68379, 0x30000000},
	{55275, 0x40000000},
	/* 4871 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{55267, 0xFF80, 257, 0},
	{55700, 0x1FF0000},
	{68282, 0x8000000},
	{67777, 0x10000000},
	/* 4878 */
	{68407, 0x1},
	{68425, 0x2},
	{68439, 0x4},
	{68458, 0x8},
	{68478, 0x10},
	{68498, 0x20},
	{68520, 0x40},
	{68531, 0x400},
	{68549, 0x800},
	{10394, 0x1000},
	{68581, 0x4000},
	/* 4889 */
	{67564, 0x3F},
	{67570, 0x3C0},
	{65260, 0xC00},
	{67619, 0xFF000, 241, 2834},
	{55331, 0x100000},
	{55124, 0x200000},
	{111890, 0x400000},
	{67630, 0x800000},
	{68634, 0x1000000},
	{111911, 0x2000000},
	{55275, 0x4000000},
	/* 4900 */
	{67669, 0x1},
	{67680, 0x3E},
	{67690, 0x40},
	{68640, 0x80},
	{68650, 0x100},
	{68660, 0x200},
	{68396, 0x400},
	{68670, 0x1800},
	{68685, 0x6000},
	{55700, 0xFF8000},
	{55267, 0x7F000000, 257, 0},
	{68282, 0x80000000},
	/* 4912 */
	{68697, 0x3FF},
	{68710, 0xF000},
	{68720, 0x3F0000},
	{68735, 0x400000},
	{68750, 0x800000},
	{68766, 0x7000000},
	{114819, 0x78000000},
	/* 4919 */
	{69301, 0x7FF},
	{69328, 0xFFE000},
	{69338, 0x1000000},
	{69350, 0x2000000},
	{69368, 0x3C000000},
	/* 4924 */
	{17331, 0x3, 4, 3099},
	{70633, 0xC},
	{67119, 0x1F0},
	{70717, 0x1000},
	{70688, 0x6000, 4, 3103},
	{70703, 0x8000},
	{70753, 0xF0000},
	{70760, 0x7800000},
	{70784, 0x8000000},
	{70799, 0x10000000},
	{70809, 0x20000000},
	{113222, 0x40000000},
	{70829, 0x80000000},
	/* 4937 */
	{17331, 0x1, 2, 3107},
	{67119, 0x1F0},
	{70717, 0x1000},
	{70688, 0x6000, 4, 3103},
	{70703, 0x8000},
	{70784, 0x8000000},
	{70872, 0x20000000},
	{113222, 0x40000000},
	/* 4945 */
	{54769, 0xFFFF},
	/* 4946 */
	{71702, 0x3, 4, 35886},
	{71714, 0xC, 4, 35886},
	{71826, 0x30, 4, 35890},
	{71883, 0x40, 2, 35894},
	{71939, 0x80, 2, 35896},
	{72043, 0x300, 4, 35898},
	{72151, 0xC00, 4, 35902},
	{72260, 0x3000, 4, 35906},
	{72373, 0xC000, 4, 35910},
	{72475, 0x30000, 4, 35914},
	{72621, 0xC0000, 4, 35918},
	{72768, 0x300000, 4, 35922},
	{72868, 0x3000000, 4, 35926},
	{73014, 0x1C000000, 5, 37282},
	{73161, 0xE0000000, 5, 37287},
	/* 4961 */
	{73281, 0x3, 4, 35938},
	{73452, 0x1C, 5, 37292},
	{73624, 0xE0, 5, 37297},
	/* 4964 */
	{73961, 0x1},
	{113239, 0x2},
	{73988, 0x7C},
	{74017, 0x100},
	{74046, 0x200},
	{74077, 0x400},
	{74105, 0x1000},
	{74133, 0x2000},
	{74163, 0x4000},
	/* 4973 */
	{80623, 0x1},
	{80639, 0x2},
	{80655, 0x4},
	{80671, 0x8},
	{80687, 0x10},
	{80703, 0x20},
	{80719, 0x40},
	{80735, 0x80},
	{80751, 0x100},
	{80767, 0x200},
	{80783, 0x400},
	{80799, 0x800},
	{80815, 0x1000},
	{80831, 0x2000},
	{80847, 0x4000},
	{80863, 0x8000},
	{80879, 0x10000},
	{80898, 0x20000},
	{80916, 0x40000},
	{80943, 0x80000},
	{80965, 0x100000},
	{80983, 0x200000},
	{81003, 0x400000},
	{81026, 0x800000},
	{81049, 0x1000000},
	{81074, 0x2000000},
	{81117, 0x4000000},
	{81094, 0x8000000},
	/* 5001 */
	{81723, 0x1},
	{81495, 0x2},
	{81519, 0x4},
	{81539, 0x8},
	{81560, 0x10},
	{81761, 0x40},
	/* 5007 */
	{81790, 0x1},
	{81801, 0x2},
	{114986, 0x4},
	/* 5010 */
	{92568, 0x1},
	{81971, 0x1E},
	{81983, 0xE0},
	{81997, 0x300},
	{82013, 0x1C00},
	{82024, 0x1E000},
	/* 5016 */
	{214, 0x3, 3, 36374},
	{83812, 0xC, 4, 36377},
	{83892, 0x30, 4, 36381},
	{83952, 0x40, 2, 36385},
	{86002, 0x100},
	{78319, 0x200},
	{83969, 0x400},
	/* 5023 */
	{85188, 0x3F, 64, 37302},
	{60407, 0x7FFFC00},
	{85199, 0x8000000},
	/* 5026 */
	{54888, 0xFFFF},
	/* 5027 */
	{85229, 0x1},
	{85243, 0x2},
	{115049, 0x4},
	{85259, 0x8},
	/* 5031 */
	{85402, 0x2},
	{112534, 0x4},
	{112557, 0x8},
	{112565, 0x3F0},
	{112580, 0xFC00},
	{85481, 0x10000},
	{67416, 0x40000},
	{114798, 0x80000},
	/* 5039 */
	{85753, 0x3, 4, 36452},
	{85784, 0x4, 2, 36456},
	{19787, 0x18, 4, 36458},
	{85866, 0x20, 2, 36462},
	{85931, 0xC0, 4, 36464},
	{68265, 0x200},
	{85948, 0x400},
	{85968, 0x800},
	{85988, 0x1000},
	{86002, 0x2000},
	{86013, 0x4000},
	{86029, 0x78000},
	{86049, 0x180000},
	/* 5052 */
	{220, 0x3, 3, 36468},
	{86263, 0x1C, 4, 36471},
	{86340, 0xE0, 4, 36475},
	{86349, 0x100},
	{86369, 0x200},
	{86402, 0x4000},
	{83952, 0x8000, 2, 36385},
	{86436, 0x60000, 4, 36479},
	/* 5060 */
	{88091, 0x3, 4, 36505},
	{88104, 0x4},
	{88115, 0x8},
	{88224, 0x70},
	{88242, 0x380},
	{88260, 0x1C00},
	{88283, 0x3E000},
	{88309, 0x40000},
	{88331, 0x7F80000},
	{88347, 0x8000000},
	{88369, 0x10000000},
	/* 5071 */
	{88508, 0x1},
	{88525, 0x1E},
	{88549, 0x20},
	{88567, 0x3C0},
	{88592, 0x400},
	{88622, 0x800},
	{88637, 0x1000},
	{88652, 0x2000},
	{88687, 0x4000},
	{88723, 0x8000},
	{88813, 0x30000},
	{88837, 0x40000},
	{88873, 0x80000},
	{88909, 0x100000},
	{88935, 0x200000},
	{88959, 0x400000},
	{88979, 0x800000},
	{89000, 0x1000000},
	/* 5089 */
	{69301, 0x7FF},
	{69328, 0xFFE000},
	{89169, 0xF000000},
	/* 5092 */
	{89230, 0x3, 4, 36520},
	{17331, 0x7C, 32, 36524},
	{89828, 0x700, 8, 36556},
	{89884, 0x1800, 4, 36564},
	{78927, 0x2000},
	{69921, 0x4000},
	{89894, 0x8000},
	{89906, 0x10000},
	{89919, 0x20000},
	{87498, 0x40000},
	{90159, 0x700000, 8, 36568},
	{90181, 0x3800000, 8, 36568},
	{90205, 0x4000000},
	{90231, 0x8000000},
	{90257, 0x10000000},
	{90325, 0x60000000, 3, 36576},
	/* 5108 */
	{90794, 0x7FF},
	{90805, 0x800},
	{70633, 0x7000},
	{90411, 0x18000},
	{90425, 0x20000},
	{90817, 0x7C0000},
	{90831, 0xF800000},
	{90845, 0x30000000},
	{114798, 0x40000000},
	{67416, 0x80000000},
	/* 5118 */
	{90983, 0xFFFF},
	{90995, 0x10000},
	{90911, 0x2000000},
	{26682, 0xE0000000},
	/* 5122 */
	{26250, 0xFFFF},
	{90911, 0x400000},
	/* 5124 */
	{26322, 0xFFFF},
	{90911, 0x400000},
	/* 5126 */
	{91078, 0x400},
	{91091, 0x2000},
	{91120, 0x300000},
	{91131, 0x2000000},
	{91160, 0x60000000},
	/* 5131 */
	{91505, 0x1},
	{91539, 0x30},
	{91551, 0xF0000},
	{91564, 0x10000000},
	{91579, 0x20000000},
	{91593, 0xC0000000},
	/* 5137 */
	{112824, 0x7F},
	{112836, 0x3F000},
	{90911, 0x2000000},
	{91787, 0x10000000},
	/* 5141 */
	{92217, 0xF},
	{92229, 0xF0},
	{100103, 0xF00},
	{115068, 0xF000},
	{92257, 0x30000},
	{92267, 0xC0000},
	{9911, 0x100000},
	{10394, 0xFFE00000},
	/* 5149 */
	{214, 0x3, 3, 36374},
	{86002, 0x100},
	/* 5151 */
	{107411, 0x7},
	{107419, 0x38},
	{107427, 0x1C0},
	{107435, 0xE00},
	{107443, 0x7000},
	{107451, 0x38000},
	{107459, 0x1C0000},
	{1011, 0x600000},
	{107467, 0x1800000},
	{107480, 0x2000000},
	{115077, 0x4000000},
	{107493, 0x18000000},
	{107504, 0x20000000},
	{60067, 0x40000000},
	{65018, 0x80000000},
	/* 5166 */
	{60246, 0x3FF},
	{60261, 0x3FF0000},
	{96871, 0x10000000},
	{107403, 0x20000000},
	{56284, 0x40000000},
	{68610, 0x80000000},
	/* 5172 */
	{80911, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{88792, 0x4000},
	{92814, 0x8000},
	{92826, 0xFFF0000},
	{92837, 0x10000000},
	{92848, 0x20000000},
	{92858, 0x40000000},
	{92792, 0x80000000},
	/* 5182 */
	{115088, 0xF},
	{115103, 0x10},
	{115127, 0x20},
	{115147, 0x40},
	{115163, 0x80},
	{115179, 0x100},
	{115205, 0x200},
	{115222, 0x3C00},
	{115238, 0x4000},
	{115259, 0x8000},
	{115280, 0xFFFF0000},
	/* 5193 */
	{115294, 0xF},
	{115335, 0xF0},
	/* 5195 */
	{115374, 0x3},
	{115387, 0xC},
	{115400, 0x30},
	{115413, 0xC0},
	/* 5199 */
	{115426, 0x3FF},
	{115436, 0xFFC00},
	{92939, 0xF00000},
	{92948, 0xF000000},
	{92959, 0xF0000000},
	/* 5204 */
	{115446, 0x3FF},
	{115456, 0xFFC00},
	{92990, 0xF000000},
	{93001, 0xF0000000},
	/* 5208 */
	{452, 0x7},
	{11261, 0x40000000},
	{9911, 0x80000000},
	/* 5211 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{100748, 0x1000},
	{93802, 0x2000},
	{93828, 0x4000},
	{93854, 0x10000},
	{93881, 0x20000},
	{93907, 0x40000},
	{93933, 0x80000},
	{93961, 0x100000},
	{93987, 0x200000},
	{94013, 0x400000},
	{100775, 0x800000},
	{94039, 0x1000000},
	{94066, 0x2000000},
	{94093, 0x4000000},
	{100801, 0x8000000},
	{100827, 0x10000000},
	{94173, 0x20000000},
	{94202, 0x40000000},
	{94228, 0x80000000},
	/* 5233 */
	{92920, 0x3F},
	{93748, 0x400},
	{93775, 0x800},
	{93802, 0x1000},
	{93828, 0x2000},
	{93854, 0x8000},
	{93881, 0x10000},
	{93961, 0x20000},
	{93987, 0x40000},
	{100748, 0x80000},
	{93907, 0x100000},
	{94066, 0x200000},
	{94228, 0x400000},
	/* 5246 */
	{115466, 0xFF},
	{10394, 0xFFFFFF00},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'I', 'K', '\0', /* INDIRECT_BUFFER_CIK (481) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (501) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (511, 520) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (523) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (536) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (550) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (561) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (573) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (589) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (605) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (617) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (633) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (647) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (659) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (666) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (683) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (695) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (712) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (730) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (745) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (761) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (772, 783) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (790) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (806) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (828) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (843) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (859) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (874, 887) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (895) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (916) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (935) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (952) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (975) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (987) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (994) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1003, 1011, 1013) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1016, 1024) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1031) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1047) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1068) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1086) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1104) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1119) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1133, 1141) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1147) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1164) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1180) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1197) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1212) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1227) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1247) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1266) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1286) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1302) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1316) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1330) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1344) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1358) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1372) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1386) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1400) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1414) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1428) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1442) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1457) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1472) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1487) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1502) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1517) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1532) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1543) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1559) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1575) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1599) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1623) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1647) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1660) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1672) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1688) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (1704) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (1717) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (1733) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (1749) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (1763) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (1780) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (1801) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (1815) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (1832) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (1853) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (1871, 1883, 1888) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (1894, 1901) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (1915) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (1935) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (1958) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (1976) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (1999) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2025) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2051) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2077) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2103, 2119) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2124) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2145, 2161) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2172) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2193) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2216) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2245) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2275) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2307) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2338) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2371) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2380) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2398) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2416) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2434) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2452) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2470) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2488) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2506) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2524) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2540) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2555) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2569) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2583) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2597) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2611) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2625) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2639) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2653) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2667) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2681) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (2695) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (2710) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (2725) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (2740) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (2755) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (2770) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (2785) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (2800) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (2815) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (2830) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (2845) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (2860) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (2875) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (2890) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (2905) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (2920) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (2935) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (2950) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (2965) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (2980) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (2995) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3010) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3025) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3044) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3063) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3082) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3101) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3120) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3139) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3158) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3177) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3196) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3215) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3235) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3255) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3275) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3295) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3315) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3335) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3353) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3371) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3389) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3407) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3425) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3443) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3461) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3503) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3528) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3552) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3573) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3594) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3642) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (3668) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (3694) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (3720) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (3746) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (3772) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (3798) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (3824) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (3850) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (3876) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (3902) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (3929) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (3956) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (3983) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4010) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4037) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4064) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4091) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4118) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4172) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4199) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4226) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4253) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4280) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4307) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4334) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4361) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4388) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4442) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4469) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4496) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4519) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4552) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4579) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4606) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4633) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4660) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (4684) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (4709) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (4733) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (4758) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (4779) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (4800) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (4824) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (4848) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (4874) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (4900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (4926) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (4952) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (4978) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5004) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5030) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5056) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5082) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5108) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5135) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5162) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5189) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5216) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5243) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5270) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5297) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5324) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5351) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5378) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5405) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5432) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5459) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5486) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5540) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5567) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5594) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5621) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5648) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (5675) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (5702) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (5725) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (5758) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (5785) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (5812) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (5839) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (5866) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (5893) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (5920) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (5947) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (5972) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (5996) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6028) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6060) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6084) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6108) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6132) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6153) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6174) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6222) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6248) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6300) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6326) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6352) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6378) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6404) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6430) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6482) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6509) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6536) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6563) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6590) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6617) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6644) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (6671) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (6698) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (6725) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (6752) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (6779) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (6806) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (6833) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (6860) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (6887) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (6914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (6941) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (6968) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (6995) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7022) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7049) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7076) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7101) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7136) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7165) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7194) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7223) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7252) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7279) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7303) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7324) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7345) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7369) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7393) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7419) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7445) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7471) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7497) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7523) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7549) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7575) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7601) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7627) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7653) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (7680) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (7707) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (7734) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (7761) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (7788) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (7815) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (7842) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (7867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (7891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (7923) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (7955) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (7979) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8003) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8027) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8048) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8069) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8093) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8117) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8143) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8195) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8221) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8247) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8273) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8299) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8325) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8351) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8377) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8404) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8431) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8458) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8485) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8512) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8539) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8566) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8593) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8620) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8647) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (8674) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (8701) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (8728) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (8755) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (8782) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (8809) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (8836) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (8863) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (8890) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (8917) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (8944) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (8971) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (8996) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9031) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9060) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9118) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9147) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9174) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9219) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9240) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9264) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9288) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9314) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9366) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9392) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9418) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9444) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9470) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9496) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9522) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9548) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9575) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9602) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9629) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9656) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (9683) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (9710) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (9737) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (9751) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (9765) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (9779, 9787) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (9795, 9803) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (9811) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (9827) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (9848) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (9869) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (9890, 9898, 9911) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (9918, 9926) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (9943) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (9958) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (9973, 9994) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10002, 10023) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10031) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10064, 10089) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10097, 10110) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10115, 10128) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10133, 10141, 10143) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10146) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10170) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10197) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10224) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10245) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10272) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10299) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10317) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10335) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10353, 10361) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10381, 10394) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10403) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10423) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10446) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10463) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10484) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10505) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10526) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10547) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10565) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10584) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10606) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10623) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10652) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (10681) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (10699) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (10719) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (10739) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (10759) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (10779) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (10799) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (10819) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (10839) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (10859) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (10879) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (10899) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (10920) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (10941) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (10962) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (10983) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11004) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11025) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11049) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11070, 11078) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11086) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11104) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11121) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11135) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11154) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11174) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11193) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11210, 11226) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11230, 11246) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11250, 11261) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11267) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11282) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11306) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11330) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11346) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11364) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11374) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11390) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11405) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11426) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11442) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11464) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11482) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11500) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11518) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11542) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11561) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11586) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11608, 11618) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11632, 11638, 11643) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11648) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (11667) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (11688) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (11709) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (11730) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (11751) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (11769) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (11787, 11798) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (11807) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (11831) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (11855) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (11875) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (11895) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (11915) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (11935) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (11955) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (11975) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (11995) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12015) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12035) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12050) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12079) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12094) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12109) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12134) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12159) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12177) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12195) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12220) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12245) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12270) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12295) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12320) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12345) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12370) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12395) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12420) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12445) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12470) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12495) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12520) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12545) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12570) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12595) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12620) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12645) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (12670) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (12695) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (12721) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (12747) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (12773) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (12799) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (12825) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (12851) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (12877) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (12903) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (12929) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (12955) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (12981) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13007, 13021) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13026) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13045, 13059) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13064) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13083, 13097) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13102) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13121, 13135) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13140) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13159) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13178) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13197) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13216) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13235) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13254) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13273) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13292) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13311) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13330) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13349) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13368) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13387, 13401) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13407) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13427) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13447) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13467) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13487) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13507) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13527) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13547) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13567) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13587) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13607) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13627) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13647) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (13669) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (13697) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (13726) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (13747) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (13757) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (13765) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (13787) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (13808) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (13825) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (13842) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (13859, 13866) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (13875) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (13904) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (13929) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (13942, 13954) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (13957) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (13971) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (13986) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14001) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14025) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14044) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14062) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14083) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14102) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14122) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14141) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14161) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14180) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14200) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14221) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14243) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14264) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14286) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14307) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14329) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14350) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14372) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14393) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14415) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14436) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14458) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14479) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14501) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14522) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14544) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14565) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14587) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14608) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14630) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14651) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (14673) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (14694) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (14716) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (14737) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (14759) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (14780) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (14802) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (14823) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (14845) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (14866) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (14888) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (14909) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (14931) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (14952) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (14974) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (14995) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15017) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15038) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15060) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15081) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15103) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15124) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15146) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15167) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15189) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15210) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15232) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15253) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15275) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15296) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15318) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15339) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15361) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15383) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15406) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15428) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15451) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15473) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15496) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15518) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15541) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15563) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15586) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15608) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15631) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15653) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (15676) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (15698) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (15721) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (15743) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (15766) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (15788) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (15811) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (15833) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (15856) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (15878) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (15901) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (15923) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (15946) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (15968) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (15991) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16013) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16036) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16058) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16081) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16103) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16126) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16148) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16171) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16185) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16199) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16213) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16227) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16241) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16255) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16269) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16283) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16297) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16311) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16325) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16339) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16353) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16367) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16381) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16395) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16409) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16423) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16437) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16451) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16465) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16479) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16493) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16507) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16530) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16550) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16570) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16590) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16610) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16630) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16650) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (16670) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (16690) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (16710) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (16730) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (16751) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (16772) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (16793) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (16814) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (16835) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (16856) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (16877) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (16898) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (16919) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (16940) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (16961) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (16982) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17003) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17024) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17045) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17066) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17087) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17108) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17129) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17150) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17171) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17192) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17210) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17227) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17245) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17266) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17284) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17299) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17316, 17331) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17338) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17360) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17380) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17402) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17420) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17441) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17462) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17480) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17498) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17516) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17534) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17552) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17570) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17588) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17606) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17624) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17642) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17660) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (17678) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (17696) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (17714) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (17732) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (17750) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (17764) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (17779) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (17797) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (17815) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (17832) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (17853) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (17869) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (17882) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (17901) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (17916) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (17938) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (17965) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (17982) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (17990) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18007) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18025) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18041) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18060) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18075) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18093) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18111) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18135) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18160) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18183) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18212) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18234) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18249) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18279) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18294) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18312) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18329) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18348) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18364) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18383) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18404) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18417) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18440) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18463, 18471, 18477) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18483, 18493) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18503, 18513, 18519) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18524) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18539) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18561) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18583) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18609) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18635) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18647) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (18666) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (18684) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (18702, 18711) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (18714, 18718) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (18728, 18732) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (18742, 18746) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (18756) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (18779) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (18802) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (18825) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (18846) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (18857) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (18870, 18878) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (18887) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (18906) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (18917, 18921) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (18936) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (18958, 18974) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (18980) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19000, 19018) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19027) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19049) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19074) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19099) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19118, 19132) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19141) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19164, 19168) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19178, 19182) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19193, 19205) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19210) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19237) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19264) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19283) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19309) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19334) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19362) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19388) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19413) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19441) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19467) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19492) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19520) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19546) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19571) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19599) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19630) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (19673, 19697, 19704) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (19711, 19718, 19727) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (19731) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (19750) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (19772, 19787) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (19793) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (19810) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (19831) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (19854) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (19877) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (19900) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (19913) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (19930) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (19954) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (19984) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20008) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20038) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20069) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20098) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20128, 20144) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20148) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20167) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20193) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20217) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20243) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20269) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20285) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20301) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20316) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20339) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20362) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20385) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20408) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20442) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20476) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20510) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20544) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20578) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20612) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20646) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (20680) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (20714) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (20748) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (20782) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (20816) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (20850) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (20884) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (20918) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (20952) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (20976) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21000) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21021) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21041) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21061) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21099) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21119) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21147) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21168) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21183, 21193) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21199) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21215) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21230) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21245) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21262) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21284) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21300) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21322) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21338) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21360) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21382) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21404) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21423) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21438) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21454) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21470) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21485) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21500) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21517) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21539) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21555) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21577) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21593) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21615) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21637) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21659) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (21678) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (21693) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (21709) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (21725) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (21740) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (21755) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (21772) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (21794) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (21810) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (21832) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (21848) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (21870) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (21892) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (21914) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (21933) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (21948) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (21964) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (21980) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (21995) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22010) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22027) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22049) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22065) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22087) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22103) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22125) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22147) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22169) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22188) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22203) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22219) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22235) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22250) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22265) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22282) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22304) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22320) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22342) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22358) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22380) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22402) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22424) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22443) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22458) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22474) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22490) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22505) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22520) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22537) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22559) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22575) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22597) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22613) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22635) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22657) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (22679) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (22698) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (22713) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (22729) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (22745) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (22760) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (22775) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (22792) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (22814) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (22830) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (22852) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (22868) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (22890) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (22912) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (22934) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (22953) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (22968) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (22984) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23000) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23015) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23030) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23047) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23069) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23085) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23107) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23123) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23145) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23167) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23189) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23208) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23227) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23246) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23265) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23284) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23303) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23322) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23341) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23360) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23385) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23410) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23435) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23460) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23485) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23510) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23535) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23560) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23585) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23610) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23635) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23660) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (23685) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (23710) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (23735) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (23760) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (23783) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (23806) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (23829) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (23852) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (23875) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (23898) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (23921) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (23944) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (23962) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (23980) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (23998) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24016) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24034) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24052) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24070) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24088) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24106) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24124) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24142) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24160) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24178) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24196) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24214) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24232) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24252) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24272) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24292) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24312) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24333) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24354, 24357) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24376, 24379) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24398) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24428) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24458) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24487) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24516) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24546) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24576) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24605) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24634) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (24664) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (24694) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (24723) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (24752) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (24782) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (24812) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (24841) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (24870, 24873) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (24892, 24895) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (24914) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (24937, 24951) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (24960) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (24983) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25006) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25029) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25052) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25076) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25100) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25124) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25148) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25172) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25196) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25220) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25244) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25266) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25288) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25309) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25330) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25354) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25378) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25402) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25426) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25450) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25474) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25495) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25518) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25534) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25556) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25578) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25594) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25607) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25620) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25633) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25646) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25659) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (25672) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (25685) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (25698) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (25721) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (25740) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (25758) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (25785) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (25812) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (25825) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (25838) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (25861) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (25884) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (25912) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (25940) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (25968) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (25996) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26014) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26032) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26047) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26071) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26095) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26114) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26133) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26157) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26181) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26205) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26229, 26232) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26247, 26250) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26265) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26283) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26301, 26304) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26319, 26322) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26337) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26355, 26362) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26374, 26381) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26393) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26417) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26437) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26457) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26476) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26494) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26511) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26532) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26546) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26560) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26574) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26590, 26600) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26609, 26619) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26631, 26641) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26650, 26660) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (26672, 26682) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (26690) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (26710) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (26733) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (26753) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (26776) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (26795) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (26807) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (26824) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (26841, 26848) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (26859) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (26879) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (26896) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (26912, 26915) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (26925, 26928) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (26939, 26942) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (26953, 26956) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (26975, 26978) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (26995, 26998) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27017, 27020) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27037) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27054) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27071) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27085) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27107) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27129) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27152) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27175) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27197) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27219) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27240) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27260) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27280) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27297) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27314) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27330, 27336) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27349, 27355) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27368, 27374) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27385, 27391) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27403, 27409) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27421, 27427) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27437, 27443) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27455, 27461) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27473, 27479) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27489) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27504) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27519) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27532) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27547) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27562) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27575, 27578) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27589, 27592) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27603, 27606) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27615) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27638) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27660, 27672) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (27680, 27683) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (27694, 27697) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (27708, 27711) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (27720) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (27736) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (27753) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (27770) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (27785) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (27804) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (27829) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (27853, 27861) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (27873) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (27899) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (27928) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (27953) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (27981) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28004) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28030) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28052) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28077) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28096) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28118) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28132) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28149) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28169) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28186) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28203) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28220) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28240) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28257) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28277) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28296) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28317) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28338) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28353) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28372) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28391) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28410) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28425) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28458) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28491) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28524) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28557) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28573) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28588) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28614) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28630) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (28648) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (28665) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (28686) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (28705) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (28724) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (28740) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (28759) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (28779) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (28802) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (28820) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (28841) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (28866) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (28882, 28897) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (28903) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (28911) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (28925) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (28939) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (28953) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (28968) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (28980) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29002) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29018, 29024, 29037) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29043) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29068) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29094) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29120) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29146) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29172) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29200) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29224) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29248) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29281) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29309) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29338) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29363) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29388) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29422) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29451) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29475) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29495) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29515) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29544) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29568) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29595) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29622) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29649) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (29676) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (29703) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (29730) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (29757) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (29784) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (29795, 29799) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (29809) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (29828) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (29850) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (29874) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (29897) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (29921) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (29944) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (29968) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (29991) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30015) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30038) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30057) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30075) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30087) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30099) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30117) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30136) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30154) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30166) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30178) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30196) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30214, 30224) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30233) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30247) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30265) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30279) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30293, 30302) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30310, 30319) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30327, 30336) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30340) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30352, 30361) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30366) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30382) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30396) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30412) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30427) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30444) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30459) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30476) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30498, 30508) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30515, 30523) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30536) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30548) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30563, 30570) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30578, 30585) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30592) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30609) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30631) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30655) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (30679) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (30705) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (30725) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (30745) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (30765) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (30785) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (30805) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (30825) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (30845) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (30865) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (30885) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (30905) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (30925) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (30945) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (30968) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (30991) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31014) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31035) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31056) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31077) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31098) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31122, 31131, 31135) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31146) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31170) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31194) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31218) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31242) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31266) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31290) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31309) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31328) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31347) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31366) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31385) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31404) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31423) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31442) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31461) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31480) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31499) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31518) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31537) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31556) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31575) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31594) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31613) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31632) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31651) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (31670) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (31690) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (31710) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (31730) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (31750) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (31772) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (31794) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (31816) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (31838) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (31860) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (31882) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (31904) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (31926) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (31948) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (31970) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (31992) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32014) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32036) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32058) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32080) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32102) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32124) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32146) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32168) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32190) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32212) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32234) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32256) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32278) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32298) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32318) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32338) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32358) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32378) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32398) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32418) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32438) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32458) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32478) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32498) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32518) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32537) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32556) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32575) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32594) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32613) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32632) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32651) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (32670) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (32689) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (32708) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (32727) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (32746) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (32765) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (32784) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (32803) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (32822) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (32841) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (32860) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (32879) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (32898) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (32918) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (32938) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (32958) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (32978) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (32998) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33018) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33038) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33058) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33078) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33098) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33118) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33138) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33157) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33176) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33195) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33214) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33233) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33252) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33271) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33290) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33311) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33332) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33352) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33372) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33392) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33412) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33432) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33452) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33472) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33492) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33511) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33530) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33549) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33568) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33587) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33606) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33625) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33644) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (33664) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (33684) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (33704) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (33724) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (33744) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (33764) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (33784) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (33804) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (33825) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (33846) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (33867) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (33888) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (33909) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (33930) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (33951) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (33972) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (33993) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34014) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34035) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34056) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34077) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34098) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34119) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34140) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34161) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34182) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34203) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34224) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34245) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34266) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34287) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34308) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34328) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34348) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34368) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34388) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34408) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34428) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34448) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34468) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34489) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34510) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34531) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34552) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34573) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34594) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34615) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34636) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34655) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (34674) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (34693) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (34712) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (34731) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (34750) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (34769) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (34788) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (34807) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (34826) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (34845) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (34864) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (34883) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (34902) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (34921) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (34940) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (34960) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (34980) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35000) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35020) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35040) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35060) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35080) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35100) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35120) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35140) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35160) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35180, 35183) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35205, 35208) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35230, 35232) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35256, 35258) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35282) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35307) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35332) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35357) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35382) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35408) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35434) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35456) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35478) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35500) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35522) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35542) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35562) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35582) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35602) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35624) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35646) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (35668) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (35690) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (35712) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (35734) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (35756) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (35778) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (35800) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (35822) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (35844) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (35866) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (35888) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (35910) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (35932) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (35954) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (35975) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (35996) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36017) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36038) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36059) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36080) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36101) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36122) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36142) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36162) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36182) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36202) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36222) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36242) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36262) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36282) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36302) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36322) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36346) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36371) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36395) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36419) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36444) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36468) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36493) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36517) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36533) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36557) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36591) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36625) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36650) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (36675) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (36700) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (36715) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (36738) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (36761) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (36779) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (36797) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (36817) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (36842) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (36867, 36876) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (36895) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (36923) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (36951) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (36979) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37007) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37035) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37058) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37082) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37105) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37129) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37152) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37176) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37199) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37223) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37246) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37269) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37292) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37315) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37338) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37361) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37385) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37409) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37435) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37462) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37488) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37515) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37541) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37568) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37594) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37621) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37647) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (37674) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (37700) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (37726) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (37752) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (37778) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (37804) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (37830) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (37856) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (37880) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (37904) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (37928) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (37952) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (37977) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38002) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38027) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38052) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38076) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38100) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38121) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38144) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38167) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38190) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38213) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38236) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38259) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38282) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38305) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38328) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38351) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38375) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38399) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38423) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38447) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38471) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38495) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38515) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38536) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38561) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38587) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38610) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38633) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38656) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (38679) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (38702) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (38726) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (38750) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (38774) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (38798) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (38822) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (38846) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (38871) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (38894) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (38918) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (38941) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (38964) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (38988) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39011) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39035) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39060) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39084) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39109) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39133) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39157) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39182) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39208) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39233) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39259) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39284) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39309) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39334) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39360) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39385) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39411) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39436) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39461) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39486) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39512) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39537) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39562) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39587) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39611) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39636) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39660) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (39684) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (39708) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (39733) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (39759) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (39784) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (39809) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (39834) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (39856) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (39879) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (39903) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (39926) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (39949) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (39972) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (39995) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40019) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40042) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40066) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40089) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40112) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40133) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40162, 40178) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40191) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40217, 40225) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40246) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40265) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40291) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40314) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40337) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40364) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40391, 40399) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40416, 40424) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40444, 40452) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40472, 40480) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40495, 40503) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40518) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40551) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40584) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40616) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40648) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (40667) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (40694) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (40721) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (40748) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (40775) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (40796) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (40815) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (40834) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (40858) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (40890) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (40920) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (40956) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (40989) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41007) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41027) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41044) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41068) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41092) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41118) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41147) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41176) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41205) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41234) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41255) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41282) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41306) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41331) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41355) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41379) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41404) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41428) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41450, 41453) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41477, 41480) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41504, 41507) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41536, 41538) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41564, 41566) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41592, 41594) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41620, 41622) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41648, 41650) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (41676, 41678) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (41704, 41706) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (41732, 41734) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (41760, 41762) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (41793) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (41822) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (41851) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (41881) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (41911) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (41938) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (41965) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (41995) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42026) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42054) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42078) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42103) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42127) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42153) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42179) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42205) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42232) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42258) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42284) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42310) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42336) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42362) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42388) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42414) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42441) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42468) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42495) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42520) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42546) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42571) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42596) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42621) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42645) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (42670) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (42694) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (42718) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (42742) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (42766) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (42791) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (42813) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (42825) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (42836) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (42847) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (42860) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (42873) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (42886) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (42899) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (42914) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (42929) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (42941) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (42950) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (42965, 42983) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (42988, 43003) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43010, 43017) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43037) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* SH_RESERVED_REG0 (43061) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* SH_RESERVED_REG1 (43078) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43095) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43116) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43138) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43160) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43186) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43201) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43220) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43242) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43264) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43286) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43308) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43335) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43362) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43389) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43416) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43428) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43448) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43468) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43488) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43508) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43528) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43548) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43568) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43588) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43613) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43638) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43663) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43688) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (43713) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (43738) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (43763) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (43788) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (43811) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (43834) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (43857) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (43880) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (43903) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (43926) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (43949) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (43972) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (43992) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44012) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44035) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44058) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44077) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44096) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44125) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44154) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44176) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44198) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44220) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44242) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44271) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44300) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44322) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44344) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44366) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44388) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44417) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44446) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44468) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44490) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44512) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44534) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44563) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44592) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44614) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44636) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44658) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44680) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (44704) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (44729) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (44753) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (44778) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (44802) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (44827) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (44851) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (44876) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (44905) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (44935) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (44964) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (44994) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45023) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45053) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45082) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45112) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45139) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45167) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45194) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45222) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45249) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45277) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45304) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45332) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45354) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45376) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45403) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45428) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45453) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45478) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45511) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45538) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45564) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45604) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45638) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45668) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (45699) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (45730) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (45764) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (45801) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (45842) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (45867) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (45892) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (45917) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (45942) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (45972) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (45993) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46014) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46040) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46071) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46102) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46138) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46162) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46188) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46215) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46241) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46268) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46299) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46330) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46366) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46390) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46416) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46443) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46469) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46496) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46527) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46558) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46594) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46618) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46644) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46671) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (46697) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (46724) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (46755) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (46786) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (46822) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (46846) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (46872) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (46899) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (46925) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (46952) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (46966) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (46983) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (46999) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (47014) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (47029) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (47044) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (47059) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (47072) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (47084) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (47097) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (47107) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (47122) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (47136) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (47152) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (47168, 47173) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (47184) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (47204, 47209) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (47226) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (47237) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (47257, 47262) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (47273) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (47287) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (47299) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (47312) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (47330) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (47348) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (47366) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (47384) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (47402) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (47420) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (47438) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (47456) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (47479) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (47496) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (47513) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (47530) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (47543) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (47551) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (47569) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (47588) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (47607) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (47625, 47631) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (47646) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (47658) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (47670) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (47681) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (47694) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (47711) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (47723) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (47735) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (47747) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (47764) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (47785) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (47804) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (47823) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (47841) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (47861) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (47879) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (47892) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (47905) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (47919) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (47932, 47935) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (47945) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (47957) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (47972) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (47988) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (48004) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (48016) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (48028) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (48042) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (48056) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (48074) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (48093) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (48112) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (48130) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (48153) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (48176) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (48199) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (48222) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (48241) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (48260) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (48279) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (48298) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (48317) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (48336) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (48355) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (48374) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (48397, 48401) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (48421, 48425) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (48444, 48448) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (48469) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (48489, 48493) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (48512) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (48528) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (48548) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (48564) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (48579) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (48594) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (48609) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (48623) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (48637) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (48653) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (48679) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (48703) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (48727) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (48751) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (48775) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (48795) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (48815) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (48835) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (48855) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (48875) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (48895) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (48915) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (48935) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (48953) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (48970) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (48987) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (49002) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (49028) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (49056) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (49073) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (49090) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (49108) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (49122) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (49139) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (49157) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (49179) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (49204) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (49221) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (49237) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (49256) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (49273) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (49290) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (49304) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (49314) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (49325) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (49344) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (49359) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (49373) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (49393) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (49415) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (49435) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (49451) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (49467) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (49484) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (49502) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (49515) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (49527) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (49538) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (49549) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (49570) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (49591) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (49617) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (49638) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (49659, 49675) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (49683) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (49701) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (49720) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (49735) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (49757) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (49779) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (49801) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (49823) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (49838) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (49849) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (49860) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (49872) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (49893) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (49914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (49935) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (49956) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (49977) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (49998) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (50019) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (50040) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (50061) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (50082) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (50103) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (50124) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (50145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (50166) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (50187) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (50208) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (50229) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (50250) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (50271) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (50292) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (50313) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (50334) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (50355) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (50376, 50384, 50388) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (50396) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (50411) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (50426) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (50441) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (50456) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (50487) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (50518) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (50535) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (50552) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (50566) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (50580) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (50595, 50598) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (50605) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (50620) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (50642) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (50670) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (50701) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (50732) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (50751) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (50770) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (50789) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (50808) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (50827) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (50846) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (50865) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (50884) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (50904) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (50924) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (50944) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (50964) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (50984) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (51004) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (51024) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (51044) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (51064) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (51084) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (51104) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (51124) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (51144) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (51164) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (51184) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (51204) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (51224) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (51244) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (51264) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (51284) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (51304) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (51324) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (51344) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (51364) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (51387) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (51410) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (51433) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (51456) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (51480) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (51505) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (51530) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (51550) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (51574) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (51599) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (51623) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (51648) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (51672) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (51696) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (51720) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (51745) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (51769) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (51794) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (51818) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (51842) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (51866) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (51891) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (51915) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (51939) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (51963, 51975) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (51996) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (52029) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (52062) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (52094) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (52126) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (52158) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (52191) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (52223) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (52255) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (52288) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (52321) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (52354) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (52386) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (52418) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (52451) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (52484) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (52517) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (52550) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (52582) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (52616) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (52650) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (52684) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (52718) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (52747) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (52763) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (52790) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (52817) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (52844) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (52871) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (52898) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (52925) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (52952) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (52979) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (53006) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (53033) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (53060) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (53087) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (53114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (53141) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (53168) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (53195) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (53222) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (53249) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (53276) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (53303) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (53330) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (53357) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (53384) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (53411) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (53438) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (53465) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (53492) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (53519) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (53546) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (53573) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (53600) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (53627) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (53657) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (53687) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (53717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (53747) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (53777) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (53807) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (53837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (53867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (53897) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (53927) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (53958) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (53989) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (54020) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (54051) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (54082) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (54113) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (54144) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (54175) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (54206) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (54237) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (54268) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (54299) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (54330) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (54361) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (54392) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (54423) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (54454) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (54485) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (54516) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (54547) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (54578) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (54609) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (54640) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (54671) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (54702) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (54733) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (54744) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (54761, 54769) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (54776) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (54791) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (54806) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (54821) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (54836) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (54851) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (54866) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (54881, 54888) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (54911) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (54929) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (54956) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (54983) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (55001) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (55019) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (55039) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (55072, 55099) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (55105) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (55114) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (55124) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (55135) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (55140) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (55152, 55154) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (55160) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (55175) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (55190) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (55199) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (55209, 55211) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (55217) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (55236) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (55250) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (55267) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (55275) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (55285) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (55298) */
	'C', 'S', 'P', '\0', /* CSP (55304) */
	'S', 'C', 'C', '\0', /* SCC (55308) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (55312) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (55321) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (55331) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (55336) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (55344) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (55354) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (55365) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (55371) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (55376) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (55382) */
	'H', 'A', 'L', 'T', '\0', /* HALT (55393) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (55398) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (55403, 55410) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (55418) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (55426) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (55438) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (55446) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (55457) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (55469) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (55474) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (55482) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (55495) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (55503) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (55514) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (55525) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (55541, 55546) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (55555) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (55567) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (55575) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (55583) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (55591) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (55597) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (55603) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (55615) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (55621) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (55627) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (55636) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (55645) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (55651) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (55661) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (55671) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (55681) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (55691) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (55700) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (55709) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (55726) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (55733) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (55741) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (55755) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (55764) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (55773) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (55786) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (55791) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (55801) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (55815) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (55827) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (55834) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (55840) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (55854) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (55869) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (55874) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (55879) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (55889) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (55898) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (55905) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (55911) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (55917) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (55930, 55932) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (55938) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (55953) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (55962) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (55976) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (55994) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (56004) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (56017) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (56024) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (56034) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (56057) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (56080) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (56103) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (56123) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (56143) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (56163) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (56183) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (56203) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (56223) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (56243) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (56263) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (56278, 56284) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (56289) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (56297) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (56306) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (56323) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (56338) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (56351, 56352) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (56361) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (56378) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (56395) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (56404, 56405) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (56413) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (56422) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (56431) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (56440) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (56451) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (56474, 56475) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (56490) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (56513) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (56536) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (56555) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (56564) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (56573) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (56581) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (56590) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (56605) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (56613) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (56621) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (56630) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (56639) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (56647) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (56655) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (56663) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (56681) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (56689) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (56700) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (56711) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (56722) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (56751) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (56782) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (56811) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (56831) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (56851) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (56871) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (56891) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (56899) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (56907) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (56918) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (56932) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (56941) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (56950) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (56960) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (56970) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (56979) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (56988) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (56999) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (57010) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (57020) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (57030) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (57040) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (57057) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (57065) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (57078) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (57096) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (57107) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (57116) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (57137) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (57148) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (57175) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (57188) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (57201) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (57216) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (57236) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (57252) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (57270) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (57290) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (57309) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (57328, 57333) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (57341) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (57355) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (57379) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (57395) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (57411) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (57427) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (57443) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (57458) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (57478) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (57494) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (57512) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (57532) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (57551) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (57570) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (57583) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (57597) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (57621) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (57637) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (57653) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (57669) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (57685) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (57704) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (57724) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (57743) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (57764) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (57782) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (57805) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (57827) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (57848) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (57866) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (57889) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (57911) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (57935) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (57959) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (57982) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (58004) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (58023) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (58032) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (58047) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (58061) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (58080) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (58099) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (58114) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (58131) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (58153) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (58175) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (58190) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (58205) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (58214) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (58223) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (58233) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (58247) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (58261) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (58275) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (58292) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (58305) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (58318) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (58331) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (58350) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (58363) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (58381) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (58395) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (58414) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (58433) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (58448) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (58466) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (58484) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (58501) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (58516) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (58530) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (58547) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (58571) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (58589) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (58607) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (58628) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (58652) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (58678) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (58695) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (58715) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (58735) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (58755) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (58776) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (58799) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (58820) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (58839) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (58856) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (58872) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (58888) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (58904) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (58923) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (58935) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (58947) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (58966) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (58986) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (59006) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (59026) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (59047) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (59068) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (59095) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (59122) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (59143) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (59162) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (59181) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (59195) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (59210) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (59227) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (59239) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (59252) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (59267) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (59282) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (59297) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (59312) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (59337) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (59359) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (59384) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (59405) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (59429) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (59456) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (59481) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (59504) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (59524) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (59540) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (59550) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (59559) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (59567) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (59574) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (59588) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (59611) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (59633) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (59656) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (59678) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (59699, 59713) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (59723) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (59741) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (59761) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (59780) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (59802) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (59826) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (59845) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (59859) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (59877) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (59895) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (59915) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (59932) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (59952) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (59971) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (59989) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (60007) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (60019) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (60032) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (60047) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (60056) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (60067) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (60080) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (60094) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (60107) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (60120) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (60132) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (60150) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (60161) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (60176) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (60184) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (60203) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (60220) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (60232) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (60246) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (60261, 60268) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (60273) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (60281) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (60301) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (60318) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (60329) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (60341) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (60353) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (60364) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (60376) */
	'T', 'G', 'T', '\0', /* TGT (60389) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (60393) */
	'V', 'M', '\0', /* VM (60399) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (60402, 60407) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (60418) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (60432) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (60447) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (60457) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (60467) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (60477) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (60487) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (60508) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (60529) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (60550) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (60573) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (60596) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (60616) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (60636) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (60658) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (60680) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (60704) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (60728) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (60749) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (60770) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (60792) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (60815) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (60838) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (60863) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (60888) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (60910) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (60932) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (60953) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (60974) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (60996) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (61021) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (61046) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (61073) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (61100) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (61124) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (61148) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (61173) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (61201) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (61229) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (61259) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (61289) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (61316) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (61343) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (61371) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (61399) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (61427) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (61457) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (61487) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (61514) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (61541) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (61569) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (61599) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (61629) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (61661) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (61693) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (61722) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (61751) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (61781) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (61811) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (61843) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (61875) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (61904) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (61933) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (61960) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (61987) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (62016) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (62045) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (62071) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (62097) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (62121) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (62145) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (62170) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (62201) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (62232) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (62265) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (62298) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (62328) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (62358) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (62389) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (62416) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (62443) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (62471) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (62501) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (62531) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (62562) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (62582) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (62604) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (62630) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (62653) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (62680) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (62705) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (62732) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (62759) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (62786) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (62809) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (62830) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (62860) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (62888) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (62912) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (62935) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (62959) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (62982) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (63009) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (63037) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (63062) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (63087) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (63111) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (63135) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (63160) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (63185) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (63209) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (63233) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (63259) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (63285) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (63311) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (63337) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (63363) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (63389) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (63417) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (63444) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (63472) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (63499) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (63526) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (63554) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (63582) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (63605) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (63627) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (63650) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (63672) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (63695) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (63717) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (63740) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (63763) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (63786) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (63809) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (63833) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (63857) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (63880) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (63902) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (63926) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (63949) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (63975) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (64000) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (64030) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (64059) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (64087) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (64114) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (64145) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (64175) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (64208) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (64240) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (64274) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (64307) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (64338) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (64368) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (64402) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (64435) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (64476) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (64515) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (64538) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (64563) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (64588) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (64615) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (64642) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (64666) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (64690) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (64714) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (64727) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (64742) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (64757) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (64791) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (64813) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (64833, 64844) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (64848) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (64859) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (64867) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (64875) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (64883) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (64899) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (64918) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (64937) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (64953) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (64968) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (64982) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (64993) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (65005, 65018) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (65023) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (65035) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (65048) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (65056) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (65064) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (65073) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (65080) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (65089) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (65106) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (65124) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (65137) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (65151) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (65165) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (65174) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (65185) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (65204) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (65219) */
	'D', 'E', 'R', 'I', 'V', '_', 'A', 'D', 'J', 'U', 'S', 'T', '_', 'E', 'N', '\0', /* DERIV_ADJUST_EN (65234) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (65250, 65260) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (65269) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (65288) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (65310) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (65332) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (65348) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (65365) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (65383) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (65399) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (65420) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (65430) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (65451) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (65472) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (65491) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (65505, 65511) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (65526) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (65547) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (65568) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (65589) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (65610) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (65632) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (65657) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (65678) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (65700) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (65722) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (65747) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (65772) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (65793) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (65814) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (65836) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (65861) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (65872) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (65885) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (65908, 65921) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (65931, 65944) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (65954) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (65972) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (65991) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (66010) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (66029) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (66053) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (66077) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (66101) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (66126) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (66151) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (66176) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (66201) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (66224) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (66249) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (66275) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (66289) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (66301) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (66326) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (66352) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (66378) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (66404) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (66429) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (66454) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (66479) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (66490) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (66521) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (66549) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (66578) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (66609) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (66638) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (66658) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (66671) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (66694) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (66717) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (66740) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (66763, 66768) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (66774) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (66798) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (66822) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (66846) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (66870, 66875) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (66882) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (66907) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (66932) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (66957) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (66982) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (67000) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (67017) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (67034) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (67051) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (67069) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (67079) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (67088) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (67097) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (67108) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (67119) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (67127) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (67143) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (67159) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (67175) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (67191) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (67207) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (67223) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (67234) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (67245) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (67257) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (67265) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (67278) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (67287) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (67302) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (67317) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (67329) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (67345) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (67357) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (67385) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (67411, 67416) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (67429) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (67451) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (67466) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (67482) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (67498) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (67519) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (67525, 67530) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (67536) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (67555) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (67564) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (67570) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (67576) */
	'F', 'P', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_64_DENORMS (67590) */
	'F', 'P', '_', 'A', 'L', 'L', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_ALL_DENORMS (67604) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (67619) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (67630) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (67640) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (67657) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (67669) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (67680) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (67690) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (67703) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (67715) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (67730) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (67752) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (67777) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (67791) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (67807) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (67824) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (67850) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (67883) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (67904) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (67928) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (67953) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (67972) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (68009) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (68038) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (68070) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (68086) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (68115) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (68147) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (68160) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (68174) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (68190) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (68200) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (68212) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (68224) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (68236) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (68248) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (68254) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (68265) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (68282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (68294) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (68319) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (68336) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (68345) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (68362) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (68379) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (68396) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (68407) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (68425) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (68439) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (68458) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (68478) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (68498) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (68520) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (68531, 68545) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (68549) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (68567) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (68581) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (68589) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (68599, 68610) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (68615) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (68634) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (68640) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (68650) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (68660) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (68670) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (68685) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (68697) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (68710) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (68720) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (68735) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (68750) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (68766) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (68781) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (68787) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (68796) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (68806) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (68816) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (68826) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (68839) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (68876, 68879) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (68884) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (68893) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (68902) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (68912) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (68931) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (68952) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (68963) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (68976) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (68995) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (69020) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (69043) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (69057) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (69069) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (69087) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (69111) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (69132) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (69166) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (69201) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (69213) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (69226) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (69239) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (69252) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (69266) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (69284) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (69301, 69307) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (69313) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (69328) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (69338) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (69350) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (69368) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (69374) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (69387) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (69397) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (69410) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (69424) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (69439, 69447) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (69456, 69466) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (69474, 69484) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (69492, 69505) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (69513) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (69528) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (69549) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (69567, 69579) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (69584) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (69597) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (69616) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (69635) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (69659) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (69682) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (69699) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (69721) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (69736) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (69752) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (69768) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (69784) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (69803) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (69820) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (69844, 69852) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (69858) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (69878) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (69892) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (69912, 69921) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (69933) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (69943) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (69961) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (69971) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (69986) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (70015) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (70046) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (70082) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (70117) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (70145) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (70167) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (70185) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (70217) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (70243) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (70254) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (70264) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (70275) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (70287) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (70300) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (70314) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (70326, 70331) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (70338, 70342) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (70348) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (70361) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (70374) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (70390) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (70408) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (70426) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (70454) */
	'T', 'L', '_', 'X', '\0', /* TL_X (70460) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (70465) */
	'B', 'R', '_', 'X', '\0', /* BR_X (70470) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (70475) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (70480) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (70489) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (70503) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (70528) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (70546) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (70554) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (70562) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (70570) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (70578) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (70586) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (70594) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (70602) */
	'Z', '_', '1', '6', '\0', /* Z_16 (70612) */
	'Z', '_', '2', '4', '\0', /* Z_24 (70617) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (70622) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (70633) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (70645) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (70656) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (70666) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (70677) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (70688) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (70703) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (70717) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (70736) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (70753) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (70760) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (70784) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (70799) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (70809) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (70829) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (70846) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (70862) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (70872) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (70893) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (70906) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (70919) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (70932) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (70944) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (70956) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (70968) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (70984) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (71001) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (71014) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (71024) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (71036) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (71054) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (71066) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (71078) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (71094, 71096) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (71105) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (71116) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (71134) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (71150, 71157) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (71166) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (71188) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (71194) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (71200) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (71207) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (71213) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (71219) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (71226) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (71232) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (71239) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (71246) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (71254) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (71264) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (71271) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (71280) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (71288) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (71299) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (71310) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (71321) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (71332) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (71351) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (71370) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (71385) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (71400) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (71415) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (71430) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (71445) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (71460) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (71475) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (71490) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (71505) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (71520) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (71535) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (71550) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (71565) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (71580) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (71595) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (71610) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (71633) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (71656) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (71679) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (71702) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (71714) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (71726) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (71751) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (71776) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (71801) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (71826) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (71835) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (71859) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (71883) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (71891) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (71915) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (71939) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (71947) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (71971) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (71995) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (72019) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (72043) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (72051) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (72076) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (72101) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (72126) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (72151) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (72160) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (72185) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (72210) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (72235) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (72260) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (72269) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (72295) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (72321) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (72347) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (72373) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (72383) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (72406) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (72429) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (72452) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (72475) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (72482) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (72516) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (72551) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (72586) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (72621) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (72629) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (72663) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (72698) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (72733) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (72768) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (72776) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (72799) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (72822) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (72845) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (72868) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (72875) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (72909) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (72944) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (72979) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (73014) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (73022) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (73056) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (73091) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (73126) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (73161) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (73169) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_1 (73197) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_2 (73225) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_3 (73253) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '\0', /* SE_PAIR_MAP (73281) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE (73293) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE (73332) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE (73372) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE (73412) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* SE_PAIR_XSEL (73452) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE (73465) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE (73504) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE (73544) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE (73584) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_PAIR_YSEL (73624) */
	'N', 'U', 'M', '_', 'S', 'E', '\0', /* NUM_SE (73637) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'R', 'B', 'S', 'L', '_', 'D', 'B', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', 'D', '_', 'P', 'A', 'C', 'K', 'I', 'N', 'G', '\0', /* DISABLE_SRBSL_DB_OPTIMIZED_PACKING (73644) */
	'N', 'U', 'M', '_', 'S', 'C', '\0', /* NUM_SC (73679) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_RB_PER_SC (73686) */
	'N', 'U', 'M', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_PACKER_PER_SC (73700) */
	'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PERFMON_ENABLE (73718) */
	'L', 'E', 'F', 'T', '_', 'Q', 'T', 'R', '\0', /* LEFT_QTR (73733) */
	'L', 'E', 'F', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* LEFT_HALF (73742) */
	'R', 'I', 'G', 'H', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* RIGHT_HALF (73752) */
	'R', 'I', 'G', 'H', 'T', '_', 'Q', 'T', 'R', '\0', /* RIGHT_QTR (73763) */
	'T', 'O', 'P', '_', 'Q', 'T', 'R', '\0', /* TOP_QTR (73773) */
	'T', 'O', 'P', '_', 'H', 'A', 'L', 'F', '\0', /* TOP_HALF (73781) */
	'B', 'O', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* BOT_HALF (73790) */
	'B', 'O', 'T', '_', 'Q', 'T', 'R', '\0', /* BOT_QTR (73799) */
	'C', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_WR_POLICY (73807) */
	'F', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_WR_POLICY (73823) */
	'D', 'C', 'C', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_WR_POLICY (73839) */
	'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_WR_POLICY (73853) */
	'C', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_RD_POLICY (73869) */
	'F', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_RD_POLICY (73885) */
	'D', 'C', 'C', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_RD_POLICY (73901) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_RD_POLICY (73915) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* FMASK_BIG_PAGE (73931) */
	'C', 'O', 'L', 'O', 'R', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* COLOR_BIG_PAGE (73946) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* OVERWRITE_COMBINER_DISABLE (73961) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', 'M', 'A', 'R', 'K', '\0', /* OVERWRITE_COMBINER_WATERMARK (73988) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_CONSTANT_ENCODE_AC01 (74017) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_CONSTANT_ENCODE_SINGLE (74046) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* DISABLE_CONSTANT_ENCODE_REG (74077) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_ELIMFC_SKIP_OF_AC01 (74105) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_ELIMFC_SKIP_OF_SINGLE (74133) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'R', 'E', 'G', '\0', /* ENABLE_ELIMFC_SKIP_OF_REG (74163) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_OUT_ENABLE (74189) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'M', 'R', 'T', '\0', /* COVERAGE_OUT_MRT (74209) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'H', 'A', 'N', 'N', 'E', 'L', '\0', /* COVERAGE_OUT_CHANNEL (74226) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* COVERAGE_OUT_SAMPLES (74247) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'K', 'E', 'E', 'P', '\0', /* STENCIL_KEEP (74268) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'Z', 'E', 'R', 'O', '\0', /* STENCIL_ZERO (74281) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'N', 'E', 'S', '\0', /* STENCIL_ONES (74294) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'T', 'E', 'S', 'T', '\0', /* STENCIL_REPLACE_TEST (74307) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'O', 'P', '\0', /* STENCIL_REPLACE_OP (74328) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_ADD_CLAMP (74347) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_SUB_CLAMP (74365) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* STENCIL_INVERT (74383) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_ADD_WRAP (74398) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_SUB_WRAP (74415) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'N', 'D', '\0', /* STENCIL_AND (74432) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'R', '\0', /* STENCIL_OR (74444) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'O', 'R', '\0', /* STENCIL_XOR (74455) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'A', 'N', 'D', '\0', /* STENCIL_NAND (74467) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'O', 'R', '\0', /* STENCIL_NOR (74480) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'N', 'O', 'R', '\0', /* STENCIL_XNOR (74492) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '\0', /* STENCILFAIL (74505) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '\0', /* STENCILZPASS (74517) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '\0', /* STENCILZFAIL (74530) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILFAIL_BF (74543) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '_', 'B', 'F', '\0', /* STENCILZPASS_BF (74558) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILZFAIL_BF (74574) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '\0', /* STENCILTESTVAL (74590) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '\0', /* STENCILMASK (74605) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '\0', /* STENCILWRITEMASK (74617) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '\0', /* STENCILOPVAL (74634) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILTESTVAL_BF (74647) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILMASK_BF (74665) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILWRITEMASK_BF (74680) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILOPVAL_BF (74700) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '\0', /* DEFAULT_VAL (74716) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '\0', /* FLAT_SHADE (74728) */
	'C', 'Y', 'L', '_', 'W', 'R', 'A', 'P', '\0', /* CYL_WRAP (74739) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '\0', /* PT_SPRITE_TEX (74748) */
	'D', 'U', 'P', '\0', /* DUP (74762) */
	'F', 'P', '1', '6', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* FP16_INTERP_MODE (74766) */
	'U', 'S', 'E', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'A', 'T', 'T', 'R', '1', '\0', /* USE_DEFAULT_ATTR1 (74783) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '_', 'A', 'T', 'T', 'R', '1', '\0', /* DEFAULT_VAL_ATTR1 (74801) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '_', 'A', 'T', 'T', 'R', '1', '\0', /* PT_SPRITE_TEX_ATTR1 (74819) */
	'A', 'T', 'T', 'R', '0', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR0_VALID (74839) */
	'A', 'T', 'T', 'R', '1', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR1_VALID (74851) */
	'V', 'S', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* VS_EXPORT_COUNT (74863) */
	'V', 'S', '_', 'H', 'A', 'L', 'F', '_', 'P', 'A', 'C', 'K', '\0', /* VS_HALF_PACK (74879) */
	'N', 'O', '_', 'P', 'C', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* NO_PC_EXPORT (74892) */
	'P', 'E', 'R', 'S', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* PERSP_SAMPLE_ENA (74905) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTER_ENA (74922) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTROID_ENA (74939) */
	'P', 'E', 'R', 'S', 'P', '_', 'P', 'U', 'L', 'L', '_', 'M', 'O', 'D', 'E', 'L', '_', 'E', 'N', 'A', '\0', /* PERSP_PULL_MODEL_ENA (74958) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* LINEAR_SAMPLE_ENA (74979) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTER_ENA (74997) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTROID_ENA (75015) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'T', 'E', 'X', '_', 'E', 'N', 'A', '\0', /* LINE_STIPPLE_TEX_ENA (75035) */
	'P', 'O', 'S', '_', 'X', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_X_FLOAT_ENA (75056) */
	'P', 'O', 'S', '_', 'Y', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Y_FLOAT_ENA (75072) */
	'P', 'O', 'S', '_', 'Z', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Z_FLOAT_ENA (75088) */
	'P', 'O', 'S', '_', 'W', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_W_FLOAT_ENA (75104) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', '\0', /* FRONT_FACE_ENA (75120) */
	'A', 'N', 'C', 'I', 'L', 'L', 'A', 'R', 'Y', '_', 'E', 'N', 'A', '\0', /* ANCILLARY_ENA (75135) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', '\0', /* SAMPLE_COVERAGE_ENA (75149) */
	'P', 'O', 'S', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'T', '_', 'E', 'N', 'A', '\0', /* POS_FIXED_PT_ENA (75169) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '_', 'E', 'N', 'A', '\0', /* FLAT_SHADE_ENA (75186) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', '\0', /* PNT_SPRITE_ENA (75201) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '0', '\0', /* SPI_PNT_SPRITE_SEL_0 (75216) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '1', '\0', /* SPI_PNT_SPRITE_SEL_1 (75237) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'S', '\0', /* SPI_PNT_SPRITE_SEL_S (75258) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'T', '\0', /* SPI_PNT_SPRITE_SEL_T (75279) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_PNT_SPRITE_SEL_NONE (75300, 75319) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'X', '\0', /* PNT_SPRITE_OVRD_X (75324) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Y', '\0', /* PNT_SPRITE_OVRD_Y (75342) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Z', '\0', /* PNT_SPRITE_OVRD_Z (75360) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'W', '\0', /* PNT_SPRITE_OVRD_W (75378) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'O', 'P', '_', '1', '\0', /* PNT_SPRITE_TOP_1 (75396) */
	'N', 'U', 'M', '_', 'I', 'N', 'T', 'E', 'R', 'P', '\0', /* NUM_INTERP (75413) */
	'P', 'A', 'R', 'A', 'M', '_', 'G', 'E', 'N', '\0', /* PARAM_GEN (75424) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '_', 'E', 'N', '\0', /* OFFCHIP_PARAM_EN (75434) */
	'L', 'A', 'T', 'E', '_', 'P', 'C', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* LATE_PC_DEALLOC (75451) */
	'B', 'C', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* BC_OPTIMIZE_DISABLE (75467) */
	'P', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* PS_W32_EN (75487) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTER_CNTL (75497) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTROID_CNTL (75515) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTER_CNTL (75535) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTROID_CNTL (75554) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* POS_FLOAT_LOCATION (75575) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'U', 'L', 'C', '\0', /* POS_FLOAT_ULC (75594) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* FRONT_FACE_ALL_BITS (75608) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_SHADER_NONE (75628) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '1', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_1COMP (75644) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '2', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_2COMP (75661) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* SPI_SHADER_4COMPRESS (75678) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_4COMP (75699) */
	'I', 'D', 'X', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* IDX0_EXPORT_FORMAT (75716) */
	'P', 'O', 'S', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS0_EXPORT_FORMAT (75735) */
	'P', 'O', 'S', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS1_EXPORT_FORMAT (75754) */
	'P', 'O', 'S', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS2_EXPORT_FORMAT (75773) */
	'P', 'O', 'S', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS3_EXPORT_FORMAT (75792) */
	'P', 'O', 'S', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS4_EXPORT_FORMAT (75811) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', 'E', 'R', 'O', '\0', /* SPI_SHADER_ZERO (75830) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'R', '\0', /* SPI_SHADER_32_R (75846) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'G', 'R', '\0', /* SPI_SHADER_32_GR (75862) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'R', '\0', /* SPI_SHADER_32_AR (75879) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'F', 'P', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_FP16_ABGR (75896) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UNORM16_ABGR (75917) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SNORM16_ABGR (75941) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UINT16_ABGR (75965) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SINT16_ABGR (75988) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_32_ABGR (76011) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* Z_EXPORT_FORMAT (76030) */
	'C', 'O', 'L', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL0_EXPORT_FORMAT (76046) */
	'C', 'O', 'L', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL1_EXPORT_FORMAT (76065) */
	'C', 'O', 'L', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL2_EXPORT_FORMAT (76084) */
	'C', 'O', 'L', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL3_EXPORT_FORMAT (76103) */
	'C', 'O', 'L', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL4_EXPORT_FORMAT (76122) */
	'C', 'O', 'L', '5', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL5_EXPORT_FORMAT (76141) */
	'C', 'O', 'L', '6', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL6_EXPORT_FORMAT (76160) */
	'C', 'O', 'L', '7', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL7_EXPORT_FORMAT (76179) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'O', '_', 'C', 'O', 'N', 'V', 'E', 'R', 'S', 'I', 'O', 'N', '\0', /* SX_RT_EXPORT_NO_CONVERSION (76198) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'R', '\0', /* SX_RT_EXPORT_32_R (76225) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'A', '\0', /* SX_RT_EXPORT_32_A (76243) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* SX_RT_EXPORT_10_11_11 (76261) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* SX_RT_EXPORT_2_10_10_10 (76283) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* SX_RT_EXPORT_8_8_8_8 (76307) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '5', '_', '6', '_', '5', '\0', /* SX_RT_EXPORT_5_6_5 (76328) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* SX_RT_EXPORT_1_5_5_5 (76347) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* SX_RT_EXPORT_4_4_4_4 (76368) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'G', 'R', '\0', /* SX_RT_EXPORT_16_16_GR (76389) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'A', 'R', '\0', /* SX_RT_EXPORT_16_16_AR (76411) */
	'M', 'R', 'T', '0', '\0', /* MRT0 (76433) */
	'M', 'R', 'T', '1', '\0', /* MRT1 (76438) */
	'M', 'R', 'T', '2', '\0', /* MRT2 (76443) */
	'M', 'R', 'T', '3', '\0', /* MRT3 (76448) */
	'M', 'R', 'T', '4', '\0', /* MRT4 (76453) */
	'M', 'R', 'T', '5', '\0', /* MRT5 (76458) */
	'M', 'R', 'T', '6', '\0', /* MRT6 (76463) */
	'M', 'R', 'T', '7', '\0', /* MRT7 (76468) */
	'1', '1', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 11BIT_FORMAT (76473) */
	'1', '0', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 10BIT_FORMAT (76486) */
	'8', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 8BIT_FORMAT (76499) */
	'6', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 6BIT_FORMAT (76511) */
	'5', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 5BIT_FORMAT (76523) */
	'4', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 4BIT_FORMAT (76535) */
	'M', 'R', 'T', '0', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT0_EPSILON (76547) */
	'M', 'R', 'T', '1', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT1_EPSILON (76560) */
	'M', 'R', 'T', '2', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT2_EPSILON (76573) */
	'M', 'R', 'T', '3', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT3_EPSILON (76586) */
	'M', 'R', 'T', '4', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT4_EPSILON (76599) */
	'M', 'R', 'T', '5', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT5_EPSILON (76612) */
	'M', 'R', 'T', '6', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT6_EPSILON (76625) */
	'M', 'R', 'T', '7', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT7_EPSILON (76638) */
	'M', 'R', 'T', '0', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_COLOR_OPT_DISABLE (76651) */
	'M', 'R', 'T', '0', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_ALPHA_OPT_DISABLE (76674) */
	'M', 'R', 'T', '1', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_COLOR_OPT_DISABLE (76697) */
	'M', 'R', 'T', '1', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_ALPHA_OPT_DISABLE (76720) */
	'M', 'R', 'T', '2', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_COLOR_OPT_DISABLE (76743) */
	'M', 'R', 'T', '2', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_ALPHA_OPT_DISABLE (76766) */
	'M', 'R', 'T', '3', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_COLOR_OPT_DISABLE (76789) */
	'M', 'R', 'T', '3', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_ALPHA_OPT_DISABLE (76812) */
	'M', 'R', 'T', '4', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_COLOR_OPT_DISABLE (76835) */
	'M', 'R', 'T', '4', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_ALPHA_OPT_DISABLE (76858) */
	'M', 'R', 'T', '5', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_COLOR_OPT_DISABLE (76881) */
	'M', 'R', 'T', '5', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_ALPHA_OPT_DISABLE (76904) */
	'M', 'R', 'T', '6', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_COLOR_OPT_DISABLE (76927) */
	'M', 'R', 'T', '6', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_ALPHA_OPT_DISABLE (76950) */
	'M', 'R', 'T', '7', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_COLOR_OPT_DISABLE (76973) */
	'M', 'R', 'T', '7', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_ALPHA_OPT_DISABLE (76996) */
	'P', 'I', 'X', 'E', 'N', '_', 'Z', 'E', 'R', 'O', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* PIXEN_ZERO_OPT_DISABLE (77019) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_ALL (77042) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', 'L', 'L', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_ALL_IGNORE_NONE (77077) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '0', '\0', /* BLEND_OPT_PRESERVE_C1_IGNORE_C0 (77112) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '1', '\0', /* BLEND_OPT_PRESERVE_C0_IGNORE_C1 (77144) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_A1_IGNORE_A0 (77176) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '1', '\0', /* BLEND_OPT_PRESERVE_A0_IGNORE_A1 (77208) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_A0 (77240) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_NONE (77274) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* COLOR_SRC_OPT (77310) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* COLOR_DST_OPT (77324) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'N', 'O', 'N', 'E', '\0', /* OPT_COMB_NONE (77338) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_ADD (77352) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_SUBTRACT (77365) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '\0', /* OPT_COMB_MIN (77383) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '\0', /* OPT_COMB_MAX (77396) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'R', 'E', 'V', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_REVSUBTRACT (77409) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OPT_COMB_BLEND_DISABLED (77430) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'A', 'F', 'E', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_SAFE_ADD (77454) */
	'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* COLOR_COMB_FCN (77472) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* ALPHA_SRC_OPT (77487) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* ALPHA_DST_OPT (77501) */
	'A', 'L', 'P', 'H', 'A', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* ALPHA_COMB_FCN (77515) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '\0', /* BLEND_ZERO (77530) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '\0', /* BLEND_ONE (77541) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC_COLOR (77551) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_SRC_COLOR (77567) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC_ALPHA (77593) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_SRC_ALPHA (77609) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_DST_ALPHA (77635) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_DST_ALPHA (77651) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_DST_COLOR (77677) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_DST_COLOR (77693) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '_', 'S', 'A', 'T', 'U', 'R', 'A', 'T', 'E', '\0', /* BLEND_SRC_ALPHA_SATURATE (77719) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_SRC_ALPHA (77744) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_INV_SRC_ALPHA (77765) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_CONSTANT_COLOR (77790) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_CONSTANT_COLOR (77811) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC1_COLOR (77842) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_INV_SRC1_COLOR (77859) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC1_ALPHA (77880) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_INV_SRC1_ALPHA (77897) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_CONSTANT_ALPHA (77918) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_CONSTANT_ALPHA (77939) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_SRCBLEND (77970) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'P', 'L', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_PLUS_SRC (77985) */
	'C', 'O', 'M', 'B', '_', 'S', 'R', 'C', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '\0', /* COMB_SRC_MINUS_DST (78003) */
	'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MIN_DST_SRC (78022) */
	'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MAX_DST_SRC (78039) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_MINUS_SRC (78056) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_DESTBLEND (78075) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_SRCBLEND (78091) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_DESTBLEND (78106) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'A', 'L', 'P', 'H', 'A', '_', 'B', 'L', 'E', 'N', 'D', '\0', /* SEPARATE_ALPHA_BLEND (78122) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'O', 'P', '3', '\0', /* DISABLE_ROP3 (78143, 78151) */
	'S', 'R', 'C', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* SRC_STATE_ID (78156) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'D', 'M', 'A', '\0', /* DI_SRC_SEL_DMA (78169) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* DI_SRC_SEL_IMMEDIATE (78184) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'A', 'U', 'T', 'O', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DI_SRC_SEL_AUTO_INDEX (78205) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* DI_SRC_SEL_RESERVED (78227) */
	'S', 'O', 'U', 'R', 'C', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SOURCE_SELECT (78247) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '0', '\0', /* DI_MAJOR_MODE_0 (78261) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '1', '\0', /* DI_MAJOR_MODE_1 (78277) */
	'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* MAJOR_MODE (78293) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '_', 'R', '6', 'X', 'X', '\0', /* SPRITE_EN_R6XX (78304) */
	'N', 'O', 'T', '_', 'E', 'O', 'P', '\0', /* NOT_EOP (78319) */
	'U', 'S', 'E', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '\0', /* USE_OPAQUE (78327) */
	'U', 'N', 'R', 'O', 'L', 'L', 'E', 'D', '_', 'I', 'N', 'S', 'T', '\0', /* UNROLLED_INST (78338) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'N', 'O', '_', 'D', 'E', 'C', '\0', /* GRBM_SKEW_NO_DEC (78352) */
	'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* REG_RT_INDEX (78369) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', 'W', '\0', /* ADDRESS_LOW (78382) */
	'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* MAX_VERTS_PER_SUBGROUP (78394) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_ENABLE (78417) */
	'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_WRITE_ENABLE (78432) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_ENABLE (78447) */
	'B', 'A', 'C', 'K', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* BACKFACE_ENABLE (78467) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '\0', /* STENCILFUNC (78483) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* STENCILFUNC_BF (78495) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'F', 'A', 'I', 'L', '\0', /* ENABLE_COLOR_WRITES_ON_DEPTH_FAIL (78510) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_COLOR_WRITES_ON_DEPTH_PASS (78544) */
	'M', 'A', 'X', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MAX_ANCHOR_SAMPLES (78579) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* PS_ITER_SAMPLES (78598) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MASK_EXPORT_NUM_SAMPLES (78614) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* ALPHA_TO_MASK_NUM_SAMPLES (78638) */
	'H', 'I', 'G', 'H', '_', 'Q', 'U', 'A', 'L', 'I', 'T', 'Y', '_', 'I', 'N', 'T', 'E', 'R', 'S', 'E', 'C', 'T', 'I', 'O', 'N', 'S', '\0', /* HIGH_QUALITY_INTERSECTIONS (78664) */
	'I', 'N', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'T', '_', 'E', 'Q', 'A', 'A', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* INCOHERENT_EQAA_READS (78691) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'C', 'O', 'M', 'P', '_', 'Z', '\0', /* INTERPOLATE_COMP_Z (78713) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'S', 'R', 'C', '_', 'Z', '\0', /* INTERPOLATE_SRC_Z (78732) */
	'S', 'T', 'A', 'T', 'I', 'C', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'A', 'S', 'S', 'O', 'C', 'I', 'A', 'T', 'I', 'O', 'N', 'S', '\0', /* STATIC_ANCHOR_ASSOCIATIONS (78750) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'Q', 'A', 'A', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_EQAA_DISABLE (78777) */
	'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'M', 'O', 'U', 'N', 'T', '\0', /* OVERRASTERIZATION_AMOUNT (78804) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'P', 'O', 'S', 'T', 'Z', '_', 'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* ENABLE_POSTZ_OVERRASTERIZATION (78829) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'D', 'U', 'A', 'L', '_', 'Q', 'U', 'A', 'D', '\0', /* DISABLE_DUAL_QUAD (78860) */
	'D', 'E', 'G', 'A', 'M', 'M', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEGAMMA_ENABLE (78878) */
	'C', 'B', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CB_DISABLE (78893) */
	'C', 'B', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* CB_NORMAL (78904) */
	'C', 'B', '_', 'E', 'L', 'I', 'M', 'I', 'N', 'A', 'T', 'E', '_', 'F', 'A', 'S', 'T', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* CB_ELIMINATE_FAST_CLEAR (78914, 78927) */
	'C', 'B', '_', 'R', 'E', 'S', 'O', 'L', 'V', 'E', '\0', /* CB_RESOLVE (78938) */
	'C', 'B', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DECOMPRESS (78949) */
	'C', 'B', '_', 'F', 'M', 'A', 'S', 'K', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_FMASK_DECOMPRESS (78963) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DCC_DECOMPRESS (78983) */
	'C', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* CB_RESERVED (79001) */
	'R', 'O', 'P', '3', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* ROP3_CLEAR (79013) */
	'X', '_', '0', 'X', '0', '5', '\0', /* X_0X05 (79024) */
	'X', '_', '0', 'X', '0', 'A', '\0', /* X_0X0A (79031) */
	'X', '_', '0', 'X', '0', 'F', '\0', /* X_0X0F (79038) */
	'R', 'O', 'P', '3', '_', 'N', 'O', 'R', '\0', /* ROP3_NOR (79045) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_AND_INVERTED (79054) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_COPY_INVERTED (79072) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_AND_REVERSE (79091) */
	'X', '_', '0', 'X', '5', '0', '\0', /* X_0X50 (79108) */
	'R', 'O', 'P', '3', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* ROP3_INVERT (79115) */
	'X', '_', '0', 'X', '5', 'A', '\0', /* X_0X5A (79127) */
	'X', '_', '0', 'X', '5', 'F', '\0', /* X_0X5F (79134) */
	'R', 'O', 'P', '3', '_', 'X', 'O', 'R', '\0', /* ROP3_XOR (79141) */
	'R', 'O', 'P', '3', '_', 'N', 'A', 'N', 'D', '\0', /* ROP3_NAND (79150) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '\0', /* ROP3_AND (79160) */
	'R', 'O', 'P', '3', '_', 'E', 'Q', 'U', 'I', 'V', 'A', 'L', 'E', 'N', 'T', '\0', /* ROP3_EQUIVALENT (79169) */
	'X', '_', '0', 'X', 'A', '0', '\0', /* X_0XA0 (79185) */
	'X', '_', '0', 'X', 'A', '5', '\0', /* X_0XA5 (79192) */
	'R', 'O', 'P', '3', '_', 'N', 'O', '_', 'O', 'P', '\0', /* ROP3_NO_OP (79199) */
	'X', '_', '0', 'X', 'A', 'F', '\0', /* X_0XAF (79210) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_OR_INVERTED (79217) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '\0', /* ROP3_COPY (79234) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_OR_REVERSE (79244) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '\0', /* ROP3_OR (79260) */
	'X', '_', '0', 'X', 'F', '0', '\0', /* X_0XF0 (79268) */
	'X', '_', '0', 'X', 'F', '5', '\0', /* X_0XF5 (79275) */
	'X', '_', '0', 'X', 'F', 'A', '\0', /* X_0XFA (79282) */
	'R', 'O', 'P', '3', '_', 'S', 'E', 'T', '\0', /* ROP3_SET (79289) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_EXPORT_ENABLE (79298) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'T', 'E', 'S', 'T', '_', 'V', 'A', 'L', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_TEST_VAL_EXPORT_ENABLE (79314) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'P', '_', 'V', 'A', 'L', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_OP_VAL_EXPORT_ENABLE (79345) */
	'L', 'A', 'T', 'E', '_', 'Z', '\0', /* LATE_Z (79374) */
	'E', 'A', 'R', 'L', 'Y', '_', 'Z', '_', 'T', 'H', 'E', 'N', '_', 'L', 'A', 'T', 'E', '_', 'Z', '\0', /* EARLY_Z_THEN_LATE_Z (79381) */
	'R', 'E', '_', 'Z', '\0', /* RE_Z (79401) */
	'E', 'A', 'R', 'L', 'Y', '_', 'Z', '_', 'T', 'H', 'E', 'N', '_', 'R', 'E', '_', 'Z', '\0', /* EARLY_Z_THEN_RE_Z (79406) */
	'K', 'I', 'L', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KILL_ENABLE (79424) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_TO_MASK_ENABLE (79436) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MASK_EXPORT_ENABLE (79460) */
	'E', 'X', 'E', 'C', '_', 'O', 'N', '_', 'H', 'I', 'E', 'R', '_', 'F', 'A', 'I', 'L', '\0', /* EXEC_ON_HIER_FAIL (79479) */
	'E', 'X', 'E', 'C', '_', 'O', 'N', '_', 'N', 'O', 'O', 'P', '\0', /* EXEC_ON_NOOP (79497) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_DISABLE (79510) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'E', 'F', 'O', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* DEPTH_BEFORE_SHADER (79532) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'A', 'N', 'Y', '_', 'Z', '\0', /* EXPORT_ANY_Z (79552) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'L', 'E', 'S', 'S', '_', 'T', 'H', 'A', 'N', '_', 'Z', '\0', /* EXPORT_LESS_THAN_Z (79565) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '_', 'T', 'H', 'A', 'N', '_', 'Z', '\0', /* EXPORT_GREATER_THAN_Z (79584) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* EXPORT_RESERVED (79606) */
	'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* CONSERVATIVE_Z_EXPORT (79622) */
	'D', 'U', 'A', 'L', '_', 'Q', 'U', 'A', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DUAL_QUAD_DISABLE (79644) */
	'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'P', 'I', 'X', 'E', 'L', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* PRIMITIVE_ORDERED_PIXEL_SHADER (79662) */
	'E', 'X', 'E', 'C', '_', 'I', 'F', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', 'P', 'E', 'D', '\0', /* EXEC_IF_OVERLAPPED (79693) */
	'P', 'O', 'P', 'S', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* POPS_OVERLAP_NUM_SAMPLES (79712) */
	'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PRE_SHADER_DEPTH_COVERAGE_ENABLE (79737) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '0', '\0', /* UCP_ENA_0 (79770) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '1', '\0', /* UCP_ENA_1 (79780) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '2', '\0', /* UCP_ENA_2 (79790) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '3', '\0', /* UCP_ENA_3 (79800) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '4', '\0', /* UCP_ENA_4 (79810) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '5', '\0', /* UCP_ENA_5 (79820) */
	'P', 'S', '_', 'U', 'C', 'P', '_', 'Y', '_', 'S', 'C', 'A', 'L', 'E', '_', 'N', 'E', 'G', '\0', /* PS_UCP_Y_SCALE_NEG (79830) */
	'P', 'S', '_', 'U', 'C', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* PS_UCP_MODE (79849) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CLIP_DISABLE (79861) */
	'U', 'C', 'P', '_', 'C', 'U', 'L', 'L', '_', 'O', 'N', 'L', 'Y', '_', 'E', 'N', 'A', '\0', /* UCP_CULL_ONLY_ENA (79874) */
	'B', 'O', 'U', 'N', 'D', 'A', 'R', 'Y', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '_', 'E', 'N', 'A', '\0', /* BOUNDARY_EDGE_FLAG_ENA (79892) */
	'D', 'X', '_', 'C', 'L', 'I', 'P', '_', 'S', 'P', 'A', 'C', 'E', '_', 'D', 'E', 'F', '\0', /* DX_CLIP_SPACE_DEF (79915) */
	'D', 'I', 'S', '_', 'C', 'L', 'I', 'P', '_', 'E', 'R', 'R', '_', 'D', 'E', 'T', 'E', 'C', 'T', '\0', /* DIS_CLIP_ERR_DETECT (79933) */
	'V', 'T', 'X', '_', 'K', 'I', 'L', 'L', '_', 'O', 'R', '\0', /* VTX_KILL_OR (79953) */
	'D', 'X', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'K', 'I', 'L', 'L', '\0', /* DX_RASTERIZATION_KILL (79965) */
	'D', 'X', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'T', 'T', 'R', '_', 'C', 'L', 'I', 'P', '_', 'E', 'N', 'A', '\0', /* DX_LINEAR_ATTR_CLIP_ENA (79987) */
	'V', 'T', 'E', '_', 'V', 'P', 'O', 'R', 'T', '_', 'P', 'R', 'O', 'V', 'O', 'K', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* VTE_VPORT_PROVOKE_DISABLE (80011) */
	'Z', 'C', 'L', 'I', 'P', '_', 'N', 'E', 'A', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZCLIP_NEAR_DISABLE (80037) */
	'Z', 'C', 'L', 'I', 'P', '_', 'F', 'A', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZCLIP_FAR_DISABLE (80056) */
	'Z', 'C', 'L', 'I', 'P', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'E', 'N', 'A', '\0', /* ZCLIP_PROG_NEAR_ENA (80074) */
	'C', 'U', 'L', 'L', '_', 'F', 'R', 'O', 'N', 'T', '\0', /* CULL_FRONT (80094) */
	'C', 'U', 'L', 'L', '_', 'B', 'A', 'C', 'K', '\0', /* CULL_BACK (80105) */
	'X', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'O', 'L', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* X_DISABLE_POLY_MODE (80115, 80125) */
	'X', '_', 'D', 'U', 'A', 'L', '_', 'M', 'O', 'D', 'E', '\0', /* X_DUAL_MODE (80135) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'P', 'O', 'I', 'N', 'T', 'S', '\0', /* X_DRAW_POINTS (80147) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* X_DRAW_LINES (80161) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* X_DRAW_TRIANGLES (80174) */
	'P', 'O', 'L', 'Y', 'M', 'O', 'D', 'E', '_', 'F', 'R', 'O', 'N', 'T', '_', 'P', 'T', 'Y', 'P', 'E', '\0', /* POLYMODE_FRONT_PTYPE (80191) */
	'P', 'O', 'L', 'Y', 'M', 'O', 'D', 'E', '_', 'B', 'A', 'C', 'K', '_', 'P', 'T', 'Y', 'P', 'E', '\0', /* POLYMODE_BACK_PTYPE (80212) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_FRONT_ENABLE (80232) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_BACK_ENABLE (80257) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'P', 'A', 'R', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_PARA_ENABLE (80281) */
	'V', 'T', 'X', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* VTX_WINDOW_OFFSET_ENABLE (80305) */
	'P', 'R', 'O', 'V', 'O', 'K', 'I', 'N', 'G', '_', 'V', 'T', 'X', '_', 'L', 'A', 'S', 'T', '\0', /* PROVOKING_VTX_LAST (80330) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'O', 'R', 'R', '_', 'D', 'I', 'S', '\0', /* PERSP_CORR_DIS (80349) */
	'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'E', 'N', 'A', '\0', /* MULTI_PRIM_IB_ENA (80364) */
	'R', 'I', 'G', 'H', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'A', 'L', 'T', 'E', 'R', 'N', 'A', 'T', 'E', '_', 'G', 'R', 'A', 'D', 'I', 'E', 'N', 'T', '_', 'R', 'E', 'F', '\0', /* RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF (80382) */
	'N', 'E', 'W', '_', 'Q', 'U', 'A', 'D', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'O', 'S', 'I', 'T', 'I', 'O', 'N', '\0', /* NEW_QUAD_DECOMPOSITION (80420) */
	'K', 'E', 'E', 'P', '_', 'T', 'O', 'G', 'E', 'T', 'H', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KEEP_TOGETHER_ENABLE (80443) */
	'V', 'P', 'O', 'R', 'T', '_', 'X', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_X_SCALE_ENA (80464) */
	'V', 'P', 'O', 'R', 'T', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_X_OFFSET_ENA (80482) */
	'V', 'P', 'O', 'R', 'T', '_', 'Y', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_Y_SCALE_ENA (80501) */
	'V', 'P', 'O', 'R', 'T', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_Y_OFFSET_ENA (80519) */
	'V', 'P', 'O', 'R', 'T', '_', 'Z', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_Z_SCALE_ENA (80538) */
	'V', 'P', 'O', 'R', 'T', '_', 'Z', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_Z_OFFSET_ENA (80556) */
	'V', 'T', 'X', '_', 'X', 'Y', '_', 'F', 'M', 'T', '\0', /* VTX_XY_FMT (80575) */
	'V', 'T', 'X', '_', 'Z', '_', 'F', 'M', 'T', '\0', /* VTX_Z_FMT (80586) */
	'V', 'T', 'X', '_', 'W', '0', '_', 'F', 'M', 'T', '\0', /* VTX_W0_FMT (80596) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'E', 'F', '\0', /* PERFCOUNTER_REF (80607) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '0', '\0', /* CLIP_DIST_ENA_0 (80623) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '1', '\0', /* CLIP_DIST_ENA_1 (80639) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '2', '\0', /* CLIP_DIST_ENA_2 (80655) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '3', '\0', /* CLIP_DIST_ENA_3 (80671) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '4', '\0', /* CLIP_DIST_ENA_4 (80687) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '5', '\0', /* CLIP_DIST_ENA_5 (80703) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '6', '\0', /* CLIP_DIST_ENA_6 (80719) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '7', '\0', /* CLIP_DIST_ENA_7 (80735) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '0', '\0', /* CULL_DIST_ENA_0 (80751) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '1', '\0', /* CULL_DIST_ENA_1 (80767) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '2', '\0', /* CULL_DIST_ENA_2 (80783) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '3', '\0', /* CULL_DIST_ENA_3 (80799) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '4', '\0', /* CULL_DIST_ENA_4 (80815) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '5', '\0', /* CULL_DIST_ENA_5 (80831) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '6', '\0', /* CULL_DIST_ENA_6 (80847) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '7', '\0', /* CULL_DIST_ENA_7 (80863) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* USE_VTX_POINT_SIZE (80879) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_EDGE_FLAG (80898, 80911) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* USE_VTX_RENDER_TARGET_INDX (80916) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* USE_VTX_VIEWPORT_INDX (80943) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'K', 'I', 'L', 'L', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_KILL_FLAG (80965) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'M', 'I', 'S', 'C', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_MISC_VEC_ENA (80983) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'C', 'D', 'I', 'S', 'T', '0', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_CCDIST0_VEC_ENA (81003) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'C', 'D', 'I', 'S', 'T', '1', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_CCDIST1_VEC_ENA (81026) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'M', 'I', 'S', 'C', '_', 'S', 'I', 'D', 'E', '_', 'B', 'U', 'S', '_', 'E', 'N', 'A', '\0', /* VS_OUT_MISC_SIDE_BUS_ENA (81049) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'G', 'S', '_', 'C', 'U', 'T', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_GS_CUT_FLAG (81074) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'S', 'H', 'D', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '\0', /* USE_VTX_SHD_OBJPRIM_ID (81094) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* USE_VTX_LINE_WIDTH (81117) */
	'V', 'T', 'E', '_', 'X', 'Y', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_XY_INF_DISCARD (81136) */
	'V', 'T', 'E', '_', 'Z', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_Z_INF_DISCARD (81155) */
	'V', 'T', 'E', '_', 'W', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_W_INF_DISCARD (81173) */
	'V', 'T', 'E', '_', '0', 'X', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'I', 'S', '_', '0', '\0', /* VTE_0XNANINF_IS_0 (81191) */
	'V', 'T', 'E', '_', 'X', 'Y', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_XY_NAN_RETAIN (81209) */
	'V', 'T', 'E', '_', 'Z', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_Z_NAN_RETAIN (81227) */
	'V', 'T', 'E', '_', 'W', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_W_NAN_RETAIN (81244) */
	'V', 'T', 'E', '_', 'W', '_', 'R', 'E', 'C', 'I', 'P', '_', 'N', 'A', 'N', '_', 'I', 'S', '_', '0', '\0', /* VTE_W_RECIP_NAN_IS_0 (81261) */
	'V', 'S', '_', 'X', 'Y', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_XY_NAN_TO_INF (81282) */
	'V', 'S', '_', 'X', 'Y', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_XY_INF_RETAIN (81299) */
	'V', 'S', '_', 'Z', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_Z_NAN_TO_INF (81316) */
	'V', 'S', '_', 'Z', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_Z_INF_RETAIN (81332) */
	'V', 'S', '_', 'W', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_W_NAN_TO_INF (81348) */
	'V', 'S', '_', 'W', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_W_INF_RETAIN (81364) */
	'V', 'S', '_', 'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VS_CLIP_DIST_INF_DISCARD (81380) */
	'V', 'T', 'E', '_', 'N', 'O', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'N', 'E', 'G', '_', '0', '\0', /* VTE_NO_OUTPUT_NEG_0 (81405) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* LINE_STIPPLE_RESET (81425) */
	'E', 'X', 'P', 'A', 'N', 'D', '_', 'F', 'U', 'L', 'L', '_', 'L', 'E', 'N', 'G', 'T', 'H', '\0', /* EXPAND_FULL_LENGTH (81444) */
	'F', 'R', 'A', 'C', 'T', 'I', 'O', 'N', 'A', 'L', '_', 'A', 'C', 'C', 'U', 'M', '\0', /* FRACTIONAL_ACCUM (81463) */
	'D', 'I', 'A', 'M', 'O', 'N', 'D', '_', 'A', 'D', 'J', 'U', 'S', 'T', '\0', /* DIAMOND_ADJUST (81480) */
	'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TRIANGLE_FILTER_DISABLE (81495) */
	'L', 'I', 'N', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* LINE_FILTER_DISABLE (81519) */
	'P', 'O', 'I', 'N', 'T', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* POINT_FILTER_DISABLE (81539) */
	'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* RECTANGLE_FILTER_DISABLE (81560) */
	'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* TRIANGLE_EXPAND_ENA (81585) */
	'L', 'I', 'N', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* LINE_EXPAND_ENA (81605) */
	'P', 'O', 'I', 'N', 'T', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* POINT_EXPAND_ENA (81621) */
	'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* RECTANGLE_EXPAND_ENA (81638) */
	'P', 'R', 'I', 'M', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '\0', /* PRIM_EXPAND_CONSTANT (81659) */
	'X', 'M', 'A', 'X', '_', 'R', 'I', 'G', 'H', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '\0', /* XMAX_RIGHT_EXCLUSION (81680) */
	'Y', 'M', 'A', 'X', '_', 'B', 'O', 'T', 'T', 'O', 'M', '_', 'E', 'X', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '\0', /* YMAX_BOTTOM_EXCLUSION (81701) */
	'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SMALL_PRIM_FILTER_ENABLE (81723) */
	'S', 'R', 'B', 'S', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SRBSL_ENABLE (81748) */
	'S', 'C', '_', '1', 'X', 'M', 'S', 'A', 'A', '_', 'C', 'O', 'M', 'P', 'A', 'T', 'I', 'B', 'L', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* SC_1XMSAA_COMPATIBLE_DISABLE (81761) */
	'O', 'B', 'J', '_', 'I', 'D', '_', 'S', 'E', 'L', '\0', /* OBJ_ID_SEL (81790) */
	'A', 'D', 'D', '_', 'P', 'I', 'P', 'E', 'D', '_', 'P', 'R', 'I', 'M', '_', 'I', 'D', '\0', /* ADD_PIPED_PRIM_ID (81801) */
	'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VERTEX_REUSE_OFF (81819) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '_', 'E', 'N', 'A', '\0', /* INDEX_BUF_EDGE_FLAG_ENA (81836) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* DISCARD_0_AREA_TRIANGLES (81860) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* DISCARD_0_AREA_LINES (81885) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'P', 'O', 'I', 'N', 'T', 'S', '\0', /* DISCARD_0_AREA_POINTS (81906) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* DISCARD_0_AREA_RECTANGLES (81928) */
	'U', 'S', 'E', '_', 'P', 'R', 'O', 'V', 'O', 'K', 'I', 'N', 'G', '_', 'Z', 'W', '\0', /* USE_PROVOKING_ZW (81954) */
	'S', 'T', 'E', 'R', 'E', 'O', '_', 'M', 'O', 'D', 'E', '\0', /* STEREO_MODE (81971) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* RT_SLICE_MODE (81983) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RT_SLICE_OFFSET (81997) */
	'V', 'P', '_', 'I', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* VP_ID_MODE (82013) */
	'V', 'P', '_', 'I', 'D', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VP_ID_OFFSET (82024) */
	'M', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '\0', /* MIN_SIZE (82037) */
	'L', 'I', 'N', 'E', '_', 'P', 'A', 'T', 'T', 'E', 'R', 'N', '\0', /* LINE_PATTERN (82046) */
	'R', 'E', 'P', 'E', 'A', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* REPEAT_COUNT (82059) */
	'P', 'A', 'T', 'T', 'E', 'R', 'N', '_', 'B', 'I', 'T', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* PATTERN_BIT_ORDER (82072) */
	'A', 'U', 'T', 'O', '_', 'R', 'E', 'S', 'E', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* AUTO_RESET_CNTL (82090) */
	'P', 'A', 'T', 'H', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PATH_SELECT (82106) */
	'T', 'E', 'S', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* TESS_MODE (82118) */
	'D', 'I', '_', 'P', 'T', '_', 'N', 'O', 'N', 'E', '\0', /* DI_PT_NONE (82128) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'O', 'I', 'N', 'T', 'L', 'I', 'S', 'T', '\0', /* DI_PT_POINTLIST (82139, 82145) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'I', 'S', 'T', '\0', /* DI_PT_LINELIST (82155) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_LINESTRIP (82170, 82176) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'L', 'I', 'S', 'T', '\0', /* DI_PT_TRILIST (82186) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'F', 'A', 'N', '\0', /* DI_PT_TRIFAN (82200) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_TRISTRIP (82213, 82219) */
	'D', 'I', '_', 'P', 'T', '_', '2', 'D', '_', 'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '\0', /* DI_PT_2D_RECTANGLE (82228) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '1', '\0', /* DI_PT_UNUSED_1 (82247) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'A', 'T', 'C', 'H', '\0', /* DI_PT_PATCH (82262) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'I', 'S', 'T', '_', 'A', 'D', 'J', '\0', /* DI_PT_LINELIST_ADJ (82274) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'S', 'T', 'R', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* DI_PT_LINESTRIP_ADJ (82293) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'L', 'I', 'S', 'T', '_', 'A', 'D', 'J', '\0', /* DI_PT_TRILIST_ADJ (82313) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'S', 'T', 'R', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* DI_PT_TRISTRIP_ADJ (82331) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '3', '\0', /* DI_PT_UNUSED_3 (82350) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '4', '\0', /* DI_PT_UNUSED_4 (82365) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', '_', 'W', 'I', 'T', 'H', '_', 'W', 'F', 'L', 'A', 'G', 'S', '\0', /* DI_PT_TRI_WITH_WFLAGS (82380) */
	'D', 'I', '_', 'P', 'T', '_', 'R', 'E', 'C', 'T', 'L', 'I', 'S', 'T', '\0', /* DI_PT_RECTLIST (82402, 82408) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'O', 'O', 'P', '\0', /* DI_PT_LINELOOP (82417) */
	'D', 'I', '_', 'P', 'T', '_', 'Q', 'U', 'A', 'D', 'L', 'I', 'S', 'T', '\0', /* DI_PT_QUADLIST (82432) */
	'D', 'I', '_', 'P', 'T', '_', 'Q', 'U', 'A', 'D', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_QUADSTRIP (82447) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'O', 'L', 'Y', 'G', 'O', 'N', '\0', /* DI_PT_POLYGON (82463) */
	'R', 'E', 'T', 'A', 'I', 'N', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* RETAIN_ORDER (82477) */
	'R', 'E', 'T', 'A', 'I', 'N', '_', 'Q', 'U', 'A', 'D', 'S', '\0', /* RETAIN_QUADS (82490) */
	'P', 'R', 'I', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* PRIM_ORDER (82503) */
	'C', 'O', 'M', 'P', '_', 'X', '_', 'E', 'N', '\0', /* COMP_X_EN (82514) */
	'C', 'O', 'M', 'P', '_', 'Y', '_', 'E', 'N', '\0', /* COMP_Y_EN (82524) */
	'C', 'O', 'M', 'P', '_', 'Z', '_', 'E', 'N', '\0', /* COMP_Z_EN (82534) */
	'C', 'O', 'M', 'P', '_', 'W', '_', 'E', 'N', '\0', /* COMP_W_EN (82544) */
	'S', 'H', 'I', 'F', 'T', '\0', /* SHIFT (82554) */
	'X', '_', 'C', 'O', 'N', 'V', '\0', /* X_CONV (82560, 82564) */
	'Y', '_', 'C', 'O', 'N', 'V', '\0', /* Y_CONV (82567) */
	'Z', '_', 'C', 'O', 'N', 'V', '\0', /* Z_CONV (82574) */
	'Z', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* Z_OFFSET (82581) */
	'W', '_', 'C', 'O', 'N', 'V', '\0', /* W_CONV (82590) */
	'G', 'S', '_', 'O', 'F', 'F', '\0', /* GS_OFF (82597) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'A', '\0', /* GS_SCENARIO_A (82604) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'B', '\0', /* GS_SCENARIO_B (82618) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'G', '\0', /* GS_SCENARIO_G (82632) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'C', '\0', /* GS_SCENARIO_C (82646) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '\0', /* SPRITE_EN (82660) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '0', '\0', /* RESERVED_0 (82670) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '1', '0', '2', '4', '\0', /* GS_CUT_1024 (82681) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '5', '1', '2', '\0', /* GS_CUT_512 (82693) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '2', '5', '6', '\0', /* GS_CUT_256 (82704) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '1', '2', '8', '\0', /* GS_CUT_128 (82715) */
	'C', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* CUT_MODE (82726) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '\0', /* RESERVED_1 (82735) */
	'G', 'S', '_', 'C', '_', 'P', 'A', 'C', 'K', '_', 'E', 'N', '\0', /* GS_C_PACK_EN (82746) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '\0', /* RESERVED_2 (82759) */
	'E', 'S', '_', 'P', 'A', 'S', 'S', 'T', 'H', 'R', 'U', '\0', /* ES_PASSTHRU (82770) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* COMPUTE_MODE (82782) */
	'F', 'A', 'S', 'T', '_', 'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* FAST_COMPUTE_MODE (82795) */
	'E', 'L', 'E', 'M', 'E', 'N', 'T', '_', 'I', 'N', 'F', 'O', '_', 'E', 'N', '\0', /* ELEMENT_INFO_EN (82813) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'H', 'D', '_', 'A', 'T', '_', 'E', 'O', 'I', '\0', /* PARTIAL_THD_AT_EOI (82829) */
	'S', 'U', 'P', 'P', 'R', 'E', 'S', 'S', '_', 'C', 'U', 'T', 'S', '\0', /* SUPPRESS_CUTS (82848) */
	'E', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '\0', /* ES_WRITE_OPTIMIZE (82862) */
	'G', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '\0', /* GS_WRITE_OPTIMIZE (82880) */
	'O', 'N', 'C', 'H', 'I', 'P', '\0', /* ONCHIP (82898) */
	'E', 'S', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* ES_VERTS_PER_SUBGRP (82905) */
	'G', 'S', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* GS_PRIMS_PER_SUBGRP (82925) */
	'G', 'S', '_', 'I', 'N', 'S', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'I', 'N', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* GS_INST_PRIMS_IN_SUBGRP (82945) */
	'M', 'S', 'A', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MSAA_ENABLE (82969) */
	'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* VPORT_SCISSOR_ENABLE (82981) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* LINE_STIPPLE_ENABLE (83002) */
	'S', 'E', 'N', 'D', '_', 'U', 'N', 'L', 'I', 'T', '_', 'S', 'T', 'I', 'L', 'E', 'S', '_', 'T', 'O', '_', 'P', 'K', 'R', '\0', /* SEND_UNLIT_STILES_TO_PKR (83022) */
	'S', 'C', 'A', 'L', 'E', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '_', 'P', 'A', 'D', '\0', /* SCALE_LINE_WIDTH_PAD (83047) */
	'A', 'L', 'T', 'E', 'R', 'N', 'A', 'T', 'E', '_', 'R', 'B', 'S', '_', 'P', 'E', 'R', '_', 'T', 'I', 'L', 'E', '\0', /* ALTERNATE_RBS_PER_TILE (83068) */
	'C', 'O', 'A', 'R', 'S', 'E', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'A', 'R', 'T', 'S', '_', 'O', 'N', '_', 'E', 'V', 'E', 'N', '_', 'R', 'B', '\0', /* COARSE_TILE_STARTS_ON_EVEN_RB (83091) */
	'W', 'A', 'L', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* WALK_SIZE (83121) */
	'W', 'A', 'L', 'K', '_', 'A', 'L', 'I', 'G', 'N', 'M', 'E', 'N', 'T', '\0', /* WALK_ALIGNMENT (83131) */
	'W', 'A', 'L', 'K', '_', 'A', 'L', 'I', 'G', 'N', '8', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'T', 'S', '_', 'S', 'T', '\0', /* WALK_ALIGN8_PRIM_FITS_ST (83146) */
	'W', 'A', 'L', 'K', '_', 'F', 'E', 'N', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WALK_FENCE_ENABLE (83171) */
	'W', 'A', 'L', 'K', '_', 'F', 'E', 'N', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* WALK_FENCE_SIZE (83189) */
	'S', 'U', 'P', 'E', 'R', 'T', 'I', 'L', 'E', '_', 'W', 'A', 'L', 'K', '_', 'O', 'R', 'D', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SUPERTILE_WALK_ORDER_ENABLE (83205, 83210) */
	'T', 'I', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_COVER_DISABLE (83233) */
	'T', 'I', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', '_', 'N', 'O', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '\0', /* TILE_COVER_NO_SCISSOR (83252) */
	'Z', 'M', 'M', '_', 'L', 'I', 'N', 'E', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_LINE_EXTENT (83274) */
	'Z', 'M', 'M', '_', 'L', 'I', 'N', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* ZMM_LINE_OFFSET (83290) */
	'Z', 'M', 'M', '_', 'R', 'E', 'C', 'T', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_RECT_EXTENT (83306) */
	'K', 'I', 'L', 'L', '_', 'P', 'I', 'X', '_', 'P', 'O', 'S', 'T', '_', 'H', 'I', '_', 'Z', '\0', /* KILL_PIX_POST_HI_Z (83322) */
	'K', 'I', 'L', 'L', '_', 'P', 'I', 'X', '_', 'P', 'O', 'S', 'T', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'M', 'A', 'S', 'K', '\0', /* KILL_PIX_POST_DETAIL_MASK (83341) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* PS_ITER_SAMPLE (83367) */
	'M', 'U', 'L', 'T', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', '_', 'P', 'R', 'I', 'M', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE (83382) */
	'M', 'U', 'L', 'T', 'I', '_', 'G', 'P', 'U', '_', 'S', 'U', 'P', 'E', 'R', 'T', 'I', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_GPU_SUPERTILE_ENABLE (83422) */
	'G', 'P', 'U', '_', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* GPU_ID_OVERRIDE_ENABLE (83449) */
	'G', 'P', 'U', '_', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* GPU_ID_OVERRIDE (83472) */
	'M', 'U', 'L', 'T', 'I', '_', 'G', 'P', 'U', '_', 'P', 'R', 'I', 'M', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_GPU_PRIM_DISCARD_ENABLE (83488) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'C', 'N', 'T', 'D', 'W', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_EOV_CNTDWN_ENABLE (83518) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'R', 'E', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_EOV_REZ_ENABLE (83542) */
	'O', 'U', 'T', '_', 'O', 'F', '_', 'O', 'R', 'D', 'E', 'R', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUT_OF_ORDER_PRIMITIVE_ENABLE (83563) */
	'O', 'U', 'T', '_', 'O', 'F', '_', 'O', 'R', 'D', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', '_', 'M', 'A', 'R', 'K', '\0', /* OUT_OF_ORDER_WATER_MARK (83593) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* OUTPRIM_TYPE (83617) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '1', '\0', /* OUTPRIM_TYPE_1 (83630) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '2', '\0', /* OUTPRIM_TYPE_2 (83645) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '3', '\0', /* OUTPRIM_TYPE_3 (83660) */
	'U', 'N', 'I', 'Q', 'U', 'E', '_', 'T', 'Y', 'P', 'E', '_', 'P', 'E', 'R', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* UNIQUE_TYPE_PER_STREAM (83675) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '1', '6', '\0', /* VGT_INDEX_16 (83698) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '3', '2', '\0', /* VGT_INDEX_32 (83711) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '8', '\0', /* VGT_INDEX_8 (83724) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', 'N', 'O', 'N', 'E', '\0', /* VGT_DMA_SWAP_NONE (83736) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', '1', '6', '_', 'B', 'I', 'T', '\0', /* VGT_DMA_SWAP_16_BIT (83754) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', '3', '2', '_', 'B', 'I', 'T', '\0', /* VGT_DMA_SWAP_32_BIT (83774) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', 'W', 'O', 'R', 'D', '\0', /* VGT_DMA_SWAP_WORD (83794) */
	'S', 'W', 'A', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* SWAP_MODE (83812) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'M', 'E', 'M', '\0', /* VGT_DMA_BUF_MEM (83822) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'R', 'I', 'N', 'G', '\0', /* VGT_DMA_BUF_RING (83838) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'S', 'E', 'T', 'U', 'P', '\0', /* VGT_DMA_BUF_SETUP (83855) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'P', 'T', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* VGT_DMA_PTR_UPDATE (83873) */
	'B', 'U', 'F', '_', 'T', 'Y', 'P', 'E', '\0', /* BUF_TYPE (83892) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'L', 'R', 'U', '\0', /* VGT_POLICY_LRU (83901) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* VGT_POLICY_STREAM (83916) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* VGT_POLICY_BYPASS (83934) */
	'R', 'D', 'R', 'E', 'Q', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RDREQ_POLICY (83952) */
	'A', 'T', 'C', '\0', /* ATC (83965) */
	'R', 'E', 'Q', '_', 'P', 'A', 'T', 'H', '\0', /* REQ_PATH (83969) */
	'M', 'T', 'Y', 'P', 'E', '\0', /* MTYPE (83978) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'S', 'E', 'T', '_', 'O', 'N', '_', 'E', 'O', 'I', '\0', /* DISABLE_RESET_ON_EOI (83984) */
	'N', 'G', 'G', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'R', 'O', 'V', 'O', 'K', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* NGG_DISABLE_PROVOK_REUSE (84005) */
	'R', 'e', 's', 'e', 'r', 'v', 'e', 'd', '_', '0', 'x', '0', '0', '\0', /* Reserved_0x00 (84030) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '1', '\0', /* SAMPLE_STREAMOUTSTATS1 (84044) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '2', '\0', /* SAMPLE_STREAMOUTSTATS2 (84067) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '3', '\0', /* SAMPLE_STREAMOUTSTATS3 (84090) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'T', 'S', '\0', /* CACHE_FLUSH_TS (84113) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* CONTEXT_DONE (84128) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* CACHE_FLUSH (84141) */
	'C', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* CS_PARTIAL_FLUSH (84153) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'S', 'Y', 'N', 'C', '\0', /* VGT_STREAMOUT_SYNC (84170) */
	'S', 'E', 'T', '_', 'F', 'E', '_', 'I', 'D', '\0', /* SET_FE_ID (84189) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_STREAMOUT_RESET (84199) */
	'E', 'N', 'D', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'I', 'N', 'C', 'R', '_', 'D', 'E', '\0', /* END_OF_PIPE_INCR_DE (84219) */
	'E', 'N', 'D', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'I', 'B', '_', 'E', 'N', 'D', '\0', /* END_OF_PIPE_IB_END (84239) */
	'R', 'S', 'T', '_', 'P', 'I', 'X', '_', 'C', 'N', 'T', '\0', /* RST_PIX_CNT (84258) */
	'B', 'R', 'E', 'A', 'K', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* BREAK_BATCH (84270) */
	'V', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* VS_PARTIAL_FLUSH (84282) */
	'P', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* PS_PARTIAL_FLUSH (84299) */
	'F', 'L', 'U', 'S', 'H', '_', 'H', 'S', '_', 'O', 'U', 'T', 'P', 'U', 'T', '\0', /* FLUSH_HS_OUTPUT (84316) */
	'F', 'L', 'U', 'S', 'H', '_', 'D', 'F', 'S', 'M', '\0', /* FLUSH_DFSM (84332) */
	'R', 'E', 'S', 'E', 'T', '_', 'T', 'O', '_', 'L', 'O', 'W', 'E', 'S', 'T', '_', 'V', 'G', 'T', '\0', /* RESET_TO_LOWEST_VGT (84343) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'T', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* CACHE_FLUSH_AND_INV_TS_EVENT (84363) */
	'Z', 'P', 'A', 'S', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* ZPASS_DONE (84392) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* CACHE_FLUSH_AND_INV_EVENT (84403) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* PERFCOUNTER_START (84429) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'T', 'O', 'P', '\0', /* PERFCOUNTER_STOP (84447) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* PIPELINESTAT_START (84464) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'S', 'T', 'O', 'P', '\0', /* PIPELINESTAT_STOP (84483) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* PERFCOUNTER_SAMPLE (84501) */
	'F', 'L', 'U', 'S', 'H', '_', 'E', 'S', '_', 'O', 'U', 'T', 'P', 'U', 'T', '\0', /* FLUSH_ES_OUTPUT (84520) */
	'B', 'I', 'N', '_', 'C', 'O', 'N', 'F', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'H', 'E', 'C', 'K', '\0', /* BIN_CONF_OVERRIDE_CHECK (84536) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '\0', /* SAMPLE_PIPELINESTAT (84560) */
	'S', 'O', '_', 'V', 'G', 'T', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* SO_VGTSTREAMOUT_FLUSH (84580) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '\0', /* SAMPLE_STREAMOUTSTATS (84602) */
	'R', 'E', 'S', 'E', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '\0', /* RESET_VTX_CNT (84624) */
	'B', 'L', 'O', 'C', 'K', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* BLOCK_CONTEXT_DONE (84638) */
	'C', 'S', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* CS_CONTEXT_DONE (84657) */
	'V', 'G', 'T', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* VGT_FLUSH (84673) */
	'T', 'G', 'I', 'D', '_', 'R', 'O', 'L', 'L', 'O', 'V', 'E', 'R', '\0', /* TGID_ROLLOVER (84683) */
	'S', 'Q', '_', 'N', 'O', 'N', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* SQ_NON_EVENT (84697) */
	'S', 'C', '_', 'S', 'E', 'N', 'D', '_', 'D', 'B', '_', 'V', 'P', 'Z', '\0', /* SC_SEND_DB_VPZ (84710) */
	'B', 'O', 'T', 'T', 'O', 'M', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'T', 'S', '\0', /* BOTTOM_OF_PIPE_TS (84725) */
	'F', 'L', 'U', 'S', 'H', '_', 'S', 'X', '_', 'T', 'S', '\0', /* FLUSH_SX_TS (84743) */
	'D', 'B', '_', 'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '\0', /* DB_CACHE_FLUSH_AND_INV (84755) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'D', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'S', '\0', /* FLUSH_AND_INV_DB_DATA_TS (84778) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'D', 'B', '_', 'M', 'E', 'T', 'A', '\0', /* FLUSH_AND_INV_DB_META (84803) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'S', '\0', /* FLUSH_AND_INV_CB_DATA_TS (84825) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'M', 'E', 'T', 'A', '\0', /* FLUSH_AND_INV_CB_META (84850) */
	'C', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* CS_DONE (84872) */
	'P', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* PS_DONE (84880) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'P', 'I', 'X', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* FLUSH_AND_INV_CB_PIXEL_DATA (84888) */
	'S', 'X', '_', 'C', 'B', '_', 'R', 'A', 'T', '_', 'A', 'C', 'K', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '\0', /* SX_CB_RAT_ACK_REQUEST (84916) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* THREAD_TRACE_START (84938) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'O', 'P', '\0', /* THREAD_TRACE_STOP (84957) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'R', 'K', 'E', 'R', '\0', /* THREAD_TRACE_MARKER (84975) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'A', 'W', '\0', /* THREAD_TRACE_DRAW (84995) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* THREAD_TRACE_FINISH (85013) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PIXEL_PIPE_STAT_CONTROL (85033) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'D', 'U', 'M', 'P', '\0', /* PIXEL_PIPE_STAT_DUMP (85057) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* PIXEL_PIPE_STAT_RESET (85078) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'S', 'U', 'S', 'P', 'E', 'N', 'D', '\0', /* CONTEXT_SUSPEND (85100) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'H', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* OFFCHIP_HS_DEALLOC (85116) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'N', 'G', 'G', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '\0', /* ENABLE_NGG_PIPELINE (85135) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '\0', /* ENABLE_LEGACY_PIPELINE (85155) */
	'D', 'R', 'A', 'W', '_', 'D', 'O', 'N', 'E', '\0', /* DRAW_DONE (85178) */
	'E', 'V', 'E', 'N', 'T', '_', 'T', 'Y', 'P', 'E', '\0', /* EVENT_TYPE (85188) */
	'E', 'X', 'T', 'E', 'N', 'D', 'E', 'D', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* EXTENDED_EVENT (85199) */
	'M', 'A', 'T', 'C', 'H', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* MATCH_ALL_BITS (85214) */
	'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'E', 'N', '\0', /* OBJPRIM_ID_EN (85229) */
	'E', 'N', '_', 'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* EN_REG_RT_INDEX (85243) */
	'O', 'B', 'J', 'E', 'C', 'T', '_', 'I', 'D', '_', 'I', 'N', 'S', 'T', '_', 'E', 'N', '\0', /* OBJECT_ID_INST_EN (85259) */
	'E', 'N', '_', 'P', 'R', 'I', 'M', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* EN_PRIM_PAYLOAD (85277) */
	'E', 'N', '_', 'D', 'R', 'A', 'W', '_', 'V', 'P', '\0', /* EN_DRAW_VP (85293) */
	'P', 'R', 'I', 'M', 'G', 'R', 'O', 'U', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* PRIMGROUP_SIZE (85304) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'V', 'S', '_', 'W', 'A', 'V', 'E', '_', 'O', 'N', '\0', /* PARTIAL_VS_WAVE_ON (85319) */
	'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'P', '\0', /* SWITCH_ON_EOP (85338) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'E', 'S', '_', 'W', 'A', 'V', 'E', '_', 'O', 'N', '\0', /* PARTIAL_ES_WAVE_ON (85352) */
	'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'I', '\0', /* SWITCH_ON_EOI (85371) */
	'W', 'D', '_', 'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'P', '\0', /* WD_SWITCH_ON_EOP (85385) */
	'F', 'U', 'L', 'L', '_', 'C', 'A', 'C', 'H', 'E', '\0', /* FULL_CACHE (85402) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* RESERVED_FIELD_2 (85413) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* RESERVED_FIELD_3 (85430) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* RESERVED_FIELD_4 (85447) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* RESERVED_FIELD_5 (85464) */
	'D', 'S', 'T', '_', 'O', 'U', 'T', 'S', 'I', 'D', 'E', '_', 'Z', 'E', 'R', 'O', '_', 'T', 'O', '_', 'O', 'N', 'E', '\0', /* DST_OUTSIDE_ZERO_TO_ONE (85481) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* RESERVED_FIELD_6 (85505) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'F', 'U', 'N', 'C', '0', '\0', /* COMPAREFUNC0 (85522) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'V', 'A', 'L', 'U', 'E', '0', '\0', /* COMPAREVALUE0 (85535) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'M', 'A', 'S', 'K', '0', '\0', /* COMPAREMASK0 (85549) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'F', 'U', 'N', 'C', '1', '\0', /* COMPAREFUNC1 (85562) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'V', 'A', 'L', 'U', 'E', '1', '\0', /* COMPAREVALUE1 (85575) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'M', 'A', 'S', 'K', '1', '\0', /* COMPAREMASK1 (85589) */
	'M', 'A', 'X', '_', 'X', '\0', /* MAX_X (85602) */
	'M', 'A', 'X', '_', 'Y', '\0', /* MAX_Y (85608) */
	'P', 'R', 'I', 'M', '_', 'A', 'M', 'P', '_', 'F', 'A', 'C', 'T', 'O', 'R', '\0', /* PRIM_AMP_FACTOR (85614) */
	'T', 'H', 'D', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* THDS_PER_SUBGRP (85630) */
	'A', 'C', 'C', 'U', 'M', '_', 'I', 'S', 'O', 'L', 'I', 'N', 'E', '\0', /* ACCUM_ISOLINE (85646) */
	'A', 'C', 'C', 'U', 'M', '_', 'T', 'R', 'I', '\0', /* ACCUM_TRI (85660) */
	'A', 'C', 'C', 'U', 'M', '_', 'Q', 'U', 'A', 'D', '\0', /* ACCUM_QUAD (85670) */
	'D', 'O', 'N', 'U', 'T', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* DONUT_SPLIT (85681) */
	'T', 'R', 'A', 'P', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TRAP_SPLIT (85693) */
	'L', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* LS_STAGE_OFF (85704) */
	'L', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* LS_STAGE_ON (85717) */
	'C', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* CS_STAGE_ON (85729) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'L', 'S', '\0', /* RESERVED_LS (85741) */
	'L', 'S', '_', 'E', 'N', '\0', /* LS_EN (85753) */
	'H', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* HS_STAGE_OFF (85759) */
	'H', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* HS_STAGE_ON (85772) */
	'H', 'S', '_', 'E', 'N', '\0', /* HS_EN (85784) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* ES_STAGE_OFF (85790) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'D', 'S', '\0', /* ES_STAGE_DS (85803) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'R', 'E', 'A', 'L', '\0', /* ES_STAGE_REAL (85815) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'E', 'S', '\0', /* RESERVED_ES (85829) */
	'G', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* GS_STAGE_OFF (85841) */
	'G', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* GS_STAGE_ON (85854) */
	'G', 'S', '_', 'E', 'N', '\0', /* GS_EN (85866) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'R', 'E', 'A', 'L', '\0', /* VS_STAGE_REAL (85872) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'D', 'S', '\0', /* VS_STAGE_DS (85886) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* VS_STAGE_COPY_SHADER (85898) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'V', 'S', '\0', /* RESERVED_VS (85919) */
	'V', 'S', '_', 'E', 'N', '\0', /* VS_EN (85931) */
	'D', 'Y', 'N', 'A', 'M', 'I', 'C', '_', 'H', 'S', '\0', /* DYNAMIC_HS (85937) */
	'D', 'I', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* DIS_DEALLOC_ACCUM_0 (85948) */
	'D', 'I', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* DIS_DEALLOC_ACCUM_1 (85968) */
	'V', 'S', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'E', 'N', '\0', /* VS_WAVE_ID_EN (85988) */
	'P', 'R', 'I', 'M', 'G', 'E', 'N', '_', 'E', 'N', '\0', /* PRIMGEN_EN (86002) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'I', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_ID_MODE (86013) */
	'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'G', 'R', 'P', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_PRIMGRP_IN_WAVE (86029) */
	'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* GS_FAST_LAUNCH (86049) */
	'H', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* HS_W32_EN (86064) */
	'G', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* GS_W32_EN (86074) */
	'V', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* VS_W32_EN (86084) */
	'N', 'G', 'G', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'E', 'N', '\0', /* NGG_WAVE_ID_EN (86094) */
	'P', 'R', 'I', 'M', 'G', 'E', 'N', '_', 'P', 'A', 'S', 'S', 'T', 'H', 'R', 'U', '_', 'E', 'N', '\0', /* PRIMGEN_PASSTHRU_EN (86109) */
	'N', 'U', 'M', '_', 'P', 'A', 'T', 'C', 'H', 'E', 'S', '\0', /* NUM_PATCHES (86129, 86133) */
	'H', 'S', '_', 'N', 'U', 'M', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'P', '\0', /* HS_NUM_INPUT_CP (86141) */
	'H', 'S', '_', 'N', 'U', 'M', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'C', 'P', '\0', /* HS_NUM_OUTPUT_CP (86157) */
	'T', 'E', 'S', 'S', '_', 'I', 'S', 'O', 'L', 'I', 'N', 'E', '\0', /* TESS_ISOLINE (86174) */
	'T', 'E', 'S', 'S', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '\0', /* TESS_TRIANGLE (86187) */
	'T', 'E', 'S', 'S', '_', 'Q', 'U', 'A', 'D', '\0', /* TESS_QUAD (86201) */
	'P', 'A', 'R', 'T', '_', 'I', 'N', 'T', 'E', 'G', 'E', 'R', '\0', /* PART_INTEGER (86211) */
	'P', 'A', 'R', 'T', '_', 'P', 'O', 'W', '2', '\0', /* PART_POW2 (86224) */
	'P', 'A', 'R', 'T', '_', 'F', 'R', 'A', 'C', '_', 'O', 'D', 'D', '\0', /* PART_FRAC_ODD (86234) */
	'P', 'A', 'R', 'T', '_', 'F', 'R', 'A', 'C', '_', 'E', 'V', 'E', 'N', '\0', /* PART_FRAC_EVEN (86248) */
	'P', 'A', 'R', 'T', 'I', 'T', 'I', 'O', 'N', 'I', 'N', 'G', '\0', /* PARTITIONING (86263) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* OUTPUT_POINT (86276) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'L', 'I', 'N', 'E', '\0', /* OUTPUT_LINE (86289) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'C', 'W', '\0', /* OUTPUT_TRIANGLE_CW (86301) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'C', 'C', 'W', '\0', /* OUTPUT_TRIANGLE_CCW (86320) */
	'T', 'O', 'P', 'O', 'L', 'O', 'G', 'Y', '\0', /* TOPOLOGY (86340) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'D', 'U', 'C', '_', 'A', 'X', 'I', 'S', '\0', /* RESERVED_REDUC_AXIS (86349) */
	'D', 'E', 'P', 'R', 'E', 'C', 'A', 'T', 'E', 'D', '\0', /* DEPRECATED (86369) */
	'N', 'U', 'M', '_', 'D', 'S', '_', 'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'I', 'M', 'D', '\0', /* NUM_DS_WAVES_PER_SIMD (86380) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'D', 'O', 'N', 'U', 'T', 'S', '\0', /* DISABLE_DONUTS (86402, 86410) */
	'N', 'O', '_', 'D', 'I', 'S', 'T', '\0', /* NO_DIST (86417) */
	'T', 'R', 'A', 'P', 'E', 'Z', 'O', 'I', 'D', 'S', '\0', /* TRAPEZOIDS (86425) */
	'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '_', 'M', 'O', 'D', 'E', '\0', /* DISTRIBUTION_MODE (86436) */
	'P', 'R', 'E', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '1', '\0', /* PRE_CLAMP_TF1 (86454) */
	'P', 'O', 'S', 'T', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '1', '\0', /* POST_CLAMP_TF1 (86468) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'F', '1', '\0', /* DISABLE_TF1 (86483) */
	'D', 'E', 'T', 'E', 'C', 'T', '_', 'O', 'N', 'E', '\0', /* DETECT_ONE (86495) */
	'P', 'R', 'E', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '0', '\0', /* PRE_CLAMP_TF0 (86506) */
	'P', 'O', 'S', 'T', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '0', '\0', /* POST_CLAMP_TF0 (86520) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'F', '0', '\0', /* DISABLE_TF0 (86535) */
	'D', 'E', 'T', 'E', 'C', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* DETECT_ZERO (86547) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_ENABLE (86559) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* ALPHA_TO_MASK_OFFSET0 (86580) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* ALPHA_TO_MASK_OFFSET1 (86602) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '2', '\0', /* ALPHA_TO_MASK_OFFSET2 (86624) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '3', '\0', /* ALPHA_TO_MASK_OFFSET3 (86646) */
	'O', 'F', 'F', 'S', 'E', 'T', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* OFFSET_ROUND (86668) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'N', 'E', 'G', '_', 'N', 'U', 'M', '_', 'D', 'B', '_', 'B', 'I', 'T', 'S', '\0', /* POLY_OFFSET_NEG_NUM_DB_BITS (86681) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'I', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'F', 'M', 'T', '\0', /* POLY_OFFSET_DB_IS_FLOAT_FMT (86709) */
	'E', 'N', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '_', 'P', 'E', 'R', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '\0', /* EN_MAX_VERT_OUT_PER_GS_INSTANCE (86737) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '0', '_', 'E', 'N', '\0', /* STREAMOUT_0_EN (86769) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '1', '_', 'E', 'N', '\0', /* STREAMOUT_1_EN (86784) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '2', '_', 'E', 'N', '\0', /* STREAMOUT_2_EN (86799) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '3', '_', 'E', 'N', '\0', /* STREAMOUT_3_EN (86814) */
	'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* RAST_STREAM (86829) */
	'E', 'N', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* EN_PRIMS_NEEDED_CNT (86841) */
	'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'M', 'A', 'S', 'K', '\0', /* RAST_STREAM_MASK (86861) */
	'U', 'S', 'E', '_', 'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'M', 'A', 'S', 'K', '\0', /* USE_RAST_STREAM_MASK (86878) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '0', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_0_BUFFER_EN (86899) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '1', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_1_BUFFER_EN (86918) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '2', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_2_BUFFER_EN (86937) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '3', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_3_BUFFER_EN (86956) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '0', '\0', /* DISTANCE_0 (86975) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '\0', /* DISTANCE_1 (86986) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '2', '\0', /* DISTANCE_2 (86997) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '3', '\0', /* DISTANCE_3 (87008) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '4', '\0', /* DISTANCE_4 (87019) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '5', '\0', /* DISTANCE_5 (87030) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '6', '\0', /* DISTANCE_6 (87041) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '7', '\0', /* DISTANCE_7 (87052) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '8', '\0', /* DISTANCE_8 (87063) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '9', '\0', /* DISTANCE_9 (87074) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '0', '\0', /* DISTANCE_10 (87085) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '1', '\0', /* DISTANCE_11 (87097) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '2', '\0', /* DISTANCE_12 (87109) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '3', '\0', /* DISTANCE_13 (87121) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '4', '\0', /* DISTANCE_14 (87133) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '5', '\0', /* DISTANCE_15 (87145) */
	'E', 'X', 'P', 'A', 'N', 'D', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* EXPAND_LINE_WIDTH (87157) */
	'L', 'A', 'S', 'T', '_', 'P', 'I', 'X', 'E', 'L', '\0', /* LAST_PIXEL (87175) */
	'P', 'E', 'R', 'P', 'E', 'N', 'D', 'I', 'C', 'U', 'L', 'A', 'R', '_', 'E', 'N', 'D', 'C', 'A', 'P', '_', 'E', 'N', 'A', '\0', /* PERPENDICULAR_ENDCAP_ENA (87186) */
	'D', 'X', '1', '0', '_', 'D', 'I', 'A', 'M', 'O', 'N', 'D', '_', 'T', 'E', 'S', 'T', '_', 'E', 'N', 'A', '\0', /* DX10_DIAMOND_TEST_ENA (87211) */
	'E', 'X', 'T', 'R', 'A', '_', 'D', 'X', '_', 'D', 'Y', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* EXTRA_DX_DY_PRECISION (87233) */
	'M', 'S', 'A', 'A', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MSAA_NUM_SAMPLES (87255) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'D', 'T', 'M', 'N', '\0', /* AA_MASK_CENTROID_DTMN (87272) */
	'M', 'A', 'X', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'I', 'S', 'T', '\0', /* MAX_SAMPLE_DIST (87294) */
	'M', 'S', 'A', 'A', '_', 'E', 'X', 'P', 'O', 'S', 'E', 'D', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MSAA_EXPOSED_SAMPLES (87310) */
	'D', 'E', 'T', 'A', 'I', 'L', '_', 'T', 'O', '_', 'E', 'X', 'P', 'O', 'S', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* DETAIL_TO_EXPOSED_MODE (87331) */
	'I', 'N', 'P', 'U', 'T', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_COVERAGE (87354) */
	'I', 'N', 'P', 'U', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_INNER_COVERAGE (87369) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_DEPTH_COVERAGE (87390) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'T', 'O', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* COVERAGE_TO_SHADER_SELECT (87411) */
	'P', 'I', 'X', '_', 'C', 'E', 'N', 'T', 'E', 'R', '\0', /* PIX_CENTER (87437) */
	'X', '_', 'T', 'R', 'U', 'N', 'C', 'A', 'T', 'E', '\0', /* X_TRUNCATE (87448) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* X_ROUND (87459) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', '_', 'E', 'V', 'E', 'N', '\0', /* X_ROUND_TO_EVEN (87467) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', '_', 'O', 'D', 'D', '\0', /* X_ROUND_TO_ODD (87483) */
	'R', 'O', 'U', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ROUND_MODE (87498) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '1', '6', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_16TH (87509) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '8', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_8TH (87535) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '4', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_4TH (87560) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '2', '\0', /* X_16_8_FIXED_POINT_1_2 (87585) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '\0', /* X_16_8_FIXED_POINT_1 (87608) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '2', '5', '6', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_256TH (87629) */
	'X', '_', '1', '4', '_', '1', '0', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '1', '0', '2', '4', 'T', 'H', '\0', /* X_14_10_FIXED_POINT_1_1024TH (87656) */
	'X', '_', '1', '2', '_', '1', '2', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '4', '0', '9', '6', 'T', 'H', '\0', /* X_12_12_FIXED_POINT_1_4096TH (87685) */
	'Q', 'U', 'A', 'N', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* QUANT_MODE (87714) */
	'S', '0', '_', 'X', '\0', /* S0_X (87725) */
	'S', '0', '_', 'Y', '\0', /* S0_Y (87730) */
	'S', '1', '_', 'X', '\0', /* S1_X (87735) */
	'S', '1', '_', 'Y', '\0', /* S1_Y (87740) */
	'S', '2', '_', 'X', '\0', /* S2_X (87745) */
	'S', '2', '_', 'Y', '\0', /* S2_Y (87750) */
	'S', '3', '_', 'X', '\0', /* S3_X (87755) */
	'S', '3', '_', 'Y', '\0', /* S3_Y (87760) */
	'S', '4', '_', 'X', '\0', /* S4_X (87765) */
	'S', '4', '_', 'Y', '\0', /* S4_Y (87770) */
	'S', '5', '_', 'X', '\0', /* S5_X (87775) */
	'S', '5', '_', 'Y', '\0', /* S5_Y (87780) */
	'S', '6', '_', 'X', '\0', /* S6_X (87785) */
	'S', '6', '_', 'Y', '\0', /* S6_Y (87790) */
	'S', '7', '_', 'X', '\0', /* S7_X (87795) */
	'S', '7', '_', 'Y', '\0', /* S7_Y (87800) */
	'S', '8', '_', 'X', '\0', /* S8_X (87805) */
	'S', '8', '_', 'Y', '\0', /* S8_Y (87810) */
	'S', '9', '_', 'X', '\0', /* S9_X (87815) */
	'S', '9', '_', 'Y', '\0', /* S9_Y (87820) */
	'S', '1', '0', '_', 'X', '\0', /* S10_X (87825) */
	'S', '1', '0', '_', 'Y', '\0', /* S10_Y (87831) */
	'S', '1', '1', '_', 'X', '\0', /* S11_X (87837) */
	'S', '1', '1', '_', 'Y', '\0', /* S11_Y (87843) */
	'S', '1', '2', '_', 'X', '\0', /* S12_X (87849) */
	'S', '1', '2', '_', 'Y', '\0', /* S12_Y (87855) */
	'S', '1', '3', '_', 'X', '\0', /* S13_X (87861) */
	'S', '1', '3', '_', 'Y', '\0', /* S13_Y (87867) */
	'S', '1', '4', '_', 'X', '\0', /* S14_X (87873) */
	'S', '1', '4', '_', 'Y', '\0', /* S14_Y (87879) */
	'S', '1', '5', '_', 'X', '\0', /* S15_X (87885) */
	'S', '1', '5', '_', 'Y', '\0', /* S15_Y (87891) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '\0', /* AA_MASK_X0Y0 (87897) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '1', 'Y', '0', '\0', /* AA_MASK_X1Y0 (87910) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '\0', /* AA_MASK_X0Y1 (87923) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '1', 'Y', '1', '\0', /* AA_MASK_X1Y1 (87936) */
	'R', 'E', 'A', 'L', 'I', 'G', 'N', '_', 'D', 'Q', 'U', 'A', 'D', 'S', '_', 'A', 'F', 'T', 'E', 'R', '_', 'N', '_', 'W', 'A', 'V', 'E', 'S', '\0', /* REALIGN_DQUADS_AFTER_N_WAVES (87949) */
	'W', 'A', 'V', 'E', '_', 'B', 'R', 'E', 'A', 'K', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'S', 'I', 'Z', 'E', '\0', /* WAVE_BREAK_REGION_SIZE (87978) */
	'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'W', 'E', 'D', '\0', /* BINNING_ALLOWED (88001) */
	'F', 'O', 'R', 'C', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'O', 'N', '\0', /* FORCE_BINNING_ON (88017) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'U', 'S', 'E', '_', 'N', 'E', 'W', '_', 'S', 'C', '\0', /* DISABLE_BINNING_USE_NEW_SC (88034) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'U', 'S', 'E', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '_', 'S', 'C', '\0', /* DISABLE_BINNING_USE_LEGACY_SC (88061) */
	'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'M', 'O', 'D', 'E', '\0', /* BINNING_MODE (88091) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'X', '\0', /* BIN_SIZE_X (88104) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'Y', '\0', /* BIN_SIZE_Y (88115) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '3', '2', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_32_PIXELS (88126) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_64_PIXELS (88145) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '1', '2', '8', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_128_PIXELS (88164) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '2', '5', '6', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_256_PIXELS (88184) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '5', '1', '2', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_512_PIXELS (88204) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'X', '_', 'E', 'X', 'T', 'E', 'N', 'D', '\0', /* BIN_SIZE_X_EXTEND (88224) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'Y', '_', 'E', 'X', 'T', 'E', 'N', 'D', '\0', /* BIN_SIZE_Y_EXTEND (88242) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'S', 'T', 'A', 'T', 'E', 'S', '_', 'P', 'E', 'R', '_', 'B', 'I', 'N', '\0', /* CONTEXT_STATES_PER_BIN (88260) */
	'P', 'E', 'R', 'S', 'I', 'S', 'T', 'E', 'N', 'T', '_', 'S', 'T', 'A', 'T', 'E', 'S', '_', 'P', 'E', 'R', '_', 'B', 'I', 'N', '\0', /* PERSISTENT_STATES_PER_BIN (88283) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'O', 'F', '_', 'P', 'R', 'I', 'M', '\0', /* DISABLE_START_OF_PRIM (88309) */
	'F', 'P', 'O', 'V', 'S', '_', 'P', 'E', 'R', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* FPOVS_PER_BATCH (88331) */
	'O', 'P', 'T', 'I', 'M', 'A', 'L', '_', 'B', 'I', 'N', '_', 'S', 'E', 'L', 'E', 'C', 'T', 'I', 'O', 'N', '\0', /* OPTIMAL_BIN_SELECTION (88347) */
	'F', 'L', 'U', 'S', 'H', '_', 'O', 'N', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'T', 'R', 'A', 'N', 'S', 'I', 'T', 'I', 'O', 'N', '\0', /* FLUSH_ON_BINNING_TRANSITION (88369) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BIN_MAP_MODE_NONE (88397) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'R', 'T', 'A', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* BIN_MAP_MODE_RTA_INDEX (88415) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'P', 'O', 'P', 'S', '\0', /* BIN_MAP_MODE_POPS (88438) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', 'P', 'I', 'N', 'G', '_', 'M', 'O', 'D', 'E', '\0', /* BIN_MAPPING_MODE (88456) */
	'M', 'A', 'X', '_', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* MAX_ALLOC_COUNT (88473) */
	'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', '_', 'P', 'E', 'R', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* MAX_PRIM_PER_BATCH (88489) */
	'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OVER_RAST_ENABLE (88508) */
	'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OVER_RAST_SAMPLE_SELECT (88525) */
	'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* UNDER_RAST_ENABLE (88549) */
	'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UNDER_RAST_SAMPLE_SELECT (88567) */
	'P', 'B', 'B', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PBB_UNCERTAINTY_REGION_ENABLE (88592) */
	'Z', 'M', 'M', '_', 'T', 'R', 'I', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_TRI_EXTENT (88622) */
	'Z', 'M', 'M', '_', 'T', 'R', 'I', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* ZMM_TRI_OFFSET (88637) */
	'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* OVERRIDE_OVER_RAST_INNER_TO_NORMAL (88652) */
	'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* OVERRIDE_UNDER_RAST_INNER_TO_NORMAL (88687) */
	'D', 'E', 'G', 'E', 'N', 'E', 'R', 'A', 'T', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE (88723) */
	'S', 'C', '_', 'H', 'A', 'L', 'F', '_', 'L', 'S', 'B', '\0', /* SC_HALF_LSB (88767) */
	'S', 'C', '_', 'L', 'S', 'B', '_', 'O', 'N', 'E', '_', 'S', 'I', 'D', 'E', 'D', '\0', /* SC_LSB_ONE_SIDED (88779, 88792) */
	'S', 'C', '_', 'L', 'S', 'B', '_', 'T', 'W', 'O', '_', 'S', 'I', 'D', 'E', 'D', '\0', /* SC_LSB_TWO_SIDED (88796) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'M', 'O', 'D', 'E', '\0', /* UNCERTAINTY_REGION_MODE (88813) */
	'O', 'U', 'T', 'E', 'R', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* OUTER_UNCERTAINTY_EDGERULE_OVERRIDE (88837) */
	'I', 'N', 'N', 'E', 'R', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* INNER_UNCERTAINTY_EDGERULE_OVERRIDE (88873) */
	'N', 'U', 'L', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* NULL_SQUAD_AA_MASK_ENABLE (88909) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_AA_MASK_ENABLE (88935) */
	'P', 'R', 'E', 'Z', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PREZ_AA_MASK_ENABLE (88959) */
	'P', 'O', 'S', 'T', 'Z', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POSTZ_AA_MASK_ENABLE (88979) */
	'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* CENTROID_SAMPLE_OVERRIDE (89000) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'M', 'U', 'L', 'T', '\0', /* UNCERTAINTY_REGION_MULT (89025) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'P', 'B', 'B', '_', 'M', 'U', 'L', 'T', '\0', /* UNCERTAINTY_REGION_PBB_MULT (89049) */
	'M', 'A', 'X', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', 'S', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_DEALLOCS_IN_WAVE (89077) */
	'M', 'A', 'X', '_', 'F', 'P', 'O', 'V', 'S', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_FPOVS_IN_WAVE (89098) */
	'V', 'T', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VTX_REUSE_DEPTH (89116) */
	'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'D', 'I', 'S', 'T', '\0', /* DEALLOC_DIST (89132) */
	'T', 'I', 'L', 'E', '_', 'M', 'A', 'X', '\0', /* TILE_MAX (89145) */
	'F', 'M', 'A', 'S', 'K', '_', 'T', 'I', 'L', 'E', '_', 'M', 'A', 'X', '\0', /* FMASK_TILE_MAX (89154) */
	'M', 'I', 'P', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* MIP_LEVEL (89169) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', 'N', 'O', 'N', 'E', '\0', /* ENDIAN_NONE (89179) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '1', '6', '\0', /* ENDIAN_8IN16 (89191) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '3', '2', '\0', /* ENDIAN_8IN32 (89204) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '6', '4', '\0', /* ENDIAN_8IN64 (89217) */
	'E', 'N', 'D', 'I', 'A', 'N', '\0', /* ENDIAN (89230) */
	'C', 'O', 'L', 'O', 'R', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* COLOR_INVALID (89237) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '\0', /* COLOR_8 (89251) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '\0', /* COLOR_16 (89259) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '8', '\0', /* COLOR_8_8 (89268) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '\0', /* COLOR_32 (89278) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '_', '1', '6', '\0', /* COLOR_16_16 (89287) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* COLOR_10_11_11 (89299) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '1', '_', '1', '1', '_', '1', '0', '\0', /* COLOR_11_11_10 (89314) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '\0', /* COLOR_10_10_10_2 (89329) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* COLOR_2_10_10_10 (89346) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* COLOR_8_8_8_8 (89363) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '_', '3', '2', '\0', /* COLOR_32_32 (89377) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '\0', /* COLOR_16_16_16_16 (89389) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '3', '\0', /* COLOR_RESERVED_13 (89407) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '\0', /* COLOR_32_32_32_32 (89425) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '5', '\0', /* COLOR_RESERVED_15 (89443) */
	'C', 'O', 'L', 'O', 'R', '_', '5', '_', '6', '_', '5', '\0', /* COLOR_5_6_5 (89461) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* COLOR_1_5_5_5 (89473) */
	'C', 'O', 'L', 'O', 'R', '_', '5', '_', '5', '_', '5', '_', '1', '\0', /* COLOR_5_5_5_1 (89487) */
	'C', 'O', 'L', 'O', 'R', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* COLOR_4_4_4_4 (89501) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '2', '4', '\0', /* COLOR_8_24 (89515) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '4', '_', '8', '\0', /* COLOR_24_8 (89526) */
	'C', 'O', 'L', 'O', 'R', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* COLOR_X24_8_32_FLOAT (89537) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '3', '\0', /* COLOR_RESERVED_23 (89558) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '4', '\0', /* COLOR_RESERVED_24 (89576) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '5', '\0', /* COLOR_RESERVED_25 (89594) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '6', '\0', /* COLOR_RESERVED_26 (89612) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '7', '\0', /* COLOR_RESERVED_27 (89630) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '8', '\0', /* COLOR_RESERVED_28 (89648) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '9', '\0', /* COLOR_RESERVED_29 (89666) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '3', '0', '\0', /* COLOR_RESERVED_30 (89684) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '6', 'E', '4', '\0', /* COLOR_2_10_10_10_6E4 (89702) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* NUMBER_UNORM (89723) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* NUMBER_SNORM (89736) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* NUMBER_USCALED (89749) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* NUMBER_SSCALED (89764) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* NUMBER_UINT (89779) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* NUMBER_SINT (89791) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* NUMBER_SRGB (89803) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* NUMBER_FLOAT (89815) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* NUMBER_TYPE (89828) */
	'S', 'W', 'A', 'P', '_', 'S', 'T', 'D', '\0', /* SWAP_STD (89840) */
	'S', 'W', 'A', 'P', '_', 'A', 'L', 'T', '\0', /* SWAP_ALT (89849) */
	'S', 'W', 'A', 'P', '_', 'S', 'T', 'D', '_', 'R', 'E', 'V', '\0', /* SWAP_STD_REV (89858) */
	'S', 'W', 'A', 'P', '_', 'A', 'L', 'T', '_', 'R', 'E', 'V', '\0', /* SWAP_ALT_REV (89871) */
	'C', 'O', 'M', 'P', '_', 'S', 'W', 'A', 'P', '\0', /* COMP_SWAP (89884) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* BLEND_CLAMP (89894) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* BLEND_BYPASS (89906) */
	'S', 'I', 'M', 'P', 'L', 'E', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* SIMPLE_FLOAT (89919) */
	'C', 'M', 'A', 'S', 'K', '_', 'I', 'S', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* CMASK_IS_LINEAR (89932, 89941) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'A', 'U', 'T', 'O', '\0', /* FORCE_OPT_AUTO (89948) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_OPT_DISABLE (89963) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_A_0 (89981) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'R', 'G', 'B', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_RGB_0 (90009) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', 'R', 'G', 'B', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_ARGB_0 (90039) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_A_1 (90070) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'R', 'G', 'B', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_RGB_1 (90098) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', 'R', 'G', 'B', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_ARGB_1 (90128) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'D', 'O', 'N', 'T', '_', 'R', 'D', '_', 'D', 'S', 'T', '\0', /* BLEND_OPT_DONT_RD_DST (90159) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'P', 'I', 'X', 'E', 'L', '\0', /* BLEND_OPT_DISCARD_PIXEL (90181) */
	'F', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FMASK_COMPRESSION_DISABLE (90205) */
	'F', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', '1', 'F', 'R', 'A', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* FMASK_COMPRESS_1FRAG_ONLY (90231) */
	'D', 'C', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DCC_ENABLE (90257) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'T', 'I', 'L', 'E', 'D', '\0', /* CMASK_ADDR_TILED (90268) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* CMASK_ADDR_LINEAR (90285) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'M', 'P', 'A', 'T', 'I', 'B', 'L', 'E', '\0', /* CMASK_ADDR_COMPATIBLE (90303) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* CMASK_ADDR_TYPE (90325) */
	'A', 'L', 'T', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* ALT_TILE_MODE (90341) */
	'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* TILE_MODE_INDEX (90355) */
	'F', 'M', 'A', 'S', 'K', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* FMASK_TILE_MODE_INDEX (90371) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* FMASK_BANK_HEIGHT (90393) */
	'N', 'U', 'M', '_', 'F', 'R', 'A', 'G', 'M', 'E', 'N', 'T', 'S', '\0', /* NUM_FRAGMENTS (90411) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '_', '1', '\0', /* FORCE_DST_ALPHA_1 (90425) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'M', 'A', 'S', 'K', '_', 'N', 'O', 'F', 'E', 'T', 'C', 'H', '_', 'O', 'P', 'T', '\0', /* DISABLE_FMASK_NOFETCH_OPT (90443) */
	'L', 'I', 'M', 'I', 'T', '_', 'C', 'O', 'L', 'O', 'R', '_', 'F', 'E', 'T', 'C', 'H', '_', 'T', 'O', '_', '2', '5', '6', 'B', '_', 'M', 'A', 'X', '\0', /* LIMIT_COLOR_FETCH_TO_256B_MAX (90469) */
	'K', 'E', 'Y', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KEY_CLEAR_ENABLE (90499) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', 'B', '\0', /* MAX_BLOCK_SIZE_64B (90516) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '1', '2', '8', 'B', '\0', /* MAX_BLOCK_SIZE_128B (90535) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '2', '5', '6', 'B', '\0', /* MAX_BLOCK_SIZE_256B (90555) */
	'M', 'I', 'N', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '3', '2', 'B', '\0', /* MIN_BLOCK_SIZE_32B (90575) */
	'M', 'I', 'N', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', 'B', '\0', /* MIN_BLOCK_SIZE_64B (90594) */
	'M', 'I', 'N', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MIN_COMPRESSED_BLOCK_SIZE (90613) */
	'I', 'N', 'D', 'E', 'P', 'E', 'N', 'D', 'E', 'N', 'T', '_', '6', '4', 'B', '_', 'B', 'L', 'O', 'C', 'K', 'S', '\0', /* INDEPENDENT_64B_BLOCKS (90639) */
	'L', 'O', 'S', 'S', 'Y', '_', 'R', 'G', 'B', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* LOSSY_RGB_PRECISION (90662) */
	'L', 'O', 'S', 'S', 'Y', '_', 'A', 'L', 'P', 'H', 'A', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* LOSSY_ALPHA_PRECISION (90682) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ENABLE_CONSTANT_ENCODE_REG_WRITE (90704) */
	'I', 'N', 'D', 'E', 'P', 'E', 'N', 'D', 'E', 'N', 'T', '_', '1', '2', '8', 'B', '_', 'B', 'L', 'O', 'C', 'K', 'S', '\0', /* INDEPENDENT_128B_BLOCKS (90737) */
	'B', 'A', 'S', 'E', '_', '2', '5', '6', 'B', '\0', /* BASE_256B (90761) */
	'M', 'I', 'P', '0', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* MIP0_HEIGHT (90771) */
	'M', 'I', 'P', '0', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* MIP0_WIDTH (90783) */
	'M', 'I', 'P', '0', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* MIP0_DEPTH (90794) */
	'M', 'E', 'T', 'A', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* META_LINEAR (90805) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* COLOR_SW_MODE (90817) */
	'F', 'M', 'A', 'S', 'K', '_', 'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* FMASK_SW_MODE (90831) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* RESOURCE_TYPE (90845) */
	'C', 'M', 'A', 'S', 'K', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* CMASK_PIPE_ALIGNED (90859) */
	'D', 'C', 'C', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* DCC_PIPE_ALIGNED (90878) */
	'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* DOORBELL_OFFSET (90895) */
	'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CACHE_POLICY (90911) */
	'O', 'F', 'F', 'S', 'E', 'T', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'D', 'O', 'N', 'E', '\0', /* OFFSET_UPDATE_DONE (90924) */
	'O', 'B', 'S', 'O', 'L', 'E', 'T', 'E', '_', 'U', 'M', 'S', 'K', '\0', /* OBSOLETE_UMSK (90943) */
	'O', 'B', 'S', 'O', 'L', 'E', 'T', 'E', '_', 'S', 'W', 'A', 'P', '\0', /* OBSOLETE_SWAP (90957) */
	'M', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* MEM_ADDR_LO (90971) */
	'M', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* MEM_ADDR_HI (90983) */
	'C', 'S', '_', 'P', 'S', '_', 'S', 'E', 'L', '\0', /* CS_PS_SEL (90995) */
	'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'S', 'W', 'A', 'P', '\0', /* SEM_ADDR_SWAP (91005, 91009) */
	'S', 'E', 'M', '_', 'U', 'S', 'E', '_', 'M', 'A', 'I', 'L', 'B', 'O', 'X', '\0', /* SEM_USE_MAILBOX (91019) */
	'S', 'E', 'M', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'T', 'Y', 'P', 'E', '\0', /* SEM_SIGNAL_TYPE (91035) */
	'S', 'E', 'M', '_', 'C', 'L', 'I', 'E', 'N', 'T', '_', 'C', 'O', 'D', 'E', '\0', /* SEM_CLIENT_CODE (91051) */
	'S', 'E', 'M', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SEM_SELECT (91067) */
	'M', 'E', 'M', 'L', 'O', 'G', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* MEMLOG_CLEAR (91078) */
	'S', 'R', 'C', '_', 'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* SRC_CACHE_POLICY (91091) */
	'S', 'R', 'C', '_', 'V', 'O', 'L', 'A', 'T', 'L', 'E', '\0', /* SRC_VOLATLE (91108) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DST_SELECT (91120) */
	'D', 'S', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DST_CACHE_POLICY (91131) */
	'D', 'S', 'T', '_', 'V', 'O', 'L', 'A', 'T', 'L', 'E', '\0', /* DST_VOLATLE (91148) */
	'S', 'R', 'C', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SRC_SELECT (91160) */
	'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* COHER_BASE_HI_256B (91171) */
	'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* START_DELAY_COUNT (91190) */
	'T', 'C', '_', 'N', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_NC_ACTION_ENA (91208) */
	'T', 'C', '_', 'W', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_WC_ACTION_ENA (91225) */
	'T', 'C', '_', 'I', 'N', 'V', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_INV_METADATA_ACTION_ENA (91242) */
	'T', 'C', 'L', '1', '_', 'V', 'O', 'L', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TCL1_VOL_ACTION_ENA (91269) */
	'T', 'C', '_', 'W', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_WB_ACTION_ENA (91289) */
	'T', 'C', 'L', '1', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TCL1_ACTION_ENA (91306) */
	'T', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_ACTION_ENA (91322) */
	'C', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* CB_ACTION_ENA (91336) */
	'D', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* DB_ACTION_ENA (91350) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_ACTION_ENA (91364) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'V', 'O', 'L', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_VOL_ACTION_ENA (91385) */
	'S', 'H', '_', 'I', 'C', 'A', 'C', 'H', 'E', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_ICACHE_ACTION_ENA (91410) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'W', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_WB_ACTION_ENA (91431) */
	'M', 'E', 'I', 'D', '\0', /* MEID (91455) */
	'B', 'Y', 'T', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* BYTE_COUNT (91460) */
	'S', 'A', 'S', '\0', /* SAS (91471) */
	'D', 'A', 'S', '\0', /* DAS (91475) */
	'S', 'A', 'I', 'C', '\0', /* SAIC (91479) */
	'D', 'A', 'I', 'C', '\0', /* DAIC (91484) */
	'R', 'A', 'W', '_', 'W', 'A', 'I', 'T', '\0', /* RAW_WAIT (91489) */
	'D', 'I', 'S', '_', 'W', 'C', '\0', /* DIS_WC (91498) */
	'U', 'T', 'C', 'L', '1', '_', 'F', 'A', 'U', 'L', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* UTCL1_FAULT_CONTROL (91505) */
	'W', 'A', 'T', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* WATCH_CONTROL (91525) */
	'M', 'I', 'N', '_', 'A', 'V', 'A', 'I', 'L', 'S', 'Z', '\0', /* MIN_AVAILSZ (91539) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* BUFFER_DEPTH (91551) */
	'P', 'I', 'O', '_', 'F', 'I', 'F', 'O', '_', 'E', 'M', 'P', 'T', 'Y', '\0', /* PIO_FIFO_EMPTY (91564) */
	'P', 'I', 'O', '_', 'F', 'I', 'F', 'O', '_', 'F', 'U', 'L', 'L', '\0', /* PIO_FIFO_FULL (91579) */
	'P', 'I', 'O', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PIO_COUNT (91593) */
	'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', '\0', /* DMA_READ_TAG (91603) */
	'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* DMA_READ_TAG_VALID (91616) */
	'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* COHER_SIZE_HI_256B (91635) */
	'I', 'B', '_', 'E', 'N', '\0', /* IB_EN (91654) */
	'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* CONFIG_REG_EN (91660) */
	'C', 'N', 'T', 'X', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* CNTX_REG_EN (91674) */
	'S', 'H', '_', 'G', 'F', 'X', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* SH_GFX_REG_EN (91686) */
	'S', 'H', '_', 'C', 'S', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* SH_CS_REG_EN (91700) */
	'R', 'S', 'V', 'D', '\0', /* RSVD (91713) */
	'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* INIT_CMD_REQSZ (91718) */
	'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* IB1_CMD_REQSZ (91733) */
	'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* IB2_CMD_REQSZ (91747) */
	'S', 'T', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* ST_CMD_REQSZ (91761) */
	'E', 'O', 'P', '_', 'V', 'O', 'L', 'A', 'T', 'I', 'L', 'E', '\0', /* EOP_VOLATILE (91774) */
	'E', 'X', 'E', 'C', 'U', 'T', 'E', '\0', /* EXECUTE (91787) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '\0', /* DST_SEL (91795) */
	'I', 'N', 'T', '_', 'S', 'E', 'L', '\0', /* INT_SEL (91803) */
	'D', 'A', 'T', 'A', '_', 'S', 'E', 'L', '\0', /* DATA_SEL (91811) */
	'D', 'B', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* DB_CMD_REQSZ (91820) */
	'Z', '_', 'P', 'A', 'S', 'S', '_', 'A', 'C', 'I', 'T', 'V', 'E', '\0', /* Z_PASS_ACITVE (91833) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* STREAMOUT_ACTIVE (91847) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* PIPELINE_ACTIVE (91864) */
	'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* STIPPLE_ACTIVE (91880) */
	'V', 'G', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', 'S', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* VGT_BUFFERS_ACTIVE (91895) */
	'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SCREEN_EXT_ACTIVE (91914) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* DRAW_INDIRECT_ACTIVE (91932) */
	'D', 'I', 'S', 'P', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* DISP_INDIRECT_ACTIVE (91953) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_0_ENA (91974) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_1_ENA (91990) */
	'C', 'B', '0', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB0_DEST_BASE_ENA (92006) */
	'C', 'B', '1', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB1_DEST_BASE_ENA (92024) */
	'C', 'B', '2', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB2_DEST_BASE_ENA (92042) */
	'C', 'B', '3', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB3_DEST_BASE_ENA (92060) */
	'C', 'B', '4', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB4_DEST_BASE_ENA (92078) */
	'C', 'B', '5', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB5_DEST_BASE_ENA (92096) */
	'C', 'B', '6', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB6_DEST_BASE_ENA (92114) */
	'C', 'B', '7', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB7_DEST_BASE_ENA (92132) */
	'D', 'B', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* DB_DEST_BASE_ENA (92150) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_2_ENA (92167) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_3_ENA (92183) */
	'M', 'A', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'G', 'F', 'X', '_', 'C', 'N', 'T', 'X', '\0', /* MATCHING_GFX_CNTX (92199) */
	'F', 'E', 'A', 'T', 'U', 'R', 'E', '_', 'S', 'E', 'L', '\0', /* FEATURE_SEL (92217) */
	'S', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SE_INDEX (92229) */
	'S', 'A', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SA_INDEX (92238) */
	'W', 'G', 'P', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* WGP_INDEX (92247) */
	'E', 'V', 'E', 'N', 'T', '_', 'S', 'E', 'L', '\0', /* EVENT_SEL (92257) */
	'U', 'N', 'U', 'S', 'E', 'D', '\0', /* UNUSED (92267) */
	'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* INSTANCE_INDEX (92274) */
	'S', 'A', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* SA_BROADCAST_WRITES (92289) */
	'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* INSTANCE_BROADCAST_WRITES (92309) */
	'S', 'E', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* SE_BROADCAST_WRITES (92335) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'B', 'U', 'F', 'F', 'E', 'R', 'I', 'N', 'G', '\0', /* OFFCHIP_BUFFERING (92355) */
	'X', '_', '8', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_8K_DWORDS (92373) */
	'X', '_', '4', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_4K_DWORDS (92385) */
	'X', '_', '2', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_2K_DWORDS (92397) */
	'X', '_', '1', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_1K_DWORDS (92409) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'G', 'R', 'A', 'N', 'U', 'L', 'A', 'R', 'I', 'T', 'Y', '\0', /* OFFCHIP_GRANULARITY (92421) */
	'E', 'N', '_', 'I', 'N', 'S', 'T', '_', 'O', 'P', 'T', '_', 'B', 'A', 'S', 'I', 'C', '\0', /* EN_INST_OPT_BASIC (92441) */
	'E', 'N', '_', 'I', 'N', 'S', 'T', '_', 'O', 'P', 'T', '_', 'A', 'D', 'V', '\0', /* EN_INST_OPT_ADV (92459) */
	'H', 'W', '_', 'U', 'S', 'E', '_', 'O', 'N', 'L', 'Y', '\0', /* HW_USE_ONLY (92475) */
	'P', 'R', 'I', 'M', '_', 'G', 'R', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* PRIM_GRP_SIZE (92487) */
	'V', 'E', 'R', 'T', '_', 'G', 'R', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* VERT_GRP_SIZE (92501) */
	'B', 'R', 'E', 'A', 'K', '_', 'W', 'A', 'V', 'E', '_', 'A', 'T', '_', 'E', 'O', 'I', '\0', /* BREAK_WAVE_AT_EOI (92515) */
	'P', 'A', 'C', 'K', 'E', 'T', '_', 'T', 'O', '_', 'O', 'N', 'E', '_', 'P', 'A', '\0', /* PACKET_TO_ONE_PA (92533) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* RT_SLICE (92550) */
	'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '\0', /* VIEWPORT (92559) */
	'E', 'N', '_', 'S', 'T', 'E', 'R', 'E', 'O', '\0', /* EN_STEREO (92568) */
	'O', 'V', 'E', 'R', 'S', 'U', 'B', '_', 'E', 'N', '\0', /* OVERSUB_EN (92578) */
	'N', 'U', 'M', '_', 'P', 'C', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* NUM_PC_LINES (92589) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* EN_USER_VGPR1 (92602) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* EN_USER_VGPR2 (92616) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* EN_USER_VGPR3 (92630) */
	'C', 'U', 'R', 'R', 'E', 'N', 'T', '_', 'P', 'T', 'R', '\0', /* CURRENT_PTR (92644) */
	'C', 'U', 'R', 'R', 'E', 'N', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CURRENT_COUNT (92656) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'H', 'V', '_', 'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* ENABLE_HV_PRE_SHADER (92670) */
	'F', 'O', 'R', 'C', 'E', '_', 'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'L', 'L', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* FORCE_PRE_SHADER_ALL_PIXELS (92691) */
	'X', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* X_COORD (92719) */
	'Y', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* Y_COORD (92727) */
	'T', 'A', 'R', 'G', 'E', 'T', '_', 'I', 'N', 'S', 'T', '\0', /* TARGET_INST (92735) */
	'T', 'A', 'R', 'G', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* TARGET_DATA (92747) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'E', '\0', /* INVALIDATE (92759) */
	'L', '2', '_', 'W', 'B', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* L2_WB_POLICY (92770) */
	'D', 'W', 'B', '\0', /* DWB (92783) */
	'A', 'I', 'N', 'C', '\0', /* AINC (92787) */
	'U', 'N', 'U', 'S', 'E', 'D', '1', '\0', /* UNUSED1 (92792) */
	'D', 'M', 'O', 'D', 'E', '\0', /* DMODE (92800) */
	'U', 'N', 'U', 'S', 'E', 'D', '2', '\0', /* UNUSED2 (92806) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'A', 'L', 'L', '\0', /* RELEASE_ALL (92814) */
	'H', 'E', 'A', 'D', '_', 'Q', 'U', 'E', 'U', 'E', '\0', /* HEAD_QUEUE (92826) */
	'H', 'E', 'A', 'D', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* HEAD_VALID (92837) */
	'H', 'E', 'A', 'D', '_', 'F', 'L', 'A', 'G', '\0', /* HEAD_FLAG (92848) */
	'H', 'A', 'L', 'T', 'E', 'D', '\0', /* HALTED (92858) */
	'D', 'S', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* DS_ADDRESS (92865) */
	'C', 'R', 'A', 'W', 'L', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* CRAWLER_TYPE (92876) */
	'C', 'R', 'A', 'W', 'L', 'E', 'R', '\0', /* CRAWLER (92889) */
	'N', 'O', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* NO_ALLOC (92897) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* COMPARE_VALUE (92906) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '\0', /* PERF_SEL (92920) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '1', '\0', /* PERF_SEL1 (92929) */
	'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* SPM_MODE (92939) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '1', '\0', /* CNTR_MODE1 (92948) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '0', '\0', /* CNTR_MODE0 (92959) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '2', '\0', /* PERF_SEL2 (92970) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '3', '\0', /* PERF_SEL3 (92980) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '3', '\0', /* CNTR_MODE3 (92990) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '2', '\0', /* CNTR_MODE2 (93001) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S