/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.Migration;
import org.apache.tomcat.jakartaee.StringManager;

public class MigrationCLI {
    private static final StringManager sm = StringManager.getManager(MigrationCLI.class);
    private static final String EXCLUDE_ARG = "-exclude=";
    private static final String LOGLEVEL_ARG = "-logLevel=";
    private static final String PROFILE_ARG = "-profile=";
    private static final String ZIPINMEMORY_ARG = "-zipInMemory";

    public static void main(String[] args) throws IOException {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s%n");
        Migration migration = new Migration();
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            String argument = (String)iter.next();
            if (argument.startsWith(EXCLUDE_ARG)) {
                iter.remove();
                String exclude = argument.substring(EXCLUDE_ARG.length());
                migration.addExclude(exclude);
                continue;
            }
            if (argument.startsWith(LOGLEVEL_ARG)) {
                iter.remove();
                String logLevelName = argument.substring(LOGLEVEL_ARG.length());
                Level level = null;
                try {
                    level = Level.parse(logLevelName.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException iae) {
                    MigrationCLI.invalidArguments();
                }
                Logger.getGlobal().getParent().getHandlers()[0].setLevel(level);
                Logger.getGlobal().getParent().setLevel(level);
                continue;
            }
            if (argument.startsWith(PROFILE_ARG)) {
                iter.remove();
                String profileName = argument.substring(PROFILE_ARG.length());
                try {
                    EESpecProfiles profile = EESpecProfiles.valueOf(profileName.toUpperCase(Locale.ENGLISH));
                    migration.setEESpecProfile(profile);
                }
                catch (IllegalArgumentException e) {
                    MigrationCLI.invalidArguments();
                }
                continue;
            }
            if (!argument.equals(ZIPINMEMORY_ARG)) continue;
            iter.remove();
            migration.setZipInMemory(true);
        }
        if (arguments.size() != 2) {
            MigrationCLI.invalidArguments();
        }
        String source = (String)arguments.get(0);
        String dest = (String)arguments.get(1);
        migration.setSource(new File(source));
        migration.setDestination(new File(dest));
        migration.execute();
    }

    private static void invalidArguments() {
        System.out.println(sm.getString("migration.usage"));
        System.exit(1);
    }
}

